/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IAttribute;
import igeo.IColor;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.ISurfaceGeo;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVolume;
import igeo.IVolumeGeo;
import igeo.IVolumeI;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicFillGL;
import igeo.gui.ISurfaceGraphicWireframeGL;

public class IVolumeGraphicGL
extends IGraphicObject {
    public ISurfaceGeo[] faces;
    public ISurfaceGraphicFillGL[] fills = new ISurfaceGraphicFillGL[6];
    public ISurfaceGraphicWireframeGL[] wireframes = new ISurfaceGraphicWireframeGL[6];

    public IVolumeGraphicGL(IVolume iVolume) {
        super(iVolume);
        this.faces = this.createFaces(iVolume);
        for (int i = 0; i < this.faces.length; ++i) {
            this.wireframes[i] = new ISurfaceGraphicWireframeGL(iVolume, this.faces[i]);
            this.fills[i] = new ISurfaceGraphicFillGL(iVolume, this.faces[i]);
        }
    }

    public IVolumeGraphicGL(IObject iObject, IVolumeGeo iVolumeGeo) {
        super(iObject);
        this.faces = this.createFaces(iVolumeGeo);
        for (int i = 0; i < this.faces.length; ++i) {
            this.wireframes[i] = new ISurfaceGraphicWireframeGL(iObject, this.faces[i]);
            this.fills[i] = new ISurfaceGraphicFillGL(iObject, this.faces[i]);
        }
    }

    public ISurfaceGeo[] createFaces(IVolumeI iVolumeI) {
        int n;
        int n2;
        int n3 = iVolumeI.ucpNum();
        int n4 = iVolumeI.vcpNum();
        int n5 = iVolumeI.wcpNum();
        IVecI[][] iVecIArray = new IVec[n3][n4];
        IVecI[][] iVecIArray2 = new IVec[n3][n4];
        IVecI[][] iVecIArray3 = new IVec[n4][n5];
        IVecI[][] iVecIArray4 = new IVec[n4][n5];
        IVecI[][] iVecIArray5 = new IVec[n5][n3];
        IVecI[][] iVecIArray6 = new IVec[n5][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                iVecIArray[n2][n] = iVolumeI.cp(n2, n, 0).get();
                iVecIArray2[n2][n] = iVolumeI.cp(n2, n, n5 - 1).get();
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n5; ++n) {
                iVecIArray3[n2][n] = iVolumeI.cp(0, n2, n).get();
                iVecIArray4[n2][n] = iVolumeI.cp(n3 - 1, n2, n).get();
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n3; ++n) {
                iVecIArray5[n2][n] = iVolumeI.cp(n, 0, n2).get();
                iVecIArray6[n2][n] = iVolumeI.cp(n, n4 - 1, n2).get();
            }
        }
        ISurfaceGeo[] iSurfaceGeoArray = new ISurfaceGeo[]{new ISurfaceGeo(iVecIArray, iVolumeI.udeg(), iVolumeI.vdeg(), iVolumeI.uknots(), iVolumeI.vknots(), iVolumeI.ustart(), iVolumeI.uend(), iVolumeI.vstart(), iVolumeI.vend()), new ISurfaceGeo(iVecIArray2, iVolumeI.udeg(), iVolumeI.vdeg(), iVolumeI.uknots(), iVolumeI.vknots(), iVolumeI.ustart(), iVolumeI.uend(), iVolumeI.vstart(), iVolumeI.vend()), new ISurfaceGeo(iVecIArray3, iVolumeI.vdeg(), iVolumeI.wdeg(), iVolumeI.vknots(), iVolumeI.wknots(), iVolumeI.vstart(), iVolumeI.vend(), iVolumeI.wstart(), iVolumeI.wend()), new ISurfaceGeo(iVecIArray4, iVolumeI.vdeg(), iVolumeI.wdeg(), iVolumeI.vknots(), iVolumeI.wknots(), iVolumeI.vstart(), iVolumeI.vend(), iVolumeI.wstart(), iVolumeI.wend()), new ISurfaceGeo(iVecIArray5, iVolumeI.wdeg(), iVolumeI.udeg(), iVolumeI.wknots(), iVolumeI.uknots(), iVolumeI.wstart(), iVolumeI.wend(), iVolumeI.ustart(), iVolumeI.uend()), new ISurfaceGeo(iVecIArray6, iVolumeI.wdeg(), iVolumeI.udeg(), iVolumeI.wknots(), iVolumeI.uknots(), iVolumeI.wstart(), iVolumeI.wend(), iVolumeI.ustart(), iVolumeI.uend())};
        return iSurfaceGeoArray;
    }

    public void setAttribute(IAttribute iAttribute) {
        int n;
        super.setAttribute(iAttribute);
        if (this.fills != null) {
            for (n = 0; n < this.fills.length; ++n) {
                this.fills[n].setAttribute(iAttribute);
            }
        }
        if (this.wireframes != null) {
            for (n = 0; n < this.wireframes.length; ++n) {
                this.wireframes[n].setAttribute(iAttribute);
            }
        }
    }

    public void setColor(IColor iColor) {
        int n;
        super.setColor(iColor);
        if (this.fills != null) {
            for (n = 0; n < this.fills.length; ++n) {
                this.fills[n].setColor(iColor);
            }
        }
        if (this.wireframes != null) {
            for (n = 0; n < this.wireframes.length; ++n) {
                this.wireframes[n].setColor(iColor);
            }
        }
    }

    public void setWeight(float f) {
        if (this.wireframes != null) {
            for (int i = 0; i < this.wireframes.length; ++i) {
                this.wireframes[i].setWeight(f);
            }
        }
    }

    public float getWeight() {
        if (this.wireframes != null) {
            return this.wireframes[0].getWeight();
        }
        return -1.0f;
    }

    public void update() {
        int n;
        if (this.fills != null) {
            for (n = 0; n < this.fills.length; ++n) {
                this.fills[n].update();
            }
        }
        if (this.wireframes != null) {
            for (n = 0; n < this.wireframes.length; ++n) {
                this.wireframes[n].update();
            }
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }

    public void draw(IGraphics iGraphics) {
        int n;
        if (iGraphics.view().mode().isFill()) {
            for (n = 0; n < this.fills.length; ++n) {
                this.fills[n].draw(iGraphics);
            }
        }
        if (iGraphics.view().mode().isWireframe()) {
            for (n = 0; n < this.wireframes.length; ++n) {
                this.wireframes[n].draw(iGraphics);
            }
        }
    }
}

