/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAttribute;
import igeo.IColor;
import igeo.IConfig;
import igeo.IDynamics;
import igeo.IG;
import igeo.IGraphicObject;
import igeo.ILayer;
import igeo.IOut;
import igeo.IParameterObject;
import igeo.IServer;
import igeo.IServerI;
import igeo.ITexture;
import igeo.gui.IGraphicMode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IObject {
    public IServer server;
    public IParameterObject parameter;
    public ArrayList<IGraphicObject> graphics;
    public ArrayList<IDynamics> dynamics;
    public IAttribute attribute;
    public Object[] userData;

    public IObject() {
        this.initObject(null);
    }

    public IObject(IServerI iServerI) {
        this.initObject(iServerI);
    }

    public IObject(IObject iObject) {
        this.initObject(iObject.server);
        if (iObject.attribute != null) {
            this.attribute = iObject.attribute.dup();
        }
    }

    public IObject(IServerI iServerI, IObject iObject) {
        this.initObject(iServerI);
        if (iObject.attribute != null) {
            this.attribute = iObject.attribute.dup();
        }
    }

    public IObject dup() {
        return new IObject(this);
    }

    public IObject cp() {
        return this.dup();
    }

    public void initObject(IServerI iServerI) {
        this.server = null;
        if (iServerI == null) {
            IG iG = IG.cur();
            if (iG == null) {
                IOut.err("no IG is found. IObject is not stored in a server.");
                return;
            }
            this.server = iG.server();
        } else {
            this.server = iServerI.server();
        }
        this.server.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initGraphic(IServerI iServerI) {
        IG iG;
        this.server = null;
        if (iServerI == null) {
            iG = IG.current();
            if (iG == null) {
                IOut.err("no IG is found. IObject is not stored in a server.");
                return;
            }
            this.server = iG.server();
        } else {
            this.server = iServerI.server();
        }
        if (this.server.isGraphicMode()) {
            iG = this.server.server().ig;
            synchronized (iG) {
                this.server.graphicServer().add(this);
            }
        }
    }

    public void del() {
        if (this.server != null) {
            this.server.remove(this);
            this.server = null;
        } else if (IG.current() != null) {
            IG.current().server().remove(this);
        }
    }

    public boolean isValid() {
        return true;
    }

    public void setParameter(IParameterObject iParameterObject) {
        if (this.parameter != null) {
            IOut.err("parameter is already set. overwrote.");
        }
        this.parameter = iParameterObject;
    }

    public void addDynamics(IDynamics iDynamics) {
        if (this.dynamics == null) {
            this.dynamics = new ArrayList();
        }
        if (!this.dynamics.contains(iDynamics)) {
            this.dynamics.add(iDynamics);
        }
        if (this.server != null && this.server.dynamicServer() != null) {
            this.server.dynamicServer().add(iDynamics);
        }
    }

    public IParameterObject getParameter() {
        return this.parameter;
    }

    public IGraphicObject getGraphic(int n) {
        if (this.graphics == null) {
            return null;
        }
        return this.graphics.get(n);
    }

    public IDynamics getDynamics(int n) {
        if (this.dynamics == null) {
            return null;
        }
        return this.dynamics.get(n);
    }

    public int graphicsNum() {
        if (this.graphics == null) {
            return 0;
        }
        return this.graphics.size();
    }

    public int dynamicsNum() {
        if (this.dynamics == null) {
            return 0;
        }
        return this.dynamics.size();
    }

    public void clearGraphics() {
        if (this.graphics != null) {
            this.graphics.clear();
        }
    }

    public void clearDynamics() {
        if (this.dynamics != null) {
            this.dynamics.clear();
        }
    }

    public void deletDynamics(int n) {
        if (n < 0 || n >= this.dynamics.size()) {
            return;
        }
        if (this.server != null && this.server.dynamicServer != null) {
            this.server.dynamicServer.remove(this.dynamics.get(n));
        }
        this.dynamics.remove(n);
    }

    public void deleteDynamics(IDynamics iDynamics) {
        if (!this.dynamics.contains(iDynamics)) {
            return;
        }
        if (this.server != null && this.server.dynamicServer != null) {
            this.server.dynamicServer.remove(iDynamics);
        }
        this.dynamics.remove(iDynamics);
    }

    public void deleteDynamics() {
        if (this.server != null && this.server.dynamicServer != null) {
            for (IDynamics iDynamics : this.dynamics) {
                this.server.dynamicServer.remove(iDynamics);
            }
        }
    }

    public IGraphicObject getGraphic(IGraphicMode iGraphicMode) {
        if (this.graphics == null) {
            this.graphics = new ArrayList();
        } else {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (!iGraphicObject.isDrawable(iGraphicMode)) continue;
                return iGraphicObject;
            }
        }
        IGraphicObject iGraphicObject = this.createGraphic(iGraphicMode);
        if (this.attribute != null) {
            iGraphicObject.setAttribute(this.attribute);
        }
        if (iGraphicObject != null) {
            this.graphics.add(iGraphicObject);
        }
        return iGraphicObject;
    }

    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return null;
    }

    public void deleteGraphic() {
        if (this.server != null && this.server.graphicServer != null && this.graphics != null) {
            for (int i = 0; i < this.graphics.size(); ++i) {
                this.server.graphicServer.remove(this.graphics.get(i));
            }
        }
    }

    public void updateGraphic() {
        if (this.graphics != null) {
            for (int i = 0; i < this.graphics.size(); ++i) {
                this.graphics.get(i).update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetGraphic() {
        this.deleteGraphic();
        if (this.server != null && this.server.graphicServer != null) {
            IG iG = this.server.server().ig;
            synchronized (iG) {
                this.server.graphicServer().add(this);
            }
        }
    }

    public IServer server() {
        return this.server;
    }

    public String name() {
        if (this.attribute != null) {
            return this.attribute.name;
        }
        return null;
    }

    public IObject name(String string) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.name = string;
        return this;
    }

    public ILayer layer() {
        if (this.attribute != null) {
            return this.attribute.layer;
        }
        return null;
    }

    public IObject layer(ILayer iLayer) {
        if (iLayer == null) {
            if (this.attribute != null) {
                this.attribute.layer = null;
            }
        } else if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
            if (!iLayer.contains(this)) {
                iLayer.add(this);
            }
            this.attribute.layer = iLayer;
        } else if (this.attribute.layer != iLayer) {
            if (!iLayer.contains(this)) {
                iLayer.add(this);
            }
            this.attribute.layer = iLayer;
        }
        return this;
    }

    public IObject layer(String string) {
        if (this.server != null) {
            return this.layer(this.server.layer(string));
        }
        return this.layer(IG.layer(string));
    }

    public IAttribute attr() {
        return this.attribute;
    }

    public IObject attr(IAttribute iAttribute) {
        this.attribute = iAttribute;
        if (this.attribute != null && this.graphics != null) {
            for (int i = 0; i < this.graphics.size(); ++i) {
                this.graphics.get(i).setAttribute(this.attribute);
            }
        }
        return this;
    }

    public IObject attr(IObject iObject) {
        if (iObject != null && iObject.attr() != null) {
            this.attr(iObject.attr().dup());
        }
        return this;
    }

    public IAttribute defaultAttribute() {
        return new IAttribute();
    }

    public Object[] userData() {
        return this.userData;
    }

    public Object userData(int n) {
        if (this.userData == null || n >= this.userData.length) {
            return null;
        }
        return this.userData[n];
    }

    public int userDataNum() {
        return this.userData == null ? 0 : this.userData.length;
    }

    public IObject userData(Object[] objectArray) {
        this.userData = objectArray;
        return this;
    }

    public IObject addUserData(Object object) {
        if (this.userData == null) {
            this.userData = new Object[1];
            this.userData[0] = object;
        } else {
            Object[] objectArray = new Object[this.userData.length + 1];
            for (int i = 0; i < this.userData.length; ++i) {
                objectArray[i] = this.userData[i];
            }
            objectArray[this.userData.length] = object;
            this.userData = objectArray;
        }
        return this;
    }

    public IObject addUserData(String string, String string2) {
        HashMap<String, String> hashMap = null;
        if (this.userData == null) {
            this.userData = new Object[1];
            this.userData[0] = hashMap = new HashMap<String, String>();
        } else {
            for (int i = 0; i < this.userData.length && hashMap == null; ++i) {
                Object v;
                Object k;
                Iterator iterator;
                HashMap hashMap2;
                Set set;
                if (!(this.userData[i] instanceof HashMap) || (set = (hashMap2 = (HashMap)this.userData[i]).keySet()) == null || (iterator = set.iterator()) == null || !((k = iterator.next()) instanceof String) || !((v = hashMap2.get(k)) instanceof String)) continue;
                hashMap = IObject.castStringHashMap(hashMap2);
            }
            if (hashMap == null) {
                Object[] objectArray = new Object[this.userData.length + 1];
                for (int i = 0; i < this.userData.length; ++i) {
                    objectArray[i] = this.userData[i];
                }
                objectArray[this.userData.length] = hashMap = new HashMap();
                this.userData = objectArray;
            }
        }
        hashMap.put(string, string2);
        return this;
    }

    public static HashMap<String, String> castStringHashMap(HashMap hashMap) {
        return hashMap;
    }

    public boolean visible() {
        if (this.attribute != null) {
            return this.attribute.visible();
        }
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (!iGraphicObject.visible()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible();
    }

    public IObject hide() {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.hide();
            }
        }
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.hide();
        return this;
    }

    public IObject show() {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.show();
            }
        }
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.show();
        return this;
    }

    public void syncGraphic() {
        this.syncColor();
        this.syncWeight();
        this.syncVisibility();
    }

    public void syncColor() {
        if (this.attribute != null && this.attribute.clr() != null && this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(this.attribute.clr());
            }
        }
    }

    public void syncVisibility() {
        if (this.attribute != null && this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setVisible(this.attribute.visible());
            }
        }
    }

    public void syncWeight() {
        if (this.attribute != null && this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setWeight(this.attribute.weight());
            }
        }
    }

    public IColor clr() {
        if (this.attribute != null && this.attribute.clr() != null) {
            return this.attribute.clr();
        }
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (iGraphicObject.getColor() == null) continue;
                return iGraphicObject.getColor();
            }
        }
        return IConfig.objectColor;
    }

    public float weight() {
        if (this.attribute != null) {
            return this.attribute.weight;
        }
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (!(iGraphicObject.getWeight() >= 0.0f)) continue;
                return iGraphicObject.getWeight();
            }
        }
        return IConfig.strokeWeight;
    }

    public int redInt() {
        return this.clr().getRed();
    }

    public int greenInt() {
        return this.clr().getGreen();
    }

    public int blueInt() {
        return this.clr().getBlue();
    }

    public int alphaInt() {
        return this.clr().getAlpha();
    }

    public int greyInt() {
        return this.clr().getGrey();
    }

    public int grayInt() {
        return this.greyInt();
    }

    public float red() {
        return this.clr().red();
    }

    public float green() {
        return this.clr().green();
    }

    public float blue() {
        return this.clr().blue();
    }

    public float alpha() {
        return this.clr().alpha();
    }

    public float grey() {
        return this.clr().grey();
    }

    public float gray() {
        return this.clr().gray();
    }

    public float hue() {
        return this.clr().hue();
    }

    public float saturation() {
        return this.clr().saturation();
    }

    public float brightness() {
        return this.clr().brightness();
    }

    public IObject clr(IColor iColor) {
        if (iColor == null) {
            return this;
        }
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(iColor);
        this.syncColor();
        return this;
    }

    public IObject clr(IColor iColor, int n) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(iColor, n);
        this.syncColor();
        return this;
    }

    public IObject clr(IColor iColor, float f) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(iColor, f);
        this.syncColor();
        return this;
    }

    public IObject clr(IColor iColor, double d) {
        return this.clr(iColor, (float)d);
    }

    public IObject clr(IObject iObject) {
        this.clr(iObject.clr());
        return this;
    }

    public Color awtColor() {
        if (this.attribute != null) {
            return this.attribute.color.awt();
        }
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (iGraphicObject.getColor() == null) continue;
                return iGraphicObject.getColor().awt();
            }
        }
        return IConfig.objectColor.awt();
    }

    public Color getAWTColor() {
        return this.awtColor();
    }

    public IObject clr(Color color) {
        return this.clr(new IColor(color));
    }

    public IObject clr(Color color, int n) {
        return this.clr(new IColor(color), n);
    }

    public IObject clr(Color color, float f) {
        return this.clr(new IColor(color), f);
    }

    public IObject clr(Color color, double d) {
        return this.clr(new IColor(color), d);
    }

    public IColor getColor() {
        return this.clr();
    }

    public IObject clr(int n) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(n);
        this.syncColor();
        return this;
    }

    public IObject clr(double d) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(d);
        this.syncColor();
        return this;
    }

    public IObject clr(float f) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(f);
        this.syncColor();
        return this;
    }

    public IObject clr(int n, int n2) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(n, n2);
        this.syncColor();
        return this;
    }

    public IObject clr(double d, double d2) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(d, d2);
        this.syncColor();
        return this;
    }

    public IObject clr(float f, float f2) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(f, f2);
        this.syncColor();
        return this;
    }

    public IObject clr(int n, int n2, int n3) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(n, n2, n3);
        this.syncColor();
        return this;
    }

    public IObject clr(double d, double d2, double d3) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(d, d2, d3);
        this.syncColor();
        return this;
    }

    public IObject clr(float f, float f2, float f3) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(f, f2, f3);
        this.syncColor();
        return this;
    }

    public IObject clr(int n, int n2, int n3, int n4) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(n, n2, n3, n4);
        this.syncColor();
        return this;
    }

    public IObject clr(double d, double d2, double d3, double d4) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(d, d2, d3, d4);
        this.syncColor();
        return this;
    }

    public IObject clr(float f, float f2, float f3, float f4) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.clr(f, f2, f3, f4);
        this.syncColor();
        return this;
    }

    public IObject hsb(double d, double d2, double d3, double d4) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.hsb(d, d2, d3, d4);
        this.syncColor();
        return this;
    }

    public IObject hsb(float f, float f2, float f3, float f4) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.hsb(f, f2, f3, f4);
        this.syncColor();
        return this;
    }

    public IObject hsb(double d, double d2, double d3) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.hsb(d, d2, d3);
        this.syncColor();
        return this;
    }

    public IObject hsb(float f, float f2, float f3) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.hsb(f, f2, f3);
        this.syncColor();
        return this;
    }

    public IObject weight(double d) {
        return this.weight((float)d);
    }

    public IObject weight(float f) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.weight(f);
        this.syncWeight();
        return this;
    }

    public IObject setColor(IColor iColor) {
        return this.clr(iColor);
    }

    public IObject setColor(IColor iColor, int n) {
        return this.clr(iColor, n);
    }

    public IObject setColor(IColor iColor, float f) {
        return this.clr(iColor, f);
    }

    public IObject setColor(IColor iColor, double d) {
        return this.clr(iColor, d);
    }

    public IObject setColor(Color color) {
        return this.clr(color);
    }

    public IObject setColor(Color color, int n) {
        return this.clr(color, n);
    }

    public IObject setColor(Color color, float f) {
        return this.clr(color, f);
    }

    public IObject setColor(Color color, double d) {
        return this.clr(color, d);
    }

    public IObject setColor(int n) {
        return this.clr(n);
    }

    public IObject setColor(float f) {
        return this.clr(f);
    }

    public IObject setColor(double d) {
        return this.clr(d);
    }

    public IObject setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    public IObject setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    public IObject setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    public IObject setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    public IObject setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    public IObject setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    public IObject setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    public IObject setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    public IObject setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    public IObject setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    public IObject setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    public IObject setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    public IObject setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }

    public IObject texture(ITexture iTexture) {
        if (this.attribute == null) {
            this.attribute = this.defaultAttribute();
        }
        this.attribute.texture = iTexture;
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setAttribute(this.attribute);
            }
        }
        return this;
    }

    public IObject setTexture(ITexture iTexture) {
        return this.texture(iTexture);
    }
}

