/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBoolI;
import igeo.IConfig;
import igeo.ICurveGeo;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IOut;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVecI;

public class IArcGeo
extends ICurveGeo {
    public static double maxSegmentAngle = 0.39269908169872414;
    public IVecI center;
    public IVecI normal;
    public IVecI startPt;
    public IDoubleI angle;

    public static int arcDeg() {
        return 2;
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, double d) {
        if (d < 0.0) {
            iVec2 = iVec2.dup().neg();
            d = -d;
        }
        int n = (int)(d / maxSegmentAngle) + 1;
        IVec4[] iVec4Array = new IVec4[n * 2 + 1];
        IVec iVec4 = iVec3.diff(iVec);
        IVec iVec5 = iVec4.dup();
        double d2 = iVec4.len();
        double d3 = d / (double)n;
        double d4 = d3 / 2.0;
        double d5 = d2 / Math.cos(d4);
        iVec5.len(d5);
        iVec5.rot(iVec2, d4);
        for (int i = 0; i < iVec4Array.length; ++i) {
            iVec4Array[i] = iVec.to4d();
            if (i % 2 == 0) {
                iVec4Array[i].add(iVec4);
                iVec4.rot(iVec2, d3);
                continue;
            }
            iVec4Array[i].add(iVec5);
            iVec4Array[i].w = Math.cos(d4);
            iVec5.rot(iVec2, d3);
        }
        return iVec4Array;
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, double d, int n) {
        if (d < 0.0) {
            iVec2 = iVec2.dup().neg();
            d = -d;
        }
        IVec4[] iVec4Array = new IVec4[n * 2 + 1];
        IVec iVec4 = iVec3.diff(iVec);
        IVec iVec5 = iVec4.dup();
        double d2 = iVec4.len();
        double d3 = d / (double)n;
        double d4 = d3 / 2.0;
        double d5 = d2 / Math.cos(d4);
        iVec5.len(d5);
        iVec5.rot(iVec2, d4);
        for (int i = 0; i < iVec4Array.length; ++i) {
            iVec4Array[i] = iVec.to4d();
            if (i % 2 == 0) {
                iVec4Array[i].add(iVec4);
                iVec4.rot(iVec2, d3);
                continue;
            }
            iVec4Array[i].add(iVec5);
            iVec4Array[i].w = Math.cos(d4);
            iVec5.rot(iVec2, d3);
        }
        return iVec4Array;
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, boolean bl) {
        IVec iVec4 = iVec2.diff(iVec);
        IVec iVec5 = iVec3.diff(iVec);
        IVec iVec6 = null;
        iVec6 = iVec4.isParallel(iVec5) ? iVec5.cross(iVec4.cross(IVec.zaxis)) : iVec5.cross(iVec4);
        double d = iVec4.angle(iVec5);
        if (d == 0.0 || d == Math.PI) {
            iVec6 = iVec4.x != 0.0 || iVec4.y != 0.0 ? iVec4.cross(IVec.zaxis) : iVec4.cross(IVec.xaxis);
        }
        if (bl) {
            d = Math.PI * 2 - d;
            iVec6.neg();
        }
        return IArcGeo.arcCP(iVec, iVec6, iVec2, d);
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, boolean bl, int n) {
        IVec iVec4 = iVec2.diff(iVec);
        IVec iVec5 = iVec3.diff(iVec);
        IVec iVec6 = null;
        iVec6 = iVec4.isParallel(iVec5) ? iVec5.cross(iVec4.cross(IVec.zaxis)) : iVec5.cross(iVec4);
        double d = iVec4.angle(iVec5);
        if (d == 0.0 || d == Math.PI) {
            iVec6 = iVec4.x != 0.0 || iVec4.y != 0.0 ? iVec4.cross(IVec.zaxis) : iVec4.cross(IVec.xaxis);
        }
        if (bl) {
            d = Math.PI * 2 - d;
            iVec6.neg();
        }
        return IArcGeo.arcCP(iVec, iVec6, iVec2, d, n);
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5) {
        IVec iVec6 = iVec2.diff(iVec);
        IVec iVec7 = iVec4.diff(iVec);
        IVec iVec8 = iVec3.diff(iVec);
        double d = iVec6.angle(iVec7, iVec5);
        double d2 = iVec6.angle(iVec8, iVec5);
        if (d > 0.0 && d2 < 0.0) {
            d = -(Math.PI * 2 - d);
        } else if (d < 0.0 && d2 > 0.0) {
            d = Math.PI * 2 + d;
        }
        if (d < 0.0) {
            iVec5.neg();
            d = -d;
        }
        iVec5.neg();
        return IArcGeo.arcCP(iVec, iVec5, iVec2, d);
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5, int n) {
        IVec iVec6 = iVec2.diff(iVec);
        IVec iVec7 = iVec4.diff(iVec);
        IVec iVec8 = iVec3.diff(iVec);
        double d = iVec6.angle(iVec7, iVec5);
        double d2 = iVec6.angle(iVec8, iVec5);
        if (d > 0.0 && d2 < 0.0) {
            d = -(Math.PI * 2 - d);
        } else if (d < 0.0 && d2 > 0.0) {
            d = Math.PI * 2 + d;
        }
        if (d < 0.0) {
            iVec5.neg();
            d = -d;
        }
        iVec5.neg();
        return IArcGeo.arcCP(iVec, iVec5, iVec2, d, n);
    }

    public static double[] arcKnots(double d) {
        double d2;
        if (d < 0.0) {
            d = -d;
        }
        int n = (int)(d / maxSegmentAngle) + 1;
        double d3 = d / (double)n;
        double[] dArray = new double[(n + 1) * 2 + 2];
        int n2 = 0;
        dArray[n2] = d2 = 0.0;
        dArray[++n2] = d2;
        dArray[++n2] = d2;
        ++n2;
        while (n2 < dArray.length - 1) {
            dArray[n2] = d2 += d3;
            dArray[++n2] = d2;
            ++n2;
        }
        dArray[n2] = d2;
        n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] / d2;
        }
        return dArray;
    }

    public static double[] arcKnots(double d, int n) {
        double d2;
        if (d < 0.0) {
            d = -d;
        }
        double d3 = d / (double)n;
        double[] dArray = new double[(n + 1) * 2 + 2];
        int n2 = 0;
        dArray[n2] = d2 = 0.0;
        dArray[++n2] = d2;
        dArray[++n2] = d2;
        ++n2;
        while (n2 < dArray.length - 1) {
            dArray[n2] = d2 += d3;
            dArray[++n2] = d2;
            ++n2;
        }
        dArray[n2] = d2;
        n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] / d2;
        }
        return dArray;
    }

    public IArcGeo() {
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        this.init(iVecI, iVecI2, iVecI3, d);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        this.init(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iBoolI);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        this.init(iVecI, iVecI2, iVecI3, bl);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        this.init(iVecI, iVecI2, iVecI3, iVecI4, iVecI5);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IDoubleI iDoubleI, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iVecI4, iDoubleI, iBoolI);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, double d, boolean bl) {
        this.init(iVecI, iVecI2, iVecI3, iVecI4, d, bl);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iDoubleI, iBoolI);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, boolean bl) {
        this.init(iVecI, iVecI2, iVecI3, d, bl);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVec iVec = iVecI.get().nml(iVecI2, iVecI3);
        IVec iVec2 = iVecI2.get().dif(iVecI);
        IVec iVec3 = iVecI3.get().dif(iVecI2);
        IVec iVec4 = iVecI2.get().mid(iVecI);
        IVec iVec5 = iVecI3.get().mid(iVecI2);
        iVec2.rot(iVec, 1.5707963267948966);
        iVec3.rot(iVec, 1.5707963267948966);
        IVec iVec6 = IVec.intersect(iVec4, iVec4.cp(iVec2), iVec5, iVec5.cp(iVec3));
        this.init((IVecI)iVec6, iVecI, iVecI2, iVecI3, iVec);
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        this.center = iVecI;
        this.normal = iVecI2;
        this.startPt = iVecI3;
        this.angle = iDoubleI;
        IVecI[] iVecIArray = IArcGeo.arcCP(iVecI.get(), iVecI2.get(), iVecI3.get(), iDoubleI.x());
        super.init(iVecIArray, IArcGeo.arcDeg(), IArcGeo.arcKnots(iDoubleI.x()));
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        this.center = iVecI;
        this.normal = iVecI2;
        this.startPt = iVecI3;
        this.angle = new IDouble(d);
        IVecI[] iVecIArray = IArcGeo.arcCP(iVecI.get(), iVecI2.get(), iVecI3.get(), d);
        super.init(iVecIArray, IArcGeo.arcDeg(), IArcGeo.arcKnots(d));
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iBoolI.x());
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        IVec iVec;
        IVec iVec2 = iVecI2.get().diff(iVecI);
        this.normal = iVec2.isParallel(iVec = iVecI3.get().diff(iVecI)) ? iVec.cross(iVec2.cross(IVec.zaxis)) : iVec.cross(iVec2);
        double d = iVec2.angle((IVecI)iVec, this.normal);
        if (d == 0.0 || d == Math.PI) {
            this.normal = iVec2.x != 0.0 || iVec2.y != 0.0 ? iVec2.cross(IVec.zaxis) : iVec2.cross(IVec.xaxis);
        }
        if (bl) {
            if (d >= 0.0) {
                d = Math.PI * 2 - d;
                this.normal.neg();
            } else {
                d += Math.PI * 2;
            }
        }
        this.init(iVecI, this.normal, iVecI2, new IDouble(d));
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        IVec iVec = iVecI2.get().diff(iVecI);
        IVec iVec2 = iVecI4.get().diff(iVecI);
        IVec iVec3 = iVecI3.get().diff(iVecI);
        double d = iVec.angle((IVecI)iVec2, iVecI5);
        double d2 = iVec.angle((IVecI)iVec3, iVecI5);
        if (d > 0.0 && d2 < 0.0) {
            d = -(Math.PI * 2 - d);
        } else if (d < 0.0 && d2 > 0.0) {
            d = Math.PI * 2 + d;
        }
        if (d < 0.0) {
            iVecI5.neg();
            d = -d;
        }
        this.init(iVecI, iVecI5, iVecI2, new IDouble(d));
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IDoubleI iDoubleI, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iVecI4, iDoubleI.x(), iBoolI.x());
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, double d, boolean bl) {
        IVec iVec;
        IVec iVec2 = IVec.intersect(iVecI.get(), iVecI2.get(), iVecI3.get(), iVecI4.get());
        IVec iVec3 = iVecI2.get().dif(iVec2);
        IVec iVec4 = iVecI4.get().dif(iVec2);
        if (iVec3.len2() < IConfig.tolerance * IConfig.tolerance) {
            iVec3 = iVecI.get().dif(iVec2);
        }
        if (iVec4.len2() < IConfig.tolerance * IConfig.tolerance) {
            iVec4 = iVecI3.get().dif(iVec2);
        }
        if (iVec2 != null && IVec.distBetween2Lines(iVecI, iVecI2, iVecI3, iVecI4) < IConfig.tolerance) {
            iVec3.len(d).add(iVec2);
            iVec4.len(d).add(iVec2);
            this.init((IVecI)iVec2, (IVecI)iVec3, (IVecI)iVec4, bl);
            return;
        }
        IVec iVec5 = iVecI2.get().dif(iVecI);
        if (!iVec5.isParallel(iVec = iVecI4.get().dif(iVecI3))) {
            IVec[] iVecArray = IVec.closestPointsOn2Lines((IVecI)iVec5, iVecI, (IVecI)iVec, iVecI3);
            if (iVecArray != null && iVecArray.length >= 2) {
                IVec iVec6 = iVecArray[0].mid(iVecArray[1]);
                if (iVec5.dot(iVec3) < 0.0) {
                    iVec5.neg();
                }
                if (iVec.dot(iVec4) < 0.0) {
                    iVec.neg();
                }
                IVec[] iVecArray2 = IVec.intersectLineAndSphere(iVec5, iVecI.get(), iVec6, d);
                IVec[] iVecArray3 = IVec.intersectLineAndSphere(iVec, iVecI3.get(), iVec6, d);
                if (iVecArray2 == null || iVecArray3 == null) {
                    IOut.err("Arc could not be created for non-intersecting lines. too small radius.");
                    return;
                }
                this.init((IVecI)iVec6, (IVecI)iVecArray2[0], (IVecI)iVecArray3[0], bl);
                return;
            }
            IOut.err("Arc could not be created.");
            return;
        }
        IOut.err("arc could not be created for parallel lines.");
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iDoubleI.x(), iBoolI.x());
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, boolean bl) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVecI3.get().dif(iVecI);
        iVec.len(d).add(iVecI);
        iVec2.len(d).add(iVecI);
        this.init(iVecI, (IVecI)iVec, (IVecI)iVec2, bl);
    }
}

