/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.texture.Texture;
import igeo.IColor;
import igeo.IConfig;
import igeo.IGraphicI;
import igeo.ITexture;
import igeo.IVec;
import igeo.IVec2f;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphicsGL;
import igeo.gui.ITextureGraphicGL;
import igeo.gui.ITextureGraphicGL2;
import igeo.gui.IView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class IGraphicsGL2
implements IGraphicsGL {
    public static float[] defaultGLLightPosition = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static float[] defaultGLAmbientLight = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    public static float[] defaultGLDiffuseLight = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
    public static float[] defaultGLSpecularLight = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static boolean defaultGLTwoSidedLighting = false;
    public GL gl;
    public GL2 gl2;
    public Graphics2D g;
    public IView view;
    public double[][][] bgColor = new double[2][2][3];
    public Texture bgTexture;
    public int bgTextureID;
    public boolean firstDraw = true;
    String imageFile;

    @Override
    public IView view() {
        return this.view;
    }

    @Override
    public void setGL(GL gL) {
        this.gl = gL;
        this.gl2 = gL.getGL2();
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    @Override
    public GL getGL() {
        return this.gl2;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    @Override
    public IGraphicMode.GraphicType type() {
        return IGraphicMode.GraphicType.GL;
    }

    @Override
    public void setBGImage(String string) {
        this.imageFile = string;
        this.bgTexture = ITextureGraphicGL2.getTexture(this.imageFile);
        if (this.bgTexture != null) {
            this.bgTextureID = this.bgTexture.getTextureObject();
        }
    }

    public void drawBG(GL gL, IView iView) {
        GL2 gL2 = gL.getGL2();
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        if (this.bgTexture != null) {
            gL2.glDisable(3042);
            gL2.glEnable(3553);
            gL2.glTexEnvf(8960, 8704, 7681.0f);
            gL2.glBindTexture(3553, this.bgTextureID);
            gL2.glBegin(7);
            gL2.glTexCoord2f(0.0f, 0.0f);
            gL2.glVertex3d(-1.0, -1.0, 0.0);
            gL2.glTexCoord2f(1.0f, 0.0f);
            gL2.glVertex3d(1.0, -1.0, 0.0);
            gL2.glTexCoord2f(1.0f, 1.0f);
            gL2.glVertex3d(1.0, 1.0, 0.0);
            gL2.glTexCoord2f(0.0f, 1.0f);
            gL2.glVertex3d(-1.0, 1.0, 0.0);
            gL2.glEnd();
            gL2.glBindTexture(3553, 0);
            gL2.glEnable(3042);
        } else if (this.view.bgColor != null) {
            for (int i = 0; i < this.bgColor.length; ++i) {
                for (int j = 0; j < this.bgColor[i].length; ++j) {
                    this.bgColor[i][j][0] = (double)this.view.bgColor[i][j].getRed() / 255.0;
                    this.bgColor[i][j][1] = (double)this.view.bgColor[i][j].getGreen() / 255.0;
                    this.bgColor[i][j][2] = (double)this.view.bgColor[i][j].getBlue() / 255.0;
                }
            }
            gL2.glBegin(7);
            gL2.glColor3dv(this.bgColor[0][1], 0);
            gL2.glVertex3d(-1.0, -1.0, 0.0);
            gL2.glColor3dv(this.bgColor[1][1], 0);
            gL2.glVertex3d(1.0, -1.0, 0.0);
            gL2.glColor3dv(this.bgColor[1][0], 0);
            gL2.glVertex3d(1.0, 1.0, 0.0);
            gL2.glColor3dv(this.bgColor[0][0], 0);
            gL2.glVertex3d(-1.0, 1.0, 0.0);
            gL2.glEnd();
        }
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
    }

    public void drawView(IView iView) {
        this.gl2.glViewport(iView.screenX, iView.screenY, iView.screenWidth, iView.screenHeight);
        if (IConfig.clearBG || this.firstDraw) {
            this.gl2.glDisable(2929);
            this.drawBG(this.gl, iView);
        }
        if (iView.mode.isTransparent() && !iView.mode.isWireframe() || IConfig.disableDepthTest) {
            this.gl2.glDisable(2929);
        } else if (IConfig.depthSort) {
            this.gl2.glEnable(2929);
        }
        if (iView.mode.isLight()) {
            this.gl2.glMatrixMode(5888);
            this.gl2.glPushMatrix();
            this.gl2.glLoadIdentity();
            this.gl2.glLightfv(16385, 4611, defaultGLLightPosition, 0);
            this.gl2.glLightfv(16385, 4608, defaultGLAmbientLight, 0);
            this.gl2.glLightfv(16385, 4609, defaultGLDiffuseLight, 0);
            this.gl2.glLightfv(16385, 4610, defaultGLSpecularLight, 0);
            if (defaultGLTwoSidedLighting) {
                this.gl2.glLightModeli(2898, 1);
            }
            this.gl2.glEnable(16385);
            this.gl2.glEnable(2896);
            this.gl2.glPopMatrix();
        }
        this.gl2.glMatrixMode(5889);
        this.gl2.glLoadIdentity();
        if (iView.axonometric) {
            double d = (double)iView.screenWidth * iView.axonRatio;
            double d2 = (double)iView.screenHeight * iView.axonRatio;
            this.gl2.glOrtho(-d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, iView.near, iView.far);
        } else {
            double d = iView.near * iView.persRatio * 2.0;
            double d3 = d * (double)iView.screenWidth / (double)iView.screenHeight;
            this.gl2.glFrustum(-d3 / 2.0, d3 / 2.0, -d / 2.0, d / 2.0, iView.near, iView.far);
        }
        this.gl2.glMatrixMode(5888);
        this.gl2.glLoadMatrixd(iView.transformArray, 0);
    }

    @Override
    public void draw(ArrayList<IGraphicI> arrayList, IView iView) {
        this.view = iView;
        if (this.view.hide) {
            return;
        }
        this.drawView(this.view);
        if (arrayList != null) {
            if (IConfig.drawOrderForward) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).isVisible()) continue;
                    arrayList.get(i).draw(this);
                }
            } else {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    if (!arrayList.get(i).isVisible()) continue;
                    arrayList.get(i).draw(this);
                }
            }
        }
        if (this.view.mode().isLight()) {
            this.gl2.glDisable(2896);
            this.gl2.glDisable(16385);
        }
        if (this.g != null && this.view.pane != null && this.view.pane.getBorderWidth() > 0.0f && (this.view.pane.getPanel().getWidth() != this.view.pane.getWidth() || this.view.pane.getPanel().getHeight() != this.view.pane.getHeight())) {
            this.g.setColor(new Color(this.view.pane.getBorderColor(), true));
            this.g.setStroke(new BasicStroke(this.view.pane.getBorderWidth()));
            this.g.drawRect((int)this.view.pane.getX(), (int)this.view.pane.getY(), this.view.pane.getWidth(), this.view.pane.getHeight());
        }
    }

    @Override
    public boolean firstDraw() {
        return this.firstDraw;
    }

    @Override
    public void firstDraw(boolean bl) {
        this.firstDraw = bl;
    }

    @Override
    public void clr(IColor iColor) {
        this.gl2.glColor4fv(iColor.rgba(), 0);
    }

    @Override
    public void clr(float[] fArray) {
        this.gl2.glColor4fv(fArray, 0);
    }

    @Override
    public void clr(float f, float f2, float f3, float f4) {
        this.gl2.glColor4f(f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f);
    }

    @Override
    public void clr(float f, float f2, float f3) {
        this.clr(f, f2, f3, 255.0f);
    }

    public void clr(IColor iColor, float f) {
        this.gl2.glColor4f(iColor.r(), iColor.g(), iColor.b(), f);
    }

    @Override
    public void stroke(IColor iColor) {
        this.clr(iColor);
    }

    @Override
    public void stroke(float[] fArray) {
        this.clr(fArray);
    }

    @Override
    public void stroke(float f, float f2, float f3, float f4) {
        this.clr(f, f2, f3, f4);
    }

    @Override
    public void stroke(float f, float f2, float f3) {
        this.clr(f, f2, f3);
    }

    public void weight(double d) {
        this.gl2.glLineWidth((float)d);
    }

    @Override
    public void weight(float f) {
        this.gl2.glLineWidth(f);
    }

    @Override
    public void diffuse(float[] fArray) {
        this.gl2.glMaterialfv(1032, 4609, fArray, 0);
    }

    @Override
    public void diffuse(float f, float f2, float f3, float f4) {
        this.diffuse(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void diffuse(float f, float f2, float f3) {
        this.diffuse(f, f2, f3, 255.0f);
    }

    @Override
    public void diffuse(IColor iColor) {
        this.diffuse(iColor.rgba());
    }

    @Override
    public void diffuse(IColor iColor, float f) {
        this.diffuse(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void ambient(float[] fArray) {
        this.gl2.glMaterialfv(1032, 4608, fArray, 0);
    }

    @Override
    public void ambient(float f, float f2, float f3, float f4) {
        this.ambient(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void ambient(float f, float f2, float f3) {
        this.ambient(f, f2, f3, 255.0f);
    }

    @Override
    public void ambient(IColor iColor) {
        this.ambient(iColor.rgba());
    }

    @Override
    public void ambient(IColor iColor, float f) {
        this.ambient(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void specular(float[] fArray) {
        this.gl2.glMaterialfv(1032, 4610, fArray, 0);
    }

    @Override
    public void specular(float f, float f2, float f3, float f4) {
        this.specular(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void specular(float f, float f2, float f3) {
        this.specular(f, f2, f3, 255.0f);
    }

    @Override
    public void specular(IColor iColor) {
        this.specular(iColor.rgba());
    }

    @Override
    public void specular(IColor iColor, float f) {
        this.specular(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void emissive(float[] fArray) {
        this.gl2.glMaterialfv(1032, 5632, fArray, 0);
    }

    @Override
    public void emissive(float f, float f2, float f3, float f4) {
        this.emissive(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void emissive(float f, float f2, float f3) {
        this.emissive(f, f2, f3, 255.0f);
    }

    @Override
    public void emissive(IColor iColor) {
        this.emissive(iColor.rgba());
    }

    @Override
    public void emissive(IColor iColor, float f) {
        this.emissive(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void shininess(float f) {
        this.gl2.glMaterialf(1032, 5633, f);
    }

    @Override
    public void enableLight() {
        this.gl2.glEnable(16385);
        this.gl2.glEnable(2896);
    }

    @Override
    public void disableLight() {
        this.gl2.glDisable(2896);
        this.gl2.glDisable(16385);
    }

    @Override
    public void pointSize(float f) {
        this.gl2.glPointSize(f);
    }

    @Override
    public void drawPoint(IVec iVec) {
        this.gl2.glBegin(0);
        this.gl2.glVertex3d(iVec.x, iVec.y, iVec.z);
        this.gl2.glEnd();
    }

    @Override
    public void drawPoints(IVec[] iVecArray) {
        this.gl2.glBegin(0);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawLines(IVec[] iVecArray) {
        this.gl2.glBegin(1);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawLineStrip(IVec[] iVecArray) {
        this.gl2.glBegin(3);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawLineLoop(IVec[] iVecArray) {
        this.gl2.glBegin(2);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(9);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray) {
        this.gl2.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(9);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray) {
        this.gl2.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(7);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(7);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray) {
        this.gl2.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(8);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(8);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i]);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i], f);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.ambient(iColorArray[i]);
                this.diffuse(iColorArray[i]);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.ambient(iColorArray[i], f);
                this.diffuse(iColorArray[i], f);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl2.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl2.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec2f[][] iVec2fArray) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl2.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl2.glTexCoord2f(iVec2fArray[i][j].x, iVec2fArray[i][j].y);
                this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl2.glTexCoord2f(iVec2fArray[i + 1][j].x, iVec2fArray[i + 1][j].y);
                this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl2.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IColor[][] iColorArray, float f, boolean bl) {
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl2.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j]);
                        this.diffuse(iColorArray[i][j]);
                        this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j]);
                        this.diffuse(iColorArray[i + 1][j]);
                        this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl2.glEnd();
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl2.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j], f);
                        this.diffuse(iColorArray[i][j], f);
                        this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j]);
                        this.diffuse(iColorArray[i + 1][j]);
                        this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl2.glEnd();
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl2.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j]);
                    this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j]);
                    this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl2.glEnd();
            }
        } else {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl2.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j], f);
                    this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j]);
                    this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl2.glEnd();
            }
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl2.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl2.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2, IVec2f[][] iVec2fArray) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl2.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl2.glTexCoord2f(iVec2fArray[i][j].x, iVec2fArray[i][j].y);
                this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl2.glTexCoord2f(iVec2fArray[i + 1][j].x, iVec2fArray[i + 1][j].y);
                this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl2.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2, IColor[][] iColorArray, float f, boolean bl) {
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl2.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j]);
                        this.diffuse(iColorArray[i][j]);
                        this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                        this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j]);
                        this.diffuse(iColorArray[i + 1][j]);
                        this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                        this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl2.glEnd();
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl2.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j], f);
                        this.diffuse(iColorArray[i][j], f);
                        this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                        this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j]);
                        this.diffuse(iColorArray[i + 1][j]);
                        this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                        this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl2.glEnd();
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl2.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j]);
                    this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                    this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j]);
                    this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                    this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl2.glEnd();
            }
        } else {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl2.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j], f);
                    this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                    this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j]);
                    this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                    this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl2.glEnd();
            }
        }
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(4);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray) {
        this.gl2.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(4);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(5);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray) {
        this.gl2.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(5);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(6);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray) {
        this.gl2.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.gl2.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glTexCoord2f(iVec2fArray[i].x, iVec2fArray[i].y);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl2.glBegin(6);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl2.glEnd();
    }

    @Override
    public void beginTexture(ITexture iTexture) {
        this.gl2.glDisable(3042);
        this.gl2.glEnable(3553);
        this.gl2.glTexEnvf(8960, 8704, 7681.0f);
        this.gl2.glBindTexture(3553, iTexture.id(this));
    }

    @Override
    public void endTexture() {
        this.gl2.glBindTexture(3553, 0);
        this.gl2.glEnable(3042);
    }

    @Override
    public ITextureGraphicGL getTextureGraphic(String string) {
        return new ITextureGraphicGL2(string, this.getGL());
    }

    @Override
    public ITextureGraphicGL getTextureGraphic(BufferedImage bufferedImage) {
        return new ITextureGraphicGL2(bufferedImage, this.getGL());
    }
}

