/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IG;
import igeo.IMap;
import igeo.IOut;
import java.util.ArrayList;

public class IVLinearMap
extends IMap {
    public double start;
    public double end;
    public ArrayList<Double> domains;
    public ArrayList<Double> values;

    public IVLinearMap() {
        this.start = 0.0;
        this.end = 0.0;
    }

    public IVLinearMap(double d) {
        this.start = d;
        this.end = d;
    }

    public IVLinearMap(double d, double d2) {
        this.start = d;
        this.end = d2;
    }

    public IVLinearMap(double d, double d2, double d3) {
        this.start = d;
        this.end = d3;
        this.domains = new ArrayList();
        this.values = new ArrayList();
        this.domains.add(0.5);
        this.values.add(d2);
    }

    public IVLinearMap(double d, double d2, double d3, double d4) {
        this.start = d;
        this.end = d4;
        this.domains = new ArrayList();
        this.values = new ArrayList();
        this.domains.add(0.3333333333333333);
        this.values.add(d2);
        this.domains.add(0.6666666666666666);
        this.values.add(d3);
    }

    public IVLinearMap add(double d, double d2) {
        if (IG.eq(d, 0.0, IConfig.parameterTolerance)) {
            this.start = d2;
            return this;
        }
        if (IG.eq(d, 1.0, IConfig.parameterTolerance)) {
            this.end = d2;
            return this;
        }
        if (d < 0.0 || d > 1.0) {
            IOut.err("v (" + d + ") is out of range. skipped");
            return this;
        }
        if (this.domains == null) {
            this.domains = new ArrayList();
            this.values = new ArrayList();
            this.domains.add(d);
            this.values.add(d2);
            return this;
        }
        for (int i = 0; i < this.domains.size(); ++i) {
            if (IG.eq(d, this.domains.get(i), IConfig.parameterTolerance)) {
                this.domains.set(i, d);
                this.values.set(i, d2);
                return this;
            }
            if (!(d < this.domains.get(i))) continue;
            this.domains.add(i, d);
            this.values.add(i, d2);
            return this;
        }
        this.domains.add(d);
        this.values.add(d2);
        return this;
    }

    public IVLinearMap addValue(double d, double d2) {
        return this.add(d, d2);
    }

    public IVLinearMap insert(double d, double d2) {
        return this.add(d, d2);
    }

    public double get(double d, double d2) {
        return this.get(d2);
    }

    public double get(double d) {
        if (d < 0.0) {
            return this.start;
        }
        if (d > 1.0) {
            return this.end;
        }
        if (this.domains == null || this.domains.size() == 0) {
            return (this.end - this.start) * d + this.start;
        }
        if (d <= this.domains.get(0)) {
            return (this.values.get(0) - this.start) * d / this.domains.get(0) + this.start;
        }
        int n = this.domains.size();
        if (d >= this.domains.get(n - 1)) {
            return (this.end - this.values.get(n - 1)) * (d - this.domains.get(n - 1)) / (1.0 - this.domains.get(n - 1)) + this.values.get(n - 1);
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(d >= this.domains.get(i)) || !(d < this.domains.get(i + 1))) continue;
            return (this.values.get(i + 1) - this.values.get(i)) * (d - this.domains.get(i)) / (this.domains.get(i + 1) - this.domains.get(i)) + this.values.get(i);
        }
        return this.end;
    }

    public IVLinearMap flipV() {
        double d = this.start;
        this.start = this.end;
        this.end = d;
        if (this.domains != null && this.domains.size() > 1) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = this.domains.size() - 1; i >= 0; --i) {
                arrayList.add(1.0 - this.domains.get(i));
                arrayList2.add(this.values.get(i));
            }
            this.domains = arrayList;
            this.values = arrayList2;
        }
        return this;
    }
}

