/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveGeo;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.INurbsGeo;
import igeo.IOut;
import igeo.ISurfaceI;
import igeo.ITrimCurveI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import java.util.ArrayList;

public class ITrimCurve
extends ICurveGeo
implements ITrimCurveI {
    public ISurfaceI surface = null;

    public ITrimCurve() {
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        super(iVecIArray, n, dArray, d, d2);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, double[] dArray) {
        super(iVecIArray, n, dArray);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n) {
        super(iVecIArray, n);
    }

    public ITrimCurve(IVecI[] iVecIArray) {
        super(iVecIArray);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, boolean bl) {
        super(iVecIArray, n, bl);
    }

    public ITrimCurve(IVecI[] iVecIArray, boolean bl) {
        super(iVecIArray, bl);
    }

    public ITrimCurve(IVecI iVecI, IVecI iVecI2) {
        super(iVecI, iVecI2);
    }

    public ITrimCurve(double d, double d2, double d3, double d4) {
        super(d, d2, 0.0, d3, d4, 0.0);
    }

    public ITrimCurve(double[][] dArray) {
        super(dArray);
    }

    public ITrimCurve(double[][] dArray, int n) {
        super(dArray, n);
    }

    public ITrimCurve(double[][] dArray, boolean bl) {
        super(dArray, bl);
    }

    public ITrimCurve(double[][] dArray, int n, boolean bl) {
        super(dArray, n, bl);
    }

    public ITrimCurve(ICurveGeo iCurveGeo) {
        super(iCurveGeo);
    }

    public ITrimCurve(ICurve iCurve) {
        this(iCurve.curve);
    }

    public ITrimCurve(ICurveI iCurveI) {
        this(iCurveI.get());
    }

    public ITrimCurve(ITrimCurve iTrimCurve) {
        super(iTrimCurve);
        this.surface = iTrimCurve.surface;
    }

    public ITrimCurve(ITrimCurve iTrimCurve, ISurfaceI iSurfaceI) {
        super(iTrimCurve);
        this.surface = iSurfaceI;
    }

    public ITrimCurve surface(ISurfaceI iSurfaceI) {
        if (this.surface != null && this.surface != iSurfaceI) {
            IOut.err("surface is already set. overwritten.");
        }
        this.surface = iSurfaceI;
        return this;
    }

    public ISurfaceI surface() {
        return this.surface;
    }

    public ITrimCurve dup() {
        ITrimCurve iTrimCurve = new ITrimCurve(this);
        iTrimCurve.surface = null;
        return iTrimCurve;
    }

    public ITrimCurve get() {
        return this;
    }

    public ICurveGeo get3d() {
        Object object;
        Object object2;
        IVecI[] iVecIArray;
        IVecI[] iVecIArray2;
        if (this.surface == null) {
            IOut.err("surface is not set");
            return null;
        }
        if (this.num() == 2) {
            iVecIArray2 = new IVec(0.0, 0.0, 0.0);
            iVecIArray = new IVec(1.0, 0.0, 0.0);
            object2 = new IVec(0.0, 1.0, 0.0);
            object = new IVec(1.0, 1.0, 0.0);
            if (this.cp(0).eq((IVecI)iVecIArray2)) {
                if (this.cp(1).eq((IVecI)iVecIArray)) {
                    int n = this.surface.unum();
                    IVecI[] iVecIArray3 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray3[i] = this.surface.cp(i, 0);
                    }
                    return new ICurveGeo(iVecIArray3, this.surface.udeg(), this.surface.uknots());
                }
                if (this.cp(1).eq((IVecI)object2)) {
                    int n = this.surface.vnum();
                    IVecI[] iVecIArray4 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray4[i] = this.surface.cp(0, i);
                    }
                    return new ICurveGeo(iVecIArray4, this.surface.vdeg(), this.surface.vknots());
                }
            } else if (this.cp(0).eq((IVecI)iVecIArray)) {
                if (this.cp(1).eq((IVecI)iVecIArray2)) {
                    int n = this.surface.unum();
                    IVecI[] iVecIArray5 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray5[i] = this.surface.cp(n - 1 - i, 0);
                    }
                    return new ICurveGeo(iVecIArray5, this.surface.udeg(), INurbsGeo.invertKnots(this.surface.uknots()));
                }
                if (this.cp(1).eq((IVecI)object)) {
                    int n = this.surface.vnum();
                    IVecI[] iVecIArray6 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray6[i] = this.surface.cp(this.surface.unum() - 1, i);
                    }
                    return new ICurveGeo(iVecIArray6, this.surface.vdeg(), this.surface.vknots());
                }
            } else if (this.cp(0).eq((IVecI)object2)) {
                if (this.cp(1).eq((IVecI)iVecIArray2)) {
                    int n = this.surface.vnum();
                    IVecI[] iVecIArray7 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray7[i] = this.surface.cp(0, n - 1 - i);
                    }
                    return new ICurveGeo(iVecIArray7, this.surface.vdeg(), INurbsGeo.invertKnots(this.surface.vknots()));
                }
                if (this.cp(1).eq((IVecI)object)) {
                    int n = this.surface.unum();
                    IVecI[] iVecIArray8 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray8[i] = this.surface.cp(i, this.surface.vnum() - 1);
                    }
                    return new ICurveGeo(iVecIArray8, this.surface.udeg(), this.surface.uknots());
                }
            } else if (this.cp(0).eq((IVecI)object)) {
                if (this.cp(1).eq((IVecI)iVecIArray)) {
                    int n = this.surface.vnum();
                    IVecI[] iVecIArray9 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray9[i] = this.surface.cp(this.surface.unum() - 1, n - 1 - i);
                    }
                    return new ICurveGeo(iVecIArray9, this.surface.vdeg(), INurbsGeo.invertKnots(this.surface.vknots()));
                }
                if (this.cp(1).eq((IVecI)object2)) {
                    int n = this.surface.unum();
                    IVecI[] iVecIArray10 = new IVecI[n];
                    for (int i = 0; i < n; ++i) {
                        iVecIArray10[i] = this.surface.cp(n - 1 - i, this.surface.vnum() - 1);
                    }
                    return new ICurveGeo(iVecIArray10, this.surface.udeg(), INurbsGeo.invertKnots(this.surface.uknots()));
                }
            }
        }
        if (this.surface.udeg() == 1 && this.surface.vdeg() == 1 && this.surface.unum() == 2 && this.surface.vnum() == 2 && Math.abs(this.surface.cp(0, 0).dist(this.surface.cp(1, 0)) - this.surface.cp(0, 1).dist(this.surface.cp(1, 1))) < IConfig.tolerance && Math.abs(this.surface.cp(0, 0).dist(this.surface.cp(0, 1)) - this.surface.cp(1, 0).dist(this.surface.cp(1, 1))) < IConfig.tolerance && this.surface.isFlat()) {
            int n;
            IOut.debug(20, "surface is planar.");
            iVecIArray2 = this.cps();
            IOut.debug(20, "cpts2.length = " + iVecIArray2.length);
            if (iVecIArray2.length == 2) {
                iVecIArray = iVecIArray2[0].get();
                object2 = iVecIArray2[iVecIArray2.length - 1].get();
                object = this.surface.pt(iVecIArray.x, iVecIArray.y).get();
                IVec iVec = this.surface.pt(((IVec)object2).x, ((IVec)object2).y).get();
                IOut.debug(20, "trim curve cp num = 2 or straight.");
                return new ICurveGeo((IVecI)object, iVec);
            }
            IOut.debug(20, "trim curve cp num != 2.");
            iVecIArray = new IVec[iVecIArray2.length];
            for (n = 0; n < iVecIArray2.length; ++n) {
                if (this.defaultWeights[n]) {
                    object = iVecIArray2[n].get();
                    iVecIArray[n] = this.surface.pt(((IVec)object).x, ((IVec)object).y).get();
                    continue;
                }
                object = iVecIArray2[n].get();
                IVec4 iVec4 = this.surface.pt(((IVec)object).x, ((IVec)object).y).to4d().get();
                iVec4.w = iVecIArray2[n] instanceof IVec4I ? ((IVec4I)iVecIArray2[n]).w() : 1.0;
                iVecIArray[n] = iVec4;
            }
            n = this.deg();
            object = new double[this.knotNum()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = this.knot(i);
            }
            double d = this.ustart();
            double d2 = this.uend();
            ICurveGeo iCurveGeo = new ICurveGeo(iVecIArray, n, (double[])object, 0.0, 1.0);
            iCurveGeo.ustart = d;
            iCurveGeo.uend = d2;
            IOut.debug(10, "crv3: deg = " + iCurveGeo.deg() + ", cpnum = " + iCurveGeo.num());
            return iCurveGeo;
        }
        IOut.debug(20, "surface is not planar.");
        int n = this.surface.unum();
        int n2 = this.surface.vnum();
        if (this.deg() == 1) {
            object2 = new ArrayList();
            object = this.cp(0).get();
            ((ArrayList)object2).add(this.surface.pt(((IVec)object).x, ((IVec)object).y).get());
            IVec iVec = object;
            for (int i = 1; i < this.num(); ++i) {
                object = this.cp(i).get();
                double d = Math.abs(((IVec)object).x - iVec.x);
                double d3 = Math.abs(((IVec)object).y - iVec.y);
                int n3 = (int)(d * (double)n * (double)IConfig.trimApproximationResolution);
                int n4 = (int)(d3 * (double)n2 * (double)IConfig.trimApproximationResolution);
                int n5 = Math.max(n3, n4);
                for (int j = 0; j < n5; ++j) {
                    IVec iVec2 = iVec.sum((IVec)object, (double)j / (double)(n5 + 1));
                    ((ArrayList)object2).add(this.surface.pt(iVec2.x, iVec2.y).get());
                }
                ((ArrayList)object2).add(this.surface.pt(((IVec)object).x, ((IVec)object).y).get());
                iVec = object;
            }
            return new ICurveGeo(((ArrayList)object2).toArray(new IVec[((ArrayList)object2).size()]));
        }
        double d = 1.0;
        double d4 = 1.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.num(); ++i) {
            IVec iVec = this.cp(i).get();
            if (iVec.x < d) {
                d = iVec.x;
            }
            if (iVec.x > d5) {
                d5 = iVec.x;
            }
            if (iVec.y < d4) {
                d4 = iVec.y;
            }
            if (!(iVec.y > d6)) continue;
            d6 = iVec.y;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d5 > 1.0) {
            d5 = 1.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        double d7 = d5 - d;
        double d8 = d6 - d4;
        int n6 = (int)(d7 * (double)n * (double)IConfig.trimApproximationResolution);
        int n7 = (int)(d8 * (double)n2 * (double)IConfig.trimApproximationResolution);
        int n8 = this.epNum() * IConfig.trimApproximationResolution;
        int n9 = Math.max(n8, Math.max(n6, n7));
        IVecI[] iVecIArray11 = new IVec[n9 + 1];
        for (int i = 0; i <= n9; ++i) {
            iVecIArray11[i] = this.pt((double)i / (double)n9);
        }
        return new ICurveGeo(iVecIArray11);
    }

    public void normalizeControlPoints() {
        this.normalizeControlPoints(this.surface);
    }

    public void normalizeControlPoints(ISurfaceI iSurfaceI) {
        double d = iSurfaceI.ustart();
        double d2 = iSurfaceI.uend();
        double d3 = iSurfaceI.vstart();
        double d4 = iSurfaceI.vend();
        if (d != 0.0 || d2 != 1.0 || d3 != 0.0 || d4 != 1.0) {
            for (IVecI iVecI : this.controlPoints) {
                iVecI.set((iVecI.x() - d) / (d2 - d), (iVecI.y() - d3) / (d4 - d3), iVecI.z());
            }
        }
    }

    public void pt(double d, IVec iVec) {
        IVec iVec2 = new IVec();
        super.pt(d, iVec2);
        iVec.set(this.surface.pt(iVec2.x, iVec2.y));
    }

    public void pt2(double d, IVec2 iVec2) {
        IVec iVec = new IVec();
        super.pt(d, iVec);
        iVec2.set(iVec.x, iVec.y);
    }

    public void pt2d(double d, IVec2 iVec2) {
        this.pt2(d, iVec2);
    }

    public IVec2I pt2(double d) {
        IVec2 iVec2 = new IVec2();
        this.pt2d(d, iVec2);
        return iVec2;
    }

    public IVec2I pt2d(double d) {
        return this.pt2(d);
    }

    public IVec2I pt2(IDoubleI iDoubleI) {
        IVec2 iVec2 = new IVec2();
        this.pt2d(iDoubleI.x(), iVec2);
        return iVec2;
    }

    public IVec2I pt2d(IDoubleI iDoubleI) {
        return this.pt2(iDoubleI);
    }

    public IVec2 start2() {
        IVec iVec = new IVec();
        super.pt(0.0, iVec);
        return new IVec2(iVec);
    }

    public IVec2 start2d() {
        return this.start2();
    }

    public IVec2 end2() {
        IVec iVec = new IVec();
        super.pt(1.0, iVec);
        return new IVec2(iVec);
    }

    public IVec2 end2d() {
        return this.end2();
    }

    public IVec2 startCP2() {
        return new IVec2(this.cp(0));
    }

    public IVec2 startCP2d() {
        return this.startCP2();
    }

    public IVec2 endCP2() {
        return new IVec2(this.cp(this.num() - 1));
    }

    public IVec2 endCP2d() {
        return this.endCP2();
    }

    public void tan(double d, IVec iVec) {
        IVec iVec2 = new IVec();
        super.pt(d, iVec2);
        IVec iVec3 = new IVec();
        super.tan(d, iVec3);
        IVec iVec4 = this.surface.utan(iVec2.x, iVec2.y).get();
        IVec iVec5 = this.surface.vtan(iVec2.x, iVec2.y).get();
        iVec4.mul(iVec3.x).add(iVec5.mul(iVec3.y));
        iVec.set(iVec4);
    }

    public boolean isClosed() {
        boolean bl = true;
        if (this.knots[0] != 0.0 || this.knots[this.knots.length - 1] != 1.0) {
            bl = false;
        }
        if (bl) {
            return this.cp(0).eq(this.cp(this.num() - 1));
        }
        return this.pt2d(0.0).eq(this.pt2d(1.0));
    }

    public ITrimCurve rev() {
        super.rev();
        return this;
    }

    public ITrimCurve revU() {
        return this.rev();
    }

    public ITrimCurve flipU() {
        return this.rev();
    }

    public ITrimCurve add(double d, double d2, double d3) {
        super.add(d, d2, d3);
        return this;
    }

    public ITrimCurve add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public ITrimCurve add(IVecI iVecI) {
        super.add(iVecI);
        return this;
    }

    public ITrimCurve sub(double d, double d2, double d3) {
        super.sub(d, d2, d3);
        return this;
    }

    public ITrimCurve sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public ITrimCurve sub(IVecI iVecI) {
        super.sub(iVecI);
        return this;
    }

    public ITrimCurve mul(IDoubleI iDoubleI) {
        super.mul(iDoubleI);
        return this;
    }

    public ITrimCurve mul(double d) {
        super.mul(d);
        return this;
    }

    public ITrimCurve div(IDoubleI iDoubleI) {
        super.div(iDoubleI);
        return this;
    }

    public ITrimCurve div(double d) {
        super.div(d);
        return this;
    }

    public ITrimCurve neg() {
        super.neg();
        return this;
    }

    public ITrimCurve flip() {
        return this.neg();
    }

    public ITrimCurve add(IVecI iVecI, double d) {
        super.add(iVecI, d);
        return this;
    }

    public ITrimCurve add(IVecI iVecI, IDoubleI iDoubleI) {
        super.add(iVecI, iDoubleI);
        return this;
    }

    public ITrimCurve add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    public ITrimCurve add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    public ITrimCurve rot(IDoubleI iDoubleI) {
        super.rot(iDoubleI);
        return this;
    }

    public ITrimCurve rot(double d) {
        super.rot(d);
        return this;
    }

    public ITrimCurve rot(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot(iVecI, iDoubleI);
        return this;
    }

    public ITrimCurve rot(IVecI iVecI, double d) {
        super.rot(iVecI, d);
        return this;
    }

    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2, double d) {
        super.rot(iVecI, iVecI2, d);
        return this;
    }

    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2) {
        super.rot(iVecI, iVecI2);
        return this;
    }

    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public ITrimCurve rot2(IDoubleI iDoubleI) {
        super.rot(iDoubleI);
        return this;
    }

    public ITrimCurve rot2(double d) {
        super.rot(d);
        return this;
    }

    public ITrimCurve rot2(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot2(iVecI, iDoubleI);
        return this;
    }

    public ITrimCurve rot2(IVecI iVecI, double d) {
        super.rot2(iVecI, d);
        return this;
    }

    public ITrimCurve rot2(IVecI iVecI) {
        super.rot2(iVecI);
        return this;
    }

    public ITrimCurve rot2(IVecI iVecI, IVecI iVecI2) {
        super.rot2(iVecI, iVecI2);
        return this;
    }

    public ITrimCurve scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public ITrimCurve scale(double d) {
        return this.mul(d);
    }

    public ITrimCurve scale(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale(iVecI, iDoubleI);
        return this;
    }

    public ITrimCurve scale(IVecI iVecI, double d) {
        super.scale(iVecI, d);
        return this;
    }

    public ITrimCurve ref(IVecI iVecI) {
        super.ref(iVecI);
        return this;
    }

    public ITrimCurve ref(IVecI iVecI, IVecI iVecI2) {
        super.ref(iVecI, iVecI2);
        return this;
    }

    public ITrimCurve mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    public ITrimCurve mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    public ITrimCurve shear(double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    public ITrimCurve shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public ITrimCurve shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    public ITrimCurve shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public ITrimCurve shearXY(double d, double d2) {
        super.shearXY(d, d2);
        return this;
    }

    public ITrimCurve shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    public ITrimCurve shearXY(IVecI iVecI, double d, double d2) {
        super.shearXY(iVecI, d, d2);
        return this;
    }

    public ITrimCurve shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public ITrimCurve shearYZ(double d, double d2) {
        super.shearYZ(d, d2);
        return this;
    }

    public ITrimCurve shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    public ITrimCurve shearYZ(IVecI iVecI, double d, double d2) {
        super.shearYZ(iVecI, d, d2);
        return this;
    }

    public ITrimCurve shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public ITrimCurve shearZX(double d, double d2) {
        super.shearZX(d, d2);
        return this;
    }

    public ITrimCurve shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    public ITrimCurve shearZX(IVecI iVecI, double d, double d2) {
        super.shearZX(iVecI, d, d2);
        return this;
    }

    public ITrimCurve shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public ITrimCurve translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public ITrimCurve translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public ITrimCurve translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    public ITrimCurve transform(IMatrix3I iMatrix3I) {
        super.transform(iMatrix3I);
        return this;
    }

    public ITrimCurve transform(IMatrix4I iMatrix4I) {
        super.transform(iMatrix4I);
        return this;
    }

    public ITrimCurve transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public ITrimCurve transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public ITrimCurve mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public ITrimCurve mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public ITrimCurve mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public ITrimCurve cp() {
        return this.dup();
    }

    public ITrimCurve cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public ITrimCurve cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public ITrimCurve cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

