/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IVec;

class IOrient {
    IVec dir;
    IVec nml;
    boolean righthand;

    IOrient(IVec iVec, IVec iVec2, boolean bl) {
        this.dir = iVec;
        this.nml = iVec2;
        this.righthand = bl;
    }

    IOrient(IVec iVec, IVec iVec2) {
        this(iVec, iVec2, true);
    }

    IOrient(IOrient iOrient) {
        this.dir = iOrient.dir.cp();
        this.nml = iOrient.nml.cp();
        this.righthand = iOrient.righthand;
    }

    IOrient cp() {
        return new IOrient(this);
    }

    IVec dir() {
        return this.dir.cp();
    }

    IVec front() {
        return this.dir();
    }

    IVec back() {
        return this.dir().neg();
    }

    IVec nml() {
        return this.nml.cp();
    }

    IVec up() {
        return this.nml();
    }

    IVec down() {
        return this.nml().neg();
    }

    IVec side() {
        if (this.righthand) {
            return this.dir.cross(this.nml);
        }
        return this.nml.cross(this.dir);
    }

    IVec right() {
        return this.side();
    }

    IVec left() {
        if (this.righthand) {
            return this.nml.cross(this.dir);
        }
        return this.dir.cross(this.nml);
    }

    IOrient rot(double d) {
        this.dir.rot(this.nml, d);
        return this;
    }

    IOrient rot(IVec iVec, double d) {
        this.dir.rot(iVec, d);
        this.nml.rot(iVec, d);
        return this;
    }

    IOrient pitch(double d) {
        IVec iVec = this.dir.cross(this.nml);
        this.dir.rot(iVec, d);
        this.nml.rot(iVec, d);
        return this;
    }

    IOrient yaw(double d) {
        this.dir.rot(this.nml, d);
        return this;
    }

    IOrient roll(double d) {
        this.nml.rot(this.dir, d);
        return this;
    }

    IOrient ref(IVec iVec) {
        this.dir.ref(iVec);
        this.nml.ref(iVec);
        this.righthand = !this.righthand;
        return this;
    }

    IOrient flip() {
        this.dir.flip();
        this.righthand = !this.righthand;
        return this;
    }

    IOrient flipNml() {
        this.nml.flip();
        this.righthand = !this.righthand;
        return this;
    }

    IOrient flipSide() {
        this.righthand = !this.righthand;
        return this;
    }

    IOrient mul(double d) {
        this.dir.mul(d);
        return this;
    }

    IOrient div(double d) {
        this.dir.div(d);
        return this;
    }

    IOrient add(IOrient iOrient) {
        this.dir.add(iOrient.dir);
        this.nml.add(iOrient.nml());
        return this;
    }

    IOrient add(IOrient iOrient, double d) {
        this.dir.add(iOrient.dir, d);
        this.nml.add(iOrient.nml(), d);
        return this;
    }

    IOrient sum(IOrient iOrient, double d) {
        this.dir.mul(1.0 - d).add(iOrient.dir, d);
        this.nml.mul(1.0 - d).add(iOrient.nml(), d);
        return this;
    }

    IOrient mid(IOrient iOrient) {
        return this.sum(iOrient, 0.5);
    }
}

