/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IG;
import igeo.IOut;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class IImageLoader
implements ImageObserver {
    public static final IImageLoader observer = new IImageLoader();
    public static boolean convertFilePath = true;

    public static Image getImage(String string) {
        return IImageLoader.getImage(string, new Container());
    }

    public static Image getImage(String string, Component component) {
        Object object;
        IOut.debug(10, "opening image of " + string);
        InputStream inputStream = null;
        if (convertFilePath) {
            object = IG.current();
            if (object != null && ((IG)object).inputWrapper != null) {
                inputStream = ((IG)object).inputWrapper.getStream(string);
            } else {
                File file;
                File file2 = new File(string);
                if (!file2.isAbsolute() && (object = IG.current()) != null && ((IG)object).getBasePath() != null) {
                    string = ((IG)object).getBasePath() + File.separator + string;
                }
                if (!(file = new File(string)).exists()) {
                    IOut.err("file does not exist: " + string);
                    return null;
                }
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (IOException iOException) {
                    IOut.err("IOException");
                    iOException.printStackTrace();
                    return null;
                }
            }
        }
        if (inputStream == null) {
            IOut.err("InputStream is null");
            return null;
        }
        object = null;
        try {
            object = ImageIO.read(inputStream);
        }
        catch (Exception exception) {
            IOut.err("ImageIO exception");
            exception.printStackTrace();
            return null;
        }
        return object;
    }

    public static int getWidth(Image image) {
        return image.getWidth(observer);
    }

    public static int getHeight(Image image) {
        return image.getHeight(observer);
    }

    public static int[] getPixelBuffer(Image image) {
        int n;
        int n2 = image.getWidth(observer);
        int[] nArray = new int[n2 * (n = image.getHeight(observer))];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, nArray, 0, n2);
        if (pixelGrabber == null) {
            return null;
        }
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    public static int[][] getPixelMatrix(Image image) {
        int n;
        int n2 = image.getWidth(observer);
        int[] nArray = new int[n2 * (n = image.getHeight(observer))];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, nArray, 0, n2);
        if (pixelGrabber == null) {
            return null;
        }
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int[][] nArray2 = new int[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[j][i] = nArray[n2 * i + j];
            }
        }
        return nArray2;
    }

    public static byte[] getRGBBytes(Image image) {
        int[] nArray = IImageLoader.getPixelBuffer(image);
        byte[] byArray = new byte[nArray.length * 3];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i * 3] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[i * 3 + 1] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[i * 3 + 2] = (byte)(nArray[i] & 0xFF);
        }
        return byArray;
    }

    public static byte[] getARGBBytes(Image image) {
        int[] nArray = IImageLoader.getPixelBuffer(image);
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i * 4] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray[i * 4 + 1] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[i * 4 + 2] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[i * 4 + 3] = (byte)(nArray[i] & 0xFF);
        }
        return byArray;
    }

    public static Color[][] getPixels(Image image) {
        int n;
        int n2 = image.getWidth(observer);
        int[] nArray = new int[n2 * (n = image.getHeight(observer))];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, nArray, 0, n2);
        if (pixelGrabber == null) {
            return null;
        }
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return IImageLoader.getPixels(nArray, n2, n);
    }

    public static Color[][] getPixels(int[] nArray, int n, int n2) {
        Color[][] colorArray = new Color[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                colorArray[j][i] = IImageLoader.getColor(nArray, j, i, n);
            }
        }
        return colorArray;
    }

    public static Color getColor(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n3 * n2 + n];
        int n5 = n4 >> 24 & 0xFF;
        int n6 = n4 >> 16 & 0xFF;
        int n7 = n4 >> 8 & 0xFF;
        int n8 = n4 & 0xFF;
        return new Color(n6, n7, n8, n5);
    }

    public static BufferedImage createImage(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, nArray[j][i]);
            }
        }
        return bufferedImage;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }
}

