/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IColor;
import igeo.ICurve;
import igeo.IG;
import igeo.IGeometry;
import igeo.IObject;
import igeo.IPoint;
import igeo.IVec;
import java.awt.Color;

public class IEsri {
    public static Shape[] getShape(IObject[] iObjectArray) {
        if (iObjectArray == null) {
            return new Shape[0];
        }
        Shape[] shapeArray = new Shape[iObjectArray.length];
        for (int i = 0; i < iObjectArray.length; ++i) {
            shapeArray[i] = IEsri.getShape(iObjectArray[i]);
        }
        return shapeArray;
    }

    public static Shape getShape(IObject iObject) {
        return new Shape(iObject);
    }

    public static class AttributeHeader {
        public long recordNum;
        public long firstDataPos;
        public long recordLen;
        public long fieldNum;
        public AttributeField[] fields;
    }

    public static class Attributes {
        public long length;
        public String[] text;
        public double[] number;
        public AttributeField[] fields;

        public Attributes(int n) {
            this.length = n;
            this.text = new String[n];
            this.number = new double[n];
        }
    }

    public static class AttributeField {
        public String name;
        public char type;
        public int length;
        public int fractionLength;
        public int workspaceID;
    }

    public static class Shape {
        public IObject object;
        public Attributes attr;

        public Shape(IObject iObject) {
            this.object = iObject;
            for (int i = 0; i < this.object.userDataNum() && this.attr == null; ++i) {
                if (!(this.object.userData(i) instanceof Attributes)) continue;
                this.attr = (Attributes)this.object.userData(i);
            }
        }

        public ICurve curve() {
            if (this.object == null) {
                return null;
            }
            if (this.object instanceof ICurve) {
                return (ICurve)this.object;
            }
            IG.err("object is not curve " + this.object);
            return null;
        }

        public IPoint point() {
            if (this.object == null) {
                return null;
            }
            if (this.object instanceof IPoint) {
                return (IPoint)this.object;
            }
            IG.err("object is not point " + this.object);
            return null;
        }

        public IVec center() {
            if (this.object instanceof IGeometry) {
                return ((IGeometry)this.object).center().get();
            }
            IG.err("object is not IGeometry " + this.object);
            return new IVec();
        }

        public int fieldNum() {
            if (this.attr == null) {
                IG.err("no attributes found");
                return 0;
            }
            if (this.attr.fields == null) {
                IG.err("no fields found");
                return 0;
            }
            return this.attr.fields.length;
        }

        public String fieldName(int n) {
            if (this.attr == null) {
                IG.err("no attributes found");
                return "";
            }
            if (this.attr.fields == null) {
                IG.err("no fields found");
                return "";
            }
            if (n < 0 || n >= this.attr.fields.length) {
                IG.err("invalid index number " + n);
                return "";
            }
            return this.attr.fields[n].name;
        }

        public char fieldType(int n) {
            if (this.attr == null) {
                IG.err("no attributes found");
                return '\u0000';
            }
            if (this.attr.fields == null) {
                IG.err("no fields found");
                return '\u0000';
            }
            if (n < 0 || n >= this.attr.fields.length) {
                IG.err("invalid index number " + n);
                return '\u0000';
            }
            return this.attr.fields[n].type;
        }

        public AttributeField field(int n) {
            if (this.attr == null) {
                IG.err("no attributes found");
                return null;
            }
            if (this.attr.fields == null) {
                IG.err("no fields found");
                return null;
            }
            if (n < 0 || n >= this.attr.fields.length) {
                IG.err("invalid index number " + n);
                return null;
            }
            return this.attr.fields[n];
        }

        public int fieldIndex(String string) {
            if (this.attr.fields == null) {
                IG.err("no fields found");
                return -1;
            }
            String string2 = string.toLowerCase();
            for (int i = 0; i < this.attr.fields.length; ++i) {
                if (!string2.equals(this.attr.fields[i].name.toLowerCase())) continue;
                return i;
            }
            IG.err("no field named " + string + " is found");
            return -1;
        }

        public String text(int n) {
            return this.textAttr(n);
        }

        public String textAttr(int n) {
            if (this.attr == null) {
                IG.err("no attributes found");
                return "";
            }
            if (n < 0 || n >= this.attr.text.length) {
                IG.err("invalid index number " + n);
                return "";
            }
            if (this.attr.text[n] != null) {
                return this.attr.text[n];
            }
            return "";
        }

        public String text(String string) {
            return this.textAttr(string);
        }

        public String textAttr(String string) {
            int n = this.fieldIndex(string);
            if (n < 0) {
                return "";
            }
            return this.textAttr(n);
        }

        public double num(int n) {
            return this.numAttr(n);
        }

        public double numAttr(int n) {
            if (this.attr == null) {
                IG.err("no attributes found");
                return 0.0;
            }
            if (n < 0 || n >= this.attr.number.length) {
                IG.err("invalid index number " + n);
                return 0.0;
            }
            return this.attr.number[n];
        }

        public double num(String string) {
            return this.numAttr(string);
        }

        public double numAttr(String string) {
            int n = this.fieldIndex(string);
            if (n < 0) {
                return 0.0;
            }
            return this.numAttr(n);
        }

        public IColor clr() {
            return this.object.clr();
        }

        public float weight() {
            return this.object.weight();
        }

        public int redInt() {
            return this.clr().getRed();
        }

        public int greenInt() {
            return this.clr().getGreen();
        }

        public int blueInt() {
            return this.clr().getBlue();
        }

        public int alphaInt() {
            return this.clr().getAlpha();
        }

        public int grayInt() {
            return this.clr().getGrey();
        }

        public int greyInt() {
            return this.grayInt();
        }

        public double red() {
            return (double)this.redInt() / 255.0;
        }

        public double green() {
            return (double)this.greenInt() / 255.0;
        }

        public double blue() {
            return (double)this.blueInt() / 255.0;
        }

        public double alpha() {
            return (double)this.alphaInt() / 255.0;
        }

        public double gray() {
            return (double)this.grayInt() / 255.0;
        }

        public Shape clr(IColor iColor) {
            this.object.clr(iColor);
            return this;
        }

        public Shape clr(IColor iColor, int n) {
            this.object.clr(iColor, n);
            return this;
        }

        public Shape clr(IColor iColor, float f) {
            this.object.clr(iColor, f);
            return this;
        }

        public Shape clr(IColor iColor, double d) {
            return this.clr(iColor, (float)d);
        }

        public Color awtColor() {
            return this.object.awtColor();
        }

        public Color getAWTColor() {
            return this.awtColor();
        }

        public Shape clr(Color color) {
            return this.clr(new IColor(color));
        }

        public Shape clr(Color color, int n) {
            return this.clr(new IColor(color), n);
        }

        public Shape clr(Color color, float f) {
            return this.clr(new IColor(color), f);
        }

        public Shape clr(Color color, double d) {
            return this.clr(new IColor(color), d);
        }

        public IColor getColor() {
            return this.clr();
        }

        public Shape clr(int n) {
            this.object.clr(n);
            return this;
        }

        public Shape clr(double d) {
            this.object.clr(d);
            return this;
        }

        public Shape clr(float f) {
            this.object.clr(f);
            return this;
        }

        public Shape clr(int n, int n2) {
            this.object.clr(n, n2);
            return this;
        }

        public Shape clr(double d, double d2) {
            this.object.clr(d, d2);
            return this;
        }

        public Shape clr(float f, float f2) {
            this.object.clr(f, f2);
            return this;
        }

        public Shape clr(int n, int n2, int n3) {
            this.object.clr(n, n2, n3);
            return this;
        }

        public Shape clr(double d, double d2, double d3) {
            this.object.clr(d, d2, d3);
            return this;
        }

        public Shape clr(float f, float f2, float f3) {
            this.object.clr(f, f2, f3);
            return this;
        }

        public Shape clr(int n, int n2, int n3, int n4) {
            this.object.clr(n, n2, n3, n4);
            return this;
        }

        public Shape clr(double d, double d2, double d3, double d4) {
            this.object.clr(d, d2, d3, d4);
            return this;
        }

        public Shape clr(float f, float f2, float f3, float f4) {
            this.object.clr(f, f2, f3, f4);
            return this;
        }

        public Shape hsb(double d, double d2, double d3, double d4) {
            this.object.hsb(d, d2, d3, d4);
            return this;
        }

        public Shape hsb(float f, float f2, float f3, float f4) {
            this.object.hsb(f, f2, f3, f4);
            return this;
        }

        public Shape hsb(double d, double d2, double d3) {
            this.object.hsb(d, d2, d3);
            return this;
        }

        public Shape hsb(float f, float f2, float f3) {
            this.object.hsb(f, f2, f3);
            return this;
        }

        public Shape weight(double d) {
            return this.weight((float)d);
        }

        public Shape weight(float f) {
            this.object.weight(f);
            return this;
        }
    }
}

