/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IAttribute;
import igeo.IConfig;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.IOut;
import igeo.ISurface;
import igeo.ISurfaceI;
import igeo.ISurfaceR;
import igeo.ITexture;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2f;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;
import igeo.gui.ISurfaceMesh;
import igeo.gui.ITrimLoopGraphic;
import java.util.ArrayList;

public class ISurfaceGraphicFillGL
extends IGraphicObject {
    public static final boolean insertPointOnDegree1TwistedSurface = true;
    public int isoparmRatioU = IConfig.tessellationResolution;
    public int isoparmRatioV = IConfig.tessellationResolution;
    public ISurfaceI surface = null;
    public IVec[][] quads;
    public IVec[][] quadsNormal;
    public IVec2f[][] quadsUV;
    public IVec[][] triangles;
    public IVec[][] trianglesNormal;
    public IVec2f[][] trianglesUV;
    public ITexture texture;
    public double[] uvalCache;
    public double[] vvalCache;
    public IVec2[][] triangles2DCache;
    public boolean initialized = false;
    int origUEPNum;
    int origVEPNum;

    public ISurfaceGraphicFillGL(ISurface iSurface) {
        super(iSurface);
        this.surface = iSurface.surface;
    }

    public ISurfaceGraphicFillGL(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface;
    }

    public ISurfaceGraphicFillGL(IObject iObject, ISurfaceI iSurfaceI) {
        super(iObject);
        this.surface = iSurfaceI;
    }

    public ISurfaceGraphicFillGL(ISurface iSurface, int n, int n2) {
        super(iSurface);
        this.isoparmRatioU = n;
        this.isoparmRatioV = n2;
    }

    public ISurfaceGraphicFillGL(ISurfaceR iSurfaceR, int n, int n2) {
        super(iSurfaceR);
        this.isoparmRatioU = n;
        this.isoparmRatioV = n2;
    }

    public void initSurface() {
        this.origUEPNum = this.surface.uepNum();
        this.origVEPNum = this.surface.vepNum();
        if (!this.surface.hasTrim() || !this.surface.hasInnerTrim() && this.surface.hasDefaultTrim()) {
            this.initWithoutTrim();
        } else {
            this.initWithTrim();
        }
        this.initialized = true;
    }

    public void setAttribute(IAttribute iAttribute) {
        super.setAttribute(iAttribute);
        this.texture = iAttribute.texture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initWithoutTrim() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            double[] dArray;
            int n;
            int n2;
            int n3;
            double[] dArray2;
            int n4;
            if (this.surface.udeg() == 1) {
                n4 = this.surface.unum();
                dArray2 = new double[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    dArray2[n3] = this.surface.u(n3, 0.0);
                }
            } else {
                n4 = this.surface.uepNum();
                n3 = (n4 - 1) * this.isoparmRatioU + 1;
                dArray2 = new double[n3];
                for (n2 = 0; n2 < n4; ++n2) {
                    for (n = 0; n < this.isoparmRatioU; ++n) {
                        if (n2 >= n4 - 1 && n != 0) continue;
                        dArray2[n2 * this.isoparmRatioU + n] = this.surface.u(n2, (double)n / (double)this.isoparmRatioU);
                    }
                }
            }
            if (this.surface.vdeg() == 1) {
                n4 = this.surface.vnum();
                dArray = new double[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    dArray[n3] = this.surface.v(n3, 0.0);
                }
            } else {
                n4 = this.surface.vepNum();
                n3 = (n4 - 1) * this.isoparmRatioV + 1;
                dArray = new double[n3];
                for (n2 = 0; n2 < n4; ++n2) {
                    for (n = 0; n < this.isoparmRatioV; ++n) {
                        if (n2 >= n4 - 1 && n != 0) continue;
                        dArray[n2 * this.isoparmRatioV + n] = this.surface.v(n2, (double)n / (double)this.isoparmRatioV);
                    }
                }
            }
            if (this.surface.udeg() == 1 && this.surface.vdeg() == 1) {
                int n5;
                boolean[] blArray = new boolean[dArray2.length - 1];
                boolean[] blArray2 = new boolean[dArray.length - 1];
                n2 = 0;
                for (n = 0; n < dArray2.length - 1; ++n) {
                    blArray[n] = false;
                }
                for (n = 0; n < dArray.length - 1; ++n) {
                    blArray2[n] = false;
                }
                for (n = 0; n < dArray2.length - 1; ++n) {
                    for (n5 = 0; n5 < dArray.length - 1; ++n5) {
                        if (IVec.isFlat(this.surface.pt(dArray2[n], dArray[n5]), this.surface.pt(dArray2[n + 1], dArray[n5]), this.surface.pt(dArray2[n + 1], dArray[n5 + 1]), this.surface.pt(dArray2[n], dArray[n5 + 1]))) continue;
                        blArray[n] = true;
                        blArray2[n5] = true;
                        n2 = 1;
                    }
                }
                if (n2 != 0) {
                    int n6;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    for (n5 = 0; n5 < dArray2.length - 1; ++n5) {
                        arrayList.add(dArray2[n5]);
                        if (!blArray[n5]) continue;
                        for (n6 = 1; n6 < this.isoparmRatioU; ++n6) {
                            arrayList.add((dArray2[n5 + 1] - dArray2[n5]) * (double)n6 / (double)this.isoparmRatioU + dArray2[n5]);
                        }
                    }
                    arrayList.add(dArray2[dArray2.length - 1]);
                    ArrayList<Double> arrayList2 = new ArrayList<Double>();
                    for (n6 = 0; n6 < dArray.length - 1; ++n6) {
                        arrayList2.add(dArray[n6]);
                        if (!blArray2[n6]) continue;
                        for (int i = 1; i < this.isoparmRatioV; ++i) {
                            arrayList2.add((dArray[n6 + 1] - dArray[n6]) * (double)i / (double)this.isoparmRatioV + dArray[n6]);
                        }
                    }
                    arrayList2.add(dArray[dArray.length - 1]);
                    dArray2 = new double[arrayList.size()];
                    for (n6 = 0; n6 < arrayList.size(); ++n6) {
                        dArray2[n6] = (Double)arrayList.get(n6);
                    }
                    dArray = new double[arrayList2.size()];
                    for (n6 = 0; n6 < arrayList2.size(); ++n6) {
                        dArray[n6] = (Double)arrayList2.get(n6);
                    }
                }
            }
            IVec[][] iVecArray = new IVec[dArray2.length][dArray.length];
            IVec[][] iVecArray2 = new IVec[dArray2.length][dArray.length];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                for (int i = 0; i < dArray.length; ++i) {
                    iVecArray[n2][i] = this.surface.pt(dArray2[n2], dArray[i]).get();
                    iVecArray2[n2][i] = this.surface.normal(dArray2[n2], dArray[i]).get().unit();
                }
            }
            if (this.texture != null) {
                IVec2f[][] iVec2fArray = new IVec2f[dArray2.length][dArray.length];
                for (int i = 0; i < dArray2.length; ++i) {
                    for (int j = 0; j < dArray.length; ++j) {
                        iVec2fArray[i][j] = new IVec2f((float)i * 1.0f / (float)(dArray2.length - 1), (float)j * 1.0f / (float)(dArray.length - 1));
                    }
                }
                this.quadsUV = iVec2fArray;
            }
            this.quads = iVecArray;
            this.quadsNormal = iVecArray2;
            this.uvalCache = dArray2;
            this.vvalCache = dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initWithTrim() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            ITrimLoopGraphic[] iTrimLoopGraphicArray = null;
            ITrimLoopGraphic[] iTrimLoopGraphicArray2 = null;
            if (this.surface.hasOuterTrim()) {
                iTrimLoopGraphicArray = new ITrimLoopGraphic[this.surface.outerTrimLoopNum()];
                for (n6 = 0; n6 < this.surface.outerTrimLoopNum(); ++n6) {
                    iTrimLoopGraphicArray[n6] = new ITrimLoopGraphic(this.surface.outerTrimLoop(n6), true, IConfig.trimSegmentResolution);
                }
            }
            if (this.surface.hasInnerTrim()) {
                iTrimLoopGraphicArray2 = new ITrimLoopGraphic[this.surface.innerTrimLoopNum()];
                for (n6 = 0; n6 < this.surface.innerTrimLoopNum(); ++n6) {
                    iTrimLoopGraphicArray2[n6] = new ITrimLoopGraphic(this.surface.innerTrimLoop(n6), false, IConfig.trimSegmentResolution);
                }
            }
            n6 = this.isoparmRatioU * (this.surface.uepNum() - 1) + 1;
            int n7 = this.isoparmRatioV * (this.surface.vepNum() - 1) + 1;
            double[] dArray = null;
            double[] dArray2 = null;
            if (this.surface.udeg() == 1) {
                n6 = this.surface.unum();
                dArray = new double[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    dArray[n5] = (double)n5 / (double)(n6 - 1);
                }
            } else {
                dArray = new double[n6];
                for (n5 = 0; n5 < this.surface.uepNum(); ++n5) {
                    for (n4 = 0; n4 < this.isoparmRatioU && n5 < this.surface.uepNum() - 1 || n4 == 0; ++n4) {
                        dArray[n5 * this.isoparmRatioU + n4] = this.surface.u(n5, (double)n4 / (double)this.isoparmRatioU);
                    }
                }
            }
            if (this.surface.vdeg() == 1) {
                n7 = this.surface.vnum();
                dArray2 = new double[n7];
                for (n5 = 0; n5 < n7; ++n5) {
                    dArray2[n5] = (double)n5 / (double)(n7 - 1);
                }
            } else {
                dArray2 = new double[n7];
                for (n5 = 0; n5 < this.surface.vepNum(); ++n5) {
                    for (n4 = 0; n4 < this.isoparmRatioV && n5 < this.surface.vepNum() - 1 || n4 == 0; ++n4) {
                        dArray2[n5 * this.isoparmRatioV + n4] = this.surface.v(n5, (double)n4 / (double)this.isoparmRatioV);
                    }
                }
            }
            if (this.surface.udeg() == 1 && this.surface.vdeg() == 1) {
                int n8;
                int n9;
                boolean[] blArray = new boolean[dArray.length - 1];
                boolean[] blArray2 = new boolean[dArray2.length - 1];
                n3 = 0;
                for (n9 = 0; n9 < dArray.length - 1; ++n9) {
                    blArray[n9] = false;
                }
                for (n9 = 0; n9 < dArray2.length - 1; ++n9) {
                    blArray2[n9] = false;
                }
                for (n9 = 0; n9 < dArray.length - 1; ++n9) {
                    for (n8 = 0; n8 < dArray2.length - 1; ++n8) {
                        if (IVec.isFlat(this.surface.pt(dArray[n9], dArray2[n8]), this.surface.pt(dArray[n9 + 1], dArray2[n8]), this.surface.pt(dArray[n9 + 1], dArray2[n8 + 1]), this.surface.pt(dArray[n9], dArray2[n8 + 1]))) continue;
                        blArray[n9] = true;
                        blArray2[n8] = true;
                        n3 = 1;
                    }
                }
                if (n3 != 0) {
                    int n10;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    for (n8 = 0; n8 < dArray.length - 1; ++n8) {
                        arrayList.add(dArray[n8]);
                        if (!blArray[n8]) continue;
                        for (n10 = 1; n10 < this.isoparmRatioU; ++n10) {
                            arrayList.add((dArray[n8 + 1] - dArray[n8]) * (double)n10 / (double)this.isoparmRatioU + dArray[n8]);
                        }
                    }
                    arrayList.add(dArray[dArray.length - 1]);
                    ArrayList<Double> arrayList2 = new ArrayList<Double>();
                    for (n10 = 0; n10 < dArray2.length - 1; ++n10) {
                        arrayList2.add(dArray2[n10]);
                        if (!blArray2[n10]) continue;
                        for (n2 = 1; n2 < this.isoparmRatioV; ++n2) {
                            arrayList2.add((dArray2[n10 + 1] - dArray2[n10]) * (double)n2 / (double)this.isoparmRatioV + dArray2[n10]);
                        }
                    }
                    arrayList2.add(dArray2[dArray2.length - 1]);
                    dArray = new double[arrayList.size()];
                    for (n10 = 0; n10 < arrayList.size(); ++n10) {
                        dArray[n10] = (Double)arrayList.get(n10);
                    }
                    n6 = dArray.length;
                    dArray2 = new double[arrayList2.size()];
                    for (n10 = 0; n10 < arrayList2.size(); ++n10) {
                        dArray2[n10] = (Double)arrayList2.get(n10);
                    }
                    n7 = dArray2.length;
                }
            }
            IVec2[][] iVec2Array = new IVec2[n6][n7];
            for (int i = 0; i < n6; ++i) {
                for (n3 = 0; n3 < n7; ++n3) {
                    iVec2Array[i][n3] = new IVec2(dArray[i], dArray2[n3]);
                }
            }
            IVec2[][] iVec2Array2 = null;
            if (iTrimLoopGraphicArray != null) {
                iVec2Array2 = new IVec2[iTrimLoopGraphicArray.length][];
                for (n3 = 0; n3 < iTrimLoopGraphicArray.length; ++n3) {
                    iVec2Array2[n3] = iTrimLoopGraphicArray[n3].getPolyline2D().get();
                }
            }
            IVec2[][] iVec2Array3 = null;
            if (iTrimLoopGraphicArray2 != null) {
                iVec2Array3 = new IVec2[iTrimLoopGraphicArray2.length][];
                for (int i = 0; i < iTrimLoopGraphicArray2.length; ++i) {
                    iVec2Array3[i] = iTrimLoopGraphicArray2[i].getPolyline2D().get();
                }
            }
            IVec2[][] iVec2Array4 = ISurfaceMesh.getTriangles(iVec2Array, iVec2Array2, iVec2Array3);
            IVec[][] iVecArray = new IVec[iVec2Array4.length][3];
            IVec[][] iVecArray2 = new IVec[iVec2Array4.length][3];
            for (n2 = 0; n2 < iVec2Array4.length; ++n2) {
                for (n = 0; n < iVec2Array4[n2].length; ++n) {
                    iVecArray[n2][n] = this.surface.pt(iVec2Array4[n2][n]).get();
                    iVecArray2[n2][n] = this.surface.normal(iVec2Array4[n2][n]).get().unit();
                }
            }
            if (this.texture != null) {
                this.trianglesUV = new IVec2f[iVec2Array4.length][3];
                for (n2 = 0; n2 < iVec2Array4.length; ++n2) {
                    for (n = 0; n < iVec2Array4[n2].length; ++n) {
                        this.trianglesUV[n2][n] = new IVec2f((float)iVec2Array4[n2][n].x, (float)iVec2Array4[n2][n].y);
                    }
                }
            }
            this.triangles = iVecArray;
            this.trianglesNormal = iVecArray2;
            this.triangles2DCache = iVec2Array4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateWithoutTrim() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            if (this.uvalCache == null || this.vvalCache == null) {
                IOut.err("cache is null. not updated.");
                return;
            }
            if (this.quads == null || this.quads.length != this.uvalCache.length || this.quads[0].length != this.vvalCache.length) {
                this.quads = new IVec[this.uvalCache.length][this.vvalCache.length];
                this.quadsNormal = new IVec[this.uvalCache.length][this.vvalCache.length];
            }
            for (int i = 0; i < this.uvalCache.length; ++i) {
                for (int j = 0; j < this.vvalCache.length; ++j) {
                    this.quads[i][j] = this.surface.pt(this.uvalCache[i], this.vvalCache[j]).get();
                    this.quadsNormal[i][j] = this.surface.normal(this.uvalCache[i], this.vvalCache[j]).get().unit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateWithTrim() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            if (this.triangles2DCache == null) {
                IOut.err("cache is null. not updated.");
                return;
            }
            if (this.triangles == null || this.triangles.length != this.triangles2DCache.length) {
                this.triangles = new IVec[this.triangles2DCache.length][3];
                this.trianglesNormal = new IVec[this.triangles2DCache.length][3];
            }
            for (int i = 0; i < this.triangles2DCache.length; ++i) {
                for (int j = 0; j < this.triangles2DCache[i].length; ++j) {
                    this.triangles[i][j] = this.surface.pt(this.triangles2DCache[i][j]).get();
                    this.trianglesNormal[i][j] = this.surface.normal(this.triangles2DCache[i][j]).get().unit();
                }
            }
        }
    }

    public void updateSurface() {
        if (this.origUEPNum != this.surface.uepNum() || this.origVEPNum != this.surface.vepNum()) {
            this.initSurface();
            return;
        }
        if (this.quads != null) {
            this.updateWithoutTrim();
        }
        if (this.triangles != null) {
            this.updateWithTrim();
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D() && iGraphicMode.isFill();
    }

    public synchronized void draw(IGraphics iGraphics) {
        if (!this.initialized) {
            this.initSurface();
        } else if (this.update) {
            this.updateSurface();
            this.update = false;
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            float[] fArray = null;
            fArray = this.color != null ? this.color.rgba() : IConfig.objectColor.rgba();
            if (iGraphics3D.view().mode().isTransparent()) {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], (float)IConfig.transparentModeAlpha / 255.0f};
            }
            if (iGraphics3D.view().mode().isLight()) {
                iGraphics3D.ambient(fArray);
                iGraphics3D.diffuse(fArray);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.clr(fArray[0], fArray[1], fArray[2], 0.0f);
            }
            iGraphics3D.clr(fArray);
            if (this.texture != null) {
                iGraphics3D.beginTexture(this.texture);
            }
            if (this.texture != null) {
                if (this.quads != null) {
                    if (this.quadsNormal == null) {
                        iGraphics3D.drawQuadMatrix(this.quads, this.quadsUV);
                    } else {
                        iGraphics3D.drawQuadMatrix(this.quads, this.quadsNormal, this.quadsUV);
                    }
                }
                if (this.triangles != null) {
                    if (this.trianglesNormal == null) {
                        for (int i = 0; i < this.triangles.length; ++i) {
                            iGraphics3D.drawTriangles(this.triangles[i], this.trianglesUV[i]);
                        }
                    } else {
                        for (int i = 0; i < this.triangles.length; ++i) {
                            iGraphics3D.drawTriangles(this.triangles[i], this.trianglesNormal[i], this.trianglesUV[i]);
                        }
                    }
                }
            } else {
                if (this.quads != null) {
                    if (this.quadsNormal == null) {
                        iGraphics3D.drawQuadMatrix(this.quads);
                    } else {
                        iGraphics3D.drawQuadMatrix(this.quads, this.quadsNormal);
                    }
                }
                if (this.triangles != null) {
                    if (this.trianglesNormal == null) {
                        for (int i = 0; i < this.triangles.length; ++i) {
                            iGraphics3D.drawTriangles(this.triangles[i]);
                        }
                    } else {
                        for (int i = 0; i < this.triangles.length; ++i) {
                            iGraphics3D.drawTriangles(this.triangles[i], this.trianglesNormal[i]);
                        }
                    }
                }
            }
            if (this.texture != null) {
                iGraphics3D.endTexture();
            }
        }
    }
}

