/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDoubleI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IParameterObject;
import igeo.ITransformable;
import igeo.IVec;
import igeo.IVecI;

public class ITextGeo
extends IParameterObject
implements ITransformable {
    public String text;
    public IVecI pos;
    public IVecI uvec;
    public IVecI vvec;
    public HorizontalAlignment halign = HorizontalAlignment.Left;
    public VerticalAlignment valign = VerticalAlignment.Bottom;

    public ITextGeo(String string, double d, IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.text = string;
        this.pos = iVecI;
        this.uvec = iVecI2.cp().len(d);
        this.vvec = iVecI2.cross(iVecI3).cross(iVecI2).len(d);
    }

    public ITextGeo(String string, double d, IVecI iVecI, IVecI iVecI2) {
        this.text = string;
        this.pos = iVecI;
        this.uvec = iVecI2.cp().len(d);
        IVec iVec = new IVec(0.0, 1.0, 0.0);
        if (iVec.isParallel(iVecI2)) {
            if (iVecI2.dot(iVec) > 0.0) {
                iVec.set(-1.0, 0.0, 0.0);
            } else {
                iVec.set(1.0, 0.0, 0.0);
            }
        }
        this.vvec = iVecI2.cross(iVec).cross(iVecI2).len(d);
    }

    public ITextGeo(String string, double d, IVecI iVecI) {
        this.text = string;
        this.pos = iVecI;
        this.uvec = new IVec(d, 0.0, 0.0);
        this.vvec = new IVec(0.0, d, 0.0);
    }

    public ITextGeo(String string, IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.text = string;
        this.pos = iVecI;
        this.uvec = iVecI2;
        this.vvec = iVecI3;
    }

    public ITextGeo(ITextGeo iTextGeo) {
        this.text = new String(iTextGeo.text());
        this.pos = iTextGeo.pos().dup();
        this.uvec = iTextGeo.uvec().dup();
        this.vvec = iTextGeo.vvec().dup();
    }

    public IVecI pos() {
        return this.pos;
    }

    public IVecI uvec() {
        return this.uvec;
    }

    public IVecI vvec() {
        return this.vvec;
    }

    public ITextGeo pos(IVecI iVecI) {
        this.pos = iVecI;
        return this;
    }

    public ITextGeo uvec(IVecI iVecI) {
        this.uvec = iVecI;
        return this;
    }

    public ITextGeo vvec(IVecI iVecI) {
        this.vvec = iVecI;
        return this;
    }

    public String text() {
        return this.text;
    }

    public ITextGeo text(String string) {
        this.text = string;
        return this;
    }

    public ITextGeo alignLeft() {
        this.halign = HorizontalAlignment.Left;
        return this;
    }

    public ITextGeo alignCenter() {
        this.halign = HorizontalAlignment.Center;
        return this;
    }

    public ITextGeo alignRight() {
        this.halign = HorizontalAlignment.Right;
        return this;
    }

    public ITextGeo alignTop() {
        this.valign = VerticalAlignment.Top;
        return this;
    }

    public ITextGeo alignMiddle() {
        this.valign = VerticalAlignment.Middle;
        return this;
    }

    public ITextGeo alignBottom() {
        this.valign = VerticalAlignment.Bottom;
        return this;
    }

    public boolean isAlignLeft() {
        return this.halign == HorizontalAlignment.Left;
    }

    public boolean isAlignCenter() {
        return this.halign == HorizontalAlignment.Center;
    }

    public boolean isAlignRight() {
        return this.halign == HorizontalAlignment.Right;
    }

    public boolean isAlignTop() {
        return this.valign == VerticalAlignment.Top;
    }

    public boolean isAlignMiddle() {
        return this.valign == VerticalAlignment.Middle;
    }

    public boolean isAlignBottom() {
        return this.valign == VerticalAlignment.Bottom;
    }

    @Override
    public ITextGeo add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public ITextGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public ITextGeo add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public ITextGeo sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public ITextGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public ITextGeo sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public ITextGeo mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        this.uvec.mul(iDoubleI);
        this.vvec.mul(iDoubleI);
        return this;
    }

    @Override
    public ITextGeo mul(double d) {
        this.pos.mul(d);
        this.uvec.mul(d);
        this.vvec.mul(d);
        return this;
    }

    @Override
    public ITextGeo div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        this.uvec.div(iDoubleI);
        this.vvec.div(iDoubleI);
        return this;
    }

    @Override
    public ITextGeo div(double d) {
        this.pos.div(d);
        this.uvec.div(d);
        this.vvec.div(d);
        return this;
    }

    @Override
    public ITextGeo neg() {
        this.pos.neg();
        this.uvec.neg();
        this.vvec.neg();
        return this;
    }

    public ITextGeo rev() {
        return this.neg();
    }

    @Override
    public ITextGeo flip() {
        return this.neg();
    }

    @Override
    public ITextGeo add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public ITextGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITextGeo add(double d, IVecI iVecI) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public ITextGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITextGeo rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        this.uvec.rot(iDoubleI);
        this.vvec.rot(iDoubleI);
        return this;
    }

    @Override
    public ITextGeo rot(double d) {
        this.pos.rot(d);
        this.uvec.rot(d);
        this.vvec.rot(d);
        return this;
    }

    @Override
    public ITextGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        this.uvec.rot(iVecI, iDoubleI);
        this.vvec.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITextGeo rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        this.uvec.rot(iVecI, d);
        this.vvec.rot(iVecI, d);
        return this;
    }

    @Override
    public ITextGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        this.uvec.rot(iVecI2, iDoubleI);
        this.vvec.rot(iVecI2, iDoubleI);
        return this;
    }

    @Override
    public ITextGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        this.uvec.rot(iVecI2, d);
        this.vvec.rot(iVecI2, d);
        return this;
    }

    @Override
    public ITextGeo rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        this.uvec.rot(iVecI, iVecI2);
        this.vvec.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public ITextGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        this.uvec.rot(iVecI2, iVecI3.dif(iVecI));
        this.vvec.rot(iVecI2, iVecI3.dif(iVecI));
        return this;
    }

    @Override
    public ITextGeo rot2(IDoubleI iDoubleI) {
        this.pos.rot2(iDoubleI);
        this.uvec.rot2(iDoubleI);
        this.vvec.rot2(iDoubleI);
        return this;
    }

    @Override
    public ITextGeo rot2(double d) {
        this.pos.rot2(d);
        this.uvec.rot2(d);
        this.vvec.rot2(d);
        return this;
    }

    @Override
    public ITextGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        this.uvec.rot2(iDoubleI);
        this.vvec.rot2(iDoubleI);
        return this;
    }

    @Override
    public ITextGeo rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        this.uvec.rot2(d);
        this.vvec.rot2(d);
        return this;
    }

    @Override
    public ITextGeo rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        this.uvec.rot2(iVecI);
        this.vvec.rot2(iVecI);
        return this;
    }

    @Override
    public ITextGeo rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        this.uvec.rot2(iVecI2.dif(iVecI));
        this.vvec.rot2(iVecI2.dif(iVecI));
        return this;
    }

    @Override
    public ITextGeo scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public ITextGeo scale(double d) {
        return this.mul(d);
    }

    @Override
    public ITextGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        this.uvec.scale(iDoubleI);
        this.vvec.scale(iDoubleI);
        return this;
    }

    @Override
    public ITextGeo scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        this.uvec.scale(d);
        this.vvec.scale(d);
        return this;
    }

    @Override
    public ITextGeo scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        this.uvec.scale1d(iVecI, d);
        this.vvec.scale1d(iVecI, d);
        return this;
    }

    @Override
    public ITextGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        this.uvec.scale1d(iVecI, iDoubleI);
        this.vvec.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITextGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        this.uvec.scale1d(iVecI2, d);
        this.vvec.scale1d(iVecI2, d);
        return this;
    }

    @Override
    public ITextGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        this.uvec.scale1d(iVecI2, iDoubleI);
        this.vvec.scale1d(iVecI2, iDoubleI);
        return this;
    }

    @Override
    public ITextGeo ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        this.uvec.ref(iVecI);
        this.vvec.ref(iVecI);
        return this;
    }

    @Override
    public ITextGeo ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        this.uvec.ref(iVecI2);
        this.vvec.ref(iVecI2);
        return this;
    }

    @Override
    public ITextGeo mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public ITextGeo mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI2);
    }

    @Override
    public ITextGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        this.uvec.shear(d, d2, d3, d4, d5, d6);
        this.vvec.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public ITextGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        this.uvec.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        this.vvec.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public ITextGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        this.uvec.shear(d, d2, d3, d4, d5, d6);
        this.vvec.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public ITextGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        this.uvec.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        this.vvec.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public ITextGeo shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        this.uvec.shearXY(d, d2);
        this.vvec.shearXY(d, d2);
        return this;
    }

    @Override
    public ITextGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        this.uvec.shearXY(iDoubleI, iDoubleI2);
        this.vvec.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITextGeo shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        this.uvec.shearXY(d, d2);
        this.vvec.shearXY(d, d2);
        return this;
    }

    @Override
    public ITextGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        this.uvec.shearXY(iDoubleI, iDoubleI2);
        this.vvec.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITextGeo shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        this.uvec.shearYZ(d, d2);
        this.vvec.shearYZ(d, d2);
        return this;
    }

    @Override
    public ITextGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        this.uvec.shearYZ(iDoubleI, iDoubleI2);
        this.vvec.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITextGeo shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        this.uvec.shearYZ(d, d2);
        this.vvec.shearYZ(d, d2);
        return this;
    }

    @Override
    public ITextGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        this.uvec.shearYZ(iDoubleI, iDoubleI2);
        this.vvec.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITextGeo shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        this.uvec.shearZX(d, d2);
        this.vvec.shearZX(d, d2);
        return this;
    }

    @Override
    public ITextGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        this.uvec.shearZX(iDoubleI, iDoubleI2);
        this.vvec.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITextGeo shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        this.uvec.shearZX(d, d2);
        this.vvec.shearZX(d, d2);
        return this;
    }

    @Override
    public ITextGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        this.uvec.shearZX(iDoubleI, iDoubleI2);
        this.vvec.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITextGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ITextGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ITextGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ITextGeo dup() {
        return new ITextGeo(this);
    }

    @Override
    public ITextGeo cp() {
        return this.dup();
    }

    @Override
    public ITextGeo cp(double d, double d2, double d3) {
        return this.cp().add(d, d2, d3);
    }

    @Override
    public ITextGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.cp().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ITextGeo cp(IVecI iVecI) {
        return this.cp().add(iVecI);
    }

    @Override
    public ITextGeo translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ITextGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ITextGeo translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ITextGeo transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        this.uvec.transform(iMatrix3I);
        this.vvec.transform(iMatrix3I);
        return this;
    }

    @Override
    public ITextGeo transform(IMatrix4I iMatrix4I) {
        IMatrix3I iMatrix3I = iMatrix4I.matrix3();
        this.pos.transform(iMatrix4I);
        this.uvec.transform(iMatrix3I);
        this.vvec.transform(iMatrix3I);
        return this;
    }

    @Override
    public ITextGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        this.uvec.transform(iVecI, iVecI2, iVecI3);
        this.vvec.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public ITextGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        this.uvec.transform(iVecI, iVecI2, iVecI3);
        this.vvec.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public static enum VerticalAlignment {
        Top,
        Middle,
        Bottom;

    }

    public static enum HorizontalAlignment {
        Left,
        Center,
        Right;

    }
}

