/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IArithmeticVal;
import igeo.IColor;
import igeo.IDataAgent;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDynamics;
import igeo.ILayer;
import igeo.IMeshI;
import igeo.IObject;
import igeo.IVecI;
import igeo.IVertex;
import java.util.ArrayList;

public class ILinkedDataAgent<T extends IArithmeticVal<T, IDoubleI>>
extends IDataAgent<T, IDoubleI> {
    public ArrayList<IDataAgent<T, IDoubleI>> links;
    public T nextData;
    public double fric = 0.5;

    public ILinkedDataAgent() {
        this.initLinkedDataAgent();
    }

    public ILinkedDataAgent(T t) {
        super(t);
        this.initLinkedDataAgent();
    }

    public ILinkedDataAgent(IVecI iVecI) {
        super(iVecI);
        this.initLinkedDataAgent();
    }

    public ILinkedDataAgent(IVecI iVecI, T t) {
        super(iVecI, t);
        this.initLinkedDataAgent();
    }

    public void initLinkedDataAgent() {
        this.links = new ArrayList();
        if (this.data != null) {
            this.nextData = (IArithmeticVal)this.data.dup();
        }
    }

    public ILinkedDataAgent fric(double d) {
        this.fric = d;
        return this;
    }

    public double fric() {
        return this.fric;
    }

    @Override
    public ILinkedDataAgent setData(T t) {
        super.setData(t);
        this.nextData = (IArithmeticVal)this.data.dup();
        return this;
    }

    public ILinkedDataAgent connect(IDataAgent<T, IDoubleI> iDataAgent) {
        this.links.add(iDataAgent);
        return this;
    }

    @Override
    public void interact(ArrayList<IDynamics> arrayList) {
        if (this.data == null || this.links.size() == 0) {
            return;
        }
        this.nextData.zero();
        for (int i = 0; i < this.links.size(); ++i) {
            this.nextData.add(this.links.get(i).getData());
        }
        this.nextData.div((IDouble)new IDouble(this.links.size()));
    }

    @Override
    public void update() {
        if (this.data != null) {
            this.nextData.sub((IArithmeticVal)this.data);
            this.nextData.mul((IDouble)new IDouble(1.0 - this.fric));
            this.data.add(this.nextData);
        }
    }

    public static <R extends IArithmeticVal<R, IDoubleI>> ILinkedDataAgent[] create(IMeshI iMeshI) {
        int n;
        ILinkedDataAgent[] iLinkedDataAgentArray = new ILinkedDataAgent[iMeshI.vertexNum()];
        for (n = 0; n < iMeshI.vertexNum(); ++n) {
            iLinkedDataAgentArray[n] = new ILinkedDataAgent<IArithmeticVal>(iMeshI.vertex(n).pos(), (IArithmeticVal)null);
        }
        for (n = 0; n < iMeshI.edgeNum(); ++n) {
            int n2;
            IVertex iVertex = iMeshI.edge(n).vertex(0);
            IVertex iVertex2 = iMeshI.edge(n).vertex(1);
            int n3 = -1;
            int n4 = -1;
            for (n2 = 0; n2 < iMeshI.vertexNum() && n3 < 0; ++n2) {
                if (iMeshI.vertex(n2) != iVertex) continue;
                n3 = n2;
            }
            for (n2 = 0; n2 < iMeshI.vertexNum() && n4 < 0; ++n2) {
                if (iMeshI.vertex(n2) != iVertex2) continue;
                n4 = n2;
            }
            if (n3 < 0 || n4 < 0) continue;
            iLinkedDataAgentArray[n3].connect(iLinkedDataAgentArray[n4]);
            iLinkedDataAgentArray[n4].connect(iLinkedDataAgentArray[n3]);
        }
        return iLinkedDataAgentArray;
    }

    @Override
    public ILinkedDataAgent name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public ILinkedDataAgent layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public ILinkedDataAgent hide() {
        super.hide();
        return this;
    }

    @Override
    public ILinkedDataAgent show() {
        super.show();
        return this;
    }

    @Override
    public ILinkedDataAgent clr(IColor iColor) {
        super.clr(iColor);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(IColor iColor, int n) {
        super.clr(iColor, n);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(IColor iColor, float f) {
        super.clr(iColor, f);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(IColor iColor, double d) {
        super.clr(iColor, d);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(IObject iObject) {
        super.clr(iObject);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public ILinkedDataAgent clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public ILinkedDataAgent hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public ILinkedDataAgent hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public ILinkedDataAgent hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public ILinkedDataAgent hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public ILinkedDataAgent weight(float f) {
        super.weight(f);
        return this;
    }

    @Override
    public ILinkedDataAgent weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(IColor iColor) {
        super.setColor(iColor);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(IColor iColor, int n) {
        super.setColor(iColor, n);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(IColor iColor, float f) {
        super.setColor(iColor, f);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(IColor iColor, double d) {
        super.setColor(iColor, d);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public ILinkedDataAgent setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public ILinkedDataAgent setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public ILinkedDataAgent setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public ILinkedDataAgent setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public ILinkedDataAgent setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

