/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IColor;
import igeo.ICurve;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IPointAgent;
import igeo.ITrajectoryI;
import igeo.IVecI;

public class ITrajectoryGeo
extends IDynamicsBase
implements ITrajectoryI {
    public int degree;
    public ICurve curve;
    public IVecI pos;

    public ITrajectoryGeo(IVecI iVecI) {
        this.pos = iVecI;
        this.degree = 1;
        this.initTrajectory();
    }

    public ITrajectoryGeo(IVecI iVecI, int n) {
        this.pos = iVecI;
        this.degree = n;
        this.initTrajectory();
    }

    public ITrajectoryGeo(IObject iObject, IVecI iVecI) {
        super(iObject);
        this.pos = iVecI;
        this.degree = 1;
        this.initTrajectory();
    }

    public ITrajectoryGeo(IObject iObject, IVecI iVecI, int n) {
        super(iObject);
        this.pos = iVecI;
        this.degree = n;
        this.initTrajectory();
    }

    public ITrajectoryGeo(IPointAgent iPointAgent) {
        super(iPointAgent);
        this.pos = iPointAgent.pos();
        this.degree = 1;
        this.initTrajectory();
    }

    public ITrajectoryGeo(IPointAgent iPointAgent, int n) {
        super(iPointAgent);
        this.pos = iPointAgent.pos();
        this.degree = n;
        this.initTrajectory();
    }

    public ITrajectoryGeo(ITrajectoryGeo iTrajectoryGeo) {
        super(iTrajectoryGeo);
        this.degree = iTrajectoryGeo.degree;
        this.curve = iTrajectoryGeo.curve.dup();
        this.pos = iTrajectoryGeo.pos.dup();
    }

    public void initTrajectory() {
        this.update();
    }

    public int deg() {
        return this.degree;
    }

    public ITrajectoryGeo deg(int n) {
        this.degree = n;
        return this;
    }

    public void hide() {
        if (this.curve != null) {
            this.curve.hide();
        }
    }

    public void show() {
        if (this.curve != null) {
            this.curve.show();
        }
    }

    public void del() {
        if (this.curve != null) {
            this.curve.del();
        }
        if (this.parent != null) {
            this.parent.deleteDynamics(this);
        }
    }

    public ICurve curve() {
        return this.curve;
    }

    public ICurve trajectory() {
        return this.curve();
    }

    public ITrajectoryGeo addCP(IVecI iVecI) {
        if (this.curve == null) {
            this.curve = new ICurve(iVecI);
            if (this.parent != null) {
                if (this.parent.attr() != null) {
                    this.curve.attr(this.parent.attr());
                } else if (this.parent.clr() != null) {
                    this.curve.clr(this.parent.clr());
                }
            }
        } else {
            this.curve.addCP(iVecI, this.degree);
        }
        return this;
    }

    public void update() {
        this.addCP(this.pos.get().dup());
    }

    public ITrajectoryGeo clr(IColor iColor) {
        if (this.curve != null) {
            this.curve.clr(iColor);
        }
        return this;
    }

    public ITrajectoryGeo clr(IColor iColor, int n) {
        if (this.curve != null) {
            this.curve.clr(iColor, n);
        }
        return this;
    }

    public ITrajectoryGeo clr(IColor iColor, float f) {
        if (this.curve != null) {
            this.curve.clr(iColor, f);
        }
        return this;
    }

    public ITrajectoryGeo clr(IColor iColor, double d) {
        if (this.curve != null) {
            this.curve.clr(iColor, d);
        }
        return this;
    }

    public ITrajectoryGeo clr(IObject iObject) {
        if (this.curve != null) {
            this.curve.clr(iObject);
        }
        return this;
    }

    public ITrajectoryGeo clr(int n) {
        if (this.curve != null) {
            this.curve.clr(n);
        }
        return this;
    }

    public ITrajectoryGeo clr(float f) {
        if (this.curve != null) {
            this.curve.clr(f);
        }
        return this;
    }

    public ITrajectoryGeo clr(double d) {
        if (this.curve != null) {
            this.curve.clr(d);
        }
        return this;
    }

    public ITrajectoryGeo clr(int n, int n2) {
        if (this.curve != null) {
            this.curve.clr(n, n2);
        }
        return this;
    }

    public ITrajectoryGeo clr(float f, float f2) {
        if (this.curve != null) {
            this.curve.clr(f, f2);
        }
        return this;
    }

    public ITrajectoryGeo clr(double d, double d2) {
        if (this.curve != null) {
            this.curve.clr(d, d2);
        }
        return this;
    }

    public ITrajectoryGeo clr(int n, int n2, int n3) {
        if (this.curve != null) {
            this.curve.clr(n, n2, n3);
        }
        return this;
    }

    public ITrajectoryGeo clr(float f, float f2, float f3) {
        if (this.curve != null) {
            this.curve.clr(f, f2, f3);
        }
        return this;
    }

    public ITrajectoryGeo clr(double d, double d2, double d3) {
        if (this.curve != null) {
            this.curve.clr(d, d2, d3);
        }
        return this;
    }

    public ITrajectoryGeo clr(int n, int n2, int n3, int n4) {
        if (this.curve != null) {
            this.curve.clr(n, n2, n3, n4);
        }
        return this;
    }

    public ITrajectoryGeo clr(float f, float f2, float f3, float f4) {
        if (this.curve != null) {
            this.curve.clr(f, f2, f3, f4);
        }
        return this;
    }

    public ITrajectoryGeo clr(double d, double d2, double d3, double d4) {
        if (this.curve != null) {
            this.curve.clr(d, d2, d3, d4);
        }
        return this;
    }

    public ITrajectoryGeo hsb(float f, float f2, float f3, float f4) {
        if (this.curve != null) {
            this.curve.hsb(f, f2, f3, f4);
        }
        return this;
    }

    public ITrajectoryGeo hsb(double d, double d2, double d3, double d4) {
        if (this.curve != null) {
            this.curve.hsb(d, d2, d3, d4);
        }
        return this;
    }

    public ITrajectoryGeo hsb(float f, float f2, float f3) {
        if (this.curve != null) {
            this.curve.hsb(f, f2, f3);
        }
        return this;
    }

    public ITrajectoryGeo hsb(double d, double d2, double d3) {
        if (this.curve != null) {
            this.curve.hsb(d, d2, d3);
        }
        return this;
    }

    public ITrajectoryGeo setColor(IColor iColor) {
        if (this.curve != null) {
            this.curve.setColor(iColor);
        }
        return this;
    }

    public ITrajectoryGeo setColor(IColor iColor, int n) {
        if (this.curve != null) {
            this.curve.setColor(iColor, n);
        }
        return this;
    }

    public ITrajectoryGeo setColor(IColor iColor, float f) {
        if (this.curve != null) {
            this.curve.setColor(iColor, f);
        }
        return this;
    }

    public ITrajectoryGeo setColor(IColor iColor, double d) {
        if (this.curve != null) {
            this.curve.setColor(iColor, d);
        }
        return this;
    }

    public ITrajectoryGeo setColor(int n) {
        if (this.curve != null) {
            this.curve.setColor(n);
        }
        return this;
    }

    public ITrajectoryGeo setColor(float f) {
        if (this.curve != null) {
            this.curve.setColor(f);
        }
        return this;
    }

    public ITrajectoryGeo setColor(double d) {
        if (this.curve != null) {
            this.curve.setColor(d);
        }
        return this;
    }

    public ITrajectoryGeo setColor(int n, int n2) {
        if (this.curve != null) {
            this.curve.setColor(n, n2);
        }
        return this;
    }

    public ITrajectoryGeo setColor(float f, float f2) {
        if (this.curve != null) {
            this.curve.setColor(f, f2);
        }
        return this;
    }

    public ITrajectoryGeo setColor(double d, double d2) {
        if (this.curve != null) {
            this.curve.setColor(d, d2);
        }
        return this;
    }

    public ITrajectoryGeo setColor(int n, int n2, int n3) {
        if (this.curve != null) {
            this.curve.setColor(n, n2, n3);
        }
        return this;
    }

    public ITrajectoryGeo setColor(float f, float f2, float f3) {
        if (this.curve != null) {
            this.curve.setColor(f, f2, f3);
        }
        return this;
    }

    public ITrajectoryGeo setColor(double d, double d2, double d3) {
        if (this.curve != null) {
            this.curve.setColor(d, d2, d3);
        }
        return this;
    }

    public ITrajectoryGeo setColor(int n, int n2, int n3, int n4) {
        if (this.curve != null) {
            this.curve.setColor(n, n2, n3, n4);
        }
        return this;
    }

    public ITrajectoryGeo setColor(float f, float f2, float f3, float f4) {
        if (this.curve != null) {
            this.curve.setColor(f, f2, f3, f4);
        }
        return this;
    }

    public ITrajectoryGeo setColor(double d, double d2, double d3, double d4) {
        if (this.curve != null) {
            this.curve.setColor(d, d2, d3, d4);
        }
        return this;
    }

    public ITrajectoryGeo setHSBColor(float f, float f2, float f3, float f4) {
        if (this.curve != null) {
            this.curve.setHSBColor(f, f2, f3, f4);
        }
        return this;
    }

    public ITrajectoryGeo setHSBColor(double d, double d2, double d3, double d4) {
        if (this.curve != null) {
            this.curve.setHSBColor(d, d2, d3, d4);
        }
        return this;
    }

    public ITrajectoryGeo setHSBColor(float f, float f2, float f3) {
        if (this.curve != null) {
            this.curve.setHSBColor(f, f2, f3);
        }
        return this;
    }

    public ITrajectoryGeo setHSBColor(double d, double d2, double d3) {
        if (this.curve != null) {
            this.curve.setHSBColor(d, d2, d3);
        }
        return this;
    }

    public ITrajectoryGeo weight(double d) {
        if (this.curve != null) {
            this.curve.weight(d);
        }
        return this;
    }

    public ITrajectoryGeo weight(float f) {
        if (this.curve != null) {
            this.curve.weight(f);
        }
        return this;
    }
}

