/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IComparator;
import igeo.IConfig;
import igeo.IDelaunay2D;
import igeo.IOut;
import igeo.ISort;
import igeo.IVec2;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IVoronoi2D {
    public static IVec2[][] getPolygons(IVec2[] iVec2Array) {
        IVec2[][] iVec2Array2 = IDelaunay2D.getTriangles(iVec2Array);
        IVec2[] iVec2Array3 = new IVec2[iVec2Array2.length];
        for (int i = 0; i < iVec2Array2.length; ++i) {
            iVec2Array3[i] = IVoronoi2D.circumcenter(iVec2Array2[i]);
        }
        IVec2[][] iVec2Array4 = new IVec2[iVec2Array.length][];
        for (int i = 0; i < iVec2Array.length; ++i) {
            ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
            for (int j = 0; j < iVec2Array2.length; ++j) {
                boolean bl = false;
                for (int k = 0; k < iVec2Array2[j].length && iVec2Array3[j] != null && !bl; ++k) {
                    if (iVec2Array[i] != iVec2Array2[j][k]) continue;
                    arrayList.add(iVec2Array3[j]);
                    bl = true;
                }
            }
            ISort.sort(arrayList, new RadialComparator(iVec2Array[i]));
            iVec2Array4[i] = arrayList.toArray(new IVec2[arrayList.size()]);
        }
        return iVec2Array4;
    }

    public static IVec2[][] getPolygons(IVec2[] iVec2Array, IVec2 iVec2, IVec2 iVec22) {
        IVec2[][] iVec2Array2 = IDelaunay2D.getTriangles(iVec2Array);
        IVec2[] iVec2Array3 = new IVec2[iVec2Array2.length];
        for (int i = 0; i < iVec2Array2.length; ++i) {
            iVec2Array3[i] = IVoronoi2D.circumcenter(iVec2Array2[i]);
        }
        IVec2[][] iVec2Array4 = new IVec2[iVec2Array.length][];
        IVec2[][][] iVec2ArrayArray = new IVec2[iVec2Array.length][][];
        for (int i = 0; i < iVec2Array.length; ++i) {
            int n;
            int n2;
            ArrayList<IVec2[]> arrayList = new ArrayList<IVec2[]>();
            for (int j = 0; j < iVec2Array2.length; ++j) {
                n2 = 0;
                for (int k = 0; k < iVec2Array2[j].length && n2 == 0; ++k) {
                    if (iVec2Array[i] != iVec2Array2[j][k]) continue;
                    n2 = 1;
                }
                if (n2 == 0) continue;
                arrayList.add(iVec2Array2[j]);
            }
            ArrayList<IVec2> arrayList2 = IVoronoi2D.sortTriangleEdgePoint(iVec2Array[i], arrayList);
            n2 = arrayList2.size();
            if (arrayList2.get(0) == arrayList2.get(n2 - 1)) {
                IVec2[] iVec2Array5 = new IVec2[n2 - 1];
                for (n = 0; n < n2 - 1; ++n) {
                    iVec2Array5[n] = IVoronoi2D.circumcenter(iVec2Array[i], arrayList2.get(n), arrayList2.get(n + 1));
                }
                iVec2Array4[i] = IVoronoi2D.pointsInsideBoundary(iVec2Array5, iVec2, iVec22, true);
                continue;
            }
            if (n2 >= 3) {
                IVec2[] iVec2Array6 = new IVec2[n2 - 1 + 2];
                for (n = 0; n < n2 - 1; ++n) {
                    iVec2Array6[n + 1] = IVoronoi2D.circumcenter(iVec2Array[i], arrayList2.get(n), arrayList2.get(n + 1));
                }
                IVec2 iVec23 = iVec2Array[i].mid(arrayList2.get(0)).dif(iVec2Array6[1]);
                if (iVec23.dot(arrayList2.get(0).dif(arrayList2.get(1))) < 0.0) {
                    iVec23.rev();
                }
                iVec2Array6[0] = iVec2Array6[1].cp(iVec23);
                IVec2 iVec24 = iVec2Array[i].mid(arrayList2.get(n2 - 1)).dif(iVec2Array6[n2 - 1]);
                if (iVec24.dot(arrayList2.get(n2 - 1).dif(arrayList2.get(n2 - 2))) < 0.0) {
                    iVec24.rev();
                }
                iVec2Array6[n2] = iVec2Array6[n2 - 1].cp(iVec24);
                iVec2Array4[i] = IVoronoi2D.removeDuplicatedPoint(IVoronoi2D.closeWithBoundary(iVec2Array6, iVec2, iVec22), IConfig.parameterTolerance);
                continue;
            }
            iVec2Array4[i] = null;
        }
        return iVec2Array4;
    }

    public static IVec2[][] getEdges(IVec2[] iVec2Array) {
        IVec2[][] iVec2Array2 = IVoronoi2D.getPolygons(iVec2Array);
        ArrayList<IVec2[]> arrayList = new ArrayList<IVec2[]>();
        for (int i = 0; i < iVec2Array2.length; ++i) {
            for (int j = 0; j < iVec2Array2[i].length; ++j) {
                boolean bl = false;
                for (int k = 0; k < arrayList.size() && !bl; ++k) {
                    if ((((IVec2[])arrayList.get(k))[0] != iVec2Array2[i][j] || ((IVec2[])arrayList.get(k))[1] != iVec2Array2[i][(j + 1) % iVec2Array2[i].length]) && (((IVec2[])arrayList.get(k))[1] != iVec2Array2[i][j] || ((IVec2[])arrayList.get(k))[0] != iVec2Array2[i][(j + 1) % iVec2Array2[i].length])) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(new IVec2[]{iVec2Array2[i][j], iVec2Array2[i][(j + 1) % iVec2Array2[i].length]});
            }
        }
        return (IVec2[][])arrayList.toArray((T[])new IVec2[arrayList.size()][]);
    }

    public static IVec2[] removeDuplicatedPoint(IVec2[] iVec2Array, double d) {
        if (iVec2Array == null) {
            return null;
        }
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
        for (int i = 0; i < iVec2Array.length; ++i) {
            if (i != 0 && (i <= 0 || i >= iVec2Array.length - 1 || ((IVec2)arrayList.get(arrayList.size() - 1)).eq(iVec2Array[i], d)) && (i != iVec2Array.length - 1 || ((IVec2)arrayList.get(arrayList.size() - 1)).eq(iVec2Array[i], d) || ((IVec2)arrayList.get(0)).eq(iVec2Array[i], d))) continue;
            arrayList.add(iVec2Array[i]);
        }
        return arrayList.toArray(new IVec2[arrayList.size()]);
    }

    public static boolean insideTriangle(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
        IVec2 iVec25;
        IVec2 iVec26;
        IVec2 iVec27 = iVec2.dif(iVec22);
        double[] dArray = iVec27.projectTo2Vec(iVec26 = iVec23.dif(iVec22), iVec25 = iVec24.dif(iVec22));
        return dArray[0] >= 0.0 && dArray[0] <= 1.0 && dArray[1] >= 0.0 && dArray[1] <= 1.0;
    }

    public static IVec2 intersectWithBoundary(IVec2 iVec2, IVec2 iVec22, IVec2[] iVec2Array) {
        IVec2 iVec23 = iVec2;
        IVec2 iVec24 = iVec22.dif(iVec2);
        IVec2 iVec25 = null;
        double d = 0.0;
        int n = -1;
        int n2 = iVec2Array.length;
        for (int i = 0; i < n2; ++i) {
            IVec2 iVec26 = iVec2Array[i];
            IVec2 iVec27 = iVec2Array[(i + 1) % n2].dif(iVec2Array[i]);
            IVec2 iVec28 = IVec2.intersect(iVec23, iVec24, iVec26, iVec27);
            if (iVec28 == null || !(iVec28.dif(iVec23).dot(iVec24) >= -IConfig.parameterTolerance) || !(iVec28.dist(iVec23) <= iVec24.len() + IConfig.parameterTolerance) || !(iVec28.dif(iVec26).dot(iVec27) >= -IConfig.parameterTolerance) || !(iVec28.dist(iVec26) <= iVec27.len() + IConfig.parameterTolerance)) continue;
            double d2 = iVec28.dist(iVec23);
            if (iVec25 != null && !(d2 < d)) continue;
            iVec25 = iVec28;
            d = d2;
            n = i;
        }
        if (iVec25 == null) {
            IOut.err("no intersection found");
        }
        return iVec25;
    }

    public static boolean insideBoundary(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        return iVec2.x >= iVec22.x && iVec2.x <= iVec23.x && iVec2.y >= iVec22.y && iVec2.y <= iVec23.y;
    }

    public static IVec2[] pointsInsideBoundary(IVec2[] iVec2Array, IVec2 iVec2, IVec2 iVec22, boolean bl) {
        IVec2[] iVec2Array2 = new IVec2[]{iVec2, iVec2.dup().x(iVec22.x), iVec22, iVec22.dup().x(iVec2.x)};
        int n = iVec2Array.length;
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
        IVec2 iVec23 = null;
        boolean bl2 = false;
        if (bl) {
            bl2 = !IVoronoi2D.insideBoundary(iVec2Array[n - 1], iVec2, iVec22);
        }
        for (int i = 0; i < n; ++i) {
            if (IVoronoi2D.insideBoundary(iVec2Array[i], iVec2, iVec22)) {
                if (!bl2) {
                    arrayList.add(iVec2Array[i]);
                    continue;
                }
                iVec23 = IVoronoi2D.intersectWithBoundary(iVec2Array[i], iVec2Array[(i - 1 + n) % n], iVec2Array2);
                if (!(iVec23 == null || arrayList.size() != 0 && iVec23.eq((IVec2)arrayList.get(arrayList.size() - 1), IConfig.parameterTolerance))) {
                    arrayList.add(iVec23);
                }
                if (iVec23 == null || !iVec23.eq(iVec2Array[i], IConfig.parameterTolerance)) {
                    arrayList.add(iVec2Array[i]);
                }
                bl2 = false;
                continue;
            }
            if (!((!bl || bl2) && (bl || i <= 0 || bl2) || (iVec23 = IVoronoi2D.intersectWithBoundary(iVec2Array[(i - 1 + n) % n], iVec2Array[i], iVec2Array2)) == null || arrayList.size() != 0 && iVec23.eq((IVec2)arrayList.get(arrayList.size() - 1), IConfig.parameterTolerance))) {
                arrayList.add(iVec23);
            }
            bl2 = true;
        }
        return arrayList.toArray(new IVec2[arrayList.size()]);
    }

    public static IVec2[] closeWithBoundary(IVec2[] iVec2Array, IVec2 iVec2, IVec2 iVec22) {
        int n;
        int n2;
        if (iVec2Array == null || iVec2Array.length <= 1) {
            return null;
        }
        IVec2[] iVec2Array2 = new IVec2[]{iVec2, iVec2.dup().x(iVec22.x), iVec22, iVec22.dup().x(iVec2.x)};
        if ((iVec2Array = IVoronoi2D.pointsInsideBoundary(iVec2Array, iVec2, iVec22, false)) == null || iVec2Array.length <= 1) {
            return null;
        }
        IVec2 iVec23 = iVec2Array[0];
        IVec2 iVec24 = iVec2Array[0].dif(iVec2Array[1]);
        IVec2 iVec25 = iVec2Array[iVec2Array.length - 1];
        IVec2 iVec26 = iVec2Array[iVec2Array.length - 1].dif(iVec2Array[iVec2Array.length - 2]);
        IVec2 iVec27 = null;
        IVec2 iVec28 = null;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = -1;
        int n4 = -1;
        int n5 = iVec2Array2.length;
        for (int i = 0; i < n5; ++i) {
            IVec2 iVec29;
            IVec2 iVec210 = iVec2Array2[i];
            IVec2 iVec211 = iVec2Array2[(i + 1) % n5].dif(iVec2Array2[i]);
            IVec2 iVec212 = IVec2.intersect(iVec23, iVec24, iVec210, iVec211);
            if (iVec212 != null && iVec212.dif(iVec2Array[1]).dot(iVec24) >= 0.0 && iVec212.dif(iVec210).dot(iVec211) >= -IConfig.parameterTolerance && iVec212.dist(iVec210) <= iVec211.len() + IConfig.parameterTolerance) {
                double d3 = iVec212.dist(iVec23);
                if (iVec27 == null || d3 < d) {
                    iVec27 = iVec212;
                    d = d3;
                    n3 = i;
                }
            }
            if ((iVec29 = IVec2.intersect(iVec25, iVec26, iVec210, iVec211)) == null || !(iVec29.dif(iVec2Array[iVec2Array.length - 2]).dot(iVec26) >= 0.0) || !(iVec29.dif(iVec210).dot(iVec211) >= -IConfig.parameterTolerance) || !(iVec29.dist(iVec210) <= iVec211.len() + IConfig.parameterTolerance)) continue;
            double d4 = iVec29.dist(iVec25);
            if (iVec28 != null && !(d4 < d2)) continue;
            iVec28 = iVec29;
            d2 = d4;
            n4 = i;
        }
        if (iVec27 == null || iVec28 == null) {
            IOut.err("no intersection found. original points returned.");
            return iVec2Array;
        }
        if (n3 == n4) {
            IVec2[] iVec2Array3 = new IVec2[iVec2Array.length + 2];
            iVec2Array3[0] = iVec27;
            for (int i = 0; i < iVec2Array.length; ++i) {
                iVec2Array3[i + 1] = iVec2Array[i];
            }
            iVec2Array3[iVec2Array.length + 1] = iVec28;
            return iVec2Array3;
        }
        IVec2 iVec213 = new IVec2();
        for (int i = 0; i < iVec2Array.length; ++i) {
            iVec213.add(iVec2Array[i]);
        }
        iVec213.div(iVec2Array.length);
        IVec2 iVec214 = iVec27.dif(iVec213).bisect(iVec28.dif(iVec213)).unit();
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n5; ++i) {
            double d7 = iVec2Array2[i].dif(iVec213).dot(iVec214);
            if (n3 < n4) {
                if (i > n3 && i <= n4) {
                    d5 += d7;
                    continue;
                }
                d6 += d7;
                continue;
            }
            if (i > n4 && i <= n3) {
                d6 += d7;
                continue;
            }
            d5 += d7;
        }
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
        if (d5 >= d6) {
            if (n3 < n4) {
                for (n2 = n3 + 1; n2 <= n4; ++n2) {
                    arrayList.add(iVec2Array2[n2]);
                }
            } else {
                for (n2 = n3 + 1; n2 < n5; ++n2) {
                    arrayList.add(iVec2Array2[n2]);
                }
                for (n2 = 0; n2 <= n4; ++n2) {
                    arrayList.add(iVec2Array2[n2]);
                }
            }
        } else if (n3 > n4) {
            for (n2 = n3; n2 > n4; --n2) {
                arrayList.add(iVec2Array2[n2]);
            }
        } else {
            for (n2 = n3; n2 >= 0; --n2) {
                arrayList.add(iVec2Array2[n2]);
            }
            for (n2 = n5 - 1; n2 > n4; --n2) {
                arrayList.add(iVec2Array2[n2]);
            }
        }
        if (arrayList.size() > 0 && ((IVec2)arrayList.get(arrayList.size() - 1)).eq(iVec27, IConfig.parameterTolerance)) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() > 0 && ((IVec2)arrayList.get(0)).eq(iVec28, IConfig.parameterTolerance)) {
            arrayList.remove(0);
        }
        if (iVec27.eq(iVec2Array[0], IConfig.parameterTolerance)) {
            iVec27 = null;
        }
        if (iVec28.eq(iVec2Array[iVec2Array.length - 1], IConfig.parameterTolerance)) {
            iVec28 = null;
        }
        n2 = 0;
        if (iVec27 != null) {
            ++n2;
        }
        if (iVec28 != null) {
            ++n2;
        }
        IVec2[] iVec2Array4 = new IVec2[iVec2Array.length + n2 + arrayList.size()];
        int n6 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            iVec2Array4[n6] = (IVec2)arrayList.get(n);
            ++n6;
        }
        if (iVec27 != null) {
            iVec2Array4[n6] = iVec27;
            ++n6;
        }
        for (n = 0; n < iVec2Array.length; ++n) {
            iVec2Array4[n6] = iVec2Array[n];
            ++n6;
        }
        if (iVec28 != null) {
            iVec2Array4[n6] = iVec28;
        }
        return iVec2Array4;
    }

    public static ArrayList<IVec2> sortTriangleEdgePoint(IVec2 iVec2, ArrayList<IVec2[]> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        ArrayList<IVec2> arrayList2 = new ArrayList<IVec2>();
        boolean[] blArray = new boolean[arrayList.size()];
        int n = 0;
        IVec2[] iVec2Array = IVoronoi2D.edgePoint(iVec2, arrayList.get(0));
        arrayList2.add(iVec2Array[0]);
        arrayList2.add(iVec2Array[1]);
        blArray[0] = true;
        ++n;
        boolean bl = true;
        while (n < arrayList.size() && bl) {
            bl = false;
            for (int i = 0; i < arrayList.size() && !bl; ++i) {
                if (blArray[i] || (iVec2Array = IVoronoi2D.edgePoint(iVec2, arrayList.get(i))) == null) continue;
                if (iVec2Array[0] == arrayList2.get(0)) {
                    arrayList2.add(0, iVec2Array[1]);
                    bl = true;
                    blArray[i] = true;
                    ++n;
                    continue;
                }
                if (iVec2Array[0] == arrayList2.get(arrayList2.size() - 1)) {
                    arrayList2.add(iVec2Array[1]);
                    bl = true;
                    blArray[i] = true;
                    ++n;
                    continue;
                }
                if (iVec2Array[1] == arrayList2.get(0)) {
                    arrayList2.add(0, iVec2Array[0]);
                    bl = true;
                    blArray[i] = true;
                    ++n;
                    continue;
                }
                if (iVec2Array[1] != arrayList2.get(arrayList2.size() - 1)) continue;
                arrayList2.add(iVec2Array[0]);
                bl = true;
                blArray[i] = true;
                ++n;
            }
        }
        if (n < arrayList.size()) {
            IOut.err("some triangles are separated");
        }
        return arrayList2;
    }

    public static IVec2[] edgePoint(IVec2 iVec2, IVec2[] iVec2Array) {
        if (iVec2Array == null || iVec2Array.length != 3) {
            IOut.err("input is not a triangle");
            return null;
        }
        if (iVec2 == iVec2Array[0]) {
            return new IVec2[]{iVec2Array[1], iVec2Array[2]};
        }
        if (iVec2 == iVec2Array[1]) {
            return new IVec2[]{iVec2Array[2], iVec2Array[0]};
        }
        if (iVec2 == iVec2Array[2]) {
            return new IVec2[]{iVec2Array[0], iVec2Array[1]};
        }
        IOut.err("the vertex is not included in the triangle");
        return null;
    }

    public static IVec2 circumcenter(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        IVec2 iVec24 = iVec2.mid(iVec22);
        IVec2 iVec25 = iVec22.mid(iVec23);
        IVec2 iVec26 = iVec22.dif(iVec2);
        IVec2 iVec27 = iVec23.dif(iVec22);
        iVec26.rot(1.5707963267948966);
        iVec27.rot(1.5707963267948966);
        return IVec2.intersect(iVec24, iVec26, iVec25, iVec27);
    }

    public static IVec2 circumcenter(IVec2[] iVec2Array) {
        if (iVec2Array.length != 3) {
            return null;
        }
        return IVoronoi2D.circumcenter(iVec2Array[0], iVec2Array[1], iVec2Array[2]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadialComparator
    implements IComparator<IVec2> {
        IVec2 center;

        public RadialComparator(IVec2 iVec2) {
            this.center = iVec2;
        }

        @Override
        public int compare(IVec2 iVec2, IVec2 iVec22) {
            double d;
            IVec2 iVec23 = new IVec2(0.0, 1.0);
            double d2 = iVec2.dif(this.center).angle(iVec23);
            if (d2 < (d = iVec22.dif(this.center).angle(iVec23))) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
    }
}

