/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I2DFieldI;
import igeo.IConfig;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.ISurfaceI;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVecI;

public class I2DSurfaceFieldGeo
extends IFieldGeo
implements I2DFieldI {
    public ISurfaceI surface;
    public ISurfaceI fieldSurface;

    public I2DSurfaceFieldGeo(ISurfaceI iSurfaceI, ISurfaceI iSurfaceI2) {
        this.surface = iSurfaceI;
        this.fieldSurface = iSurfaceI2;
        this.linearDecay(0.0);
    }

    public IVec2I get(IVecI iVecI, IVec2I iVec2I) {
        return this.fieldSurface.pt(iVec2I).to2d();
    }

    public IVec2I get(IVecI iVecI, IVecI iVecI2, IVec2I iVec2I) {
        return this.get(iVecI, iVec2I);
    }

    public IVec2I get(IVecI iVecI) {
        return this.get(iVecI, (IVecI)null);
    }

    public IVec2I get(IVecI iVecI, IVecI iVecI2) {
        double d;
        IVec2 iVec2 = this.surface.uv(iVecI.to2d()).get();
        double d2 = this.intensity;
        if (this.decay == IFieldGeo.Decay.Linear) {
            d = this.surface.pt(iVec2).to2d().dist(iVecI.to2d());
            if (d >= this.threshold && (iVec2.x <= 0.0 || iVec2.y <= 0.0 || iVec2.x >= 1.0 || iVec2.y >= 1.0)) {
                return new IVec2();
            }
            if (this.threshold > 0.0) {
                d2 *= (this.threshold - d) / this.threshold;
            }
        } else if (this.decay == IFieldGeo.Decay.Gaussian) {
            d = this.surface.pt(iVec2).to2d().dist(iVecI.to2d());
            if (this.threshold > 0.0) {
                d2 *= Math.exp(-2.0 * d * d / (this.threshold * this.threshold));
            }
        } else if (this.decay == IFieldGeo.Decay.Custom && this.customDecay != null) {
            d = this.surface.pt(iVec2).to2d().dist(iVecI.to2d());
            d2 = this.customDecay.decay(this.intensity, d, this.threshold);
        }
        IVec2I iVec2I = this.get(iVecI, iVecI2, iVec2);
        if (this.bidirectional && iVec2I.get().dot(iVecI2.to2d()) < 0.0) {
            d2 = -d2;
        }
        if (this.constantIntensity) {
            double d3 = iVec2I.len();
            if (d3 < IConfig.tolerance) {
                return iVec2I.zero();
            }
            return iVec2I.len(d2);
        }
        return iVec2I.mul(d2);
    }

    public I2DSurfaceFieldGeo constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    public I2DSurfaceFieldGeo bidirectional(boolean bl) {
        super.bidirectional(bl);
        return this;
    }

    public I2DSurfaceFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    public I2DSurfaceFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    public I2DSurfaceFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    public I2DSurfaceFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    public I2DSurfaceFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    public I2DSurfaceFieldGeo gauss(double d) {
        super.gauss(d);
        return this;
    }

    public I2DSurfaceFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    public I2DSurfaceFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    public void del() {
        if (this.surface != null && this.surface == this.fieldSurface) {
            if (this.surface instanceof IObject) {
                ((IObject)((Object)this.surface)).del();
            }
        } else {
            if (this.surface != null && this.surface instanceof IObject) {
                ((IObject)((Object)this.surface)).del();
            }
            if (this.fieldSurface != null && this.fieldSurface instanceof IObject) {
                ((IObject)((Object)this.fieldSurface)).del();
            }
        }
    }
}

