/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.gui.IGraphicsGL;
import igeo.gui.IImageLoader;
import igeo.gui.ITextureGraphicGL;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ITexture {
    public ITextureGraphicGL glTexture;
    public String filename;
    public BufferedImage image;
    public boolean needUpdate = false;

    public ITexture(String string) {
        this.filename = string;
    }

    public ITexture(String string, int n, int n2) {
        this.image = this.getBufferedImage((BufferedImage)IImageLoader.getImage(string), n, n2);
    }

    public ITexture(Image image) {
        this.image = this.getBufferedImage(image);
    }

    public ITexture(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public ITexture(int n, int n2) {
        this.image = this.getBufferedImage(n, n2);
    }

    public int width() {
        if (this.glTexture == null) {
            return 0;
        }
        if (this.image != null) {
            return this.image.getWidth();
        }
        return this.glTexture.width();
    }

    public int height() {
        if (this.glTexture == null) {
            return 0;
        }
        if (this.image != null) {
            return this.image.getHeight();
        }
        return this.glTexture.height();
    }

    public BufferedImage getBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage getBufferedImage(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage getBufferedImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage getBufferedImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public int id(IGraphicsGL iGraphicsGL) {
        if (this.glTexture != null) {
            if (this.needUpdate) {
                if (this.image != null) {
                    this.glTexture.init(this.image, iGraphicsGL.getGL());
                } else if (this.filename != null) {
                    this.glTexture.init(this.filename, iGraphicsGL.getGL());
                }
                this.needUpdate = false;
            }
            return this.glTexture.id();
        }
        if (this.image != null) {
            this.glTexture = iGraphicsGL.getTextureGraphic(this.image);
            return this.glTexture.id();
        }
        if (this.filename != null) {
            this.glTexture = iGraphicsGL.getTextureGraphic(this.filename);
            return this.glTexture.id();
        }
        return 0;
    }

    public void update() {
        this.needUpdate = true;
    }
}

