/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IColor;
import igeo.IConfig;
import igeo.IEdge;
import igeo.IMeshType;
import igeo.IObject;
import igeo.IOut;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.awt.Color;
import java.util.ArrayList;

public class IFace {
    public IVertex[] vertices;
    public IEdge[] edges;
    public IVec normal;
    public boolean deleted = false;
    public boolean invalid = false;
    public IColor clr;

    public IFace(IEdge[] iEdgeArray) {
        this.init(iEdgeArray);
    }

    public IFace(IEdge iEdge, IEdge iEdge2, IEdge iEdge3) {
        this(new IEdge[]{iEdge, iEdge2, iEdge3});
    }

    public IFace(IEdge iEdge, IEdge iEdge2, IEdge iEdge3, IEdge iEdge4) {
        this(new IEdge[]{iEdge, iEdge2, iEdge3, iEdge4});
    }

    public IFace(IVertex[] iVertexArray) {
        int n = iVertexArray.length;
        this.vertices = iVertexArray;
        this.edges = new IEdge[n];
        for (int i = 0; i < n; ++i) {
            this.edges[i] = new IEdge(iVertexArray[i], iVertexArray[(i + 1) % n]);
            this.vertices[i].addFace(this);
            this.edges[i].addFace(this);
        }
    }

    public IFace(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        this(new IVertex[]{iVertex, iVertex2, iVertex3});
    }

    public IFace(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        this(new IVertex[]{iVertex, iVertex2, iVertex3, iVertex4});
    }

    public IFace(IFace iFace) {
        int n;
        this.vertices = new IVertex[iFace.vertices.length];
        for (n = 0; n < this.vertices.length; ++n) {
            this.vertices[n] = iFace.vertices[n];
        }
        this.edges = new IEdge[iFace.edges.length];
        for (n = 0; n < this.edges.length; ++n) {
            this.edges[n] = iFace.edges[n];
        }
        if (iFace.normal != null) {
            this.normal = iFace.normal.dup();
        }
    }

    public boolean isValid() {
        int n;
        if (this.invalid) {
            return false;
        }
        if (this.vertices == null || this.edges == null) {
            return false;
        }
        for (n = 0; n < this.vertices.length; ++n) {
            if (this.vertices[n] != null) continue;
            return false;
        }
        for (n = 0; n < this.edges.length; ++n) {
            if (this.edges[n] != null) continue;
            return false;
        }
        return true;
    }

    public void init(IEdge[] iEdgeArray) {
        int n;
        int n2 = iEdgeArray.length;
        this.vertices = new IVertex[n2];
        this.edges = new IEdge[n2];
        for (n = 0; n < n2; ++n) {
            this.edges[n] = iEdgeArray[n];
        }
        if (this.edges[1].contains(this.edges[0].vertices[0])) {
            this.vertices[0] = this.edges[0].vertices[1];
        } else if (this.edges[1].contains(this.edges[0].vertices[1])) {
            this.vertices[0] = this.edges[0].vertices[0];
        } else {
            this.invalid = true;
            IOut.err("first&second edges don't match");
            IOut.err("edges[0] = " + this.edges[0].vertices[0].pos + ", " + this.edges[0].vertices[1].pos);
            IOut.err("edges[1] = " + this.edges[1].vertices[0].pos + ", " + this.edges[1].vertices[1].pos);
        }
        for (n = 1; n < n2; ++n) {
            if (this.edges[n - 1].contains(this.vertices[n - 1])) {
                this.vertices[n] = this.edges[n - 1].getOtherVertex(this.vertices[n - 1]);
                continue;
            }
            this.invalid = true;
            IOut.err(n - 1 + "&" + n + " edges don't match");
        }
        if (this.edges[n2 - 1].getOtherVertex(this.vertices[n2 - 1]) != this.vertices[0]) {
            this.invalid = true;
            IOut.err("first&last vertex doesn't match");
        }
        if (this.invalid) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            this.vertices[n].addFace(this);
            this.edges[n].addFace(this);
        }
    }

    public IFace dup() {
        return new IFace(this);
    }

    public IVertex getVertex(int n) {
        return this.vertex(n);
    }

    public IVertex vertex(int n) {
        return this.vertices[n];
    }

    public IEdge getEdge(int n) {
        return this.edge(n);
    }

    public IEdge edge(int n) {
        return this.edges[n];
    }

    public int vertexNum() {
        return this.vertices.length;
    }

    public int edgeNum() {
        return this.edges.length;
    }

    public IEdge getEdge(IVertex iVertex, IVertex iVertex2) {
        for (int i = 0; i < this.edges.length; ++i) {
            if ((this.edges[i].vertices[0] != iVertex || this.edges[i].vertices[1] != iVertex2) && (this.edges[i].vertices[0] != iVertex2 || this.edges[i].vertices[1] != iVertex)) continue;
            return this.edges[i];
        }
        return null;
    }

    public IEdge[] getOtherEdges(IVertex iVertex, IVertex iVertex2, IVertex ... iVertexArray) {
        IVertex[] iVertexArray2 = new IVertex[iVertexArray.length + 2];
        iVertexArray2[0] = iVertex;
        iVertexArray2[1] = iVertex2;
        for (int i = 0; i < iVertexArray.length; ++i) {
            iVertexArray2[i + 1] = iVertexArray[i + 2];
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (int i = 0; i < this.edges.length; ++i) {
            int n;
            boolean bl = false;
            for (n = 0; n < iVertexArray2.length && !bl; ++n) {
                if (this.edges[i].vertices[0] != iVertexArray2[n]) continue;
                bl = true;
            }
            if (!bl) {
                arrayList.add(this.edges[i]);
                continue;
            }
            bl = false;
            for (n = 0; n < iVertexArray2.length && !bl; ++n) {
                if (this.edges[i].vertices[1] != iVertexArray2[n]) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(this.edges[i]);
        }
        return arrayList.toArray(new IEdge[arrayList.size()]);
    }

    public IEdge[] getOtherEdges(IVertex iVertex) {
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i].contains(iVertex)) continue;
            arrayList.add(this.edges[i]);
        }
        return arrayList.toArray(new IEdge[arrayList.size()]);
    }

    public IEdge getOtherEdge(IVertex iVertex) {
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i].contains(iVertex)) continue;
            return this.edges[i];
        }
        return null;
    }

    public IEdge[] getOtherEdges(IEdge iEdge) {
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] == iEdge || this.edges[i].eq(iEdge)) continue;
            arrayList.add(this.edges[i]);
        }
        return arrayList.toArray(new IEdge[arrayList.size()]);
    }

    public IEdge getOtherEdge(IEdge iEdge) {
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] == iEdge) continue;
            return this.edges[i];
        }
        return null;
    }

    public IVertex getOtherVertex(IVertex iVertex, IVertex iVertex2) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] == iVertex || this.vertices[i] == iVertex2) continue;
            return this.vertices[i];
        }
        return null;
    }

    public IVertex getOtherVertex(IEdge iEdge) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] == iEdge.vertices[0] || this.vertices[i] == iEdge.vertices[1]) continue;
            return this.vertices[i];
        }
        return null;
    }

    public IVertex[] getOtherVertices(IVertex iVertex) {
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] == iVertex) continue;
            arrayList.add(this.vertices[i]);
        }
        return arrayList.toArray(new IVertex[arrayList.size()]);
    }

    public IVertex[] getSharedVertices(IFace iFace) {
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        for (int i = 0; i < this.vertices.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < iFace.vertexNum() && !bl; ++j) {
                if (this.vertices[i] == iFace.vertex(j)) continue;
                arrayList.add(this.vertices[i]);
                bl = true;
            }
        }
        return arrayList.toArray(new IVertex[arrayList.size()]);
    }

    public IEdge getSharedEdge(IFace iFace) {
        for (int i = 0; i < this.edges.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < iFace.edgeNum() && !bl; ++j) {
                if (this.edges[i] == iFace.edge(j)) {
                    return this.edges[i];
                }
                if ((this.edges[i].vertex(0) != iFace.edge(j).vertex(0) || this.edges[i].vertex(1) != iFace.edge(j).vertex(1)) && (this.edges[i].vertex(0) != iFace.edge(j).vertex(1) || this.edges[i].vertex(1) != iFace.edge(j).vertex(0))) continue;
                return this.edges[i];
            }
        }
        return null;
    }

    public IVertex[] getAdjacentVertices(IVertex iVertex, IVertex iVertex2) {
        IVertex[] iVertexArray = new IVertex[2];
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] != iVertex) continue;
            if (this.vertices[(i + 1) % this.vertices.length] == iVertex2) {
                iVertexArray[0] = this.vertices[(i - 1 + this.vertices.length) % this.vertices.length];
                iVertexArray[1] = this.vertices[(i + 2) % this.vertices.length];
                return iVertexArray;
            }
            if (this.vertices[(i - 1 + this.vertices.length) % this.vertices.length] != iVertex2) continue;
            iVertexArray[0] = this.vertices[(i + 1) % this.vertices.length];
            iVertexArray[1] = this.vertices[(i - 2 + this.vertices.length) % this.vertices.length];
            return iVertexArray;
        }
        return null;
    }

    public int sharedVertexOrder(IFace iFace) {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < iFace.vertices.length; ++j) {
                if (this.vertices[i] != iFace.vertices[j]) continue;
                if (this.vertices[(i + 1) % this.vertices.length] == iFace.vertices[(j + 1) % iFace.vertices.length] || this.vertices[(i - 1 + this.vertices.length) % this.vertices.length] == iFace.vertices[(j - 1 + iFace.vertices.length) % iFace.vertices.length]) {
                    return 0;
                }
                if (this.vertices[(i + 1) % this.vertices.length] != iFace.vertices[(j - 1 + iFace.vertices.length) % iFace.vertices.length] && this.vertices[(i - 1 + this.vertices.length) % this.vertices.length] != iFace.vertices[(j + 1) % iFace.vertices.length]) continue;
                return 1;
            }
        }
        return -1;
    }

    public boolean loopDir(IEdge iEdge) {
        int n = -1;
        for (int i = 0; i < this.vertices.length && n < 0; ++i) {
            if (!this.vertices[i].eq(iEdge.vertex(0))) continue;
            n = i;
        }
        if (n < 0) {
            IOut.err("edge is not in the face");
            return false;
        }
        if (this.vertices[(n + 1) % this.vertices.length].eq(iEdge.vertex(1))) {
            return true;
        }
        if (this.vertices[(n - 1 + this.vertices.length) % this.vertices.length].eq(iEdge.vertex(1))) {
            return false;
        }
        IOut.err("edge is not in the face");
        return false;
    }

    public boolean sameLoopDir(IEdge iEdge, IEdge iEdge2) {
        boolean bl = this.loopDir(iEdge);
        boolean bl2 = this.loopDir(iEdge2);
        return bl && bl2 || !bl && !bl2;
    }

    public IVec center() {
        IVec iVec = new IVec();
        for (int i = 0; i < this.vertices.length; ++i) {
            iVec.add(this.vertices[i].pos);
        }
        iVec.div(this.vertices.length);
        return iVec;
    }

    public IVec getCenter() {
        return this.center();
    }

    public void del() {
        int n;
        this.deleted = true;
        for (n = 0; n < this.vertices.length; ++n) {
            this.vertices[n].faces.remove(this);
        }
        for (n = 0; n < this.edges.length; ++n) {
            this.edges[n].faces.remove(this);
        }
    }

    public boolean contains(IVertex iVertex) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] != iVertex) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IEdge iEdge) {
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] != iEdge) continue;
            return true;
        }
        return false;
    }

    public boolean onFace(IEdge iEdge) {
        if (this.contains(iEdge)) {
            return true;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            if (!this.vertices[i].eq(iEdge.vertex(0))) continue;
            if (this.vertices[(i + 1) % this.vertices.length].eq(iEdge.vertex(1))) {
                return true;
            }
            if (!this.vertices[(i - 1 + this.vertices.length) % this.vertices.length].eq(iEdge.vertex(1))) continue;
            return true;
        }
        return false;
    }

    public int indexOf(IEdge iEdge) {
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] != iEdge) continue;
            return i;
        }
        return -1;
    }

    public void replaceVertex(IVertex iVertex, IVertex iVertex2) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] != iVertex) continue;
            this.vertices[i] = iVertex2;
            return;
        }
        IOut.err("no such vertex on this face");
    }

    public void replaceEdge(IEdge iEdge, IEdge iEdge2) {
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] != iEdge) continue;
            this.edges[i] = iEdge2;
            return;
        }
        IOut.err("no such edge on this face");
    }

    public double area() {
        int n;
        if (this.vertices.length == 3) {
            IVec iVec = this.vertices[1].pos.get().diff(this.vertices[0].pos);
            IVec iVec2 = this.vertices[2].pos.get().diff(this.vertices[0].pos);
            return iVec.cross(iVec2).len() / 2.0;
        }
        ArrayList<Object> arrayList = this.triangulate(true, new IMeshType());
        double d = 0.0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!(arrayList.get(n) instanceof IFace)) continue;
            d += ((IFace)arrayList.get(n)).area();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) instanceof IEdge) {
                ((IEdge)arrayList.get(n)).del();
                continue;
            }
            if (!(arrayList.get(n) instanceof IFace)) continue;
            ((IFace)arrayList.get(n)).del();
        }
        return d;
    }

    public IVec nml() {
        if (this.normal == null) {
            this.calcNormal();
        }
        return this.normal;
    }

    public IVec normal() {
        return this.nml();
    }

    public IVec getAverageNormal() {
        int n = this.vertices.length;
        IVec iVec = new IVec();
        for (int i = 0; i < n; ++i) {
            IVec iVec2 = this.vertices[(i + 1) % n].pos.get().diff(this.vertices[i].pos);
            IVec iVec3 = this.vertices[(i + 2) % n].pos.get().diff(this.vertices[(i + 1) % n].pos);
            iVec.add(iVec2.cross(iVec3));
        }
        iVec.unit();
        return iVec;
    }

    public void calcNormal() {
        this.setNormal(this.getAverageNormal());
    }

    public void setNormal(IVec iVec) {
        this.normal = iVec;
    }

    public void flipNormal() {
        this.flipNml();
    }

    public void flipNml() {
        int n;
        if (this.normal != null) {
            this.normal.neg();
        }
        IVertex[] iVertexArray = new IVertex[this.vertices.length];
        IEdge[] iEdgeArray = new IEdge[this.edges.length];
        for (n = 0; n < this.vertices.length; ++n) {
            iVertexArray[this.vertices.length - n - 1] = this.vertices[n];
        }
        for (n = 0; n < this.edges.length; ++n) {
            iEdgeArray[this.edges.length - n - 1] = this.edges[n];
        }
        this.vertices = iVertexArray;
        this.edges = iEdgeArray;
    }

    public ArrayList<Object> triangulate(boolean bl, IMeshType iMeshType) {
        int n;
        Object object;
        if (this.vertices.length == 3) {
            return null;
        }
        int n2 = 0;
        int n3 = this.vertices.length - 1;
        int n4 = this.vertices.length - 2;
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList2 = new ArrayList<IFace>();
        while (n2 + 1 <= n3 - 1) {
            object = null;
            IEdge iEdge = null;
            IEdge iEdge2 = null;
            IEdge iEdge3 = null;
            IEdge iEdge4 = null;
            IEdge[] iEdgeArray = new IEdge[3];
            IEdge[] iEdgeArray2 = new IEdge[3];
            iEdge2 = this.edges[n2];
            iEdge3 = this.edges[n3 - 1];
            object = n2 == 0 ? this.edges[n3] : (IEdge)arrayList.get(arrayList.size() - 1);
            iEdge = n2 + 1 == n3 - 1 ? null : (n2 + 1 + 1 == n3 - 1 ? this.edges[n2 + 1] : iMeshType.createEdge(this.vertices[n2 + 1], this.vertices[n3 - 1]));
            if (iEdge != null) {
                if (bl) {
                    iEdge4 = iMeshType.createEdge(this.vertices[n2], this.vertices[n3 - 1]);
                    iEdgeArray[0] = object;
                    iEdgeArray[1] = iEdge4;
                    iEdgeArray[2] = iEdge3;
                    iEdgeArray2[0] = iEdge4;
                    iEdgeArray2[1] = iEdge2;
                    iEdgeArray2[2] = iEdge;
                } else {
                    iEdge4 = iMeshType.createEdge(this.vertices[n2 + 1], this.vertices[n3]);
                    iEdgeArray[0] = object;
                    iEdgeArray[1] = iEdge2;
                    iEdgeArray[2] = iEdge4;
                    iEdgeArray2[0] = iEdge4;
                    iEdgeArray2[1] = iEdge;
                    iEdgeArray2[2] = iEdge3;
                }
            } else {
                iEdgeArray[0] = object;
                iEdgeArray[1] = iEdge2;
                iEdgeArray[2] = iEdge3;
            }
            IFace iFace = iMeshType.createFace(iEdgeArray);
            IFace iFace2 = null;
            if (iEdge != null) {
                iFace2 = iMeshType.createFace(iEdgeArray2);
            }
            if (iEdge4 != null) {
                arrayList.add(iEdge4);
            }
            if (iEdge != null && n2 + 1 + 1 != n3 - 1) {
                arrayList.add(iEdge);
            }
            arrayList2.add(iFace);
            if (iFace2 != null) {
                arrayList2.add(iFace2);
            }
            ++n2;
            --n3;
        }
        object = new ArrayList<Object>();
        for (n = 0; n < arrayList.size(); ++n) {
            ((ArrayList)object).add(arrayList.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            ((ArrayList)object).add(arrayList2.get(n));
        }
        return object;
    }

    public ArrayList<Object> triangulateAtCenter(IMeshType iMeshType) {
        int n;
        if (this.vertices.length == 3) {
            return null;
        }
        IVec iVec = this.getCenter();
        IVertex iVertex = iMeshType.createVertex(iVec);
        int n2 = this.edges.length;
        IEdge[] iEdgeArray = new IEdge[n2];
        for (int i = 0; i < n2; ++i) {
            IVertex iVertex2 = this.edges[i].getSharedVertex(this.edges[(i + 1) % n2]);
            iEdgeArray[i] = iMeshType.createEdge(iVertex2, iVertex);
        }
        IFace[] iFaceArray = new IFace[n2];
        for (int i = 0; i < n2; ++i) {
            IEdge[] iEdgeArray2 = new IEdge[]{this.edges[i], iEdgeArray[i], iEdgeArray[(i - 1 + n2) % n2]};
            iFaceArray[i] = iMeshType.createFace(iEdgeArray2);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(iVertex);
        for (n = 0; n < iEdgeArray.length; ++n) {
            arrayList.add(iEdgeArray[n]);
        }
        for (n = 0; n < iFaceArray.length; ++n) {
            arrayList.add(iFaceArray[n]);
        }
        return arrayList;
    }

    public static boolean eq(double d, double d2) {
        return Math.abs(d - d2) < IConfig.tolerance;
    }

    public boolean eq(IFace iFace) {
        if (iFace.edges.length != this.edges.length) {
            return false;
        }
        if (this.edges.length == 3) {
            if (iFace.edges[0].eq(this.edges[0])) {
                if (iFace.edges[1].eq(this.edges[1])) {
                    return iFace.edges[2].eq(this.edges[2]);
                }
                if (iFace.edges[1].eq(this.edges[2])) {
                    return iFace.edges[2].eq(this.edges[1]);
                }
                return false;
            }
            if (iFace.edges[0].eq(this.edges[1])) {
                if (iFace.edges[1].eq(this.edges[0])) {
                    return iFace.edges[2].eq(this.edges[2]);
                }
                if (iFace.edges[1].eq(this.edges[2])) {
                    return iFace.edges[2].eq(this.edges[0]);
                }
                return false;
            }
            if (iFace.edges[0].eq(this.edges[2])) {
                if (iFace.edges[1].eq(this.edges[0])) {
                    return iFace.edges[2].eq(this.edges[1]);
                }
                if (iFace.edges[1].eq(this.edges[1])) {
                    return iFace.edges[2].eq(this.edges[0]);
                }
                return false;
            }
            return false;
        }
        if (this.edges.length == 4) {
            IVertex[] iVertexArray = this.vertices;
            IVertex[] iVertexArray2 = iFace.vertices;
            double[] dArray = new double[6];
            double[] dArray2 = new double[6];
            for (int i = 0; i < 4; ++i) {
                dArray[i] = iVertexArray[i].pos.dist(iVertexArray[(i + 1) % 4].pos);
                dArray2[i] = iVertexArray2[i].pos.dist(iVertexArray2[(i + 1) % 4].pos);
            }
            dArray[4] = iVertexArray[0].pos.dist(iVertexArray[2].pos);
            dArray2[4] = iVertexArray2[0].pos.dist(iVertexArray2[2].pos);
            dArray[5] = iVertexArray[1].pos.dist(iVertexArray[3].pos);
            dArray2[5] = iVertexArray2[1].pos.dist(iVertexArray2[3].pos);
            if (IFace.eq(dArray[0], dArray2[0])) {
                if (IFace.eq(dArray[1], dArray2[1]) && IFace.eq(dArray[2], dArray2[2]) && IFace.eq(dArray[3], dArray2[3]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
                if (IFace.eq(dArray[1], dArray2[3]) && IFace.eq(dArray[2], dArray2[2]) && IFace.eq(dArray[3], dArray2[1]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
            }
            if (IFace.eq(dArray[0], dArray2[1])) {
                if (IFace.eq(dArray[1], dArray2[2]) && IFace.eq(dArray[2], dArray2[3]) && IFace.eq(dArray[3], dArray2[0]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
                if (IFace.eq(dArray[1], dArray2[0]) && IFace.eq(dArray[2], dArray2[3]) && IFace.eq(dArray[3], dArray2[2]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
            }
            if (IFace.eq(dArray[0], dArray2[2])) {
                if (IFace.eq(dArray[1], dArray2[3]) && IFace.eq(dArray[2], dArray2[0]) && IFace.eq(dArray[3], dArray2[1]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
                if (IFace.eq(dArray[1], dArray2[1]) && IFace.eq(dArray[2], dArray2[0]) && IFace.eq(dArray[3], dArray2[3]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
            }
            if (IFace.eq(dArray[0], dArray2[3])) {
                if (IFace.eq(dArray[1], dArray2[0]) && IFace.eq(dArray[2], dArray2[1]) && IFace.eq(dArray[3], dArray2[2]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
                if (IFace.eq(dArray[1], dArray2[2]) && IFace.eq(dArray[2], dArray2[1]) && IFace.eq(dArray[3], dArray2[0]) && (IFace.eq(dArray[4], dArray2[4]) && IFace.eq(dArray[5], dArray2[5]) || IFace.eq(dArray[4], dArray2[5]) && IFace.eq(dArray[5], dArray2[4]))) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public IVec[] getBoundary() {
        IVec iVec = new IVec(this.vertices[0]);
        IVec iVec2 = new IVec(this.vertices[0]);
        for (int i = 1; i < this.vertices.length; ++i) {
            IVec iVec3 = this.vertices[i].pos.get();
            if (iVec3.x < iVec.x) {
                iVec.x = iVec3.x;
            } else if (iVec3.x > iVec2.x) {
                iVec2.x = iVec3.x;
            }
            if (iVec3.y < iVec.y) {
                iVec.y = iVec3.y;
            } else if (iVec3.y > iVec2.y) {
                iVec2.y = iVec3.y;
            }
            if (iVec3.z < iVec.z) {
                iVec.z = iVec3.z;
                continue;
            }
            if (!(iVec3.z > iVec2.z)) continue;
            iVec2.z = iVec3.z;
        }
        IVec[] iVecArray = new IVec[]{iVec, iVec2};
        return iVecArray;
    }

    public double dist(IVecI iVecI) {
        if (this.vertices.length == 3) {
            // empty if block
        }
        return 0.0;
    }

    public IColor clr() {
        return this.clr;
    }

    public IFace clr(IColor iColor) {
        this.clr = iColor;
        return this;
    }

    public IFace clr(IColor iColor, int n) {
        return this.clr(new IColor(iColor, n));
    }

    public IFace clr(IColor iColor, float f) {
        return this.clr(new IColor(iColor, f));
    }

    public IFace clr(IColor iColor, double d) {
        return this.clr(new IColor(iColor, d));
    }

    public IFace clr(IObject iObject) {
        this.clr(iObject.clr());
        return this;
    }

    public IFace clr(IFace iFace) {
        this.clr(iFace.clr());
        return this;
    }

    public IFace clr(Color color) {
        return this.clr(new IColor(color));
    }

    public IFace clr(Color color, int n) {
        return this.clr(new IColor(color), n);
    }

    public IFace clr(Color color, float f) {
        return this.clr(new IColor(color), f);
    }

    public IFace clr(Color color, double d) {
        return this.clr(new IColor(color), d);
    }

    public IColor getColor() {
        return this.clr();
    }

    public IFace clr(int n) {
        return this.clr(new IColor(n));
    }

    public IFace clr(double d) {
        return this.clr(new IColor(d));
    }

    public IFace clr(float f) {
        return this.clr(new IColor(f));
    }

    public IFace clr(int n, int n2) {
        return this.clr(new IColor(n, n2));
    }

    public IFace clr(double d, double d2) {
        return this.clr(new IColor(d, d2));
    }

    public IFace clr(float f, float f2) {
        return this.clr(new IColor(f, f2));
    }

    public IFace clr(int n, int n2, int n3) {
        return this.clr(new IColor(n, n2, n3));
    }

    public IFace clr(double d, double d2, double d3) {
        return this.clr(new IColor(d, d2, d3));
    }

    public IFace clr(float f, float f2, float f3) {
        return this.clr(new IColor(f, f2, f3));
    }

    public IFace clr(int n, int n2, int n3, int n4) {
        return this.clr(new IColor(n, n2, n3, n4));
    }

    public IFace clr(double d, double d2, double d3, double d4) {
        return this.clr(new IColor(d, d2, d3, d4));
    }

    public IFace clr(float f, float f2, float f3, float f4) {
        return this.clr(new IColor(f, f2, f3, f4));
    }

    public IFace hsb(double d, double d2, double d3, double d4) {
        return this.clr(IColor.hsb(d, d2, d3, d4));
    }

    public IFace hsb(float f, float f2, float f3, float f4) {
        return this.clr(IColor.hsb(f, f2, f3, f4));
    }

    public IFace hsb(double d, double d2, double d3) {
        return this.clr(IColor.hsb(d, d2, d3));
    }

    public IFace hsb(float f, float f2, float f3) {
        return this.clr(IColor.hsb(f, f2, f3));
    }
}

