/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IFace;
import igeo.IMatrix4;
import igeo.IMesh;
import igeo.IOut;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IDelaunay {
    public static double maxDistToCheck = -1.0;

    public static IVec[][] getTetrahedron(IVec[] iVecArray) {
        if (iVecArray.length <= 4) {
            return new IVec[][]{iVecArray};
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray.length - 3; ++i) {
            IOut.debug(40, i + 1 + "/" + (iVecArray.length - 3));
            for (int j = i + 1; j < iVecArray.length - 2; ++j) {
                if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[j]) <= maxDistToCheck))) continue;
                for (int k = j + 1; k < iVecArray.length - 1; ++k) {
                    if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[k]) <= maxDistToCheck))) continue;
                    for (int i2 = k + 1; i2 < iVecArray.length; ++i2) {
                        if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[i2]) <= maxDistToCheck))) continue;
                        boolean bl = false;
                        for (int i3 = 0; i3 < iVecArray.length && !bl; ++i3) {
                            if (i3 == i || i3 == j || i3 == k || i3 == i2 || !(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[i3]) <= maxDistToCheck)) || !IDelaunay.isInsideCircumsphere(iVecArray[i3], iVecArray[i], iVecArray[j], iVecArray[k], iVecArray[i2])) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        arrayList.add(new IVec[]{iVecArray[i], iVecArray[j], iVecArray[k], iVecArray[i2]});
                    }
                }
            }
        }
        return (IVec[][])arrayList.toArray((T[])new IVec[arrayList.size()][]);
    }

    public static IVecI[][] getTetrahedron(IVecI[] iVecIArray) {
        if (iVecIArray.length <= 4) {
            return new IVecI[][]{iVecIArray};
        }
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iVecIArray.length - 3; ++i) {
            IOut.debug(40, i + 1 + "/" + (iVecIArray.length - 3));
            for (int j = i + 1; j < iVecIArray.length - 2; ++j) {
                if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecIArray[i].get().dist(iVecIArray[j]) <= maxDistToCheck))) continue;
                for (int k = j + 1; k < iVecIArray.length - 1; ++k) {
                    if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecIArray[i].get().dist(iVecIArray[k]) <= maxDistToCheck))) continue;
                    for (int i2 = k + 1; i2 < iVecIArray.length; ++i2) {
                        if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecIArray[i].get().dist(iVecIArray[i2]) <= maxDistToCheck))) continue;
                        boolean bl = false;
                        for (int i3 = 0; i3 < iVecIArray.length && !bl; ++i3) {
                            if (i3 == i || i3 == j || i3 == k || i3 == i2 || !(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecIArray[i].get().dist(iVecIArray[i3]) <= maxDistToCheck)) || !IDelaunay.isInsideCircumsphere(iVecIArray[i3].get(), iVecIArray[i].get(), iVecIArray[j].get(), iVecIArray[k].get(), iVecIArray[i2].get())) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        arrayList.add(new IVecI[]{iVecIArray[i], iVecIArray[j], iVecIArray[k], iVecIArray[i2]});
                    }
                }
            }
        }
        return (IVecI[][])arrayList.toArray((T[])new IVecI[arrayList.size()][]);
    }

    public static IVec circumsphereCenter(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        double d = IMatrix4.determinant(iVec.x, iVec.y, iVec.z, 1.0, iVec2.x, iVec2.y, iVec2.z, 1.0, iVec3.x, iVec3.y, iVec3.z, 1.0, iVec4.x, iVec4.y, iVec4.z, 1.0);
        if (d == 0.0) {
            IOut.err("4 points are on a plane");
            return null;
        }
        double d2 = iVec.len2();
        double d3 = iVec2.len2();
        double d4 = iVec3.len2();
        double d5 = iVec4.len2();
        double d6 = IMatrix4.determinant(d2, iVec.y, iVec.z, 1.0, d3, iVec2.y, iVec2.z, 1.0, d4, iVec3.y, iVec3.z, 1.0, d5, iVec4.y, iVec4.z, 1.0);
        double d7 = -IMatrix4.determinant(d2, iVec.x, iVec.z, 1.0, d3, iVec2.x, iVec2.z, 1.0, d4, iVec3.x, iVec3.z, 1.0, d5, iVec4.x, iVec4.z, 1.0);
        double d8 = IMatrix4.determinant(d2, iVec.x, iVec.y, 1.0, d3, iVec2.x, iVec2.y, 1.0, d4, iVec3.x, iVec3.y, 1.0, d5, iVec4.x, iVec4.y, 1.0);
        return new IVec(d6 / (d *= 2.0), d7 / d, d8 / d);
    }

    public static boolean isInsideCircumsphere(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5) {
        IVec iVec6 = IDelaunay.circumsphereCenter(iVec2, iVec3, iVec4, iVec5);
        if (iVec6 == null) {
            return true;
        }
        return iVec6.dist(iVec) < iVec6.dist(iVec2);
    }

    public static IVec[] getTriangleFace(IVec[] iVecArray, int n) {
        IVec[] iVecArray2 = new IVec[3];
        int n2 = 0;
        for (int i = 0; i < iVecArray.length; ++i) {
            if (i == n) continue;
            iVecArray2[n2++] = iVecArray[i];
        }
        if (IVec.nml(iVecArray2[0], iVecArray2[1], iVecArray2[2]).dot(iVecArray[n].dif(iVecArray2[0])) <= 0.0) {
            return iVecArray2;
        }
        IVec iVec = iVecArray2[1];
        iVecArray2[1] = iVecArray2[2];
        iVecArray2[2] = iVec;
        return iVecArray2;
    }

    public static IVec[][] getSurfaceTriangles(IVec[] iVecArray) {
        IVec[][] iVecArray2 = IDelaunay.getTetrahedron(iVecArray);
        if (iVecArray2.length == 1) {
            if (iVecArray2[0].length < 3) {
                return null;
            }
            if (iVecArray2[0].length == 3) {
                return iVecArray2;
            }
        }
        boolean[] blArray = new boolean[iVecArray2.length * 4];
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (int j = 0; j < iVecArray2[i].length; ++j) {
                if (blArray[i * 4 + j]) continue;
                IVecI[] iVecIArray = IDelaunay.getTriangleFace(iVecArray2[i], j);
                for (int k = i + 1; k < iVecArray2.length && !blArray[i * 4 + j]; ++k) {
                    for (int i2 = 0; i2 < iVecArray2[k].length && !blArray[i * 4 + j]; ++i2) {
                        IVecI[] iVecIArray2 = IDelaunay.getTriangleFace(iVecArray2[k], i2);
                        if (!IDelaunay.isTriangleSame(iVecIArray, iVecIArray2)) continue;
                        blArray[k * 4 + i2] = true;
                        blArray[i * 4 + j] = true;
                    }
                }
                if (blArray[i * 4 + j]) continue;
                arrayList.add(iVecIArray);
            }
        }
        return (IVec[][])arrayList.toArray((T[])new IVec[arrayList.size()][]);
    }

    public static IVecI[][] getSurfaceTriangles(IVecI[] iVecIArray) {
        IVecI[][] iVecIArray2 = IDelaunay.getTetrahedron(iVecIArray);
        if (iVecIArray2.length == 1) {
            if (iVecIArray2[0].length < 3) {
                return null;
            }
            if (iVecIArray2[0].length == 3) {
                return iVecIArray2;
            }
        }
        boolean[] blArray = new boolean[iVecIArray2.length * 4];
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iVecIArray2.length; ++i) {
            for (int j = 0; j < iVecIArray2[i].length; ++j) {
                int n;
                if (blArray[i * 4 + j]) continue;
                IVecI[] iVecIArray3 = new IVecI[3];
                int n2 = 0;
                for (n = 0; n < iVecIArray2[i].length; ++n) {
                    if (j == n) continue;
                    iVecIArray3[n2++] = iVecIArray2[i][n];
                }
                for (n = i + 1; n < iVecIArray2.length && !blArray[i * 4 + j]; ++n) {
                    for (n2 = 0; n2 < iVecIArray2[n].length && !blArray[i * 4 + j]; ++n2) {
                        IVecI[] iVecIArray4 = new IVecI[3];
                        int n3 = 0;
                        for (int k = 0; k < iVecIArray2[n].length; ++k) {
                            if (n2 == k) continue;
                            iVecIArray4[n3++] = iVecIArray2[n][k];
                        }
                        if (!IDelaunay.isTriangleSame(iVecIArray3, iVecIArray4)) continue;
                        blArray[n * 4 + n2] = true;
                        blArray[i * 4 + j] = true;
                    }
                }
                if (blArray[i * 4 + j]) continue;
                arrayList.add(iVecIArray3);
            }
        }
        return (IVecI[][])arrayList.toArray((T[])new IVecI[arrayList.size()][]);
    }

    public static IVec[][] getSurfaceEdges(IVec[] iVecArray) {
        IVec[][] iVecArray2 = IDelaunay.getSurfaceTriangles(iVecArray);
        if (iVecArray2.length == 1) {
            if (iVecArray2[0].length < 2) {
                return null;
            }
            if (iVecArray2[0].length == 2) {
                return iVecArray2;
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (int j = 0; j < iVecArray2[i].length; ++j) {
                boolean bl = false;
                for (int k = 0; k < arrayList.size() && !bl; ++k) {
                    if (!IDelaunay.isEdgeSame((IVecI[])arrayList.get(k), iVecArray2[i][j], iVecArray2[i][(j + 1) % iVecArray2[i].length])) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(new IVec[]{iVecArray2[i][j], iVecArray2[i][(j + 1) % iVecArray2[i].length]});
            }
        }
        return (IVec[][])arrayList.toArray((T[])new IVec[arrayList.size()][]);
    }

    public static IVecI[][] getSurfaceEdges(IVecI[] iVecIArray) {
        IVecI[][] iVecIArray2 = IDelaunay.getSurfaceTriangles(iVecIArray);
        if (iVecIArray2.length == 1) {
            if (iVecIArray2[0].length < 2) {
                return null;
            }
            if (iVecIArray2[0].length == 2) {
                return iVecIArray2;
            }
        }
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iVecIArray2.length; ++i) {
            for (int j = 0; j < iVecIArray2[i].length; ++j) {
                boolean bl = false;
                for (int k = 0; k < arrayList.size() && !bl; ++k) {
                    if (!IDelaunay.isEdgeSame((IVecI[])arrayList.get(k), iVecIArray2[i][j], iVecIArray2[i][(j + 1) % iVecIArray2[i].length])) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(new IVecI[]{iVecIArray2[i][j], iVecIArray2[i][(j + 1) % iVecIArray2[i].length]});
            }
        }
        return (IVecI[][])arrayList.toArray((T[])new IVecI[arrayList.size()][]);
    }

    public static IMesh getSurfaceMesh(IVec[] iVecArray) {
        IVec[][] iVecArray2 = IDelaunay.getSurfaceTriangles(iVecArray);
        if (iVecArray2 == null) {
            return null;
        }
        IVertex[] iVertexArray = new IVertex[iVecArray.length];
        List<IVec> list = Arrays.asList(iVecArray);
        IFace[] iFaceArray = new IFace[iVecArray2.length];
        for (int i = 0; i < iVecArray2.length; ++i) {
            int n = list.indexOf(iVecArray2[i][0]);
            int n2 = list.indexOf(iVecArray2[i][1]);
            int n3 = list.indexOf(iVecArray2[i][2]);
            if (iVertexArray[n] == null) {
                iVertexArray[n] = new IVertex(iVecArray[n]);
            }
            if (iVertexArray[n2] == null) {
                iVertexArray[n2] = new IVertex(iVecArray[n2]);
            }
            if (iVertexArray[n3] == null) {
                iVertexArray[n3] = new IVertex(iVecArray[n3]);
            }
            iFaceArray[i] = new IFace(iVertexArray[n], iVertexArray[n2], iVertexArray[n3]);
        }
        return new IMesh(iFaceArray);
    }

    public static IMesh getSurfaceMesh(IVecI[] iVecIArray) {
        IVecI[][] iVecIArray2 = IDelaunay.getSurfaceTriangles(iVecIArray);
        if (iVecIArray2 == null) {
            return null;
        }
        IVertex[] iVertexArray = new IVertex[iVecIArray.length];
        List<IVecI> list = Arrays.asList(iVecIArray);
        IFace[] iFaceArray = new IFace[iVecIArray2.length];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            int n = list.indexOf(iVecIArray2[i][0]);
            int n2 = list.indexOf(iVecIArray2[i][1]);
            int n3 = list.indexOf(iVecIArray2[i][2]);
            if (iVertexArray[n] == null) {
                iVertexArray[n] = new IVertex(iVecIArray[n]);
            }
            if (iVertexArray[n2] == null) {
                iVertexArray[n2] = new IVertex(iVecIArray[n2]);
            }
            if (iVertexArray[n3] == null) {
                iVertexArray[n3] = new IVertex(iVecIArray[n3]);
            }
            iFaceArray[i] = new IFace(iVertexArray[n], iVertexArray[n2], iVertexArray[n3]);
        }
        return new IMesh(iFaceArray);
    }

    public static IVec[][] getEdges(IVec[] iVecArray) {
        IVec[][] iVecArray2 = IDelaunay.getTetrahedron(iVecArray);
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (int j = 0; j < iVecArray2[i].length; ++j) {
                boolean bl = false;
                for (int k = 0; k < arrayList.size() && !bl; ++k) {
                    if ((((IVec[])arrayList.get(k))[0] != iVecArray2[i][j] || ((IVec[])arrayList.get(k))[1] != iVecArray2[i][(j + 1) % iVecArray2[i].length]) && (((IVec[])arrayList.get(k))[1] != iVecArray2[i][j] || ((IVec[])arrayList.get(k))[0] != iVecArray2[i][(j + 1) % iVecArray2[i].length])) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(new IVec[]{iVecArray2[i][j], iVecArray2[i][(j + 1) % iVecArray2[i].length]});
            }
        }
        return (IVec[][])arrayList.toArray((T[])new IVec[arrayList.size()][]);
    }

    public static IVecI[][] getEdges(IVecI[] iVecIArray) {
        IVecI[][] iVecIArray2 = IDelaunay.getTetrahedron(iVecIArray);
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iVecIArray2.length; ++i) {
            for (int j = 0; j < iVecIArray2[i].length; ++j) {
                boolean bl = false;
                for (int k = 0; k < arrayList.size() && !bl; ++k) {
                    if ((((IVecI[])arrayList.get(k))[0] != iVecIArray2[i][j] || ((IVecI[])arrayList.get(k))[1] != iVecIArray2[i][(j + 1) % iVecIArray2[i].length]) && (((IVecI[])arrayList.get(k))[1] != iVecIArray2[i][j] || ((IVecI[])arrayList.get(k))[0] != iVecIArray2[i][(j + 1) % iVecIArray2[i].length])) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(new IVecI[]{iVecIArray2[i][j], iVecIArray2[i][(j + 1) % iVecIArray2[i].length]});
            }
        }
        return (IVecI[][])arrayList.toArray((T[])new IVecI[arrayList.size()][]);
    }

    public static boolean isTriangleSame(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        if (iVecIArray[0] == iVecIArray2[0]) {
            if (iVecIArray[1] == iVecIArray2[1]) {
                return iVecIArray[2] == iVecIArray2[2];
            }
            if (iVecIArray[1] == iVecIArray2[2]) {
                return iVecIArray[2] == iVecIArray2[1];
            }
            return false;
        }
        if (iVecIArray[0] == iVecIArray2[1]) {
            if (iVecIArray[1] == iVecIArray2[2]) {
                return iVecIArray[2] == iVecIArray2[0];
            }
            if (iVecIArray[1] == iVecIArray2[0]) {
                return iVecIArray[2] == iVecIArray2[2];
            }
            return false;
        }
        if (iVecIArray[0] == iVecIArray2[2]) {
            if (iVecIArray[1] == iVecIArray2[0]) {
                return iVecIArray[2] == iVecIArray2[1];
            }
            if (iVecIArray[1] == iVecIArray2[1]) {
                return iVecIArray[2] == iVecIArray2[0];
            }
            return false;
        }
        return false;
    }

    public static boolean isEdgeSame(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        if (iVecIArray[0] == iVecIArray2[0]) {
            return iVecIArray[1] == iVecIArray2[1];
        }
        if (iVecIArray[0] == iVecIArray2[1]) {
            return iVecIArray[1] == iVecIArray2[0];
        }
        return false;
    }

    public static boolean isEdgeSame(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2) {
        if (iVecIArray[0] == iVecI) {
            return iVecIArray[1] == iVecI2;
        }
        if (iVecIArray[0] == iVecI2) {
            return iVecIArray[1] == iVecI;
        }
        return false;
    }

    public static boolean isEdgeSame(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        if (iVecI == iVecI3) {
            return iVecI2 == iVecI4;
        }
        if (iVecI == iVecI4) {
            return iVecI2 == iVecI3;
        }
        return false;
    }
}

