/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DField;
import igeo.IArithmeticVal;
import igeo.IDecay;
import igeo.ILinkedDataAgent;
import igeo.IMeshFieldGeo;
import igeo.IMeshI;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVectorObject;

public class ILinkedNodeMeshField
extends I3DField {
    public ILinkedNodeMeshField(IMeshI iMeshI) {
        super(new ILinkedNodeMeshFieldGeo(iMeshI));
    }

    public IVecI getForce(int n) {
        return ((ILinkedNodeMeshFieldGeo)this.field).getForce(n);
    }

    public ILinkedNodeMeshField setForce(int n, IVecI iVecI) {
        ((ILinkedNodeMeshFieldGeo)this.field).setForce(n, iVecI);
        return this;
    }

    public ILinkedNodeMeshField addForce(int n, IVecI iVecI) {
        ((ILinkedNodeMeshFieldGeo)this.field).addForce(n, iVecI);
        return this;
    }

    public ILinkedNodeMeshField showVector() {
        ((ILinkedNodeMeshFieldGeo)this.field).showVector();
        return this;
    }

    public ILinkedNodeMeshField linkFriction(double d) {
        ((ILinkedNodeMeshFieldGeo)this.field).linkFriction(d);
        return this;
    }

    public ILinkedNodeMeshField linkFriction(int n, double d) {
        ((ILinkedNodeMeshFieldGeo)this.field).linkFriction(n, d);
        return this;
    }

    public ILinkedNodeMeshField noDecay() {
        super.noDecay();
        return this;
    }

    public ILinkedNodeMeshField linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    public ILinkedNodeMeshField linear(double d) {
        super.linear(d);
        return this;
    }

    public ILinkedNodeMeshField gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    public ILinkedNodeMeshField gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    public ILinkedNodeMeshField gauss(double d) {
        super.gauss(d);
        return this;
    }

    public ILinkedNodeMeshField decay(IDecay iDecay, double d) {
        super.decay(iDecay, d);
        return this;
    }

    public ILinkedNodeMeshField constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    public ILinkedNodeMeshField bidirectional(boolean bl) {
        super.bidirectional(bl);
        return this;
    }

    public ILinkedNodeMeshField threshold(double d) {
        super.threshold(d);
        return this;
    }

    public ILinkedNodeMeshField intensity(double d) {
        super.intensity(d);
        return this;
    }

    public static class ILinkedNodeMeshFieldGeo
    extends IMeshFieldGeo {
        public ILinkedDataAgent<IVecI>[] linkedAgents;
        public IVectorObject[] vectorObjects;

        public ILinkedNodeMeshFieldGeo(IMeshI iMeshI) {
            super(iMeshI);
            this.initField();
        }

        public void initField() {
            ILinkedDataAgent[] iLinkedDataAgentArray = ILinkedDataAgent.create(this.mesh);
            this.linkedAgents = iLinkedDataAgentArray;
            for (int i = 0; i < this.linkedAgents.length; ++i) {
                this.linkedAgents[i].setData((IArithmeticVal)new IVec());
            }
        }

        public ILinkedNodeMeshFieldGeo setForce(int n, IVecI iVecI) {
            if (this.linkedAgents == null || n < 0 || n >= this.linkedAgents.length) {
                return this;
            }
            this.linkedAgents[n].setData((IArithmeticVal)iVecI);
            return this;
        }

        public IVecI getForce(int n) {
            if (this.linkedAgents == null || n < 0 || n >= this.linkedAgents.length) {
                return new IVec();
            }
            return (IVecI)this.linkedAgents[n].getData();
        }

        public ILinkedNodeMeshFieldGeo addForce(int n, IVecI iVecI) {
            if (this.linkedAgents == null || n < 0 || n >= this.linkedAgents.length) {
                return this;
            }
            this.linkedAgents[n].addData(iVecI);
            return this;
        }

        public IVecI get(int n) {
            return this.getForce(n);
        }

        public ILinkedNodeMeshFieldGeo showVector() {
            if (this.linkedAgents == null || this.mesh == null) {
                return this;
            }
            this.vectorObjects = new IVectorObject[this.mesh.vertexNum()];
            for (int i = 0; i < this.mesh.vertexNum(); ++i) {
                this.vectorObjects[i] = new IVectorObject((IVecI)this.linkedAgents[i].getData(), (IVecI)this.mesh.vertex(i));
            }
            return this;
        }

        public ILinkedNodeMeshFieldGeo linkFriction(double d) {
            if (this.linkedAgents == null) {
                return this;
            }
            for (int i = 0; i < this.linkedAgents.length; ++i) {
                this.linkedAgents[i].fric(d);
            }
            return this;
        }

        public ILinkedNodeMeshFieldGeo linkFriction(int n, double d) {
            if (this.linkedAgents == null || n < 0 || n >= this.linkedAgents.length) {
                return null;
            }
            this.linkedAgents[n].fric(d);
            return this;
        }
    }
}

