/*
 * Decompiled with CFR 0.152.
 */
package igeo.p;

import igeo.IBounds;
import igeo.IColor;
import igeo.IConfig;
import igeo.IG;
import igeo.IGraphicI;
import igeo.IObject;
import igeo.IOut;
import igeo.ITexture;
import igeo.IVec;
import igeo.IVec2f;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;
import igeo.gui.IGridPanel;
import igeo.gui.IKeyEvent;
import igeo.gui.IMouseEvent;
import igeo.gui.IMouseWheelEvent;
import igeo.gui.INavigator;
import igeo.gui.IPane;
import igeo.gui.IPanelI;
import igeo.gui.IScreenTogglePanel;
import igeo.gui.IView;
import igeo.p.PIConfig;
import igeo.p.PIInput;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.opengl.PGraphics3D;

public class PIGraphics3D
extends PGraphics3D
implements IGraphics3D,
IPane {
    static boolean keepColorMode = false;
    public IPanelI panel;
    public IView view;
    public IVec viewDirection;
    public IVec viewLocation;
    public int origColorMode;
    public float origColorModeX;
    public float origColorModeY;
    public float origColorModeZ;
    public float origColorModeA;
    public boolean overridePAppletFinish = true;
    public boolean finished = false;
    public boolean overridePAppletLoop = true;
    public boolean looping = true;
    public boolean enableDepthSort;
    public boolean overrideDepthSort = false;
    public boolean firstDraw = true;
    public int screenX = 0;
    public int screenY = 0;
    public float borderWidth = 1.0f;
    public BasicStroke borderStroke = new BasicStroke(this.borderWidth);
    public Color borderColor = Color.gray;
    public INavigator navigator;
    public boolean visible = true;
    public PImage bgImage = null;
    public IColor[][] bgColorCache = new IColor[2][2];
    public boolean creatingBGImage = false;
    public boolean resetTexture = false;
    public PIGraphics3D[][] subGraphics = null;
    public PIGraphics3D alias = null;

    public PIGraphics3D() {
    }

    public PIGraphics3D(PIGraphics3D pIGraphics3D) {
        this.alias = pIGraphics3D;
    }

    public void initPrimary() {
        super.initPrimary();
        if (this.alias != null) {
            return;
        }
        Object object = this.pgl.getCanvas();
        if (object instanceof Canvas) {
            Canvas canvas = (Canvas)object;
            canvas.addMouseListener(this.panel);
            canvas.addMouseMotionListener(this.panel);
            canvas.addMouseWheelListener(this.panel);
            canvas.addKeyListener(this.panel);
            canvas.addFocusListener(this.panel);
            canvas.addComponentListener(this.panel);
        } else {
            IG.err("not canvas: " + object);
        }
    }

    public void setParent(PApplet pApplet) {
        super.setParent(pApplet);
        if (this.alias != null) {
            return;
        }
        this.subGraphics = new PIGraphics3D[2][2];
        this.subGraphics[0][0] = new PIGraphics3D(this);
        this.subGraphics[0][1] = new PIGraphics3D(this);
        this.subGraphics[1][0] = new PIGraphics3D(this);
        this.subGraphics[1][1] = new PIGraphics3D(this);
        this.subGraphics[0][0].setParent(pApplet);
        this.subGraphics[0][1].setParent(pApplet);
        this.subGraphics[1][1].setParent(pApplet);
        this.subGraphics[1][0].setParent(pApplet);
        int n = pApplet.getWidth();
        int n2 = pApplet.getHeight();
        this.subGraphics[0][0].setBounds(0, 0, n / 2, n2 / 2);
        this.subGraphics[0][1].setBounds(n / 2, 0, n / 2, n2 / 2);
        this.subGraphics[1][0].setBounds(0, n2 / 2, n / 2, n2 / 2);
        this.subGraphics[1][1].setBounds(n / 2, n2 / 2, n / 2, n2 / 2);
        this.panel = new IGridPanel(0, 0, pApplet.getWidth(), pApplet.getHeight(), 2, 2, this.subGraphics);
        this.panel.setVisible(true);
        this.panel.setParent((Container)pApplet);
        IG iG = IG.init(this.panel);
        iG.server().graphicServer().enableGL();
        this.setColorMode();
        iG.setOnline(pApplet.online);
        if (!pApplet.online) {
            iG.setBasePath(pApplet.dataPath(""));
        }
        iG.setInputWrapper(new PIInput(pApplet));
        if (pApplet.frame != null) {
            pApplet.frame.addWindowListener(this.panel);
        }
        if (PIConfig.drawBeforeProcessing) {
            pApplet.registerPre((Object)this);
        } else {
            pApplet.registerDraw((Object)this);
        }
        pApplet.registerPost((Object)this);
        if (PIConfig.resizable) {
            pApplet.frame.setResizable(true);
        }
        this.enableDepthSort = IConfig.depthSort;
        if (this.enableDepthSort) {
            super.hint(3);
        } else {
            super.hint(-3);
        }
    }

    public void pre() {
        this.drawIG();
    }

    public void draw() {
        this.drawIG();
    }

    public void vertex(float f, float f2, float f3) {
        if (this.hints[3] && (this.shape == 20 || this.shape == 50 || this.shape == 4) && this.vertexCount > 0 && Math.abs(this.vertices[this.vertexCount - 1][0] - f) < 1.0E-4f && Math.abs(this.vertices[this.vertexCount - 1][1] - f2) < 1.0E-4f && Math.abs(this.vertices[this.vertexCount - 1][2] - f3) < 1.0E-4f) {
            this.vertexCheck();
            float[] fArray = this.vertices[this.vertexCount];
            this.curveVertexCount = 0;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            float f4 = fArray[12] = this.edge ? 1.0f : 0.0f;
            if (this.fill || this.textureImage != null) {
                if (this.textureImage == null) {
                    fArray[3] = this.fillR;
                    fArray[4] = this.fillG;
                    fArray[5] = this.fillB;
                    fArray[6] = this.fillA;
                } else if (this.tint) {
                    fArray[3] = this.tintR;
                    fArray[4] = this.tintG;
                    fArray[5] = this.tintB;
                    fArray[6] = this.tintA;
                } else {
                    fArray[3] = 1.0f;
                    fArray[4] = 1.0f;
                    fArray[5] = 1.0f;
                    fArray[6] = 1.0f;
                }
                fArray[25] = this.ambientR;
                fArray[26] = this.ambientG;
                fArray[27] = this.ambientB;
                fArray[28] = this.specularR;
                fArray[29] = this.specularG;
                fArray[30] = this.specularB;
                fArray[31] = this.shininess;
                fArray[32] = this.emissiveR;
                fArray[33] = this.emissiveG;
                fArray[34] = this.emissiveB;
            }
            if (this.stroke) {
                fArray[13] = this.strokeR;
                fArray[14] = this.strokeG;
                fArray[15] = this.strokeB;
                fArray[16] = this.strokeA;
                fArray[17] = this.strokeWeight;
            }
            if (this.textureImage != null) {
                fArray[7] = this.textureU;
                fArray[8] = this.textureV;
            }
            fArray[9] = this.normalX;
            fArray[10] = this.normalY;
            fArray[11] = this.normalZ;
            fArray[35] = 0.0f;
            ++this.vertexCount;
        } else {
            super.vertex(f, f2, f3);
        }
    }

    public void drawIG() {
        if (this.alias == null) {
            if (((IScreenTogglePanel)this.panel).fullScreenPane != null) {
                this.panel.predraw(this);
                IView iView = ((PIGraphics3D)((IScreenTogglePanel)this.panel).fullScreenPane).view;
                ArrayList<IGraphicI> arrayList = this.panel.getIG().server().graphicServer().getObjects(iView);
                this.draw(arrayList, iView);
                this.panel.postdraw(this);
            } else {
                if (this.panel != null) {
                    this.panel.draw(this);
                }
                this.beginDraw();
                this.pushMatrix();
                this.resetMatrix();
                this.ortho(0.0f, this.width, 0.0f, this.height);
                this.translate(-this.width / 2, -this.height / 2);
                for (int i = 0; i < this.subGraphics.length; ++i) {
                    for (int j = 0; j < this.subGraphics[i].length; ++j) {
                        super.image((PImage)this.subGraphics[i][j], (float)this.subGraphics[i][j].screenX, (float)this.subGraphics[i][j].screenY, (float)this.subGraphics[i][j].width, (float)this.subGraphics[i][j].height);
                    }
                }
                this.popMatrix();
                this.endDraw();
            }
        }
    }

    public void post() {
        if (this.overridePAppletFinish) {
            this.parent.finished = this.finished;
        }
        if (this.overridePAppletLoop) {
            if (this.looping) {
                this.parent.loop();
            } else {
                this.parent.noLoop();
            }
        }
    }

    public void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public void noLoop() {
        if (this.looping) {
            this.looping = false;
        }
    }

    public void start() {
        if (this.finished) {
            this.finished = false;
        }
    }

    public void stop() {
        if (!this.finished) {
            this.finished = true;
        }
    }

    @Override
    public IGraphicMode.GraphicType type() {
        return IGraphicMode.GraphicType.P3D;
    }

    @Override
    public IView view() {
        return this.view;
    }

    public void updateBGImage(int n, int n2, IView iView) {
        if (iView != null && iView.bgColor != null) {
            boolean bl = false;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.bgColorCache[i][j] == iView.bgColor[i][j]) continue;
                    this.bgColorCache[i][j] = iView.bgColor[i][j];
                    bl = true;
                }
            }
            if (this.bgImage == null || bl || this.bgImage.width != n || this.bgImage.height != n2) {
                PImage pImage = this.createBGImage(n, n2, iView);
                this.creatingBGImage = true;
                this.bgImage = pImage;
                this.creatingBGImage = false;
            }
            if (this.resetTexture && this.texture != null && (this.texture.glWidth != this.width || this.texture.glHeight != this.height)) {
                this.texture = null;
                if (this.primarySurface) {
                    this.loadTextureImpl(2, false);
                }
                super.restartPGL();
                this.resetTexture = false;
            }
        }
    }

    public PImage createBGImage(int n, int n2, IView iView) {
        int n3;
        PImage pImage = new PImage(n, n2);
        float[][][] fArray = new float[2][2][3];
        for (n3 = 0; n3 < 2; ++n3) {
            for (int i = 0; i < 2; ++i) {
                fArray[n3][i][0] = iView.bgColor[n3][i].getRed();
                fArray[n3][i][1] = iView.bgColor[n3][i].getGreen();
                fArray[n3][i][2] = iView.bgColor[n3][i].getBlue();
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            float f = (float)(n2 - n3) / (float)n2;
            for (int i = 0; i < n; ++i) {
                float f2 = (float)(n - i) / (float)n;
                int n4 = (int)(f * (f2 * fArray[0][0][0] + (1.0f - f2) * fArray[1][0][0]) + (1.0f - f) * (f2 * fArray[0][1][0] + (1.0f - f2) * fArray[1][1][0]));
                int n5 = (int)(f * (f2 * fArray[0][0][1] + (1.0f - f2) * fArray[1][0][1]) + (1.0f - f) * (f2 * fArray[0][1][1] + (1.0f - f2) * fArray[1][1][1]));
                int n6 = (int)(f * (f2 * fArray[0][0][2] + (1.0f - f2) * fArray[1][0][2]) + (1.0f - f) * (f2 * fArray[0][1][2] + (1.0f - f2) * fArray[1][1][2]));
                pImage.set(i, n3, 0xFF000000 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF);
            }
        }
        return pImage;
    }

    public void drawBG(IView iView) {
        if (iView.bgColor != null && !this.creatingBGImage) {
            this.background(this.bgImage);
        }
    }

    public void drawView(IView iView) {
        if (IConfig.clearBG || this.firstDraw) {
            this.drawBG(iView);
        }
        this.viewLocation = iView.location();
        this.viewDirection = iView.frontDirection();
        if (iView.mode.isLight()) {
            super.lights();
        }
        if (!this.overrideDepthSort && IConfig.depthSort != this.enableDepthSort) {
            if (IConfig.depthSort) {
                this.enableDepthSort = true;
                super.hint(3);
            } else {
                this.enableDepthSort = false;
                super.hint(-3);
            }
        }
        if (IConfig.smoothGraphicP3D) {
            super.smooth();
        }
        super.scale(1.0f, -1.0f, 1.0f);
        if (iView.axonometric) {
            double d = (double)iView.screenWidth * iView.axonRatio;
            double d2 = (double)iView.screenHeight * iView.axonRatio;
            super.ortho((float)(-d) / 2.0f + (float)iView.screenWidth / 2.0f, (float)d / 2.0f + (float)iView.screenWidth / 2.0f, (float)(-d2) / 2.0f + (float)iView.screenHeight / 2.0f, (float)d2 / 2.0f + (float)iView.screenHeight / 2.0f, (float)iView.near, (float)iView.far);
        } else {
            super.scale((float)iView.screenHeight);
            double d = iView.near * iView.persRatio * 2.0;
            double d3 = d * (double)iView.screenWidth / (double)iView.screenHeight;
            super.frustum((float)(-d3) / 2.0f, (float)d3 / 2.0f, (float)(-d) / 2.0f, (float)d / 2.0f, (float)iView.near, (float)iView.far * (float)iView.screenHeight);
        }
        super.applyMatrix((float)iView.transformArray[0], (float)iView.transformArray[4], (float)iView.transformArray[8], (float)iView.transformArray[12], (float)iView.transformArray[1], (float)iView.transformArray[5], (float)iView.transformArray[9], (float)iView.transformArray[13], (float)iView.transformArray[2], (float)iView.transformArray[6], (float)iView.transformArray[10], (float)iView.transformArray[14], (float)iView.transformArray[3], (float)iView.transformArray[7], (float)iView.transformArray[11], (float)iView.transformArray[15]);
    }

    @Override
    public synchronized void draw(ArrayList<IGraphicI> arrayList, IView iView) {
        this.view = iView;
        if (this.view.hide) {
            return;
        }
        if (this.enableDepthSort) {
            if (arrayList != null && IConfig.maxObjectNumberForDepthSort > 0 && arrayList.size() > IConfig.maxObjectNumberForDepthSort) {
                if (!this.overrideDepthSort) {
                    this.overrideDepthSort = true;
                    this.enableDepthSort = false;
                    super.hint(-3);
                    IOut.err("number of graphic objects (" + arrayList.size() + ") exceeds IConfig.maxObjectNumberForDepthSort (" + IConfig.maxObjectNumberForDepthSort + ")");
                    IOut.err("depth sort is disalbed");
                }
            } else if (IConfig.maxObjectNumberForDepthSort > 0 && this.overrideDepthSort) {
                this.overrideDepthSort = false;
            }
        }
        this.updateBGImage(this.width, this.height, this.view);
        super.resetMatrix();
        super.beginDraw();
        this.drawView(this.view);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (!arrayList.get(i).isVisible()) continue;
                arrayList.get(i).draw(this);
            }
        }
        if (this.view.mode().isLight()) {
            this.disableLight();
        }
        super.endDraw();
    }

    @Override
    public boolean firstDraw() {
        return this.firstDraw;
    }

    @Override
    public void firstDraw(boolean bl) {
        this.firstDraw = bl;
        if (this.subGraphics != null) {
            for (int i = 0; i < this.subGraphics.length; ++i) {
                for (int j = 0; j < this.subGraphics[i].length; ++j) {
                    if (this.subGraphics[i][j] == this) continue;
                    this.subGraphics[i][j].firstDraw(bl);
                }
            }
        }
    }

    public boolean isDefaultColorMode() {
        return this.colorMode == 1 && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f && this.colorModeA == 255.0f;
    }

    public void pushColorMode() {
        this.origColorMode = this.colorMode;
        this.origColorModeX = this.colorModeX;
        this.origColorModeY = this.colorModeY;
        this.origColorModeZ = this.colorModeZ;
        this.origColorModeA = this.colorModeA;
    }

    public void popColorMode() {
        super.colorMode(this.origColorMode, this.origColorModeX, this.origColorModeY, this.origColorModeZ, this.origColorModeA);
    }

    public void setColorMode() {
        this.colorMode(1, 255.0f);
    }

    @Override
    public void clr(IColor iColor) {
        this.clr(iColor.red(), iColor.green(), iColor.blue(), iColor.alpha());
    }

    @Override
    public void clr(float f, float f2, float f3) {
        this.clr(f, f2, f3, 1.0f);
    }

    @Override
    public void clr(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            this.setColorMode();
            super.fill(f * 255.0f, f2 * 255.0f, f3 * 255.0f, f4 * 255.0f);
            this.popColorMode();
        } else {
            super.fill(f * 255.0f, f2 * 255.0f, f3 * 255.0f, f4 * 255.0f);
        }
    }

    @Override
    public void clr(float[] fArray) {
        this.clr(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public void clr(IColor iColor, float f) {
        this.clr(iColor.red(), iColor.green(), iColor.blue(), f);
    }

    @Override
    public void stroke(IColor iColor) {
        this.stroke(iColor.red(), iColor.green(), iColor.blue(), iColor.alpha());
    }

    @Override
    public void stroke(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            this.setColorMode();
            super.stroke(f * 255.0f, f2 * 255.0f, f3 * 255.0f, f4 * 255.0f);
            this.popColorMode();
        } else {
            super.stroke(f * 255.0f, f2 * 255.0f, f3 * 255.0f, f4 * 255.0f);
        }
    }

    @Override
    public void stroke(float f, float f2, float f3) {
        this.stroke(f, f2, f3, 1.0f);
    }

    @Override
    public void stroke(float[] fArray) {
        this.stroke(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public void stroke(IColor iColor, float f) {
        this.stroke(iColor.red(), iColor.green(), iColor.blue(), f);
    }

    @Override
    public void weight(float f) {
        if (this.view.axonometric) {
            super.strokeWeight(f);
        } else {
            super.strokeWeight(f / (float)this.view.screenHeight);
        }
    }

    @Override
    public void diffuse(float f, float f2, float f3, float f4) {
        this.clr(f, f2, f3, f4);
    }

    @Override
    public void diffuse(float f, float f2, float f3) {
        this.diffuse(f, f2, f3, 1.0f);
    }

    @Override
    public void diffuse(IColor iColor) {
        this.diffuse(iColor.red(), iColor.green(), iColor.blue(), iColor.alpha());
    }

    @Override
    public void diffuse(IColor iColor, float f) {
        this.diffuse(iColor.red(), iColor.green(), iColor.blue(), f);
    }

    @Override
    public void diffuse(float[] fArray) {
        this.diffuse(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    @Override
    public void ambient(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            this.setColorMode();
            super.ambient(f * 255.0f, f2 * 255.0f, f3 * 255.0f);
            this.popColorMode();
        } else {
            super.ambient(f * 255.0f, f2 * 255.0f, f3 * 255.0f);
        }
    }

    @Override
    public void ambient(float f, float f2, float f3) {
        this.ambient(f, f2, f3, 1.0f);
    }

    @Override
    public void ambient(float[] fArray) {
        this.ambient(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    @Override
    public void ambient(IColor iColor) {
        this.ambient(iColor.red(), iColor.green(), iColor.blue(), iColor.alpha());
    }

    @Override
    public void ambient(IColor iColor, float f) {
        this.ambient(iColor.red(), iColor.green(), f);
    }

    @Override
    public void specular(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            this.setColorMode();
            super.specular(f * 255.0f, f2 * 255.0f, f3 * 255.0f);
            this.popColorMode();
        } else {
            super.specular(f * 255.0f, f2 * 255.0f, f3 * 255.0f);
        }
    }

    @Override
    public void specular(float f, float f2, float f3) {
        this.specular(f, f2, f3, 1.0f);
    }

    @Override
    public void specular(float[] fArray) {
        this.specular(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    @Override
    public void specular(IColor iColor) {
        this.specular(iColor.red(), iColor.green(), iColor.blue(), iColor.alpha());
    }

    @Override
    public void specular(IColor iColor, float f) {
        this.specular(iColor.red(), iColor.green(), iColor.blue(), f);
    }

    @Override
    public void emissive(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            this.setColorMode();
            super.emissive(f * 255.0f, f2 * 255.0f, f3 * 255.0f);
            this.popColorMode();
        } else {
            super.emissive(f * 255.0f, f2 * 255.0f, f3 * 255.0f);
        }
    }

    @Override
    public void emissive(float f, float f2, float f3) {
        this.emissive(f, f2, f3, 1.0f);
    }

    @Override
    public void emissive(float[] fArray) {
        this.emissive(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    @Override
    public void emissive(IColor iColor) {
        this.emissive(iColor.red(), iColor.green(), iColor.blue(), iColor.alpha());
    }

    @Override
    public void emissive(IColor iColor, float f) {
        this.emissive(iColor.red(), iColor.green(), iColor.blue(), f);
    }

    @Override
    public void shininess(float f) {
        super.shininess(f);
    }

    @Override
    public void enableLight() {
        super.lights();
    }

    @Override
    public void disableLight() {
        super.noLights();
    }

    @Override
    public void pointSize(float f) {
        super.strokeWeight(f);
    }

    public boolean isInFront(IVec iVec) {
        return true;
    }

    public void vertex(IVec iVec) {
        this.vertex((float)iVec.x, (float)iVec.y, (float)iVec.z);
    }

    public void vertex(IVec iVec, IVec2f iVec2f) {
        this.vertex((float)iVec.x, (float)iVec.y, (float)iVec.z, iVec2f.x, iVec2f.y);
    }

    public void vertex(IVec[] iVecArray) {
        for (int i = 0; i < iVecArray.length; ++i) {
            this.vertex((float)iVecArray[i].x, (float)iVecArray[i].y, (float)iVecArray[i].z);
        }
    }

    public void vertex(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        for (int i = 0; i < iVecArray.length; ++i) {
            this.vertex((float)iVecArray[i].x, (float)iVecArray[i].y, (float)iVecArray[i].z, iVec2fArray[i].x, iVec2fArray[i].y);
        }
    }

    public void vertex(IVec[] iVecArray, IVec[] iVecArray2) {
        for (int i = 0; i < iVecArray.length; ++i) {
            super.normal((float)iVecArray2[i].x, (float)iVecArray2[i].y, (float)iVecArray2[i].z);
            this.vertex((float)iVecArray[i].x, (float)iVecArray[i].y, (float)iVecArray[i].z);
        }
    }

    public void vertex(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        for (int i = 0; i < iVecArray.length; ++i) {
            super.normal((float)iVecArray2[i].x, (float)iVecArray2[i].y, (float)iVecArray2[i].z);
            this.vertex((float)iVecArray[i].x, (float)iVecArray[i].y, (float)iVecArray[i].z, iVec2fArray[i].x, iVec2fArray[i].y);
        }
    }

    public void vertexTexture(IVec2f iVec2f) {
        super.vertexTexture(iVec2f.x, iVec2f.y);
    }

    public void normal(IVec iVec) {
        super.normal((float)iVec.x, (float)iVec.y, (float)iVec.z);
    }

    @Override
    public void drawPoint(IVec iVec) {
        this.stroke = true;
        this.fill = false;
        super.beginShape(3);
        if (IConfig.cullVertexBehindViewInP3D) {
            if (this.isInFront(iVec)) {
                this.vertex(iVec);
            }
        } else {
            this.vertex(iVec);
        }
        super.endShape();
    }

    @Override
    public void drawPoints(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        super.beginShape(3);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.vertex(iVecArray[i]);
                continue;
            }
            this.vertex(iVecArray[i]);
        }
        super.endShape();
    }

    @Override
    public void drawLines(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        super.beginShape(5);
        for (int i = 0; i < iVecArray.length - 1; i += 2) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i + 1]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i + 1]);
        }
        super.endShape();
    }

    @Override
    public void drawLineStrip(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl3) {
                    if (bl2) {
                        this.vertex(iVecArray[i]);
                    } else {
                        super.beginShape(50);
                        this.vertex(iVecArray[i]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(50);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawLineLoop(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        if (IConfig.cullVertexBehindViewInP3D) {
            int n;
            boolean[] blArray = new boolean[iVecArray.length];
            boolean bl = false;
            for (n = 0; n < iVecArray.length; ++n) {
                blArray[n] = this.isInFront(iVecArray[n]);
                if (blArray[n]) continue;
                bl = true;
            }
            if (bl) {
                n = 0;
                boolean bl2 = false;
                for (int i = 0; i <= iVecArray.length; ++i) {
                    int n2 = blArray[i % iVecArray.length];
                    if (n2 != 0) {
                        if (bl2) {
                            this.vertex(iVecArray[i % iVecArray.length]);
                        } else {
                            super.beginShape(20);
                            this.vertex(iVecArray[i % iVecArray.length]);
                            bl2 = true;
                        }
                    } else if (bl2) {
                        super.endShape();
                        bl2 = false;
                    }
                    n = n2;
                }
                if (bl2) {
                    super.endShape();
                }
            } else {
                super.beginShape(20);
                for (n = 0; n < iVecArray.length; ++n) {
                    this.vertex(iVecArray[n]);
                }
                super.endShape(2);
            }
        } else {
            super.beginShape(20);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape(2);
        }
    }

    @Override
    public void drawPolygon(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.vertex(iVecArray[i]);
                continue;
            }
            this.vertex(iVecArray[i]);
        }
        super.endShape(2);
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.vertex(iVecArray[i], iVec2fArray[i]);
                continue;
            }
            this.vertex(iVecArray[i], iVec2fArray[i]);
        }
        super.endShape(2);
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i]);
        }
        super.endShape(2);
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i], iVec2fArray[i]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i], iVec2fArray[i]);
        }
        super.endShape(2);
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i])) continue;
                        this.vertex(iVecArray[i]);
                        continue;
                    }
                    this.vertex(iVecArray[i]);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i])) continue;
                        this.vertex(iVecArray[i]);
                        continue;
                    }
                    this.vertex(iVecArray[i]);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i])) continue;
                    this.vertex(iVecArray[i]);
                    continue;
                }
                this.vertex(iVecArray[i]);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i])) continue;
                    this.vertex(iVecArray[i]);
                    continue;
                }
                this.vertex(iVecArray[i]);
            }
        }
        super.endShape(2);
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i])) continue;
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        continue;
                    }
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i])) continue;
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        continue;
                    }
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i])) continue;
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    continue;
                }
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i])) continue;
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    continue;
                }
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
            }
        }
        super.endShape(2);
    }

    @Override
    public void drawQuads(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(17);
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i + 1]);
                this.vertex(iVecArray[i + 2]);
                this.vertex(iVecArray[i + 3]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i + 1]);
            this.vertex(iVecArray[i + 2]);
            this.vertex(iVecArray[i + 3]);
        }
        super.endShape();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(17);
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                this.vertex(iVecArray[i], iVec2fArray[i]);
                this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                this.vertex(iVecArray[i + 2], iVec2fArray[i + 2]);
                this.vertex(iVecArray[i + 3], iVec2fArray[i + 3]);
                continue;
            }
            this.vertex(iVecArray[i], iVec2fArray[i]);
            this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
            this.vertex(iVecArray[i + 2], iVec2fArray[i + 2]);
            this.vertex(iVecArray[i + 3], iVec2fArray[i + 3]);
        }
        super.endShape();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(17);
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
                this.normal(iVecArray2[i + 3]);
                this.vertex(iVecArray[i + 3]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i]);
            this.normal(iVecArray2[i + 1]);
            this.vertex(iVecArray[i + 1]);
            this.normal(iVecArray2[i + 2]);
            this.vertex(iVecArray[i + 2]);
            this.normal(iVecArray2[i + 3]);
            this.vertex(iVecArray[i + 3]);
        }
        super.endShape();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(17);
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i], iVec2fArray[i]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2], iVec2fArray[i + 2]);
                this.normal(iVecArray2[i + 3]);
                this.vertex(iVecArray[i + 3], iVec2fArray[i + 3]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i], iVec2fArray[i]);
            this.normal(iVecArray2[i + 1]);
            this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
            this.normal(iVecArray2[i + 2]);
            this.vertex(iVecArray[i + 2], iVec2fArray[i + 2]);
            this.normal(iVecArray2[i + 3]);
            this.vertex(iVecArray[i + 3], iVec2fArray[i + 3]);
        }
        super.endShape();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(17);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 3; i += 4) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                        this.ambient(iColorArray[i]);
                        this.diffuse(iColorArray[i]);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1]);
                        this.diffuse(iColorArray[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2]);
                        this.diffuse(iColorArray[i + 2]);
                        this.vertex(iVecArray[i + 2]);
                        this.ambient(iColorArray[i + 3]);
                        this.diffuse(iColorArray[i + 3]);
                        this.vertex(iVecArray[i + 3]);
                        continue;
                    }
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1]);
                    this.diffuse(iColorArray[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2]);
                    this.diffuse(iColorArray[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    this.ambient(iColorArray[i + 3]);
                    this.diffuse(iColorArray[i + 3]);
                    this.vertex(iVecArray[i + 3]);
                }
            } else {
                for (int i = 0; i < iVecArray.length - 3; i += 4) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                        this.ambient(iColorArray[i], f);
                        this.diffuse(iColorArray[i], f);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1], f);
                        this.diffuse(iColorArray[i + 1], f);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2], f);
                        this.diffuse(iColorArray[i + 2], f);
                        this.vertex(iVecArray[i + 2]);
                        this.ambient(iColorArray[i + 3], f);
                        this.diffuse(iColorArray[i + 3], f);
                        this.vertex(iVecArray[i + 3]);
                        continue;
                    }
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1], f);
                    this.diffuse(iColorArray[i + 1], f);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2], f);
                    this.diffuse(iColorArray[i + 2], f);
                    this.vertex(iVecArray[i + 2]);
                    this.ambient(iColorArray[i + 3], f);
                    this.diffuse(iColorArray[i + 3], f);
                    this.vertex(iVecArray[i + 3]);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 3; i += 4) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                    this.clr(iColorArray[i]);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    this.clr(iColorArray[i + 3]);
                    this.vertex(iVecArray[i + 3]);
                    continue;
                }
                this.clr(iColorArray[i]);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2]);
                this.vertex(iVecArray[i + 2]);
                this.clr(iColorArray[i + 3]);
                this.vertex(iVecArray[i + 3]);
            }
        } else {
            for (int i = 0; i < iVecArray.length - 3; i += 4) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                    this.clr(iColorArray[i], f);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1], f);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2], f);
                    this.vertex(iVecArray[i + 2]);
                    this.clr(iColorArray[i + 3], f);
                    this.vertex(iVecArray[i + 3]);
                    continue;
                }
                this.clr(iColorArray[i], f);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1], f);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2], f);
                this.vertex(iVecArray[i + 2]);
                this.clr(iColorArray[i + 3], f);
                this.vertex(iVecArray[i + 3]);
            }
        }
        super.endShape();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(17);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 3; i += 4) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                        this.ambient(iColorArray[i]);
                        this.diffuse(iColorArray[i]);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1]);
                        this.diffuse(iColorArray[i + 1]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2]);
                        this.diffuse(iColorArray[i + 2]);
                        this.normal(iVecArray2[i + 2]);
                        this.vertex(iVecArray[i + 2]);
                        this.ambient(iColorArray[i + 3]);
                        this.diffuse(iColorArray[i + 3]);
                        this.normal(iVecArray2[i + 3]);
                        this.vertex(iVecArray[i + 3]);
                        continue;
                    }
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1]);
                    this.diffuse(iColorArray[i + 1]);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2]);
                    this.diffuse(iColorArray[i + 2]);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    this.ambient(iColorArray[i + 3]);
                    this.diffuse(iColorArray[i + 3]);
                    this.normal(iVecArray2[i + 3]);
                    this.vertex(iVecArray[i + 3]);
                }
            } else {
                for (int i = 0; i < iVecArray.length - 3; i += 4) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                        this.ambient(iColorArray[i], f);
                        this.diffuse(iColorArray[i], f);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1], f);
                        this.diffuse(iColorArray[i + 1], f);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2], f);
                        this.diffuse(iColorArray[i + 2], f);
                        this.normal(iVecArray2[i + 2]);
                        this.vertex(iVecArray[i + 2]);
                        this.ambient(iColorArray[i + 3], f);
                        this.diffuse(iColorArray[i + 3], f);
                        this.normal(iVecArray2[i + 3]);
                        this.vertex(iVecArray[i + 3]);
                        continue;
                    }
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1], f);
                    this.diffuse(iColorArray[i + 1], f);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2], f);
                    this.diffuse(iColorArray[i + 2], f);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    this.ambient(iColorArray[i + 3], f);
                    this.diffuse(iColorArray[i + 3], f);
                    this.normal(iVecArray2[i + 3]);
                    this.vertex(iVecArray[i + 3]);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 3; i += 4) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                    this.clr(iColorArray[i]);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1]);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2]);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    this.clr(iColorArray[i + 3]);
                    this.normal(iVecArray2[i + 3]);
                    this.vertex(iVecArray[i + 3]);
                    continue;
                }
                this.clr(iColorArray[i]);
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
                this.clr(iColorArray[i + 3]);
                this.normal(iVecArray2[i + 3]);
                this.vertex(iVecArray[i + 3]);
            }
        } else {
            for (int i = 0; i < iVecArray.length - 3; i += 4) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                    this.clr(iColorArray[i], f);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1], f);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2], f);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    this.clr(iColorArray[i + 3], f);
                    this.normal(iVecArray2[i + 3]);
                    this.vertex(iVecArray[i + 3]);
                    continue;
                }
                this.clr(iColorArray[i], f);
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1], f);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2], f);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
                this.clr(iColorArray[i + 3], f);
                this.normal(iVecArray2[i + 3]);
                this.vertex(iVecArray[i + 3]);
            }
        }
        super.endShape();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length - 1; i += 2) {
                boolean bl3;
                boolean bl4 = bl3 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                if (bl3) {
                    if (bl2) {
                        this.vertex(iVecArray[i]);
                        this.vertex(iVecArray[i + 1]);
                    } else {
                        super.beginShape(18);
                        this.vertex(iVecArray[i]);
                        this.vertex(iVecArray[i + 1]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(18);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length - 1; i += 2) {
                boolean bl3;
                boolean bl4 = bl3 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                if (bl3) {
                    if (bl2) {
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                        this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                    } else {
                        super.beginShape(18);
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                        this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(18);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length - 1; i += 2) {
                boolean bl3;
                boolean bl4 = bl3 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                if (bl3) {
                    if (bl2) {
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                    } else {
                        super.beginShape(18);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(18);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length - 1; i += 2) {
                boolean bl3;
                boolean bl4 = bl3 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                if (bl3) {
                    if (bl2) {
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                    } else {
                        super.beginShape(18);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(18);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i], iVec2fArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                if (f < 0.0f) {
                    for (int i = 0; i < iVecArray.length - 1; i += 2) {
                        boolean bl4;
                        boolean bl5 = bl4 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                        if (bl4) {
                            if (bl3) {
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1]);
                                this.diffuse(iColorArray[i + 1]);
                                this.vertex(iVecArray[i + 1]);
                            } else {
                                super.beginShape(18);
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1]);
                                this.diffuse(iColorArray[i + 1]);
                                this.vertex(iVecArray[i + 1]);
                                bl3 = true;
                            }
                        } else if (bl3) {
                            super.endShape();
                            bl3 = false;
                        }
                        bl2 = bl4;
                    }
                } else {
                    for (int i = 0; i < iVecArray.length - 1; i += 2) {
                        boolean bl6;
                        boolean bl7 = bl6 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                        if (bl6) {
                            if (bl3) {
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1], f);
                                this.diffuse(iColorArray[i + 1], f);
                                this.vertex(iVecArray[i + 1]);
                            } else {
                                super.beginShape(18);
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1], f);
                                this.diffuse(iColorArray[i + 1], f);
                                this.vertex(iVecArray[i + 1]);
                                bl3 = true;
                            }
                        } else if (bl3) {
                            super.endShape();
                            bl3 = false;
                        }
                        bl2 = bl6;
                    }
                }
            } else if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; i += 2) {
                    boolean bl8;
                    boolean bl9 = bl8 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                    if (bl8) {
                        if (bl3) {
                            this.clr(iColorArray[i]);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1]);
                            this.vertex(iVecArray[i + 1]);
                        } else {
                            super.beginShape(18);
                            this.clr(iColorArray[i]);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1]);
                            this.vertex(iVecArray[i + 1]);
                            bl3 = true;
                        }
                    } else if (bl3) {
                        super.endShape();
                        bl3 = false;
                    }
                    bl2 = bl8;
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; i += 2) {
                    boolean bl10;
                    boolean bl11 = bl10 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                    if (bl10) {
                        if (bl3) {
                            this.clr(iColorArray[i], f);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1], f);
                            this.vertex(iVecArray[i + 1]);
                        } else {
                            super.beginShape(18);
                            this.clr(iColorArray[i], f);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1], f);
                            this.vertex(iVecArray[i + 1]);
                            bl3 = true;
                        }
                    } else if (bl3) {
                        super.endShape();
                        bl3 = false;
                    }
                    bl2 = bl10;
                }
            }
            if (bl3) {
                super.endShape();
            }
        } else {
            super.beginShape(18);
            if (bl) {
                if (f < 0.0f) {
                    for (int i = 0; i < iVecArray.length; ++i) {
                        this.ambient(iColorArray[i]);
                        this.diffuse(iColorArray[i]);
                        this.vertex(iVecArray[i]);
                    }
                } else {
                    for (int i = 0; i < iVecArray.length; ++i) {
                        this.ambient(iColorArray[i], f);
                        this.diffuse(iColorArray[i], f);
                        this.vertex(iVecArray[i]);
                    }
                }
            } else if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i]);
                    this.vertex(iVecArray[i]);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i], f);
                    this.vertex(iVecArray[i]);
                }
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                if (f < 0.0f) {
                    for (int i = 0; i < iVecArray.length - 1; i += 2) {
                        boolean bl4;
                        boolean bl5 = bl4 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                        if (bl4) {
                            if (bl3) {
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1]);
                                this.diffuse(iColorArray[i + 1]);
                                this.normal(iVecArray2[i + 1]);
                                this.vertex(iVecArray[i + 1]);
                            } else {
                                super.beginShape(18);
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1]);
                                this.diffuse(iColorArray[i + 1]);
                                this.normal(iVecArray2[i + 1]);
                                this.vertex(iVecArray[i + 1]);
                                bl3 = true;
                            }
                        } else if (bl3) {
                            super.endShape();
                            bl3 = false;
                        }
                        bl2 = bl4;
                    }
                } else {
                    for (int i = 0; i < iVecArray.length - 1; i += 2) {
                        boolean bl6;
                        boolean bl7 = bl6 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                        if (bl6) {
                            if (bl3) {
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1], f);
                                this.diffuse(iColorArray[i + 1], f);
                                this.normal(iVecArray2[i + 1]);
                                this.vertex(iVecArray[i + 1]);
                            } else {
                                super.beginShape(18);
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                                this.ambient(iColorArray[i + 1], f);
                                this.diffuse(iColorArray[i + 1], f);
                                this.normal(iVecArray2[i + 1]);
                                this.vertex(iVecArray[i + 1]);
                                bl3 = true;
                            }
                        } else if (bl3) {
                            super.endShape();
                            bl3 = false;
                        }
                        bl2 = bl6;
                    }
                }
            } else if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; i += 2) {
                    boolean bl8;
                    boolean bl9 = bl8 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                    if (bl8) {
                        if (bl3) {
                            this.clr(iColorArray[i]);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1]);
                            this.normal(iVecArray2[i + 1]);
                            this.vertex(iVecArray[i + 1]);
                        } else {
                            super.beginShape(18);
                            this.clr(iColorArray[i]);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1]);
                            this.normal(iVecArray2[i + 1]);
                            this.vertex(iVecArray[i + 1]);
                            bl3 = true;
                        }
                    } else if (bl3) {
                        super.endShape();
                        bl3 = false;
                    }
                    bl2 = bl8;
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; i += 2) {
                    boolean bl10;
                    boolean bl11 = bl10 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                    if (bl10) {
                        if (bl3) {
                            this.clr(iColorArray[i], f);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1], f);
                            this.normal(iVecArray2[i + 1]);
                            this.vertex(iVecArray[i + 1]);
                        } else {
                            super.beginShape(18);
                            this.clr(iColorArray[i], f);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                            this.clr(iColorArray[i + 1], f);
                            this.normal(iVecArray2[i + 1]);
                            this.vertex(iVecArray[i + 1]);
                            bl3 = true;
                        }
                    } else if (bl3) {
                        super.endShape();
                        bl3 = false;
                    }
                    bl2 = bl10;
                }
            }
            if (bl3) {
                super.endShape();
            }
        } else {
            super.beginShape(18);
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i]);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i], f);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                }
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray) {
        this.stroke = false;
        this.fill = true;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            int n;
            if (IConfig.cullVertexBehindViewInP3D) {
                n = 0;
                boolean bl = false;
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    int n2;
                    int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                    if (n2 != 0) {
                        if (bl) {
                            this.vertex(iVecArray[i][j]);
                            this.vertex(iVecArray[i + 1][j]);
                        } else {
                            super.beginShape(18);
                            this.vertex(iVecArray[i][j]);
                            this.vertex(iVecArray[i + 1][j]);
                            bl = true;
                        }
                    } else if (bl) {
                        super.endShape();
                        bl = false;
                    }
                    n = n2;
                }
                if (!bl) continue;
                super.endShape();
                continue;
            }
            super.beginShape(18);
            for (n = 0; n < iVecArray[i].length; ++n) {
                this.vertex(iVecArray[i][n]);
                this.vertex(iVecArray[i + 1][n]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec2f[][] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            int n;
            if (IConfig.cullVertexBehindViewInP3D) {
                n = 0;
                boolean bl = false;
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    int n2;
                    int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                    if (n2 != 0) {
                        if (bl) {
                            this.vertex(iVecArray[i][j], iVec2fArray[i][j]);
                            this.vertex(iVecArray[i + 1][j], iVec2fArray[i + 1][j]);
                        } else {
                            super.beginShape(18);
                            this.vertex(iVecArray[i][j], iVec2fArray[i][j]);
                            this.vertex(iVecArray[i + 1][j], iVec2fArray[i + 1][j]);
                            bl = true;
                        }
                    } else if (bl) {
                        super.endShape();
                        bl = false;
                    }
                    n = n2;
                }
                if (!bl) continue;
                super.endShape();
                continue;
            }
            super.beginShape(18);
            for (n = 0; n < iVecArray[i].length; ++n) {
                this.vertex(iVecArray[i][n], iVec2fArray[i][n]);
                this.vertex(iVecArray[i + 1][n], iVec2fArray[i + 1][n]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            int n;
            if (IConfig.cullVertexBehindViewInP3D) {
                n = 0;
                boolean bl = false;
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    int n2;
                    int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                    if (n2 != 0) {
                        if (bl) {
                            this.normal(iVecArray2[i][j]);
                            this.vertex(iVecArray[i][j]);
                            this.normal(iVecArray2[i + 1][j]);
                            this.vertex(iVecArray[i + 1][j]);
                        } else {
                            super.beginShape(18);
                            this.normal(iVecArray2[i][j]);
                            this.vertex(iVecArray[i][j]);
                            this.normal(iVecArray2[i + 1][j]);
                            this.vertex(iVecArray[i + 1][j]);
                            bl = true;
                        }
                    } else if (bl) {
                        super.endShape();
                        bl = false;
                    }
                    n = n2;
                }
                if (!bl) continue;
                super.endShape();
                continue;
            }
            super.beginShape(18);
            for (n = 0; n < iVecArray[i].length; ++n) {
                this.normal(iVecArray2[i][n]);
                this.vertex(iVecArray[i][n]);
                this.normal(iVecArray2[i + 1][n]);
                this.vertex(iVecArray[i + 1][n]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2, IVec2f[][] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            int n;
            if (IConfig.cullVertexBehindViewInP3D) {
                n = 0;
                boolean bl = false;
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    int n2;
                    int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                    if (n2 != 0) {
                        if (bl) {
                            this.normal(iVecArray2[i][j]);
                            this.vertex(iVecArray[i][j], iVec2fArray[i][j]);
                            this.normal(iVecArray2[i + 1][j]);
                            this.vertex(iVecArray[i + 1][j], iVec2fArray[i + 1][j]);
                        } else {
                            super.beginShape(18);
                            this.normal(iVecArray2[i][j]);
                            this.vertex(iVecArray[i][j], iVec2fArray[i][j]);
                            this.normal(iVecArray2[i + 1][j]);
                            this.vertex(iVecArray[i + 1][j], iVec2fArray[i + 1][j]);
                            bl = true;
                        }
                    } else if (bl) {
                        super.endShape();
                        bl = false;
                    }
                    n = n2;
                }
                if (!bl) continue;
                super.endShape();
                continue;
            }
            super.beginShape(18);
            for (n = 0; n < iVecArray[i].length; ++n) {
                this.normal(iVecArray2[i][n]);
                this.vertex(iVecArray[i][n], iVec2fArray[i][n]);
                this.normal(iVecArray2[i + 1][n]);
                this.vertex(iVecArray[i + 1][n], iVec2fArray[i + 1][n]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IColor[][] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    int n;
                    if (IConfig.cullVertexBehindViewInP3D) {
                        n = 0;
                        boolean bl2 = false;
                        for (int j = 0; j < iVecArray[i].length; ++j) {
                            int n2;
                            int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                            if (n2 != 0) {
                                if (bl2) {
                                    this.ambient(iColorArray[i][j]);
                                    this.diffuse(iColorArray[i][j]);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j]);
                                    this.diffuse(iColorArray[i + 1][j]);
                                    this.vertex(iVecArray[i + 1][j]);
                                } else {
                                    super.beginShape(18);
                                    this.ambient(iColorArray[i][j]);
                                    this.diffuse(iColorArray[i][j]);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j]);
                                    this.diffuse(iColorArray[i + 1][j]);
                                    this.vertex(iVecArray[i + 1][j]);
                                    bl2 = true;
                                }
                            } else if (bl2) {
                                super.endShape();
                                bl2 = false;
                            }
                            n = n2;
                        }
                        if (!bl2) continue;
                        super.endShape();
                        continue;
                    }
                    super.beginShape(18);
                    for (n = 0; n < iVecArray[i].length; ++n) {
                        this.ambient(iColorArray[i][n]);
                        this.diffuse(iColorArray[i][n]);
                        this.vertex(iVecArray[i][n]);
                        this.ambient(iColorArray[i + 1][n]);
                        this.diffuse(iColorArray[i + 1][n]);
                        this.vertex(iVecArray[i + 1][n]);
                    }
                    super.endShape();
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    int n;
                    if (IConfig.cullVertexBehindViewInP3D) {
                        n = 0;
                        boolean bl3 = false;
                        for (int j = 0; j < iVecArray[i].length; ++j) {
                            int n4;
                            int n5 = n4 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                            if (n4 != 0) {
                                if (bl3) {
                                    this.ambient(iColorArray[i][j], f);
                                    this.diffuse(iColorArray[i][j], f);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j], f);
                                    this.diffuse(iColorArray[i + 1][j], f);
                                    this.vertex(iVecArray[i + 1][j]);
                                } else {
                                    super.beginShape(18);
                                    this.ambient(iColorArray[i][j], f);
                                    this.diffuse(iColorArray[i][j], f);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j], f);
                                    this.diffuse(iColorArray[i + 1][j], f);
                                    this.vertex(iVecArray[i + 1][j]);
                                    bl3 = true;
                                }
                            } else if (bl3) {
                                super.endShape();
                                bl3 = false;
                            }
                            n = n4;
                        }
                        if (!bl3) continue;
                        super.endShape();
                        continue;
                    }
                    super.beginShape(18);
                    for (n = 0; n < iVecArray[i].length; ++n) {
                        this.ambient(iColorArray[i][n], f);
                        this.diffuse(iColorArray[i][n], f);
                        this.vertex(iVecArray[i][n]);
                        this.ambient(iColorArray[i + 1][n], f);
                        this.diffuse(iColorArray[i + 1][n], f);
                        this.vertex(iVecArray[i + 1][n]);
                    }
                    super.endShape();
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                int n;
                if (IConfig.cullVertexBehindViewInP3D) {
                    n = 0;
                    boolean bl4 = false;
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        int n6;
                        int n7 = n6 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                        if (n6 != 0) {
                            if (bl4) {
                                this.clr(iColorArray[i][j]);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j]);
                                this.vertex(iVecArray[i + 1][j]);
                            } else {
                                super.beginShape(18);
                                this.clr(iColorArray[i][j]);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j]);
                                this.vertex(iVecArray[i + 1][j]);
                                bl4 = true;
                            }
                        } else if (bl4) {
                            super.endShape();
                            bl4 = false;
                        }
                        n = n6;
                    }
                    if (!bl4) continue;
                    super.endShape();
                    continue;
                }
                super.beginShape(18);
                for (n = 0; n < iVecArray[i].length; ++n) {
                    this.clr(iColorArray[i][n]);
                    this.vertex(iVecArray[i][n]);
                    this.clr(iColorArray[i + 1][n]);
                    this.vertex(iVecArray[i + 1][n]);
                }
                super.endShape();
            }
        } else {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                int n;
                if (IConfig.cullVertexBehindViewInP3D) {
                    n = 0;
                    boolean bl5 = false;
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        int n8;
                        int n9 = n8 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                        if (n8 != 0) {
                            if (bl5) {
                                this.clr(iColorArray[i][j], f);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j], f);
                                this.vertex(iVecArray[i + 1][j]);
                            } else {
                                super.beginShape(18);
                                this.clr(iColorArray[i][j], f);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j], f);
                                this.vertex(iVecArray[i + 1][j]);
                                bl5 = true;
                            }
                        } else if (bl5) {
                            super.endShape();
                            bl5 = false;
                        }
                        n = n8;
                    }
                    if (!bl5) continue;
                    super.endShape();
                    continue;
                }
                super.beginShape(18);
                for (n = 0; n < iVecArray[i].length; ++n) {
                    this.clr(iColorArray[i][n], f);
                    this.vertex(iVecArray[i][n]);
                    this.clr(iColorArray[i + 1][n], f);
                    this.vertex(iVecArray[i + 1][n]);
                }
                super.endShape();
            }
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2, IColor[][] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    int n;
                    if (IConfig.cullVertexBehindViewInP3D) {
                        n = 0;
                        boolean bl2 = false;
                        for (int j = 0; j < iVecArray[i].length; ++j) {
                            int n2;
                            int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                            if (n2 != 0) {
                                if (bl2) {
                                    this.ambient(iColorArray[i][j]);
                                    this.diffuse(iColorArray[i][j]);
                                    this.normal(iVecArray2[i][j]);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j]);
                                    this.diffuse(iColorArray[i + 1][j]);
                                    this.normal(iVecArray2[i + 1][j]);
                                    this.vertex(iVecArray[i + 1][j]);
                                } else {
                                    super.beginShape(18);
                                    this.ambient(iColorArray[i][j]);
                                    this.diffuse(iColorArray[i][j]);
                                    this.normal(iVecArray2[i][j]);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j]);
                                    this.diffuse(iColorArray[i + 1][j]);
                                    this.normal(iVecArray2[i + 1][j]);
                                    this.vertex(iVecArray[i + 1][j]);
                                    bl2 = true;
                                }
                            } else if (bl2) {
                                super.endShape();
                                bl2 = false;
                            }
                            n = n2;
                        }
                        if (!bl2) continue;
                        super.endShape();
                        continue;
                    }
                    super.beginShape(18);
                    for (n = 0; n < iVecArray[i].length; ++n) {
                        this.ambient(iColorArray[i][n]);
                        this.diffuse(iColorArray[i][n]);
                        this.normal(iVecArray2[i][n]);
                        this.vertex(iVecArray[i][n]);
                        this.ambient(iColorArray[i + 1][n]);
                        this.diffuse(iColorArray[i + 1][n]);
                        this.normal(iVecArray2[i + 1][n]);
                        this.vertex(iVecArray[i + 1][n]);
                    }
                    super.endShape();
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    int n;
                    if (IConfig.cullVertexBehindViewInP3D) {
                        n = 0;
                        boolean bl3 = false;
                        for (int j = 0; j < iVecArray[i].length; ++j) {
                            int n4;
                            int n5 = n4 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                            if (n4 != 0) {
                                if (bl3) {
                                    this.ambient(iColorArray[i][j], f);
                                    this.diffuse(iColorArray[i][j], f);
                                    this.normal(iVecArray2[i][j]);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j], f);
                                    this.diffuse(iColorArray[i + 1][j], f);
                                    this.normal(iVecArray2[i + 1][j]);
                                    this.vertex(iVecArray[i + 1][j]);
                                } else {
                                    super.beginShape(18);
                                    this.ambient(iColorArray[i][j], f);
                                    this.diffuse(iColorArray[i][j], f);
                                    this.normal(iVecArray2[i][j]);
                                    this.vertex(iVecArray[i][j]);
                                    this.ambient(iColorArray[i + 1][j], f);
                                    this.diffuse(iColorArray[i + 1][j], f);
                                    this.normal(iVecArray2[i + 1][j]);
                                    this.vertex(iVecArray[i + 1][j]);
                                    bl3 = true;
                                }
                            } else if (bl3) {
                                super.endShape();
                                bl3 = false;
                            }
                            n = n4;
                        }
                        if (!bl3) continue;
                        super.endShape();
                        continue;
                    }
                    super.beginShape(18);
                    for (n = 0; n < iVecArray[i].length; ++n) {
                        this.ambient(iColorArray[i][n], f);
                        this.diffuse(iColorArray[i][n], f);
                        this.normal(iVecArray2[i][n]);
                        this.vertex(iVecArray[i][n]);
                        this.ambient(iColorArray[i + 1][n], f);
                        this.diffuse(iColorArray[i + 1][n], f);
                        this.normal(iVecArray2[i + 1][n]);
                        this.vertex(iVecArray[i + 1][n]);
                    }
                    super.endShape();
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                int n;
                if (IConfig.cullVertexBehindViewInP3D) {
                    n = 0;
                    boolean bl4 = false;
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        int n6;
                        int n7 = n6 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                        if (n6 != 0) {
                            if (bl4) {
                                this.clr(iColorArray[i][j]);
                                this.normal(iVecArray2[i][j]);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j]);
                                this.normal(iVecArray2[i + 1][j]);
                                this.vertex(iVecArray[i + 1][j]);
                            } else {
                                super.beginShape(18);
                                this.clr(iColorArray[i][j]);
                                this.normal(iVecArray2[i][j]);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j]);
                                this.normal(iVecArray2[i + 1][j]);
                                this.vertex(iVecArray[i + 1][j]);
                                bl4 = true;
                            }
                        } else if (bl4) {
                            super.endShape();
                            bl4 = false;
                        }
                        n = n6;
                    }
                    if (!bl4) continue;
                    super.endShape();
                    continue;
                }
                super.beginShape(18);
                for (n = 0; n < iVecArray[i].length; ++n) {
                    this.clr(iColorArray[i][n]);
                    this.normal(iVecArray2[i][n]);
                    this.vertex(iVecArray[i][n]);
                    this.clr(iColorArray[i + 1][n]);
                    this.normal(iVecArray2[i + 1][n]);
                    this.vertex(iVecArray[i + 1][n]);
                }
                super.endShape();
            }
        } else {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                int n;
                if (IConfig.cullVertexBehindViewInP3D) {
                    n = 0;
                    boolean bl5 = false;
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        int n8;
                        int n9 = n8 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                        if (n8 != 0) {
                            if (bl5) {
                                this.clr(iColorArray[i][j], f);
                                this.normal(iVecArray2[i][j]);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j], f);
                                this.normal(iVecArray2[i + 1][j]);
                                this.vertex(iVecArray[i + 1][j]);
                            } else {
                                super.beginShape(18);
                                this.clr(iColorArray[i][j], f);
                                this.normal(iVecArray2[i][j]);
                                this.vertex(iVecArray[i][j]);
                                this.clr(iColorArray[i + 1][j], f);
                                this.normal(iVecArray2[i + 1][j]);
                                this.vertex(iVecArray[i + 1][j]);
                                bl5 = true;
                            }
                        } else if (bl5) {
                            super.endShape();
                            bl5 = false;
                        }
                        n = n8;
                    }
                    if (!bl5) continue;
                    super.endShape();
                    continue;
                }
                super.beginShape(18);
                for (n = 0; n < iVecArray[i].length; ++n) {
                    this.clr(iColorArray[i][n], f);
                    this.normal(iVecArray2[i][n]);
                    this.vertex(iVecArray[i][n]);
                    this.clr(iColorArray[i + 1][n], f);
                    this.normal(iVecArray2[i + 1][n]);
                    this.vertex(iVecArray[i + 1][n]);
                }
                super.endShape();
            }
        }
    }

    @Override
    public void drawTriangles(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i + 1]);
                this.vertex(iVecArray[i + 2]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i + 1]);
            this.vertex(iVecArray[i + 2]);
        }
        super.endShape();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                this.vertex(iVecArray[i], iVec2fArray[i]);
                this.vertex(iVecArray[i + 1], iVec2fArray[i]);
                this.vertex(iVecArray[i + 2], iVec2fArray[i]);
                continue;
            }
            this.vertex(iVecArray[i], iVec2fArray[i]);
            this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
            this.vertex(iVecArray[i + 2], iVec2fArray[i + 1]);
        }
        super.endShape();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i]);
            this.normal(iVecArray2[i + 1]);
            this.vertex(iVecArray[i + 1]);
            this.normal(iVecArray2[i + 2]);
            this.vertex(iVecArray[i + 2]);
        }
        super.endShape();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i], iVec2fArray[i]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2], iVec2fArray[i + 2]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i], iVec2fArray[i]);
            this.normal(iVecArray2[i + 1]);
            this.vertex(iVecArray[i + 1], iVec2fArray[i + 1]);
            this.normal(iVecArray2[i + 2]);
            this.vertex(iVecArray[i + 2], iVec2fArray[i + 2]);
        }
        super.endShape();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 2; i += 3) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                        this.ambient(iColorArray[i]);
                        this.diffuse(iColorArray[i]);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1]);
                        this.diffuse(iColorArray[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2]);
                        this.diffuse(iColorArray[i + 2]);
                        this.vertex(iVecArray[i + 2]);
                        continue;
                    }
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1]);
                    this.diffuse(iColorArray[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2]);
                    this.diffuse(iColorArray[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                }
            } else {
                for (int i = 0; i < iVecArray.length - 2; i += 3) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                        this.ambient(iColorArray[i], f);
                        this.diffuse(iColorArray[i], f);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1], f);
                        this.diffuse(iColorArray[i + 1], f);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2], f);
                        this.diffuse(iColorArray[i + 2], f);
                        this.vertex(iVecArray[i + 2]);
                        continue;
                    }
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1], f);
                    this.diffuse(iColorArray[i + 1], f);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2], f);
                    this.diffuse(iColorArray[i + 2], f);
                    this.vertex(iVecArray[i + 2]);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 2; i += 3) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                    this.clr(iColorArray[i]);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    continue;
                }
                this.clr(iColorArray[i]);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2]);
                this.vertex(iVecArray[i + 2]);
            }
        } else {
            for (int i = 0; i < iVecArray.length - 2; i += 3) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                    this.clr(iColorArray[i], f);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1], f);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2], f);
                    this.vertex(iVecArray[i + 2]);
                    continue;
                }
                this.clr(iColorArray[i], f);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1], f);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2], f);
                this.vertex(iVecArray[i + 2]);
            }
        }
        super.endShape();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 2; i += 3) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                        this.ambient(iColorArray[i]);
                        this.diffuse(iColorArray[i]);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1]);
                        this.diffuse(iColorArray[i + 1]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2]);
                        this.diffuse(iColorArray[i + 2]);
                        this.normal(iVecArray2[i + 2]);
                        this.vertex(iVecArray[i + 2]);
                        continue;
                    }
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1]);
                    this.diffuse(iColorArray[i + 1]);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2]);
                    this.diffuse(iColorArray[i + 2]);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                }
            } else {
                for (int i = 0; i < iVecArray.length - 2; i += 3) {
                    if (IConfig.cullVertexBehindViewInP3D) {
                        if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                        this.ambient(iColorArray[i], f);
                        this.diffuse(iColorArray[i], f);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.ambient(iColorArray[i + 1], f);
                        this.diffuse(iColorArray[i + 1], f);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        this.ambient(iColorArray[i + 2], f);
                        this.diffuse(iColorArray[i + 2], f);
                        this.normal(iVecArray2[i + 2]);
                        this.vertex(iVecArray[i + 2]);
                        continue;
                    }
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.ambient(iColorArray[i + 1], f);
                    this.diffuse(iColorArray[i + 1], f);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.ambient(iColorArray[i + 2], f);
                    this.diffuse(iColorArray[i + 2], f);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 2; i += 3) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                    this.clr(iColorArray[i]);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1]);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2]);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    continue;
                }
                this.clr(iColorArray[i]);
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
            }
        } else {
            for (int i = 0; i < iVecArray.length - 2; i += 3) {
                if (IConfig.cullVertexBehindViewInP3D) {
                    if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                    this.clr(iColorArray[i], f);
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                    this.clr(iColorArray[i + 1], f);
                    this.normal(iVecArray2[i + 1]);
                    this.vertex(iVecArray[i + 1]);
                    this.clr(iColorArray[i + 2], f);
                    this.normal(iVecArray2[i + 2]);
                    this.vertex(iVecArray[i + 2]);
                    continue;
                }
                this.clr(iColorArray[i], f);
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.clr(iColorArray[i + 1], f);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.clr(iColorArray[i + 2], f);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
            }
        }
        super.endShape();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl4 = this.isInFront(iVecArray[i]);
                if (bl4) {
                    if (bl) {
                        this.vertex(iVecArray[i]);
                    } else {
                        super.beginShape(10);
                        this.vertex(iVecArray[i]);
                        bl = true;
                    }
                } else if (bl) {
                    super.endShape();
                    bl = false;
                }
                bl3 = bl2;
                bl2 = bl4;
            }
            if (bl) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            this.vertex(iVecArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl4 = this.isInFront(iVecArray[i]);
                if (bl4) {
                    if (bl) {
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                    } else {
                        super.beginShape(10);
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                        bl = true;
                    }
                } else if (bl) {
                    super.endShape();
                    bl = false;
                }
                bl3 = bl2;
                bl2 = bl4;
            }
            if (bl) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            this.vertex(iVecArray, iVec2fArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl4 = this.isInFront(iVecArray[i]);
                if (bl4) {
                    if (bl) {
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                    } else {
                        super.beginShape(10);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                    }
                } else if (bl) {
                    super.endShape();
                    bl = false;
                }
                bl3 = bl2;
                bl2 = bl4;
            }
            if (bl) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            this.vertex(iVecArray, iVecArray2);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl4 = this.isInFront(iVecArray[i]);
                if (bl4) {
                    if (bl) {
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                    } else {
                        super.beginShape(10);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i], iVec2fArray[i]);
                    }
                } else if (bl) {
                    super.endShape();
                    bl = false;
                }
                bl3 = bl2;
                bl2 = bl4;
            }
            if (bl) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            this.vertex(iVecArray, iVecArray2, iVec2fArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl) {
                if (f < 0.0f) {
                    for (int i = 0; i < iVecArray.length; ++i) {
                        boolean bl5 = this.isInFront(iVecArray[i]);
                        if (bl5) {
                            if (bl2) {
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.vertex(iVecArray[i]);
                            } else {
                                super.beginShape(10);
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.vertex(iVecArray[i]);
                                bl2 = true;
                            }
                        } else if (bl2) {
                            super.endShape();
                            bl2 = false;
                        }
                        bl4 = bl3;
                        bl3 = bl5;
                    }
                } else {
                    for (int i = 0; i < iVecArray.length; ++i) {
                        boolean bl6 = this.isInFront(iVecArray[i]);
                        if (bl6) {
                            if (bl2) {
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.vertex(iVecArray[i]);
                            } else {
                                super.beginShape(10);
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.vertex(iVecArray[i]);
                                bl2 = true;
                            }
                        } else if (bl2) {
                            super.endShape();
                            bl2 = false;
                        }
                        bl4 = bl3;
                        bl3 = bl6;
                    }
                }
            } else if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    boolean bl7 = this.isInFront(iVecArray[i]);
                    if (bl7) {
                        if (bl2) {
                            this.clr(iColorArray[i]);
                            this.vertex(iVecArray[i]);
                        } else {
                            super.beginShape(10);
                            this.clr(iColorArray[i]);
                            this.vertex(iVecArray[i]);
                            bl2 = true;
                        }
                    } else if (bl2) {
                        super.endShape();
                        bl2 = false;
                    }
                    bl4 = bl3;
                    bl3 = bl7;
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    boolean bl8 = this.isInFront(iVecArray[i]);
                    if (bl8) {
                        if (bl2) {
                            this.clr(iColorArray[i], f);
                            this.vertex(iVecArray[i]);
                        } else {
                            super.beginShape(10);
                            this.clr(iColorArray[i], f);
                            this.vertex(iVecArray[i]);
                            bl2 = true;
                        }
                    } else if (bl2) {
                        super.endShape();
                        bl2 = false;
                    }
                    bl4 = bl3;
                    bl3 = bl8;
                }
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            if (bl) {
                if (f < 0.0f) {
                    this.ambient(iColorArray[0]);
                    this.diffuse(iColorArray[0]);
                } else {
                    this.ambient(iColorArray[0], f);
                    this.diffuse(iColorArray[0], f);
                }
            } else if (f < 0.0f) {
                this.clr(iColorArray[0]);
            } else {
                this.clr(iColorArray[0], f);
            }
            this.vertex(iVecArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl) {
                if (f < 0.0f) {
                    for (int i = 0; i < iVecArray.length; ++i) {
                        boolean bl5 = this.isInFront(iVecArray[i]);
                        if (bl5) {
                            if (bl2) {
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                            } else {
                                super.beginShape(10);
                                this.ambient(iColorArray[i]);
                                this.diffuse(iColorArray[i]);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                            }
                        } else if (bl2) {
                            super.endShape();
                            bl2 = false;
                        }
                        bl4 = bl3;
                        bl3 = bl5;
                    }
                } else {
                    for (int i = 0; i < iVecArray.length; ++i) {
                        boolean bl6 = this.isInFront(iVecArray[i]);
                        if (bl6) {
                            if (bl2) {
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                            } else {
                                super.beginShape(10);
                                this.ambient(iColorArray[i], f);
                                this.diffuse(iColorArray[i], f);
                                this.normal(iVecArray2[i]);
                                this.vertex(iVecArray[i]);
                            }
                        } else if (bl2) {
                            super.endShape();
                            bl2 = false;
                        }
                        bl4 = bl3;
                        bl3 = bl6;
                    }
                }
            } else if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    boolean bl7 = this.isInFront(iVecArray[i]);
                    if (bl7) {
                        if (bl2) {
                            this.clr(iColorArray[i]);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                        } else {
                            super.beginShape(10);
                            this.clr(iColorArray[i]);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                        }
                    } else if (bl2) {
                        super.endShape();
                        bl2 = false;
                    }
                    bl4 = bl3;
                    bl3 = bl7;
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    boolean bl8 = this.isInFront(iVecArray[i]);
                    if (bl8) {
                        if (bl2) {
                            this.clr(iColorArray[i], f);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                        } else {
                            super.beginShape(10);
                            this.clr(iColorArray[i], f);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                        }
                    } else if (bl2) {
                        super.endShape();
                        bl2 = false;
                    }
                    bl4 = bl3;
                    bl3 = bl8;
                }
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            if (bl) {
                if (f < 0.0f) {
                    this.ambient(iColorArray[0]);
                    this.diffuse(iColorArray[0]);
                } else {
                    this.ambient(iColorArray[0], f);
                    this.diffuse(iColorArray[0], f);
                }
            } else if (f < 0.0f) {
                this.clr(iColorArray[0]);
            } else {
                this.clr(iColorArray[0], f);
            }
            this.vertex(iVecArray, iVecArray2);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl;
            super.beginShape(11);
            this.vertex(iVecArray[0]);
            boolean bl2 = bl = this.isInFront(iVecArray[0]);
            for (int i = 1; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl || bl2 || bl3) {
                    this.vertex(iVecArray[i]);
                }
                bl2 = bl3;
            }
            super.endShape();
        } else {
            super.beginShape(11);
            this.vertex(iVecArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl;
            super.beginShape(11);
            this.vertex(iVecArray[0], iVec2fArray[0]);
            boolean bl2 = bl = this.isInFront(iVecArray[0]);
            for (int i = 1; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl || bl2 || bl3) {
                    this.vertex(iVecArray[i], iVec2fArray[i]);
                }
                bl2 = bl3;
            }
            super.endShape();
        } else {
            super.beginShape(11);
            this.vertex(iVecArray, iVec2fArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl;
            super.beginShape(11);
            this.normal(iVecArray2[0]);
            this.vertex(iVecArray[0]);
            boolean bl2 = bl = this.isInFront(iVecArray[0]);
            for (int i = 1; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl || bl2 || bl3) {
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                }
                bl2 = bl3;
            }
            super.endShape();
        } else {
            super.beginShape(11);
            this.vertex(iVecArray, iVecArray2);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2, IVec2f[] iVec2fArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl;
            super.beginShape(11);
            this.normal(iVecArray2[0]);
            this.vertex(iVecArray[0], iVec2fArray[0]);
            boolean bl2 = bl = this.isInFront(iVecArray[0]);
            for (int i = 1; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl || bl2 || bl3) {
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i], iVec2fArray[i]);
                }
                bl2 = bl3;
            }
            super.endShape();
        } else {
            super.beginShape(11);
            this.vertex(iVecArray, iVecArray2, iVec2fArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            super.beginShape(11);
            if (bl) {
                if (f < 0.0f) {
                    boolean bl2;
                    this.ambient(iColorArray[0]);
                    this.diffuse(iColorArray[0]);
                    this.vertex(iVecArray[0]);
                    boolean bl3 = bl2 = this.isInFront(iVecArray[0]);
                    for (int i = 1; i < iVecArray.length; ++i) {
                        boolean bl4 = this.isInFront(iVecArray[i]);
                        if (bl2 || bl3 || bl4) {
                            this.ambient(iColorArray[i]);
                            this.diffuse(iColorArray[i]);
                            this.vertex(iVecArray[i]);
                        }
                        bl3 = bl4;
                    }
                } else {
                    boolean bl5;
                    this.ambient(iColorArray[0], f);
                    this.diffuse(iColorArray[0], f);
                    this.vertex(iVecArray[0]);
                    boolean bl6 = bl5 = this.isInFront(iVecArray[0]);
                    for (int i = 1; i < iVecArray.length; ++i) {
                        boolean bl7 = this.isInFront(iVecArray[i]);
                        if (bl5 || bl6 || bl7) {
                            this.ambient(iColorArray[i], f);
                            this.diffuse(iColorArray[i], f);
                            this.vertex(iVecArray[i]);
                        }
                        bl6 = bl7;
                    }
                }
            } else if (f < 0.0f) {
                boolean bl8;
                this.clr(iColorArray[0]);
                this.vertex(iVecArray[0]);
                boolean bl9 = bl8 = this.isInFront(iVecArray[0]);
                for (int i = 1; i < iVecArray.length; ++i) {
                    boolean bl10 = this.isInFront(iVecArray[i]);
                    if (bl8 || bl9 || bl10) {
                        this.clr(iColorArray[i]);
                        this.vertex(iVecArray[i]);
                    }
                    bl9 = bl10;
                }
            } else {
                boolean bl11;
                this.clr(iColorArray[0], f);
                this.vertex(iVecArray[0]);
                boolean bl12 = bl11 = this.isInFront(iVecArray[0]);
                for (int i = 1; i < iVecArray.length; ++i) {
                    boolean bl13 = this.isInFront(iVecArray[i]);
                    if (bl11 || bl12 || bl13) {
                        this.clr(iColorArray[i], f);
                        this.vertex(iVecArray[i]);
                    }
                    bl12 = bl13;
                }
            }
            super.endShape();
        } else {
            super.beginShape(11);
            if (f < 0.0f) {
                this.clr(iColorArray[0]);
            } else {
                this.clr(iColorArray[0], f);
            }
            this.vertex(iVecArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            super.beginShape(11);
            if (bl) {
                if (f < 0.0f) {
                    boolean bl2;
                    this.ambient(iColorArray[0]);
                    this.diffuse(iColorArray[0]);
                    this.normal(iVecArray2[0]);
                    this.vertex(iVecArray[0]);
                    boolean bl3 = bl2 = this.isInFront(iVecArray[0]);
                    for (int i = 1; i < iVecArray.length; ++i) {
                        boolean bl4 = this.isInFront(iVecArray[i]);
                        if (bl2 || bl3 || bl4) {
                            this.ambient(iColorArray[i]);
                            this.diffuse(iColorArray[i]);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                        }
                        bl3 = bl4;
                    }
                } else {
                    boolean bl5;
                    this.ambient(iColorArray[0], f);
                    this.diffuse(iColorArray[0], f);
                    this.normal(iVecArray2[0]);
                    this.vertex(iVecArray[0]);
                    boolean bl6 = bl5 = this.isInFront(iVecArray[0]);
                    for (int i = 1; i < iVecArray.length; ++i) {
                        boolean bl7 = this.isInFront(iVecArray[i]);
                        if (bl5 || bl6 || bl7) {
                            this.ambient(iColorArray[i], f);
                            this.diffuse(iColorArray[i], f);
                            this.normal(iVecArray2[i]);
                            this.vertex(iVecArray[i]);
                        }
                        bl6 = bl7;
                    }
                }
            } else if (f < 0.0f) {
                boolean bl8;
                this.clr(iColorArray[0]);
                this.normal(iVecArray2[0]);
                this.vertex(iVecArray[0]);
                boolean bl9 = bl8 = this.isInFront(iVecArray[0]);
                for (int i = 1; i < iVecArray.length; ++i) {
                    boolean bl10 = this.isInFront(iVecArray[i]);
                    if (bl8 || bl9 || bl10) {
                        this.clr(iColorArray[i]);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                    }
                    bl9 = bl10;
                }
            } else {
                boolean bl11;
                this.clr(iColorArray[0], f);
                this.normal(iVecArray2[0]);
                this.vertex(iVecArray[0]);
                boolean bl12 = bl11 = this.isInFront(iVecArray[0]);
                for (int i = 1; i < iVecArray.length; ++i) {
                    boolean bl13 = this.isInFront(iVecArray[i]);
                    if (bl11 || bl12 || bl13) {
                        this.clr(iColorArray[i], f);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                    }
                    bl12 = bl13;
                }
            }
            super.endShape();
        } else {
            super.beginShape(11);
            if (bl) {
                if (f < 0.0f) {
                    this.ambient(iColorArray[0]);
                    this.diffuse(iColorArray[0]);
                } else {
                    this.ambient(iColorArray[0], f);
                    this.diffuse(iColorArray[0], f);
                }
            } else if (f < 0.0f) {
                this.clr(iColorArray[0]);
            } else {
                this.clr(iColorArray[0], f);
            }
            this.vertex(iVecArray, iVecArray2);
            super.endShape();
        }
    }

    @Override
    public synchronized void setLocation(int n, int n2) {
        this.screenX = n;
        this.screenY = n2;
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public synchronized void setSize(int n, int n2) {
        this.resetTexture = true;
        this.updateBGImage(n, n2, this.view);
        super.setSize(n, n2);
        if (this.view != null) {
            this.view.setPane(this);
        }
        this.creatingBGImage = false;
    }

    @Override
    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        this.screenX = n;
        this.screenY = n2;
        this.setSize(n3, n4);
    }

    @Override
    public float getX() {
        return this.screenX;
    }

    @Override
    public float getY() {
        return this.screenY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean contains(int n, int n2) {
        if (n < this.screenX) {
            return false;
        }
        if (n2 < this.screenY) {
            return false;
        }
        if (n >= this.screenX + this.width) {
            return false;
        }
        return n2 < this.screenY + this.height;
    }

    @Override
    public void setPanel(IPanelI iPanelI) {
        this.panel = iPanelI;
    }

    @Override
    public IPanelI getPanel() {
        return this.panel;
    }

    @Override
    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    @Override
    public float getBorderWidth() {
        return this.borderWidth;
    }

    public Stroke getBorderStroke() {
        return null;
    }

    @Override
    public void setBorderColor(int n, int n2, int n3, int n4) {
        this.borderColor = new Color(n, n3, n2, n4);
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public int getBorderColor() {
        return this.borderColor.getRGB();
    }

    @Override
    public INavigator navigator() {
        return this.navigator;
    }

    @Override
    public void setView(IView iView) {
        this.view = iView;
        this.view.setPane(this);
        IGraphicMode iGraphicMode = new IGraphicMode(this.view.mode());
        iGraphicMode.setGraphicType(IGraphicMode.GraphicType.P3D);
        this.view.setMode(iGraphicMode);
        if (this.navigator == null) {
            this.navigator = new INavigator(this.view, this);
        } else {
            this.navigator.setView(this.view);
        }
    }

    @Override
    public IView getView() {
        return this.view;
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (this.view != null) {
            ArrayList<IGraphicI> arrayList = this.panel.getIG().server().graphicServer().getObjects(this.view);
            this.draw(arrayList, this.view);
        } else {
            IOut.err("view is null");
        }
    }

    @Override
    public void focus() {
        this.panel.setBounds();
        this.view.focus(this.panel.getBounds());
    }

    @Override
    public void focus(ArrayList<IObject> arrayList) {
        IBounds iBounds = new IBounds();
        iBounds.setObjects(arrayList);
        this.view.focus(iBounds);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed(new IMouseEvent(mouseEvent));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseReleased(new IMouseEvent(mouseEvent));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked(new IMouseEvent(mouseEvent));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered(new IMouseEvent(mouseEvent));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseExited(new IMouseEvent(mouseEvent));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMoved(new IMouseEvent(mouseEvent));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragged(new IMouseEvent(mouseEvent));
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseWheelMoved(new IMouseWheelEvent(mouseWheelEvent));
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed(new IKeyEvent(keyEvent));
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyReleased(new IKeyEvent(keyEvent));
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyTyped(new IKeyEvent(keyEvent));
    }

    @Override
    public void mousePressed(IMouseEvent iMouseEvent) {
        this.navigator.mousePressed(iMouseEvent);
    }

    @Override
    public void mouseReleased(IMouseEvent iMouseEvent) {
        this.navigator.mouseReleased(iMouseEvent);
    }

    @Override
    public void mouseClicked(IMouseEvent iMouseEvent) {
        this.navigator.mouseClicked(iMouseEvent);
    }

    @Override
    public void mouseEntered(IMouseEvent iMouseEvent) {
        this.navigator.mouseEntered(iMouseEvent);
    }

    @Override
    public void mouseExited(IMouseEvent iMouseEvent) {
        this.navigator.mouseExited(iMouseEvent);
    }

    @Override
    public void mouseMoved(IMouseEvent iMouseEvent) {
        this.navigator.mouseMoved(iMouseEvent);
    }

    @Override
    public void mouseDragged(IMouseEvent iMouseEvent) {
        this.navigator.mouseDragged(iMouseEvent);
    }

    @Override
    public void mouseWheelMoved(IMouseWheelEvent iMouseWheelEvent) {
        this.navigator.mouseWheelMoved(iMouseWheelEvent);
    }

    @Override
    public void keyPressed(IKeyEvent iKeyEvent) {
        this.navigator.keyPressed(iKeyEvent);
    }

    @Override
    public void keyReleased(IKeyEvent iKeyEvent) {
        this.navigator.keyReleased(iKeyEvent);
    }

    @Override
    public void keyTyped(IKeyEvent iKeyEvent) {
        this.navigator.keyTyped(iKeyEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void close() {
    }

    @Override
    public void beginTexture(ITexture iTexture) {
    }

    @Override
    public void endTexture() {
    }
}

