/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IAttribute;
import igeo.IConfig;
import igeo.IG;
import igeo.IObject;
import igeo.IOut;
import igeo.IServerI;
import igeo.io.I3DXML;
import igeo.io.I3DXMLImporter;
import igeo.io.IAIExporter;
import igeo.io.IInputWrapper;
import igeo.io.IObjFileExporter;
import igeo.io.IObjFileImporter;
import igeo.io.IRhino3dmExporter;
import igeo.io.IRhino3dmImporter;
import igeo.io.IShapeFileImporter;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIO {
    public static final String extensionObj = "obj";
    public static final String extensionRhino = "3dm";
    public static final String extension3DXML = "3dxml";
    public static final String extensionAI = "ai";
    public static final String extensionSHP = "shp";

    public static boolean isExtension(String string, String string2) {
        String string3 = IIO.getExtension(string);
        if (string3 == null) {
            return false;
        }
        return string3.toLowerCase().equals(string2.toLowerCase());
    }

    public static String getExtension(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[stringArray.length - 1];
    }

    public static String getFilenameWithoutExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static FileType getFileType(String string) {
        if (IIO.isExtension(string, extensionRhino)) {
            return FileType.RHINO;
        }
        if (IIO.isExtension(string, extensionObj)) {
            return FileType.OBJ;
        }
        if (IIO.isExtension(string, extension3DXML)) {
            return FileType._3DXML;
        }
        if (IIO.isExtension(string, extensionAI)) {
            return FileType.AI;
        }
        if (IIO.isExtension(string, extensionSHP)) {
            return FileType.SHP;
        }
        return FileType.OTHER;
    }

    public static ArrayList<IObject> open(String string, IServerI iServerI) {
        return IIO.open(new File(string), iServerI);
    }

    public static ArrayList<IObject> open(File file, IServerI iServerI) {
        IOut.debug(0, "opening " + file.getPath());
        if (!file.exists()) {
            IOut.err("the input file doesn't exist : " + file.getPath());
            return null;
        }
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            return IIO.openOBJ(file, iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.openRhino(file, iServerI);
        }
        if (fileType == FileType._3DXML) {
            return IIO.open3DXML(file, iServerI);
        }
        if (fileType == FileType.SHP) {
            return IIO.openShape(file, iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return null;
    }

    public static ArrayList<IObject> open(String string, IServerI iServerI, IInputWrapper iInputWrapper) {
        return IIO.open(new File(string), iServerI, iInputWrapper);
    }

    public static ArrayList<IObject> open(File file, IServerI iServerI, IInputWrapper iInputWrapper) {
        if (iInputWrapper == null) {
            return IIO.open(file, iServerI);
        }
        IOut.debug(0, "opening " + file.getPath());
        InputStream inputStream = iInputWrapper.getStream(file);
        if (inputStream == null) {
            if (!file.exists()) {
                IOut.err("the input file doesn't exist : " + file.getPath());
                return null;
            }
            return IIO.open(file, iServerI);
        }
        ArrayList<IObject> arrayList = null;
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            arrayList = IIO.openOBJ(inputStream, iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
        if (fileType == FileType.RHINO) {
            arrayList = IIO.openRhino(inputStream, iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
        if (fileType == FileType._3DXML) {
            arrayList = IIO.open3DXML(inputStream, file.getName(), iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
        if (fileType == FileType.SHP) {
            File file2;
            File file3 = IShapeFileImporter.getFileWithExtension(file, "dbf");
            InputStream inputStream2 = iInputWrapper.getStream(file3);
            if (inputStream2 == null) {
                file2 = IShapeFileImporter.getFileWithExtension(file, "DBF");
                inputStream2 = iInputWrapper.getStream(file2);
            }
            if (inputStream2 == null) {
                file2 = IShapeFileImporter.getFileWithExtension(file, "Dbf");
                inputStream2 = iInputWrapper.getStream(file2);
            }
            if (inputStream2 == null) {
                IG.err("DBF file does not exist : " + file3.getAbsolutePath());
            }
            arrayList = IIO.openShape(inputStream, inputStream2, iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return null;
    }

    public static ArrayList<IObject> openOBJ(File file, IServerI iServerI) {
        IOut.debug(0, "opening obj file " + file);
        ArrayList<IObject> arrayList = IObjFileImporter.read(file, iServerI);
        if (arrayList != null) {
            IOut.debug(0, "opening complete");
            return arrayList;
        }
        IOut.err("error occured in opening file " + file.toString());
        return null;
    }

    public static ArrayList<IObject> openOBJ(InputStream inputStream, IServerI iServerI) {
        ArrayList<IObject> arrayList = IObjFileImporter.read(inputStream, iServerI);
        if (arrayList != null) {
            IOut.debug(0, "opening complete");
            return arrayList;
        }
        IOut.err("error occured in opening OBJ file");
        return null;
    }

    public static ArrayList<IObject> openRhino(File file, IServerI iServerI) {
        IOut.debug(0, "opening 3dm file " + file);
        ArrayList<IObject> arrayList = IRhino3dmImporter.read(file, iServerI);
        if (arrayList != null) {
            IOut.debug(0, "opening complete");
            return arrayList;
        }
        IOut.err("error occured in opening file " + file.toString());
        return arrayList;
    }

    public static ArrayList<IObject> openRhino(InputStream inputStream, IServerI iServerI) {
        ArrayList<IObject> arrayList = IRhino3dmImporter.read(inputStream, iServerI);
        if (arrayList != null) {
            IOut.debug(0, "opening complete");
            return arrayList;
        }
        IOut.err("error occured in opening Rhino file");
        return arrayList;
    }

    public static ArrayList<IObject> open3DXML(File file, IServerI iServerI) {
        IOut.debug(0, "opening 3dxmm file " + file);
        try {
            I3DXML i3DXML = I3DXMLImporter.read(file);
            IOut.debug(0, "opening complete");
            ArrayList<IObject> arrayList = new ArrayList<IObject>();
            for (int i = 0; i < i3DXML.objects.size(); ++i) {
                arrayList.add(i3DXML.objects.get(i));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject> open3DXML(InputStream inputStream, String string, IServerI iServerI) {
        try {
            I3DXML i3DXML = I3DXMLImporter.read(inputStream, string);
            IOut.debug(0, "opening complete");
            ArrayList<IObject> arrayList = new ArrayList<IObject>();
            for (int i = 0; i < i3DXML.objects.size(); ++i) {
                arrayList.add(i3DXML.objects.get(i));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject> openShape(File file, IServerI iServerI) {
        IOut.debug(0, "opening obj file " + file);
        ArrayList<IObject> arrayList = IShapeFileImporter.read(file, iServerI);
        if (arrayList != null) {
            IOut.debug(0, "opening complete");
            return arrayList;
        }
        IOut.err("error occured in opening file " + file.toString());
        return null;
    }

    public static ArrayList<IObject> openShape(InputStream inputStream, InputStream inputStream2, IServerI iServerI) {
        ArrayList<IObject> arrayList = IShapeFileImporter.read(inputStream, inputStream2, iServerI);
        if (arrayList != null) {
            IOut.debug(0, "opening complete");
            return arrayList;
        }
        IOut.err("error occured in opening Shape file");
        return null;
    }

    public static boolean save(String string, IServerI iServerI) {
        IIO.saveTextureAsPNG(string, iServerI);
        FileType fileType = IIO.getFileType(string);
        if (fileType == FileType.OBJ) {
            return IIO.saveOBJ(new File(string), iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.saveRhino(new File(string), iServerI);
        }
        if (fileType == FileType.AI) {
            return IIO.saveAI(new File(string), iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(string) + " is not supported");
        return false;
    }

    public static boolean save(File file, IServerI iServerI) {
        IIO.saveTextureAsPNG(file.getName(), iServerI);
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            return IIO.saveOBJ(file, iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.saveRhino(file, iServerI);
        }
        if (fileType == FileType.AI) {
            return IIO.saveAI(file, iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return false;
    }

    public static boolean saveOBJ(File file, IServerI iServerI) {
        IOut.debug(0, "saving obj file: " + file);
        if (IObjFileExporter.write(file, iServerI)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static boolean saveRhino(File file, IServerI iServerI) {
        IOut.debug(0, "saving 3dm file: " + file);
        if (IRhino3dmExporter.write(file, iServerI)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static boolean saveAI(File file, IServerI iServerI) {
        return IIO.saveAI(file, iServerI, IConfig.defaultAIExportScale);
    }

    public static boolean saveAI(File file, IServerI iServerI, double d) {
        IOut.debug(0, "saving ai file: " + file);
        if (IAIExporter.write(file, iServerI, d)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static void saveTextureAsPNG(String string, IServerI iServerI) {
        int n = iServerI.server().objectNum();
        String string2 = IIO.getFilenameWithoutExtension(string);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            IObject iObject = iServerI.server().getObject(i);
            IAttribute iAttribute = iObject.attr();
            if (iAttribute == null || iAttribute.texture == null || iAttribute.texture.image == null) continue;
            String string3 = string2 + "_" + String.valueOf(i) + ".png";
            string3 = IG.cur().formatOutputFilePath(string3);
            IOut.debug(0, "saving png file: " + string3);
            try {
                ImageIO.write((RenderedImage)iAttribute.texture.image, "png", new File(string3));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        RHINO,
        OBJ,
        _3DXML,
        AI,
        SHP,
        OTHER;

    }
}

