/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBrep;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveR;
import igeo.IMesh;
import igeo.IMeshR;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IServer;
import igeo.ISurface;
import igeo.ISurfaceR;
import igeo.IText;
import igeo.IVec;
import igeo.IVectorObject;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBounds {
    public IVec min = null;
    public IVec max = null;

    public IBounds() {
    }

    public IBounds(IVec iVec) {
        this.init(iVec);
    }

    public IBounds(IObject iObject) {
        this.compare(iObject);
    }

    public IBounds(IVec iVec, IVec iVec2) {
        this.min = iVec;
        this.max = iVec2;
    }

    public IBounds(IVec iVec, double d, double d2, double d3) {
        this.init(iVec);
        this.compare(iVec.add(d, d2, d3));
    }

    public IBounds(double d, double d2, double d3, double d4, double d5, double d6) {
        IVec iVec = new IVec(d, d2, d3);
        this.init(iVec);
        this.compare(iVec.add(d4, d5, d6));
    }

    public IBounds(IObject[] iObjectArray) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            this.compare(iObjectArray[i]);
        }
    }

    public IBounds(ArrayList<IObject> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.compare(arrayList.get(i));
        }
    }

    public IVec min() {
        return this.min;
    }

    public IVec getMin() {
        return this.min();
    }

    public IVec max() {
        return this.max;
    }

    public IVec getMax() {
        return this.max();
    }

    public double minX() {
        return this.min.x;
    }

    public double minY() {
        return this.min.y;
    }

    public double minZ() {
        return this.min.z;
    }

    public double maxX() {
        return this.max.x;
    }

    public double maxY() {
        return this.max.y;
    }

    public double maxZ() {
        return this.max.z;
    }

    public double width() {
        return this.max.x - this.min.x;
    }

    public double height() {
        return this.max.y - this.min.y;
    }

    public double depth() {
        return this.max.z - this.min.z;
    }

    public IVec size() {
        if (this.min == null || this.max == null) {
            return null;
        }
        return this.max.dif(this.min);
    }

    public IVec getSize() {
        return this.size();
    }

    public IVec center() {
        if (this.min == null || this.max == null) {
            return null;
        }
        return this.max.mid(this.min);
    }

    public IVec getCenter() {
        return this.center();
    }

    public void init(IVec iVec) {
        this.min = new IVec(iVec);
        this.max = new IVec(iVec);
    }

    public void init() {
        this.max = null;
        this.min = null;
    }

    public void compare(IVec iVec) {
        if (iVec == null || !iVec.isValid()) {
            return;
        }
        if (this.min == null || this.max == null) {
            this.init(iVec);
            return;
        }
        if (iVec.x < this.min.x) {
            this.min.x = iVec.x;
        } else if (iVec.x > this.max.x) {
            this.max.x = iVec.x;
        }
        if (iVec.y < this.min.y) {
            this.min.y = iVec.y;
        } else if (iVec.y > this.max.y) {
            this.max.y = iVec.y;
        }
        if (iVec.z < this.min.z) {
            this.min.z = iVec.z;
        } else if (iVec.z > this.max.z) {
            this.max.z = iVec.z;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compare(IObject iObject) {
        IObject iObject2 = iObject;
        synchronized (iObject2) {
            if (!iObject.visible()) {
                return;
            }
            if (iObject instanceof IPoint) {
                IPoint iPoint = (IPoint)iObject;
                this.compare(iPoint.get());
            } else if (iObject instanceof IPointR) {
                IPointR iPointR = (IPointR)iObject;
                this.compare(iPointR.get());
            } else if (iObject instanceof ICurve) {
                ICurve iCurve = (ICurve)iObject;
                for (int i = 0; i < iCurve.num(); ++i) {
                    this.compare(iCurve.cp(i).get());
                }
            } else if (iObject instanceof ICurveR) {
                ICurveR iCurveR = (ICurveR)iObject;
                for (int i = 0; i < iCurveR.num(); ++i) {
                    this.compare(iCurveR.cp(i).get());
                }
            } else if (iObject instanceof ISurface) {
                ISurface iSurface = (ISurface)iObject;
                for (int i = 0; i < iSurface.unum(); ++i) {
                    for (int j = 0; j < iSurface.vnum(); ++j) {
                        this.compare(iSurface.cp(i, j).get());
                    }
                }
            } else if (iObject instanceof ISurfaceR) {
                ISurfaceR iSurfaceR = (ISurfaceR)iObject;
                for (int i = 0; i < iSurfaceR.unum(); ++i) {
                    for (int j = 0; j < iSurfaceR.vnum(); ++j) {
                        this.compare(iSurfaceR.cp(i, j).get());
                    }
                }
            } else if (iObject instanceof IMesh) {
                IMesh iMesh = (IMesh)iObject;
                for (int i = 0; i < iMesh.vertexNum(); ++i) {
                    this.compare(iMesh.vertex(i).get());
                }
            } else if (iObject instanceof IMeshR) {
                IMeshR iMeshR = (IMeshR)iObject;
                for (int i = 0; i < iMeshR.vertexNum(); ++i) {
                    this.compare(iMeshR.vertex(i).get());
                }
            } else if (iObject instanceof IBrep) {
                IBrep iBrep = (IBrep)iObject;
                for (int i = 0; i < iBrep.surfaces.length; ++i) {
                    for (int j = 0; j < iBrep.surfaces[i].unum(); ++j) {
                        for (int k = 0; k < iBrep.surfaces[i].vnum(); ++k) {
                            this.compare(iBrep.surfaces[i].cp(j, k).get());
                        }
                    }
                }
            } else if (iObject instanceof IVectorObject) {
                IVectorObject iVectorObject = (IVectorObject)iObject;
                this.compare(iVectorObject.vec.get().cp(iVectorObject.root));
                this.compare(iVectorObject.root.get());
            } else if (iObject instanceof IText) {
                IText iText = (IText)iObject;
                this.compare(iText.corner(0, 0));
                this.compare(iText.corner(1, 0));
                this.compare(iText.corner(0, 1));
                this.compare(iText.corner(1, 1));
            }
        }
    }

    public void setObjects(IServer iServer) {
        this.setObjects(iServer.getAllObjects());
    }

    public synchronized void setObject(IObject iObject) {
        ArrayList<IObject> arrayList = new ArrayList<IObject>();
        arrayList.add(iObject);
        this.setObjects(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setObjects(ArrayList<IObject> arrayList) {
        if (arrayList.size() > 1000) {
            IOut.debug(10, "calculating bounding box of " + arrayList.size() + " objects");
        }
        this.init();
        Object object = arrayList;
        synchronized (object) {
            for (int i = 0; i < arrayList.size(); ++i) {
                IObject iObject = arrayList.get(i);
                if (!iObject.visible()) continue;
                this.compare(iObject);
            }
        }
        if (this.min != null && this.max != null && this.min.eq(this.max, IConfig.tolerance) && (this.min.x != this.max.x || this.min.y != this.max.y || this.min.z != this.max.z)) {
            IOut.err("bounding box is too small. minimum size is set");
            object = new IVec(IConfig.tolerance, IConfig.tolerance, IConfig.tolerance);
            ((IVec)object).div(2.0);
            this.max.set(this.min).add((IVec)object);
            this.min.sub((IVec)object);
        }
        if (arrayList.size() > 1000) {
            IOut.debug(10, "calculation of bounding box completed");
        }
        IOut.debug(100, this);
    }

    public String toString() {
        String string = "null";
        if (this.min != null) {
            string = this.min.toString();
        }
        String string2 = "null";
        if (this.max != null) {
            string2 = this.max.toString();
        }
        return string + "-" + string2;
    }
}

