/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IBounds;
import igeo.IGraphicI;
import igeo.IObject;
import igeo.IOut;
import igeo.gui.IComponent;
import igeo.gui.IGraphics;
import igeo.gui.IGraphicsGL;
import igeo.gui.IKeyEvent;
import igeo.gui.IMouseEvent;
import igeo.gui.IMouseWheelEvent;
import igeo.gui.INavigator;
import igeo.gui.IPane;
import igeo.gui.IPanel;
import igeo.gui.IPanelI;
import igeo.gui.IView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPaneLight
extends IComponent
implements IPane {
    public IPanelI parent;
    public IView view;
    public INavigator navigator;
    public float borderWidth = 0.0f;
    public Color borderColor = Color.gray;
    public Stroke borderStroke = new BasicStroke(this.borderWidth);

    public IPaneLight(int n, int n2, int n3, int n4, IView iView, IPanel iPanel) {
        super(n, n2, n3, n4);
        this.view = iView;
        this.parent = iPanel;
        iView.setPane(this);
        this.navigator = new INavigator(iView, this);
    }

    public IPaneLight(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void setPanel(IPanel iPanel) {
        this.parent = iPanel;
    }

    @Override
    public void setPanel(IPanelI iPanelI) {
        if (iPanelI instanceof IPanel) {
            this.parent = (IPanel)iPanelI;
        }
    }

    @Override
    public IPanelI getPanel() {
        return this.parent;
    }

    @Override
    public void setBorderWidth(float f) {
        this.borderWidth = f;
        this.borderStroke = new BasicStroke(this.borderWidth);
    }

    @Override
    public float getBorderWidth() {
        return this.borderWidth;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    @Override
    public void setBorderColor(int n, int n2, int n3, int n4) {
        this.borderColor = new Color(n, n2, n3, n4);
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public int getBorderColor() {
        return this.borderColor.getRGB();
    }

    @Override
    public INavigator navigator() {
        return this.navigator;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public void setView(IView iView) {
        this.view = iView;
        this.view.setPane(this);
        if (this.navigator == null) {
            this.navigator = new INavigator(this.view, this);
        } else {
            this.navigator.setView(this.view);
        }
    }

    @Override
    public IView getView() {
        return this.view;
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (this.view != null) {
            ArrayList<IGraphicI> arrayList = this.parent.getIG().server().graphicServer().getObjects(this.view);
            if (this.parent.getIG().server().graphicServer().bgImageFilename != null && iGraphics instanceof IGraphicsGL) {
                ((IGraphicsGL)iGraphics).setBGImage(this.parent.getIG().server().graphicServer().bgImageFilename);
                this.parent.getIG().server().graphicServer().bgImageFilename = null;
            }
            iGraphics.draw(arrayList, this.view);
        } else {
            IOut.err("view is null");
        }
    }

    @Override
    public void focus() {
        this.parent.setBounds();
        this.view.focus(this.parent.getBounds());
    }

    @Override
    public void focus(ArrayList<IObject> arrayList) {
        IBounds iBounds = new IBounds();
        iBounds.setObjects(arrayList);
        this.view.focus(iBounds);
    }

    @Override
    public void mousePressed(IMouseEvent iMouseEvent) {
        this.navigator.mousePressed(iMouseEvent);
    }

    @Override
    public void mouseReleased(IMouseEvent iMouseEvent) {
        this.navigator.mouseReleased(iMouseEvent);
    }

    @Override
    public void mouseClicked(IMouseEvent iMouseEvent) {
        this.navigator.mouseClicked(iMouseEvent);
    }

    @Override
    public void mouseEntered(IMouseEvent iMouseEvent) {
        this.navigator.mouseEntered(iMouseEvent);
    }

    @Override
    public void mouseExited(IMouseEvent iMouseEvent) {
        this.navigator.mouseExited(iMouseEvent);
    }

    @Override
    public void mouseMoved(IMouseEvent iMouseEvent) {
        this.navigator.mouseMoved(iMouseEvent);
    }

    @Override
    public void mouseDragged(IMouseEvent iMouseEvent) {
        this.navigator.mouseDragged(iMouseEvent);
    }

    @Override
    public void mouseWheelMoved(IMouseWheelEvent iMouseWheelEvent) {
        this.navigator.mouseWheelMoved(iMouseWheelEvent);
    }

    @Override
    public void keyPressed(IKeyEvent iKeyEvent) {
        this.navigator.keyPressed(iKeyEvent);
    }

    @Override
    public void keyReleased(IKeyEvent iKeyEvent) {
        this.navigator.keyReleased(iKeyEvent);
    }

    @Override
    public void keyTyped(IKeyEvent iKeyEvent) {
        this.navigator.keyTyped(iKeyEvent);
    }
}

