/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAttribute;
import igeo.IBrep;
import igeo.IColor;
import igeo.ICurve;
import igeo.IGeometry;
import igeo.IMaterial;
import igeo.IMesh;
import igeo.IObject;
import igeo.IPoint;
import igeo.IServer;
import igeo.IServerI;
import igeo.ISurface;
import java.awt.Color;
import java.util.ArrayList;

public class ILayer
extends IObject {
    public ArrayList<IObject> objects;

    public ILayer() {
        this.attribute = new IAttribute();
        this.objects = new ArrayList();
    }

    public ILayer(String string) {
        this();
        this.attribute.name = string;
    }

    public ILayer(IServerI iServerI) {
        super(iServerI);
        this.attribute = new IAttribute();
        this.objects = new ArrayList();
    }

    public ILayer(IServerI iServerI, String string) {
        this(iServerI);
        this.attribute.name = string;
    }

    public int num() {
        return this.objects.size();
    }

    public IObject get(int n) {
        return this.objects.get(n);
    }

    public synchronized ILayer add(IObject iObject) {
        if (!this.objects.contains(iObject)) {
            this.objects.add(iObject);
            if (iObject.layer() != this) {
                iObject.layer(this);
            }
        }
        return this;
    }

    public synchronized ILayer remove(int n) {
        this.objects.remove(n);
        return this;
    }

    public synchronized ILayer remove(IObject iObject) {
        this.objects.remove(iObject);
        return this;
    }

    public boolean contains(IObject iObject) {
        return this.objects.contains(iObject);
    }

    public ArrayList<IObject> allObjects() {
        return this.objects;
    }

    public ArrayList<IObject> getAllObjects() {
        return this.allObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPoint[] points() {
        ArrayList<IPoint> arrayList = new ArrayList<IPoint>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPoint)) continue;
                arrayList.add((IPoint)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IPoint[arrayList.size()]);
    }

    public IPoint[] getPoints() {
        return this.points();
    }

    public IPoint[] pts() {
        return this.points();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICurve[] curves() {
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ICurve)) continue;
                arrayList.add((ICurve)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ICurve[arrayList.size()]);
    }

    public ICurve[] getCurves() {
        return this.curves();
    }

    public ICurve[] crvs() {
        return this.curves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurface[] surfaces() {
        ArrayList<ISurface> arrayList = new ArrayList<ISurface>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ISurface)) continue;
                arrayList.add((ISurface)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ISurface[arrayList.size()]);
    }

    public ISurface[] getSurfaces() {
        return this.surfaces();
    }

    public ISurface[] srfs() {
        return this.surfaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMesh[] meshes() {
        ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IMesh)) continue;
                arrayList.add((IMesh)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IMesh[arrayList.size()]);
    }

    public IMesh[] getMeshes() {
        return this.meshes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBrep[] breps() {
        ArrayList<IBrep> arrayList = new ArrayList<IBrep>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IBrep)) continue;
                arrayList.add((IBrep)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IBrep[arrayList.size()]);
    }

    public IBrep[] getBreps() {
        return this.breps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGeometry[] geometries() {
        ArrayList<IGeometry> arrayList = new ArrayList<IGeometry>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IGeometry)) continue;
                arrayList.add((IGeometry)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IGeometry[arrayList.size()]);
    }

    public IGeometry[] getGeometries() {
        return this.geometries();
    }

    public IGeometry[] geos() {
        return this.geometries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject[] objects(Class clazz) {
        ArrayList<IObject> arrayList = new ArrayList<IObject>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!clazz.isInstance(this.objects.get(i))) continue;
                arrayList.add(this.objects.get(i));
            }
        }
        return arrayList.toArray(new IObject[arrayList.size()]);
    }

    public IObject[] getObjects(Class clazz) {
        return this.objects(clazz);
    }

    public IObject[] objs(Class clazz) {
        return this.objects(clazz);
    }

    public IObject[] objects() {
        return this.objects.toArray(new IObject[this.objects.size()]);
    }

    public IObject[] getObjects() {
        return this.objects();
    }

    public IObject[] objs() {
        return this.objects();
    }

    public synchronized IPoint point(int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IPoint) || n != n2++) continue;
            return (IPoint)this.objects.get(i);
        }
        return null;
    }

    public IPoint getPoint(int n) {
        return this.point(n);
    }

    public IPoint pt(int n) {
        return this.point(n);
    }

    public synchronized ICurve curve(int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof ICurve) || n != n2++) continue;
            return (ICurve)this.objects.get(i);
        }
        return null;
    }

    public ICurve getCurve(int n) {
        return this.curve(n);
    }

    public ICurve crv(int n) {
        return this.curve(n);
    }

    public synchronized ISurface surface(int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof ISurface) || n != n2++) continue;
            return (ISurface)this.objects.get(i);
        }
        return null;
    }

    public ISurface getSurface(int n) {
        return this.surface(n);
    }

    public ISurface srf(int n) {
        return this.surface(n);
    }

    public synchronized IMesh mesh(int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IMesh) || n != n2++) continue;
            return (IMesh)this.objects.get(i);
        }
        return null;
    }

    public IMesh getMesh(int n) {
        return this.mesh(n);
    }

    public synchronized IBrep brep(int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IBrep) || n != n2++) continue;
            return (IBrep)this.objects.get(i);
        }
        return null;
    }

    public IBrep getBrep(int n) {
        return this.brep(n);
    }

    public synchronized IGeometry geometry(int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IGeometry) || n != n2++) continue;
            return (IGeometry)this.objects.get(i);
        }
        return null;
    }

    public IGeometry getGeometry(int n) {
        return this.geometry(n);
    }

    public IGeometry geo(int n) {
        return this.geometry(n);
    }

    public synchronized IObject object(Class clazz, int n) {
        int n2 = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!clazz.isInstance(this.objects.get(i)) || n != n2++) continue;
            return this.objects.get(i);
        }
        return null;
    }

    public IObject getObject(Class clazz, int n) {
        return this.object(clazz, n);
    }

    public IObject obj(Class clazz, int n) {
        return this.object(clazz, n);
    }

    public synchronized IObject object(int n) {
        return n < 0 || n >= this.objects.size() ? null : this.objects.get(n);
    }

    public IObject getObject(int n) {
        return this.object(n);
    }

    public IObject obj(int n) {
        return this.object(n);
    }

    public synchronized int pointNum() {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IPoint)) continue;
            ++n;
        }
        return n;
    }

    public int getPointNum() {
        return this.pointNum();
    }

    public int ptNum() {
        return this.pointNum();
    }

    public synchronized int curveNum() {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof ICurve)) continue;
            ++n;
        }
        return n;
    }

    public int getCurveNum() {
        return this.curveNum();
    }

    public int crvNum() {
        return this.curveNum();
    }

    public synchronized int surfaceNum() {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof ISurface)) continue;
            ++n;
        }
        return n;
    }

    public int getSurfaceNum() {
        return this.surfaceNum();
    }

    public int srfNum() {
        return this.surfaceNum();
    }

    public synchronized int meshNum() {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IMesh)) continue;
            ++n;
        }
        return n;
    }

    public int getMeshNum() {
        return this.meshNum();
    }

    public synchronized int brepNum() {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IBrep)) continue;
            ++n;
        }
        return n;
    }

    public int getBrepNum() {
        return this.brepNum();
    }

    public synchronized int geometryNum() {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof IGeometry)) continue;
            ++n;
        }
        return n;
    }

    public int getGeometryNum() {
        return this.geometryNum();
    }

    public int geoNum() {
        return this.geometryNum();
    }

    public synchronized int objectNum(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!clazz.isInstance(this.objects.get(i))) continue;
            ++n;
        }
        return n;
    }

    public int getObjectNum(Class clazz) {
        return this.objectNum(clazz);
    }

    public int objNum(Class clazz) {
        return this.objectNum(clazz);
    }

    public synchronized int objectNum() {
        return this.objects.size();
    }

    public int getObjectNum() {
        return this.objectNum();
    }

    public int objNum() {
        return this.objectNum();
    }

    @Override
    public ILayer name(String string) {
        this.attribute.name = string;
        return this;
    }

    @Override
    public boolean visible() {
        return this.attribute.visible();
    }

    public ILayer setVisible(boolean bl) {
        return this.visible(bl);
    }

    public ILayer visible(boolean bl) {
        this.attribute.visible(bl);
        if (this.attribute.visible()) {
            this.show();
        } else {
            this.hide();
        }
        return this;
    }

    @Override
    public ILayer hide() {
        super.hide();
        this.attribute.hide();
        for (IObject iObject : this.objects) {
            iObject.hide();
        }
        return this;
    }

    @Override
    public ILayer show() {
        super.show();
        this.attribute.show();
        for (IObject iObject : this.objects) {
            iObject.show();
        }
        return this;
    }

    @Override
    public IColor clr() {
        return this.attribute.clr();
    }

    public Color color() {
        return this.attribute.color();
    }

    @Override
    public Color awtColor() {
        return this.attribute.awtColor();
    }

    @Override
    public ILayer clr(IColor iColor) {
        this.attribute.clr(iColor);
        return this;
    }

    @Override
    public ILayer clr(IColor iColor, int n) {
        this.attribute.clr(iColor, n);
        return this;
    }

    @Override
    public ILayer clr(IColor iColor, float f) {
        this.attribute.clr(iColor, f);
        return this;
    }

    @Override
    public ILayer clr(IColor iColor, double d) {
        this.attribute.clr(iColor, d);
        return this;
    }

    @Override
    public ILayer clr(IObject iObject) {
        super.clr(iObject);
        return this;
    }

    @Override
    public ILayer clr(Color color) {
        this.attribute.clr(color);
        return this;
    }

    @Override
    public ILayer clr(Color color, int n) {
        this.attribute.clr(color, n);
        return this;
    }

    @Override
    public ILayer clr(Color color, float f) {
        this.attribute.clr(color, f);
        return this;
    }

    @Override
    public ILayer clr(Color color, double d) {
        this.attribute.clr(color, d);
        return this;
    }

    @Override
    public ILayer clr(int n) {
        this.attribute.clr(n);
        return this;
    }

    @Override
    public ILayer clr(float f) {
        this.attribute.clr(f);
        return this;
    }

    @Override
    public ILayer clr(double d) {
        this.attribute.clr(d);
        return this;
    }

    @Override
    public ILayer clr(int n, int n2) {
        this.attribute.clr(n, n2);
        return this;
    }

    @Override
    public ILayer clr(float f, float f2) {
        this.attribute.clr(f, f2);
        return this;
    }

    @Override
    public ILayer clr(double d, double d2) {
        this.attribute.clr(d, d2);
        return this;
    }

    @Override
    public ILayer clr(int n, int n2, int n3) {
        this.attribute.clr(n, n2, n3);
        return this;
    }

    @Override
    public ILayer clr(float f, float f2, float f3) {
        this.attribute.clr(f, f2, f3);
        return this;
    }

    @Override
    public ILayer clr(double d, double d2, double d3) {
        this.attribute.clr(d, d2, d3);
        return this;
    }

    @Override
    public ILayer clr(int n, int n2, int n3, int n4) {
        this.attribute.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public ILayer clr(float f, float f2, float f3, float f4) {
        this.attribute.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public ILayer clr(double d, double d2, double d3, double d4) {
        this.attribute.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public ILayer hsb(float f, float f2, float f3, float f4) {
        this.attribute.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public ILayer hsb(double d, double d2, double d3, double d4) {
        this.attribute.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public ILayer hsb(float f, float f2, float f3) {
        this.attribute.hsb(f, f2, f3);
        return this;
    }

    @Override
    public ILayer hsb(double d, double d2, double d3) {
        this.attribute.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IColor getColor() {
        return this.clr();
    }

    @Override
    public Color getAWTColor() {
        return this.color();
    }

    @Override
    public ILayer setColor(IColor iColor) {
        return this.clr(iColor);
    }

    @Override
    public ILayer setColor(IColor iColor, int n) {
        return this.clr(iColor, n);
    }

    @Override
    public ILayer setColor(IColor iColor, float f) {
        return this.clr(iColor, f);
    }

    @Override
    public ILayer setColor(IColor iColor, double d) {
        return this.clr(iColor, d);
    }

    @Override
    public ILayer setColor(Color color) {
        return this.clr(color);
    }

    @Override
    public ILayer setColor(Color color, int n) {
        return this.clr(color, n);
    }

    @Override
    public ILayer setColor(Color color, float f) {
        return this.clr(color, f);
    }

    @Override
    public ILayer setColor(Color color, double d) {
        return this.clr(color, d);
    }

    @Override
    public ILayer setColor(int n) {
        return this.clr(n);
    }

    @Override
    public ILayer setColor(float f) {
        return this.clr(f);
    }

    @Override
    public ILayer setColor(double d) {
        return this.clr(d);
    }

    @Override
    public ILayer setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    @Override
    public ILayer setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    @Override
    public ILayer setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    @Override
    public ILayer setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    @Override
    public ILayer setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    @Override
    public ILayer setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    @Override
    public ILayer setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    @Override
    public ILayer setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    @Override
    public ILayer setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    @Override
    public ILayer setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    @Override
    public ILayer setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    @Override
    public ILayer setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    @Override
    public ILayer setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }

    @Override
    public ILayer weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public ILayer weight(float f) {
        super.weight(f);
        return this;
    }

    public ILayer setMaterial(IMaterial iMaterial) {
        this.attribute.material = iMaterial;
        return this;
    }
}

