/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBoolI;
import igeo.IColor;
import igeo.IComparator;
import igeo.IConfig;
import igeo.IDoubleI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IOut;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import java.awt.Color;
import java.util.ArrayList;

public class IVertex
implements IVecI {
    public ArrayList<IEdge> edges;
    public ArrayList<IFace> faces;
    public ArrayList<IVertex> linkedVertices;
    public IVecI pos;
    public IVecI normal;
    public IVec2I texture;
    public IColor clr;
    public int index = -1;

    public IVertex() {
        this.pos = new IVec();
        this.init();
    }

    public IVertex(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.init();
    }

    public IVertex(IVec iVec) {
        this.pos = iVec.cp();
        this.init();
    }

    public IVertex(IVec4 iVec4) {
        this.pos = iVec4.cp();
        this.init();
    }

    public IVertex(IVecI iVecI) {
        this.pos = iVecI.cp();
        this.init();
    }

    public IVertex(IVertex iVertex) {
        int n;
        this.edges = new ArrayList();
        for (n = 0; n < iVertex.edges.size(); ++n) {
            this.edges.add(iVertex.edges.get(n));
        }
        this.faces = new ArrayList();
        for (n = 0; n < iVertex.faces.size(); ++n) {
            this.faces.add(iVertex.faces.get(n));
        }
        this.linkedVertices = new ArrayList();
        for (n = 0; n < iVertex.linkedVertices.size(); ++n) {
            this.linkedVertices.add(iVertex.linkedVertices.get(n));
        }
        this.pos = iVertex.pos.dup();
        if (iVertex.normal != null) {
            this.normal = iVertex.normal.dup();
        }
        if (iVertex.texture != null) {
            this.texture = iVertex.texture.dup();
        }
    }

    public void init() {
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        this.linkedVertices = new ArrayList();
    }

    public void del() {
        int n;
        for (n = 0; n < this.faces.size(); ++n) {
            this.faces.get(n).del();
            --n;
        }
        for (n = 0; n < this.edges.size(); ++n) {
            this.edges.get(n).del();
            --n;
        }
    }

    public void del(IEdge iEdge) {
        this.edges.remove(iEdge);
        IVertex iVertex = iEdge.vertices[0];
        if (iVertex == this) {
            iVertex = iEdge.vertices[1];
        }
        this.linkedVertices.remove(iVertex);
    }

    @Override
    public double x() {
        return this.pos.x();
    }

    @Override
    public double y() {
        return this.pos.y();
    }

    @Override
    public double z() {
        return this.pos.z();
    }

    @Override
    public IVertex x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IVertex y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IVertex z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IVertex x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IVertex y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IVertex z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IVertex x(IVecI iVecI) {
        this.pos.x(iVecI);
        return this;
    }

    @Override
    public IVertex y(IVecI iVecI) {
        this.pos.y(iVecI);
        return this;
    }

    @Override
    public IVertex z(IVecI iVecI) {
        this.pos.z(iVecI);
        return this;
    }

    @Override
    public IVertex x(IVec2I iVec2I) {
        this.pos.x(iVec2I);
        return this;
    }

    @Override
    public IVertex y(IVec2I iVec2I) {
        this.pos.y(iVec2I);
        return this;
    }

    @Override
    public double x(ISwitchE iSwitchE) {
        return this.pos.x(iSwitchE);
    }

    @Override
    public double y(ISwitchE iSwitchE) {
        return this.pos.y(iSwitchE);
    }

    @Override
    public double z(ISwitchE iSwitchE) {
        return this.pos.z(iSwitchE);
    }

    @Override
    public IDoubleI x(ISwitchR iSwitchR) {
        return this.pos.x(iSwitchR);
    }

    @Override
    public IDoubleI y(ISwitchR iSwitchR) {
        return this.pos.y(iSwitchR);
    }

    @Override
    public IDoubleI z(ISwitchR iSwitchR) {
        return this.pos.z(iSwitchR);
    }

    @Override
    public IVec get() {
        return this.pos.get();
    }

    public IVecI pos() {
        return this.pos;
    }

    @Override
    public IVertex dup() {
        return new IVertex(this);
    }

    @Override
    public IVec2I to2d() {
        return this.pos.to2d();
    }

    @Override
    public IVec2I to2d(IVecI iVecI) {
        return this.pos.to2d(iVecI);
    }

    @Override
    public IVec2I to2d(IVecI iVecI, IVecI iVecI2) {
        return this.pos.to2d(iVecI, iVecI2);
    }

    @Override
    public IVec2I to2d(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.pos.to2d(iVecI, iVecI2, iVecI3);
    }

    @Override
    public IVec4I to4d() {
        return this.pos.to4d();
    }

    @Override
    public IVec4I to4d(double d) {
        return this.pos.to4d(d);
    }

    @Override
    public IVec4I to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    @Override
    public IDoubleI getX() {
        return this.pos.getX();
    }

    @Override
    public IDoubleI getY() {
        return this.pos.getY();
    }

    @Override
    public IDoubleI getZ() {
        return this.pos.getZ();
    }

    @Override
    public IVertex set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IVertex set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IVertex set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVertex add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IVertex add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVertex add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IVertex sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IVertex sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVertex sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IVertex mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IVertex mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IVertex div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IVertex div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IVertex neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IVertex rev() {
        return this.neg();
    }

    @Override
    public IVertex flip() {
        return this.neg();
    }

    @Override
    public IVertex zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IVertex add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IVertex add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVertex add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IVertex add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    @Override
    public double dot(double d, double d2, double d3) {
        return this.pos.dot(d, d2, d3);
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    @Override
    public IVecI cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    @Override
    public IVecI cross(double d, double d2, double d3) {
        return this.pos.cross(d, d2, d3);
    }

    @Override
    public double len() {
        return this.pos.len();
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    @Override
    public IDoubleI len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    @Override
    public double len2() {
        return this.pos.len2();
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    @Override
    public IDoubleI len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    @Override
    public IVertex len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IVertex len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IVertex unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    @Override
    public double dist(double d, double d2, double d3) {
        return this.pos.dist(d, d2, d3);
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    @Override
    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    @Override
    public double dist2(double d, double d2, double d3) {
        return this.pos.dist2(d, d2, d3);
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    @Override
    public boolean eq(double d, double d2, double d3) {
        return this.pos.eq(d, d2, d3);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    @Override
    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    @Override
    public boolean eq(double d, double d2, double d3, double d4) {
        return this.pos.eq(d, d2, d3, d4);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    @Override
    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    @Override
    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    @Override
    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    @Override
    public boolean eqX(double d) {
        return this.pos.eqX(d);
    }

    @Override
    public boolean eqY(double d) {
        return this.pos.eqY(d);
    }

    @Override
    public boolean eqZ(double d) {
        return this.pos.eqZ(d);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    @Override
    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    @Override
    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    @Override
    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    @Override
    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    @Override
    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    @Override
    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    @Override
    public boolean eqX(double d, double d2) {
        return this.pos.eqX(d, d2);
    }

    @Override
    public boolean eqY(double d, double d2) {
        return this.pos.eqY(d, d2);
    }

    @Override
    public boolean eqZ(double d, double d2) {
        return this.pos.eqZ(d, d2);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    @Override
    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    @Override
    public double angle(double d, double d2, double d3) {
        return this.pos.angle(d, d2, d3);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    @Override
    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    @Override
    public double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.angle(d, d2, d3, d4, d5, d6);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    @Override
    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    @Override
    public IVertex rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IVertex rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IVertex rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVertex rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IVertex rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVertex rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IVertex rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IVertex rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IVertex rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVertex rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVertex rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IVertex rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IVertex rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVertex rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IVertex rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IVertex rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IVertex rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVertex scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IVertex scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IVertex scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVertex scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IVertex scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVertex scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IVertex scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVertex scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVertex scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IVertex scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IVertex scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IVertex ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IVertex ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IVertex ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVertex ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVertex mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IVertex mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IVertex mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVertex mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVertex shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVertex shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVertex shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVertex shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVertex shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IVertex shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVertex shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IVertex shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVertex shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IVertex shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVertex shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IVertex shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVertex shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IVertex shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVertex shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IVertex shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVertex translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IVertex translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVertex translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IVertex transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IVertex transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IVertex transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVertex transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IVertex mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVertex mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVertex mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVertex cp() {
        return this.dup();
    }

    @Override
    public IVertex cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IVertex cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVertex cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVecI dif(IVecI iVecI) {
        return this.pos.dif(iVecI);
    }

    @Override
    public IVecI dif(double d, double d2, double d3) {
        return this.pos.dif(d, d2, d3);
    }

    @Override
    public IVecI diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    @Override
    public IVecI diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    @Override
    public IVecI mid(IVecI iVecI) {
        return this.pos.mid(iVecI);
    }

    @Override
    public IVecI mid(double d, double d2, double d3) {
        return this.pos.mid(d, d2, d3);
    }

    @Override
    public IVecI sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVecI sum(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IVecI sum(IVecI ... iVecIArray) {
        return this.pos.sum(iVecIArray);
    }

    @Override
    public IVecI bisect(IVecI iVecI) {
        return this.pos.bisect(iVecI);
    }

    @Override
    public IVecI bisect(double d, double d2, double d3) {
        return this.pos.bisect(d, d2, d3);
    }

    @Override
    public IVecI sum(IVecI iVecI, double d, double d2) {
        return this.pos.sum(iVecI, d, d2);
    }

    @Override
    public IVecI sum(IVecI iVecI, double d) {
        return this.pos.sum(iVecI, d);
    }

    @Override
    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.pos.sum(iVecI, iDoubleI, iDoubleI2);
    }

    @Override
    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.sum(iVecI, iDoubleI);
    }

    @Override
    public IVecI nml(IVecI iVecI) {
        return this.pos.nml(iVecI);
    }

    @Override
    public IVecI nml(double d, double d2, double d3) {
        return this.pos.nml(d, d2, d3);
    }

    @Override
    public IVecI nml(IVecI iVecI, IVecI iVecI2) {
        return this.pos.nml(iVecI, iVecI2);
    }

    @Override
    public IVecI nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.nml(d, d2, d3, d4, d5, d6);
    }

    public IVec getAverageNormal() {
        if (this.faces == null || this.faces.size() == 0) {
            return new IVec(0.0, 0.0, 1.0);
        }
        IVec iVec = new IVec(0.0, 0.0, 0.0);
        for (int i = 0; i < this.faces.size(); ++i) {
            iVec.add(this.faces.get(i).getAverageNormal());
        }
        iVec.unit();
        return iVec;
    }

    public void calcNormal() {
        this.normal = this.getAverageNormal();
    }

    public IVecI normal() {
        return this.nml();
    }

    public IVecI nml() {
        if (this.normal == null) {
            this.calcNormal();
        }
        return this.normal;
    }

    public IVecI getNormal() {
        return this.nml();
    }

    public IVecI getNml() {
        return this.nml();
    }

    public IVertex setNormal(IVecI iVecI) {
        return this.setNml(iVecI);
    }

    public IVertex setNormal(double d, double d2, double d3) {
        return this.setNml(d, d2, d3);
    }

    public IVertex setNml(IVecI iVecI) {
        this.normal = iVecI;
        return this;
    }

    public IVertex setNml(double d, double d2, double d3) {
        return this.setNml(new IVec(d, d2, d3));
    }

    @Override
    public boolean isValid() {
        if (this.pos == null) {
            return false;
        }
        return this.pos.isValid();
    }

    public IVec2I texture() {
        return this.texture;
    }

    public IVertex texture(IVec2I iVec2I) {
        this.texture = iVec2I;
        return this;
    }

    public IVertex texture(double d, double d2) {
        this.texture(new IVec2(d, d2));
        return this;
    }

    public void addEdge(IEdge iEdge) {
        this.edges.add(iEdge);
        if (iEdge.getVertex(0) == this) {
            this.linkedVertices.add(iEdge.getVertex(1));
        } else {
            this.linkedVertices.add(iEdge.getVertex(0));
        }
    }

    public IEdge getEdge(int n) {
        return this.edge(n);
    }

    public IEdge edge(int n) {
        return this.edges.get(n);
    }

    public int edgeNum() {
        return this.edges.size();
    }

    public IEdge getEdgeTo(IVertex iVertex) {
        for (int i = 0; i < this.edges.size(); ++i) {
            IEdge iEdge = this.edges.get(i);
            if (iEdge.getOtherVertex(this) != iVertex) continue;
            return iEdge;
        }
        return null;
    }

    public IEdge createEdgeTo(IVertex iVertex) {
        IEdge iEdge = this.getEdgeTo(iVertex);
        if (iEdge == null) {
            iEdge = new IEdge(this, iVertex);
        }
        return iEdge;
    }

    public void addFace(IFace iFace) {
        this.faces.add(iFace);
    }

    public IFace getFace(int n) {
        return this.face(n);
    }

    public IFace face(int n) {
        return this.faces.get(n);
    }

    public int faceNum() {
        return this.faces.size();
    }

    public IVertex linkedVertex(int n) {
        return this.linkedVertices.get(n);
    }

    public int linkedVertexNum() {
        return this.linkedVertices.size();
    }

    public void replaceLinkedVertex(IVertex iVertex, IVertex iVertex2) {
        int n = this.linkedVertices.indexOf(iVertex);
        if (n < 0) {
            IOut.err("no such linked vertex in this vertex");
            return;
        }
        this.linkedVertices.set(n, iVertex2);
    }

    public void replaceVertex(IVertex iVertex) {
        int n;
        int n2;
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        for (int i = 0; i < this.edges.size(); ++i) {
            IVertex iVertex2 = this.edges.get(i).getOtherVertex(this);
            for (int j = 0; j < iVertex.edges.size(); ++j) {
                IVertex iVertex3 = iVertex.edges.get(j).getOtherVertex(iVertex);
                if (iVertex2 != iVertex3 || arrayList.contains(iVertex2)) continue;
                arrayList.add(iVertex2);
            }
        }
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        for (n2 = 0; n2 < this.edges.size(); ++n2) {
            IEdge iEdge = this.edges.get(n2);
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                if (!iEdge.contains((IVertex)arrayList.get(n))) continue;
                bl = true;
            }
            if (iEdge.contains(iVertex)) {
                bl = true;
            }
            if (bl) {
                arrayList2.add(iEdge);
                continue;
            }
            iEdge.replaceVertex(this, iVertex);
            iVertex.addEdge(iEdge);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            ((IEdge)arrayList2.get(n2)).del();
        }
        for (n2 = 0; n2 < this.linkedVertices.size(); ++n2) {
            IVertex iVertex4 = this.linkedVertices.get(n2);
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                if (iVertex4 != arrayList.get(n)) continue;
                bl = true;
            }
            if (iVertex4 == iVertex) {
                bl = true;
            }
            if (bl) continue;
            iVertex4.replaceLinkedVertex(this, iVertex);
        }
        for (n2 = 0; n2 < this.faces.size(); ++n2) {
            IFace iFace = this.faces.get(n2);
            iFace.replaceVertex(this, iVertex);
            iVertex.addFace(iFace);
        }
    }

    public IEdge[] getOtherEdges(IEdge iEdge) {
        IEdge[] iEdgeArray = new IEdge[this.edges.size() - 1];
        if (!this.edges.contains(iEdge)) {
            IOut.err("no such edge in this vertex");
            return null;
        }
        int n = 0;
        for (int i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i) == iEdge) continue;
            iEdgeArray[n] = this.edges.get(i);
            ++n;
        }
        return iEdgeArray;
    }

    public String toString() {
        return "IVertex: " + this.pos + " (normal=" + this.normal + ", texture=" + this.texture + ")";
    }

    public static ArrayList<IVertex> sortByEdge(ArrayList<IVertex> arrayList, int n) {
        int n2;
        if (n < 0 || n >= arrayList.size()) {
            IOut.err("start index is out of range.");
            return null;
        }
        int n3 = arrayList.size();
        ArrayList<IVertex> arrayList2 = new ArrayList<IVertex>();
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = false;
        }
        arrayList2.add(arrayList.get(n));
        blArray[n] = true;
        for (n2 = 0; arrayList2.size() < arrayList.size() && n2 < arrayList.size() * 2; ++n2) {
            int n4 = IVertex.findLinkedVertexInArray(arrayList2.get(arrayList2.size() - 1), arrayList, blArray);
            if (n4 < 0) {
                IOut.err("given vertices are not connected");
                return arrayList2;
            }
            arrayList2.add(arrayList.get(n4));
            blArray[n4] = true;
        }
        if (arrayList2.size() == arrayList.size()) {
            return arrayList2;
        }
        IOut.err("sort failed");
        return arrayList2;
    }

    public static ArrayList<IVertex> sortByEdge(ArrayList<IVertex> arrayList, IVertex iVertex) {
        return IVertex.sortByEdge(arrayList, arrayList.indexOf(iVertex));
    }

    public static ArrayList<IVertex> sortByEdge(ArrayList<IVertex> arrayList) {
        return IVertex.sortByEdge(arrayList, 0);
    }

    public static int findLinkedVertexInArray(IVertex iVertex, ArrayList<IVertex> arrayList, boolean[] blArray) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (blArray[i] || !iVertex.linkedVertices.contains(arrayList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public IColor clr() {
        return this.clr;
    }

    public IVertex clr(IColor iColor) {
        this.clr = iColor;
        return this;
    }

    public IVertex clr(IColor iColor, int n) {
        return this.clr(new IColor(iColor, n));
    }

    public IVertex clr(IColor iColor, float f) {
        return this.clr(new IColor(iColor, f));
    }

    public IVertex clr(IColor iColor, double d) {
        return this.clr(new IColor(iColor, d));
    }

    public IVertex clr(IObject iObject) {
        this.clr(iObject.clr());
        return this;
    }

    public IVertex clr(IVertex iVertex) {
        this.clr(iVertex.clr());
        return this;
    }

    public IVertex clr(Color color) {
        return this.clr(new IColor(color));
    }

    public IVertex clr(Color color, int n) {
        return this.clr(new IColor(color), n);
    }

    public IVertex clr(Color color, float f) {
        return this.clr(new IColor(color), f);
    }

    public IVertex clr(Color color, double d) {
        return this.clr(new IColor(color), d);
    }

    public IColor getColor() {
        return this.clr();
    }

    public IVertex clr(int n) {
        return this.clr(new IColor(n));
    }

    public IVertex clr(double d) {
        return this.clr(new IColor(d));
    }

    public IVertex clr(float f) {
        return this.clr(new IColor(f));
    }

    public IVertex clr(int n, int n2) {
        return this.clr(new IColor(n, n2));
    }

    public IVertex clr(double d, double d2) {
        return this.clr(new IColor(d, d2));
    }

    public IVertex clr(float f, float f2) {
        return this.clr(new IColor(f, f2));
    }

    public IVertex clr(int n, int n2, int n3) {
        return this.clr(new IColor(n, n2, n3));
    }

    public IVertex clr(double d, double d2, double d3) {
        return this.clr(new IColor(d, d2, d3));
    }

    public IVertex clr(float f, float f2, float f3) {
        return this.clr(new IColor(f, f2, f3));
    }

    public IVertex clr(int n, int n2, int n3, int n4) {
        return this.clr(new IColor(n, n2, n3, n4));
    }

    public IVertex clr(double d, double d2, double d3, double d4) {
        return this.clr(new IColor(d, d2, d3, d4));
    }

    public IVertex clr(float f, float f2, float f3, float f4) {
        return this.clr(new IColor(f, f2, f3, f4));
    }

    public IVertex hsb(double d, double d2, double d3, double d4) {
        return this.clr(IColor.hsb(d, d2, d3, d4));
    }

    public IVertex hsb(float f, float f2, float f3, float f4) {
        return this.clr(IColor.hsb(f, f2, f3, f4));
    }

    public IVertex hsb(double d, double d2, double d3) {
        return this.clr(IColor.hsb(d, d2, d3));
    }

    public IVertex hsb(float f, float f2, float f3) {
        return this.clr(IColor.hsb(f, f2, f3));
    }

    public static class ZYXComparator
    implements IComparator<IVertex> {
        @Override
        public int compare(IVertex iVertex, IVertex iVertex2) {
            IVec iVec = iVertex.pos.get();
            IVec iVec2 = iVertex2.pos.get();
            if (iVec.z < iVec2.z - IConfig.tolerance) {
                return 1;
            }
            if (iVec.z > iVec2.z + IConfig.tolerance) {
                return -1;
            }
            if (iVec.y < iVec2.y - IConfig.tolerance) {
                return 1;
            }
            if (iVec.y > iVec2.y + IConfig.tolerance) {
                return -1;
            }
            if (iVec.x < iVec2.x - IConfig.tolerance) {
                return 1;
            }
            if (iVec.x > iVec2.x + IConfig.tolerance) {
                return -1;
            }
            return 0;
        }
    }

    public static class ZComparator
    implements IComparator<IVertex> {
        @Override
        public int compare(IVertex iVertex, IVertex iVertex2) {
            double d;
            double d2 = iVertex.pos.z();
            if (d2 < (d = iVertex2.pos.z())) {
                return 1;
            }
            if (d2 > d) {
                return -1;
            }
            return 0;
        }
    }
}

