/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import java.io.PrintStream;

public class IOut {
    public static PrintStream ps = System.out;
    public static PrintStream err = System.err;
    public static PrintStream debug = System.out;
    public static boolean printPrefix = true;
    public static boolean enabled = true;
    public static boolean errEnabled = true;
    public static boolean debugEnabled = true;
    public static int debugLevel = 0;
    public static boolean printErrorPrefix = true;
    public static boolean printDebugPrefix = true;
    public static String errPrefix = "ERROR: ";
    public static String debugPrefix = "DEBUG: ";
    public static int stackDepth = 1;

    public static void setStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void setErrStream(PrintStream printStream) {
        err = printStream;
    }

    public static void enablePrint() {
        enabled = true;
    }

    public static void disablePrint() {
        enabled = false;
    }

    public static void enableErr() {
        errEnabled = true;
    }

    public static void disableErr() {
        errEnabled = false;
    }

    public static void enableDebug() {
        debugEnabled = true;
    }

    public static void disableDebug() {
        debugEnabled = false;
    }

    public static void enablePrefix() {
        printPrefix = true;
    }

    public static void disablePrefix() {
        printPrefix = false;
    }

    public static void enableErrorPrefix() {
        printErrorPrefix = true;
    }

    public static void disableErrorPrefix() {
        printErrorPrefix = false;
    }

    public static void enableDebugPrefix() {
        printDebugPrefix = true;
    }

    public static void disableDebugPrefix() {
        printDebugPrefix = false;
    }

    public static void debugLevel(int n) {
        debugLevel = n;
    }

    public static int debugLevel() {
        return debugLevel;
    }

    protected static void printCurrentStack(PrintStream printStream) {
        String string = IOut.currentStack(4);
        printStream.print(string + ": ");
    }

    protected static void printCurrentStack(PrintStream printStream, int n) {
        String string = IOut.currentStack(4 + n);
        printStream.print(string + ": ");
    }

    protected static void printStack(PrintStream printStream, StackTraceElement stackTraceElement) {
        printStream.print(IOut.stack(stackTraceElement) + ": ");
    }

    public static String currentStack(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length > n) {
            if (stackDepth == 1) {
                return IOut.stack(stackTraceElementArray[n]);
            }
            String string = "";
            for (int i = stackDepth - 1; i >= 0; --i) {
                if (i + n >= stackTraceElementArray.length) continue;
                if (string.length() > 0) {
                    string = string + "=>";
                }
                string = string + IOut.stack(stackTraceElementArray[i + n]);
            }
            return string;
        }
        return "";
    }

    public static String stack(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string + "." + stackTraceElement.getMethodName();
    }

    public static void printStack(PrintStream printStream) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null) {
            printStream.println("printStack: ");
            for (int i = 3; i < stackTraceElementArray.length; ++i) {
                printStream.print("  ");
                IOut.printStack(printStream, stackTraceElementArray[i]);
                printStream.println();
            }
        }
    }

    public static void printStack() {
        IOut.printStack(ps);
    }

    public static void p(Object object) {
        if (enabled) {
            if (printPrefix) {
                IOut.printCurrentStack(ps);
            }
            ps.println(object);
        }
    }

    public static void p() {
        if (enabled) {
            if (printPrefix) {
                IOut.printCurrentStack(ps);
            }
            ps.println();
        }
    }

    public static void printlnWithOffset(Object object, int n) {
        if (enabled) {
            if (printPrefix) {
                IOut.printCurrentStack(ps, n);
            }
            ps.println(object);
        }
    }

    public static void printlnWithOffset(int n) {
        if (enabled) {
            if (printPrefix) {
                IOut.printCurrentStack(ps, n);
            }
            ps.println();
        }
    }

    public static void err(Object object) {
        if (errEnabled) {
            if (printErrorPrefix) {
                IOut.printCurrentStack(err);
                err.print(errPrefix);
            }
            err.println(object);
        }
    }

    public static void err() {
        if (errEnabled) {
            if (printErrorPrefix) {
                IOut.printCurrentStack(err);
                err.print(errPrefix);
            }
            err.println();
        }
    }

    public static void error(Object object) {
        if (errEnabled) {
            err.print(object);
        }
    }

    public static void errWithOffset(Object object, int n) {
        if (errEnabled) {
            if (printErrorPrefix) {
                IOut.printCurrentStack(err, n);
                err.print(errPrefix);
            }
            err.println(object);
        }
    }

    public static void errWithOffset(int n) {
        if (errEnabled) {
            if (printErrorPrefix) {
                IOut.printCurrentStack(err, n);
                err.print(errPrefix);
            }
            err.println();
        }
    }

    public static void debug(int n, Object object) {
        if (debugEnabled && (debugLevel < 0 || n <= debugLevel)) {
            if (printDebugPrefix) {
                IOut.printCurrentStack(debug);
                debug.print(debugPrefix);
            }
            debug.println(object);
        }
    }

    public static void debug(int n) {
        if (debugEnabled && (debugLevel < 0 || n <= debugLevel)) {
            if (printDebugPrefix) {
                IOut.printCurrentStack(debug);
                debug.print(debugPrefix);
            }
            debug.println();
        }
    }

    public static void println(Object object) {
        if (enabled) {
            ps.println(object);
        }
    }

    public static void println(boolean bl) {
        if (enabled) {
            ps.println(bl);
        }
    }

    public static void println(char c) {
        if (enabled) {
            ps.println(c);
        }
    }

    public static void println(char[] cArray) {
        if (enabled) {
            ps.println(cArray);
        }
    }

    public static void println(double d) {
        if (enabled) {
            ps.println(d);
        }
    }

    public static void println(float f) {
        if (enabled) {
            ps.println(f);
        }
    }

    public static void println(int n) {
        if (enabled) {
            ps.println(n);
        }
    }

    public static void println(long l) {
        if (enabled) {
            ps.println(l);
        }
    }

    public static void println(String string) {
        if (enabled) {
            ps.println(string);
        }
    }

    public static void println() {
        if (enabled) {
            ps.println();
        }
    }

    public static void print(Object object) {
        if (enabled) {
            ps.print(object);
        }
    }

    public static void print(boolean bl) {
        if (enabled) {
            ps.print(bl);
        }
    }

    public static void print(char c) {
        if (enabled) {
            ps.print(c);
        }
    }

    public static void print(char[] cArray) {
        if (enabled) {
            ps.print(cArray);
        }
    }

    public static void print(double d) {
        if (enabled) {
            ps.print(d);
        }
    }

    public static void print(float f) {
        if (enabled) {
            ps.print(f);
        }
    }

    public static void print(int n) {
        if (enabled) {
            ps.print(n);
        }
    }

    public static void print(long l) {
        if (enabled) {
            ps.print(l);
        }
    }

    public static void print(String string) {
        if (enabled) {
            ps.print(string);
        }
    }

    public static void flush() {
        if (enabled) {
            ps.flush();
        }
    }

    public static PrintStream get() {
        return ps;
    }
}

