/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IColor;
import igeo.IComparator;
import igeo.IConfig;
import igeo.ICurveI;
import igeo.IDynamicServer;
import igeo.IDynamicsBase;
import igeo.IEdge;
import igeo.IG;
import igeo.ILayer;
import igeo.IMesh;
import igeo.IMeshGeo;
import igeo.IMeshI;
import igeo.IObject;
import igeo.IOut;
import igeo.IParameter;
import igeo.IParticle;
import igeo.IParticleI;
import igeo.IParticleOnCurve;
import igeo.IParticleOnCurveI;
import igeo.IServer;
import igeo.ISort;
import igeo.ISpacingEqualizer;
import igeo.IStraightenerCurve;
import igeo.IStraightenerI;
import igeo.ITension;
import igeo.ITensionI;
import igeo.ITensionLine;
import igeo.ITensionOnCurve;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ITensileNet {
    public static double friction = 0.005;
    public static double tension = 1.0;
    public static double onRailTension = 1.0;
    public static double straightenerTension = 1.0;
    public static double equalizerTension = 1.0;
    public static boolean constantTension = false;
    public static double tolerance = IConfig.tolerance;
    public static double railTolerance = IConfig.tolerance;
    public static IColor pointColor = new IColor(255, 255, 255);
    public static IColor railPointColor = new IColor(192, 192, 192);
    public static IColor fixedPointColor = new IColor(255, 255, 0);
    public static IColor straightenerColor = new IColor(255, 128, 0);
    public static IColor tensionColor = null;
    public static String pointLayer = "nodes";
    public static String fixedPointLayer = "fixedNodes";
    public static String straightenerLayer = "straightener";
    public static String equalizerLayer = "equalizer";
    public static String tensionLayer = null;
    public static boolean fixOpenEnd = true;
    public static boolean deleteInputLine = true;
    public static boolean embedTensionInLine = true;
    public static boolean deleteInputPoint = true;
    public static boolean tensionOnRail = true;
    public static boolean fixAtRailEnd = true;
    public static boolean fixPointOffRail = true;
    public static boolean straightener = false;
    public static double straightenerThresholdAngle = 1.0471975511965976;
    public static boolean removeBranchStraightener = true;
    public static boolean spacingEqualizer = false;
    public static Class<? extends IParticleI> particleClass = null;
    public static Class<? extends ITensionI> tensionClass = null;
    public static Class<? extends IParticleOnCurveI> particleOnCurveClass = null;
    public static boolean removeMeshDuplicates = true;
    public static boolean keepDuplicatedMeshEdge = true;
    public static boolean keepDuplicatedMeshVertex = true;
    public ArrayList<ITensionI> links;
    public ArrayList<IParticleI> nodes;
    public ArrayList<IStraightenerI> straighteners;

    public static void friction(double d) {
        friction = d;
    }

    public static void fric(double d) {
        ITensileNet.friction(d);
    }

    public static void tension(double d) {
        tension = d;
    }

    public static void onRailTension(double d) {
        onRailTension = d;
    }

    public static void straightenerTension(double d) {
        straightenerTension = d;
    }

    public static void equalizerTension(double d) {
        equalizerTension = d;
    }

    public static void constantTension(boolean bl) {
        constantTension = bl;
    }

    public static void enableConstantTension() {
        constantTension = true;
    }

    public static void disableConstantTension() {
        constantTension = false;
    }

    public static void tolerance(double d) {
        tolerance = d;
    }

    public static void railTolerance(double d) {
        railTolerance = d;
    }

    public static void pointColor(IColor iColor) {
        pointColor = iColor;
    }

    public static void pointColor(int n, int n2, int n3, int n4) {
        pointColor = new IColor(n, n2, n3, n4);
    }

    public static void pointColor(int n, int n2, int n3) {
        pointColor = new IColor(n, n2, n3);
    }

    public static void pointColor(int n, int n2) {
        pointColor = new IColor(n, n2);
    }

    public static void pointColor(int n) {
        pointColor = new IColor(n);
    }

    public static void pointColor(float f, float f2, float f3, float f4) {
        pointColor = new IColor(f, f2, f3, f4);
    }

    public static void pointColor(float f, float f2, float f3) {
        pointColor = new IColor(f, f2, f3);
    }

    public static void pointColor(float f, float f2) {
        pointColor = new IColor(f, f2);
    }

    public static void pointColor(float f) {
        pointColor = new IColor(f);
    }

    public static void railPointColor(IColor iColor) {
        railPointColor = iColor;
    }

    public static void railPointColor(int n, int n2, int n3, int n4) {
        railPointColor = new IColor(n, n2, n3, n4);
    }

    public static void railPointColor(int n, int n2, int n3) {
        railPointColor = new IColor(n, n2, n3);
    }

    public static void railPointColor(int n, int n2) {
        railPointColor = new IColor(n, n2);
    }

    public static void railPointColor(int n) {
        railPointColor = new IColor(n);
    }

    public static void railPointColor(float f, float f2, float f3, float f4) {
        railPointColor = new IColor(f, f2, f3, f4);
    }

    public static void railPointColor(float f, float f2, float f3) {
        railPointColor = new IColor(f, f2, f3);
    }

    public static void railPointColor(float f, float f2) {
        railPointColor = new IColor(f, f2);
    }

    public static void railPointColor(float f) {
        railPointColor = new IColor(f);
    }

    public static void fixedPointColor(IColor iColor) {
        fixedPointColor = iColor;
    }

    public static void fixedPointColor(int n, int n2, int n3, int n4) {
        fixedPointColor = new IColor(n, n2, n3, n4);
    }

    public static void fixedPointColor(int n, int n2, int n3) {
        fixedPointColor = new IColor(n, n2, n3);
    }

    public static void fixedPointColor(int n, int n2) {
        fixedPointColor = new IColor(n, n2);
    }

    public static void fixedPointColor(int n) {
        fixedPointColor = new IColor(n);
    }

    public static void fixedPointColor(float f, float f2, float f3, float f4) {
        fixedPointColor = new IColor(f, f2, f3, f4);
    }

    public static void fixedPointColor(float f, float f2, float f3) {
        fixedPointColor = new IColor(f, f2, f3);
    }

    public static void fixedPointColor(float f, float f2) {
        fixedPointColor = new IColor(f, f2);
    }

    public static void fixedPointColor(float f) {
        fixedPointColor = new IColor(f);
    }

    public static void straightenerColor(IColor iColor) {
        straightenerColor = iColor;
    }

    public static void straightenerColor(int n, int n2, int n3, int n4) {
        straightenerColor = new IColor(n, n2, n3, n4);
    }

    public static void straightenerColor(int n, int n2, int n3) {
        straightenerColor = new IColor(n, n2, n3);
    }

    public static void straightenerColor(int n, int n2) {
        straightenerColor = new IColor(n, n2);
    }

    public static void straightenerColor(int n) {
        straightenerColor = new IColor(n);
    }

    public static void straightenerColor(float f, float f2, float f3, float f4) {
        straightenerColor = new IColor(f, f2, f3, f4);
    }

    public static void straightenerColor(float f, float f2, float f3) {
        straightenerColor = new IColor(f, f2, f3);
    }

    public static void straightenerColor(float f, float f2) {
        straightenerColor = new IColor(f, f2);
    }

    public static void straightenerColor(float f) {
        straightenerColor = new IColor(f);
    }

    public static void tensionColor(IColor iColor) {
        tensionColor = iColor;
    }

    public static void tensionColor(int n, int n2, int n3, int n4) {
        tensionColor = new IColor(n, n2, n3, n4);
    }

    public static void tensionColor(int n, int n2, int n3) {
        tensionColor = new IColor(n, n2, n3);
    }

    public static void tensionColor(int n, int n2) {
        tensionColor = new IColor(n, n2);
    }

    public static void tensionColor(int n) {
        tensionColor = new IColor(n);
    }

    public static void tensionColor(float f, float f2, float f3, float f4) {
        tensionColor = new IColor(f, f2, f3, f4);
    }

    public static void tensionColor(float f, float f2, float f3) {
        tensionColor = new IColor(f, f2, f3);
    }

    public static void tensionColor(float f, float f2) {
        tensionColor = new IColor(f, f2);
    }

    public static void tensionColor(float f) {
        tensionColor = new IColor(f);
    }

    public static void pointLayer(String string) {
        pointLayer = string;
    }

    public static void fixedPointLayer(String string) {
        fixedPointLayer = string;
    }

    public static void straightenerLayer(String string) {
        straightenerLayer = string;
    }

    public static void equalizerLayer(String string) {
        equalizerLayer = string;
    }

    public static void tensionLayer(String string) {
        tensionLayer = string;
    }

    public static void fixOpenEnd(boolean bl) {
        fixOpenEnd = bl;
    }

    public static void enableFixOpenEnd() {
        fixOpenEnd = true;
    }

    public static void disableFixOpenEnd() {
        fixOpenEnd = false;
    }

    public static void deleteInputLine(boolean bl) {
        deleteInputLine = bl;
    }

    public static void enableDeleteInputLine() {
        deleteInputLine = true;
    }

    public static void disableDeleteInputLine() {
        deleteInputLine = false;
    }

    public static void embedTensionInLine(boolean bl) {
        embedTensionInLine = bl;
    }

    public static void enableEmbedTensionInLine() {
        embedTensionInLine = true;
    }

    public static void disableEmbedTensionInLine() {
        embedTensionInLine = false;
    }

    public static void deleteInputPoint(boolean bl) {
        deleteInputPoint = bl;
    }

    public static void enableDeleteInputPoint() {
        deleteInputPoint = true;
    }

    public static void disableDeleteInputPoint() {
        deleteInputPoint = false;
    }

    public static void tensionOnRail(boolean bl) {
        tensionOnRail = bl;
    }

    public static void enableTensionOnRail() {
        tensionOnRail = true;
    }

    public static void disableTensionOnRail() {
        tensionOnRail = false;
    }

    public static void fixAtRailEnd(boolean bl) {
        fixAtRailEnd = bl;
    }

    public static void enableFixAtRailEnd() {
        fixAtRailEnd = true;
    }

    public static void disableFixAtRailEnd() {
        fixAtRailEnd = false;
    }

    public static void fixPointOffRail(boolean bl) {
        fixPointOffRail = bl;
    }

    public static void enableFixPointOffRail(boolean bl) {
        fixPointOffRail = true;
    }

    public static void disableFixPointOffRail(boolean bl) {
        fixPointOffRail = false;
    }

    public static void straightener(boolean bl) {
        straightener = bl;
    }

    public static void enableStraightener() {
        straightener = true;
    }

    public static void disableStraightener() {
        straightener = false;
    }

    public static void straightenerThresholdAngle(double d) {
        straightenerThresholdAngle = d;
    }

    public static void removeBranchStraightener(boolean bl) {
        removeBranchStraightener = bl;
    }

    public static void enableRemoveBranchStraightener() {
        removeBranchStraightener = true;
    }

    public static void disableRemoveBranchStraightener() {
        removeBranchStraightener = false;
    }

    public static void spacingEqualizer(boolean bl) {
        spacingEqualizer = bl;
    }

    public static void enableSpacingEqualizer() {
        spacingEqualizer = true;
    }

    public static void disableSpacingEqualizer() {
        spacingEqualizer = false;
    }

    public static void particleClass(Class<? extends IParticleI> clazz) {
        particleClass = clazz;
    }

    public static void tensionClass(Class<? extends ITensionI> clazz) {
        tensionClass = clazz;
    }

    public static void particleOnCurveClass(Class<? extends IParticleOnCurveI> clazz) {
        particleOnCurveClass = clazz;
    }

    public static void removeMeshDuplicates(boolean bl) {
        removeMeshDuplicates = bl;
    }

    public static void keepDuplicatedMeshEdge(boolean bl) {
        keepDuplicatedMeshEdge = bl;
    }

    public static void keepDuplicatedMeshVertex(boolean bl) {
        keepDuplicatedMeshVertex = bl;
    }

    public ITensileNet() {
    }

    public ITensileNet(ArrayList<ITensionI> arrayList, ArrayList<IParticleI> arrayList2) {
        this.links = arrayList;
        this.nodes = arrayList2;
    }

    public ITensileNet(ArrayList<ITensionI> arrayList, ArrayList<IParticleI> arrayList2, ArrayList<IStraightenerI> arrayList3) {
        this.links = arrayList;
        this.nodes = arrayList2;
        this.straighteners = arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVecI[][] iVecIArray2 = new IVec[iCurveIArray.length][2];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iVecIArray2[i][0] = iCurveIArray[i].start().get();
            iVecIArray2[i][1] = iCurveIArray[i].end().get();
        }
        IColor[] iColorArray = new IColor[iCurveIArray.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray.length];
        IServer iServer = null;
        for (int i = 0; i < iCurveIArray.length; ++i) {
            if (!(iCurveIArray[i] instanceof IObject)) continue;
            iColorArray[i] = ((IObject)((Object)iCurveIArray[i])).clr();
            iLayerArray[i] = ((IObject)((Object)iCurveIArray[i])).layer();
            if (iServer == null) {
                iServer = ((IObject)((Object)iCurveIArray[i])).server();
            }
            if (!deleteInputLine) continue;
            ((IObject)((Object)iCurveIArray[i])).del();
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            IParticleI[][] iParticleIArray = new IParticleI[iVecIArray2.length][2];
            ArrayList<IParticleI> arrayList = ITensileNet.createParticleLink(iVecIArray2, null, iVecIArray, iParticleIArray, particleClass);
            ArrayList<ITensionI> arrayList2 = ITensileNet.createTensions(iParticleIArray, iColorArray, iLayerArray, tensionClass);
            ArrayList<IStraightenerI> arrayList3 = null;
            if (straightener) {
                arrayList3 = ITensileNet.createStraighteners(arrayList2);
            }
            if (iVecIArray != null) {
                for (int i = 0; i < iVecIArray.length; ++i) {
                    if (!deleteInputPoint || !(iVecIArray[i] instanceof IObject)) continue;
                    ((IObject)((Object)iVecIArray[i])).del();
                }
            }
            iTensileNet = new ITensileNet(arrayList2, arrayList, arrayList3);
        }
        return iTensileNet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(IMeshI iMeshI, IVecI[] iVecIArray) {
        int n;
        int n2;
        int n3;
        if (removeMeshDuplicates) {
            if (iMeshI instanceof IMesh) {
                ((IMesh)iMeshI).removeDuplicates();
            } else if (iMeshI instanceof IMeshGeo) {
                ((IMeshGeo)iMeshI).removeDuplicates();
            }
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        if (keepDuplicatedMeshEdge) {
            for (n3 = 0; n3 < iMeshI.edgeNum(); ++n3) {
                arrayList.add(iMeshI.edge(n3));
            }
        } else {
            for (n3 = 0; n3 < iMeshI.edgeNum(); ++n3) {
                n2 = 1;
                for (n = n3 + 1; n < iMeshI.edgeNum() && n2 != 0; ++n) {
                    if (!iMeshI.edge(n3).eq(iMeshI.edge(n), tolerance)) continue;
                    n2 = 0;
                }
                if (n2 == 0) continue;
                arrayList.add(iMeshI.edge(n3));
            }
        }
        IVecI[][] iVecIArray2 = new IVertex[arrayList.size()][2];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            iVecIArray2[n2][0] = ((IEdge)arrayList.get(n2)).vertex(0);
            iVecIArray2[n2][1] = ((IEdge)arrayList.get(n2)).vertex(1);
        }
        ArrayList<IVecI> arrayList2 = null;
        if (keepDuplicatedMeshVertex) {
            arrayList2 = new ArrayList<IVecI>();
            for (n = 0; n < iMeshI.vertexNum(); ++n) {
                arrayList2.add(iMeshI.vertex(n));
            }
        }
        IServer iServer = null;
        if (iMeshI instanceof IObject) {
            iServer = ((IObject)((Object)iMeshI)).server();
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            int n4;
            IParticleI[][] iParticleIArray = new IParticleI[iVecIArray2.length][2];
            ArrayList<IParticleI> arrayList3 = ITensileNet.createParticleLink(iVecIArray2, arrayList2, iVecIArray, iParticleIArray, particleClass);
            Class<? extends ITensionI> clazz = tensionClass;
            if (clazz == null) {
                clazz = ITension.class;
            }
            ArrayList<ITensionI> arrayList4 = ITensileNet.createTensions(iParticleIArray, null, null, clazz);
            ArrayList<IStraightenerI> arrayList5 = null;
            if (straightener) {
                arrayList5 = ITensileNet.createStraighteners(arrayList4);
            }
            if (iVecIArray != null) {
                for (n4 = 0; n4 < iVecIArray.length; ++n4) {
                    if (!deleteInputPoint || !(iVecIArray[n4] instanceof IObject)) continue;
                    ((IObject)((Object)iVecIArray[n4])).del();
                }
            }
            if (keepDuplicatedMeshVertex && iMeshI.vertexNum() != arrayList3.size()) {
                IOut.err("mesh.vertexNum() and pointList.size() don't match.");
            }
            if (keepDuplicatedMeshVertex && iMeshI.vertexNum() == arrayList3.size()) {
                for (n4 = 0; n4 < iMeshI.vertexNum(); ++n4) {
                    iMeshI.vertex((int)n4).pos = arrayList3.get(n4);
                    if (!(iMeshI instanceof IObject)) continue;
                    arrayList3.get(n4).target((IObject)((Object)iMeshI));
                }
            } else {
                for (n4 = 0; n4 < iMeshI.vertexNum(); ++n4) {
                    IVertex iVertex = iMeshI.vertex(n4);
                    IParticleI iParticleI = null;
                    for (int i = 0; i < arrayList3.size() && iParticleI == null; ++i) {
                        if (!iVertex.eq(arrayList3.get(i), tolerance)) continue;
                        iParticleI = arrayList3.get(i);
                    }
                    if (iParticleI != null) {
                        iMeshI.vertex((int)n4).pos = iParticleI;
                        if (!(iMeshI instanceof IObject)) continue;
                        iParticleI.target((IObject)((Object)iMeshI));
                        continue;
                    }
                    IOut.err("no particle found for mesh vertex(" + n4 + ")");
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3, arrayList5);
        }
        return iTensileNet;
    }

    public static void fixParticles(ArrayList<IParticleI> arrayList, IVecI[] iVecIArray) {
        if (iVecIArray != null) {
            for (int i = 0; i < iVecIArray.length; ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!iVecIArray[i].eq(arrayList.get(j), tolerance)) continue;
                    arrayList.get(j).fix();
                    if (!(arrayList.get(j) instanceof IObject)) continue;
                    IObject iObject = (IObject)((Object)arrayList.get(j));
                    iObject.clr(fixedPointColor);
                    if (fixedPointLayer == null) continue;
                    iObject.layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                }
            }
        }
    }

    public static ArrayList<IParticleI> createParticleLink(IVecI[][] iVecIArray, ArrayList<IVecI> arrayList, IVecI[] iVecIArray2, IParticleI[][] iParticleIArray, Class<? extends IParticleI> clazz) {
        int n;
        if (iParticleIArray == null || iParticleIArray.length != iVecIArray.length || iParticleIArray.length == 0 || iParticleIArray[0].length != 2) {
            IOut.err("parameter linkParticleResult is return container. it needs to be instantiated as a 2D array whose size is same iwth linePts input parameter");
            return null;
        }
        if (arrayList == null) {
            int n2;
            for (n2 = 0; n2 < iVecIArray.length; ++n2) {
                IVecI[] iVecIArray3 = iVecIArray[n2];
                if (iVecIArray3[1].eq(iVecIArray3[0], tolerance)) {
                    iVecIArray[n2] = null;
                    continue;
                }
                for (n = n2 + 1; n < iVecIArray.length; ++n) {
                    IVecI[] iVecIArray4 = iVecIArray[n];
                    for (int i = 0; i < 2; ++i) {
                        if (iVecIArray4[i].eq(iVecIArray3[0], tolerance)) {
                            iVecIArray4[i] = iVecIArray3[0];
                            continue;
                        }
                        if (!iVecIArray4[i].eq(iVecIArray3[1], tolerance)) continue;
                        iVecIArray4[i] = iVecIArray3[1];
                    }
                }
            }
            arrayList = new ArrayList();
            for (n2 = 0; n2 < iVecIArray.length; ++n2) {
                if (iVecIArray[n2] == null) continue;
                for (int i = 0; i < 2; ++i) {
                    if (arrayList.contains(iVecIArray[n2][i])) continue;
                    arrayList.add(iVecIArray[n2][i]);
                }
            }
        }
        if (fixOpenEnd) {
            int n3;
            ArrayList<IVecI> arrayList2 = new ArrayList<IVecI>();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                n = 0;
                for (int i = 0; i < iVecIArray.length; ++i) {
                    if (iVecIArray[i] == null) continue;
                    if (iVecIArray[i][0] == arrayList.get(n3)) {
                        ++n;
                    }
                    if (iVecIArray[i][1] != arrayList.get(n3)) continue;
                    ++n;
                }
                if (n != 1) continue;
                arrayList2.add(arrayList.get(n3));
            }
            if (iVecIArray2 != null) {
                for (n3 = 0; n3 < iVecIArray2.length; ++n3) {
                    arrayList2.add(iVecIArray2[n3]);
                }
            }
            iVecIArray2 = arrayList2.toArray(new IVecI[arrayList2.size()]);
        }
        ConstructorAndParameters<IParticleI> constructorAndParameters = null;
        if (clazz != null) {
            constructorAndParameters = ITensileNet.searchParticleConstructor(particleClass);
        }
        ArrayList<IParticleI> arrayList3 = new ArrayList<IParticleI>();
        for (n = 0; n < arrayList.size(); ++n) {
            IParticleI iParticleI = null;
            if (constructorAndParameters != null && (iParticleI = ITensileNet.getParticleInstance(arrayList.get(n).get(), constructorAndParameters.constructor, constructorAndParameters.parameters)) != null) {
                iParticleI.fric(friction);
                if (iParticleI instanceof IObject) {
                    ((IObject)((Object)iParticleI)).clr(pointColor);
                    if (pointLayer != null) {
                        ((IObject)((Object)iParticleI)).layer(IG.layer(pointLayer).clr(pointColor));
                    }
                }
            }
            if (iParticleI == null) {
                IParticle iParticle = new IParticle(arrayList.get(n));
                iParticle.fric(friction);
                iParticle.clr(pointColor);
                if (pointLayer != null) {
                    iParticle.layer(IG.layer(pointLayer).clr(pointColor));
                }
                iParticleI = iParticle;
            }
            arrayList3.add(iParticleI);
        }
        for (n = 0; n < iVecIArray.length; ++n) {
            IVecI[] iVecIArray5 = iVecIArray[n];
            if (iVecIArray5 == null) continue;
            int n4 = arrayList.indexOf(iVecIArray5[0]);
            int n5 = arrayList.indexOf(iVecIArray5[1]);
            if (n4 >= 0 && n5 >= 0) {
                iParticleIArray[n][0] = arrayList3.get(n4);
                iParticleIArray[n][1] = arrayList3.get(n5);
                continue;
            }
            IOut.err("line points not found in point list (index1=" + n4 + "), (index2=" + n5 + ")");
        }
        ITensileNet.fixParticles(arrayList3, iVecIArray2);
        return arrayList3;
    }

    public static ArrayList<ITensionI> createTensions(IParticleI[][] iParticleIArray, IColor[] iColorArray, ILayer[] iLayerArray, Class<? extends ITensionI> clazz) {
        ArrayList<ITensionI> arrayList = new ArrayList<ITensionI>();
        for (int i = 0; i < iParticleIArray.length; ++i) {
            IParticleI[] iParticleIArray2 = iParticleIArray[i];
            if (iParticleIArray2 != null && iParticleIArray2.length >= 2) {
                IParticleI iParticleI = iParticleIArray2[0];
                IParticleI iParticleI2 = iParticleIArray2[1];
                ITensionI iTensionI = null;
                ConstructorAndParameters<ITensionI> constructorAndParameters = null;
                if (clazz != null) {
                    constructorAndParameters = ITensileNet.searchTensionConstructor(clazz);
                }
                if (constructorAndParameters != null && (iTensionI = ITensileNet.getTensionInstance(iParticleI, iParticleI2, constructorAndParameters.constructor, constructorAndParameters.parameters)) != null) {
                    if (iTensionI instanceof IObject) {
                        if (tensionColor != null) {
                            ((IObject)((Object)iTensionI)).clr(tensionColor);
                        } else if (iColorArray[i] != null) {
                            ((IObject)((Object)iTensionI)).clr(iColorArray[i]);
                        }
                        if (tensionLayer != null) {
                            ((IObject)((Object)iTensionI)).layer(tensionLayer);
                        } else if (iLayerArray[i] != null) {
                            ((IObject)((Object)iTensionI)).layer(iLayerArray[i]);
                        }
                    }
                    iTensionI.tension(tension);
                    iTensionI.constant(constantTension);
                    arrayList.add(iTensionI);
                }
                if (iTensionI != null) continue;
                ITensionLine iTensionLine = new ITensionLine(iParticleI, iParticleI2, tension);
                if (tensionColor != null) {
                    iTensionLine.clr(tensionColor);
                } else if (iColorArray[i] != null) {
                    iTensionLine.clr(iColorArray[i]);
                }
                if (tensionLayer != null) {
                    iTensionLine.layer(tensionLayer);
                } else if (iLayerArray[i] != null) {
                    iTensionLine.layer(iLayerArray[i]);
                }
                iTensionLine.tension(tension);
                iTensionLine.constant(constantTension);
                arrayList.add(iTensionLine);
                continue;
            }
            IOut.err("end point is not found");
        }
        return null;
    }

    public static ArrayList<IStraightenerI> createStraighteners(ArrayList<ITensionI> arrayList) {
        IParticleI iParticleI;
        IParticleI iParticleI2;
        IParticleI iParticleI3;
        IParticleI iParticleI4;
        IParticleI iParticleI5;
        int n;
        ArrayList<IStraightenerI> arrayList2 = new ArrayList<IStraightenerI>();
        for (n = 0; n < arrayList.size(); ++n) {
            iParticleI5 = arrayList.get(n).pt(0);
            iParticleI4 = arrayList.get(n).pt(1);
            for (int i = n + 1; i < arrayList.size(); ++i) {
                IParticleI iParticleI6 = arrayList.get(i).pt(0);
                IParticleI iParticleI7 = arrayList.get(i).pt(1);
                iParticleI3 = null;
                iParticleI2 = null;
                iParticleI = null;
                if (iParticleI5 == iParticleI6) {
                    iParticleI3 = iParticleI4;
                    iParticleI2 = iParticleI5;
                    iParticleI = iParticleI7;
                } else if (iParticleI5 == iParticleI7) {
                    iParticleI3 = iParticleI4;
                    iParticleI2 = iParticleI5;
                    iParticleI = iParticleI6;
                } else if (iParticleI4 == iParticleI6) {
                    iParticleI3 = iParticleI5;
                    iParticleI2 = iParticleI4;
                    iParticleI = iParticleI7;
                } else if (iParticleI4 == iParticleI7) {
                    iParticleI3 = iParticleI5;
                    iParticleI2 = iParticleI4;
                    iParticleI = iParticleI6;
                }
                if (iParticleI3 == null || iParticleI2 == null || iParticleI == null || !(Math.abs(iParticleI2.pos().diff(iParticleI3.pos()).angle(iParticleI.pos().diff(iParticleI2.pos()))) < straightenerThresholdAngle)) continue;
                IStraightenerCurve iStraightenerCurve = new IStraightenerCurve(iParticleI3, iParticleI2, iParticleI);
                iStraightenerCurve.tension(straightenerTension);
                iStraightenerCurve.clr(straightenerColor);
                iStraightenerCurve.layer(IG.layer(straightenerLayer).clr(straightenerColor));
                arrayList2.add(iStraightenerCurve);
            }
        }
        if (removeBranchStraightener) {
            for (n = 0; n < arrayList2.size(); ++n) {
                iParticleI5 = arrayList2.get(n).pt(0);
                iParticleI4 = arrayList2.get(n).pt(1);
                IParticleI iParticleI8 = arrayList2.get(n).pt(2);
                boolean bl = false;
                for (int i = n + 1; i < arrayList2.size() && !bl; ++i) {
                    iParticleI3 = arrayList2.get(i).pt(0);
                    iParticleI2 = arrayList2.get(i).pt(1);
                    iParticleI = arrayList2.get(i).pt(2);
                    if (iParticleI4 != iParticleI2 || iParticleI5 != iParticleI3 && iParticleI5 != iParticleI && iParticleI8 != iParticleI3 && iParticleI8 != iParticleI) continue;
                    double d = iParticleI4.pos().diff(iParticleI5.pos()).angle(iParticleI8.pos().diff(iParticleI4.pos()));
                    double d2 = iParticleI2.pos().diff(iParticleI3.pos()).angle(iParticleI.pos().diff(iParticleI2.pos()));
                    if (Math.abs(d) < Math.abs(d2)) {
                        if (arrayList2.get(i) instanceof IObject) {
                            ((IObject)((Object)arrayList2.get(i))).del();
                        }
                        arrayList2.remove(i);
                        --i;
                        continue;
                    }
                    if (arrayList2.get(i) instanceof IObject) {
                        ((IObject)((Object)arrayList2.get(n))).del();
                    }
                    arrayList2.remove(n);
                    --n;
                    --i;
                    bl = true;
                }
            }
        }
        return arrayList2;
    }

    public static ConstructorAndParameters<IParticleI> searchParticleConstructor(Class<? extends IParticleI> clazz) {
        if (clazz == null) {
            return null;
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        Constructor<?> constructor4 = null;
        Constructor<?> constructor5 = null;
        Constructor<?> constructor6 = null;
        Constructor<?> constructor7 = null;
        Constructor<?> constructor8 = null;
        Constructor<?> constructor9 = null;
        Constructor<?> constructor10 = null;
        Constructor<?> constructor11 = null;
        Constructor<?> constructor12 = null;
        Constructor<?> constructor13 = null;
        Constructor<?> constructor14 = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null) {
                return null;
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray == null || classArray.length == 0) {
                    constructor7 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 1 && classArray[0] == IVecI.class) {
                    constructor2 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 1 && classArray[0].isAssignableFrom(IVec.class)) {
                    constructor4 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 1 && IVecI.class.isAssignableFrom(classArray[0])) {
                    constructor6 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && classArray[0] == IVecI.class && classArray[1] == IVecI.class) {
                    constructor = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && classArray[0].isAssignableFrom(IVec.class) && classArray[1].isAssignableFrom(IVec.class)) {
                    constructor3 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && IVecI.class.isAssignableFrom(classArray[0]) && IVecI.class.isAssignableFrom(classArray[1])) {
                    constructor5 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 1 && !IVecI.class.isAssignableFrom(classArray[0])) {
                    constructor14 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && !IVecI.class.isAssignableFrom(classArray[0]) && classArray[1] == IVecI.class) {
                    constructor9 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && !IVecI.class.isAssignableFrom(classArray[0]) && classArray[1].isAssignableFrom(IVec.class)) {
                    constructor11 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && !IVecI.class.isAssignableFrom(classArray[0]) && IVecI.class.isAssignableFrom(classArray[1])) {
                    constructor13 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !IVecI.class.isAssignableFrom(classArray[0]) && classArray[1] == IVecI.class && classArray[2] == IVecI.class) {
                    constructor8 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !IVecI.class.isAssignableFrom(classArray[0]) && classArray[1].isAssignableFrom(IVec.class) && classArray[2].isAssignableFrom(IVec.class)) {
                    constructor10 = constructorArray[i];
                    continue;
                }
                if (classArray.length != 3 || IVecI.class.isAssignableFrom(classArray[0]) || !IVecI.class.isAssignableFrom(classArray[1]) || !IVecI.class.isAssignableFrom(classArray[2])) continue;
                constructor12 = constructorArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (constructor != null) {
            IOut.debug(20, "constructor parameters = { IVecI, IVecI }");
            return new ConstructorAndParameters<IParticleI>(constructor, IVecI.class, IVecI.class);
        }
        if (constructor2 != null) {
            IOut.debug(20, "constructor parameters = { IVecI }");
            return new ConstructorAndParameters<IParticleI>(constructor2, IVecI.class);
        }
        if (constructor3 != null) {
            IOut.debug(20, "constructor parameters = { IVec, IVec }");
            return new ConstructorAndParameters<IParticleI>(constructor3, IVecI.class, IVecI.class);
        }
        if (constructor4 != null) {
            IOut.debug(20, "constructor parameters = { IVec }");
            return new ConstructorAndParameters<IParticleI>(constructor4, IVecI.class);
        }
        if (constructor5 != null) {
            IOut.debug(20, "constructor parameters = { Class<? extends IVecI>, Class<? extends IVec> }");
            return new ConstructorAndParameters<IParticleI>(constructor5, IVecI.class, IVecI.class);
        }
        if (constructor6 != null) {
            IOut.debug(20, "constructor parameters = { Class<? extends IVec> }");
            return new ConstructorAndParameters<IParticleI>(constructor6, IVecI.class);
        }
        if (constructor7 != null) {
            IOut.debug(20, "constructor parameters = {}");
            return new ConstructorAndParameters<IParticleI>(constructor7, new Class[0]);
        }
        if (constructor8 != null) {
            IOut.debug(20, "constructor parameters = { Object, IVecI, IVecI }");
            return new ConstructorAndParameters<IParticleI>(constructor8, Object.class, IVecI.class, IVecI.class);
        }
        if (constructor9 != null) {
            IOut.debug(20, "constructor parameters = { Object, IVecI }");
            return new ConstructorAndParameters<IParticleI>(constructor9, Object.class, IVecI.class);
        }
        if (constructor10 != null) {
            IOut.debug(20, "constructor parameters = { Object, IVec, IVec }");
            return new ConstructorAndParameters<IParticleI>(constructor10, Object.class, IVecI.class, IVecI.class);
        }
        if (constructor11 != null) {
            IOut.debug(20, "constructor parameters = { Object, IVec }");
            return new ConstructorAndParameters<IParticleI>(constructor11, Object.class, IVecI.class);
        }
        if (constructor12 != null) {
            IOut.debug(20, "constructor parameters = { Object, Class<? extends IVecI>, Class<? extends IVecI> }");
            return new ConstructorAndParameters<IParticleI>(constructor12, Object.class, IVecI.class, IVecI.class);
        }
        if (constructor13 != null) {
            IOut.debug(20, "constructor parameters = { Object, Class<? extends IVec> }");
            return new ConstructorAndParameters<IParticleI>(constructor13, Object.class, IVecI.class);
        }
        if (constructor14 != null) {
            IOut.debug(20, "constructor parameters = { Object }");
            return new ConstructorAndParameters<IParticleI>(constructor14, Object.class);
        }
        IOut.err("no matching particle constructor found. it should be like constructor(IVec) or constructor(IVec,IVec)");
        return null;
    }

    public static ConstructorAndParameters<ITensionI> searchTensionConstructor(Class<? extends ITensionI> clazz) {
        if (clazz == null) {
            return null;
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        Constructor<?> constructor4 = null;
        Constructor<?> constructor5 = null;
        Constructor<?> constructor6 = null;
        Constructor<?> constructor7 = null;
        Constructor<?> constructor8 = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null) {
                return null;
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length == 2 && classArray[0] == IParticleI.class && classArray[1] == IParticleI.class) {
                    constructor = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && IParticleI.class.isAssignableFrom(classArray[0]) && IParticleI.class.isAssignableFrom(classArray[1])) {
                    constructor5 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && classArray[0] == IParticleI.class && classArray[1] == IParticleI.class && classArray[2] == Double.TYPE) {
                    constructor2 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && IParticleI.class.isAssignableFrom(classArray[0]) && IParticleI.class.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2])) {
                    constructor6 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !IParticleI.class.isAssignableFrom(classArray[0]) && classArray[1] == IParticleI.class && classArray[2] == IParticleI.class) {
                    constructor3 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !IParticleI.class.isAssignableFrom(classArray[0]) && IParticleI.class.isAssignableFrom(classArray[1]) && IParticleI.class.isAssignableFrom(classArray[2])) {
                    constructor7 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !IParticleI.class.isAssignableFrom(classArray[0]) && classArray[1] == IParticleI.class && classArray[2] == IParticleI.class && classArray[3] == Double.TYPE) {
                    constructor4 = constructorArray[i];
                    continue;
                }
                if (classArray.length != 4 || IParticleI.class.isAssignableFrom(classArray[0]) || !IParticleI.class.isAssignableFrom(classArray[1]) || !IParticleI.class.isAssignableFrom(classArray[2]) || !Double.TYPE.isAssignableFrom(classArray[3])) continue;
                constructor8 = constructorArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (constructor2 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor2, IParticleI.class, IParticleI.class, Double.TYPE);
        }
        if (constructor != null) {
            return new ConstructorAndParameters<ITensionI>(constructor, IParticleI.class, IParticleI.class);
        }
        if (constructor6 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor6, IParticleI.class, IParticleI.class, Double.TYPE);
        }
        if (constructor5 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor5, IParticleI.class, IParticleI.class);
        }
        if (constructor4 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor4, Object.class, IParticleI.class, IParticleI.class, Double.TYPE);
        }
        if (constructor3 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor3, Object.class, IParticleI.class, IParticleI.class);
        }
        if (constructor8 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor8, Object.class, IParticleI.class, IParticleI.class, Double.TYPE);
        }
        if (constructor7 != null) {
            return new ConstructorAndParameters<ITensionI>(constructor7, Object.class, IParticleI.class, IParticleI.class);
        }
        IOut.err("no matching tension constructor found. it should be like constructor(IParticleI,IParticleI,double) or constructor(IParticleI,IParticleI)");
        return null;
    }

    public static ConstructorAndParameters<IParticleOnCurveI> searchParticleOnCurveConstructor(Class<? extends IParticleOnCurveI> clazz) {
        if (clazz == null) {
            return null;
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        Constructor<?> constructor4 = null;
        Constructor<?> constructor5 = null;
        Constructor<?> constructor6 = null;
        Constructor<?> constructor7 = null;
        Constructor<?> constructor8 = null;
        Constructor<?> constructor9 = null;
        Constructor<?> constructor10 = null;
        Constructor<?> constructor11 = null;
        Constructor<?> constructor12 = null;
        Constructor<?> constructor13 = null;
        Constructor<?> constructor14 = null;
        Constructor<?> constructor15 = null;
        Constructor<?> constructor16 = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null) {
                return null;
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length == 2 && classArray[0] == ICurveI.class && classArray[1].isAssignableFrom(Double.TYPE)) {
                    constructor = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1].isAssignableFrom(Double.TYPE)) {
                    constructor9 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && classArray[0] == ICurveI.class && classArray[1].isAssignableFrom(Double.TYPE) && classArray[2].isAssignableFrom(Double.TYPE)) {
                    constructor2 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1].isAssignableFrom(Double.TYPE) && classArray[2].isAssignableFrom(Double.TYPE)) {
                    constructor10 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1] == ICurveI.class && classArray[2].isAssignableFrom(Double.TYPE)) {
                    constructor3 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !ICurveI.class.isAssignableFrom(classArray[0]) && ICurveI.class.isAssignableFrom(classArray[1]) && classArray[2].isAssignableFrom(Double.TYPE)) {
                    constructor11 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1] == ICurveI.class && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(Double.TYPE)) {
                    constructor4 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !ICurveI.class.isAssignableFrom(classArray[0]) && ICurveI.class.isAssignableFrom(classArray[1]) && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(Double.TYPE)) {
                    constructor12 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && classArray[0] == ICurveI.class && classArray[1].isAssignableFrom(Double.TYPE) && classArray[2].isAssignableFrom(IVec.class)) {
                    constructor5 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1].isAssignableFrom(Double.TYPE) && classArray[2].isAssignableFrom(IVec.class)) {
                    constructor13 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && classArray[0] == ICurveI.class && classArray[1].isAssignableFrom(Double.TYPE) && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(IVec.class)) {
                    constructor6 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1].isAssignableFrom(Double.TYPE) && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(IVec.class)) {
                    constructor14 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1] == ICurveI.class && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(IVec.class)) {
                    constructor7 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !ICurveI.class.isAssignableFrom(classArray[0]) && ICurveI.class.isAssignableFrom(classArray[1]) && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(IVec.class)) {
                    constructor15 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 5 && !ICurveI.class.isAssignableFrom(classArray[0]) && classArray[1] == ICurveI.class && classArray[2].isAssignableFrom(Double.TYPE) && classArray[3].isAssignableFrom(Double.TYPE) && classArray[4].isAssignableFrom(IVec.class)) {
                    constructor8 = constructorArray[i];
                    continue;
                }
                if (classArray.length != 5 || ICurveI.class.isAssignableFrom(classArray[0]) || !ICurveI.class.isAssignableFrom(classArray[1]) || !classArray[2].isAssignableFrom(Double.TYPE) || !classArray[3].isAssignableFrom(Double.TYPE) || !classArray[4].isAssignableFrom(IVec.class)) continue;
                constructor16 = constructorArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (constructor6 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor6, ICurveI.class, Double.TYPE, Double.TYPE, IVec.class);
        }
        if (constructor5 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor5, ICurveI.class, Double.TYPE, IVec.class);
        }
        if (constructor != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor, ICurveI.class, Double.TYPE);
        }
        if (constructor2 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor2, ICurveI.class, Double.TYPE, Double.TYPE);
        }
        if (constructor14 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor14, ICurveI.class, Double.TYPE, Double.TYPE, IVec.class);
        }
        if (constructor13 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor13, ICurveI.class, Double.TYPE, IVec.class);
        }
        if (constructor9 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor9, ICurveI.class, Double.TYPE);
        }
        if (constructor10 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor10, ICurveI.class, Double.TYPE, Double.TYPE);
        }
        if (constructor4 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor4, Object.class, ICurveI.class, Double.TYPE, Double.TYPE);
        }
        if (constructor8 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor8, Object.class, ICurveI.class, Double.TYPE, Double.TYPE, IVec.class);
        }
        if (constructor7 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor7, Object.class, ICurveI.class, Double.TYPE, IVec.class);
        }
        if (constructor3 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor3, Object.class, ICurveI.class, Double.TYPE);
        }
        if (constructor12 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor12, Object.class, ICurveI.class, Double.TYPE, Double.TYPE);
        }
        if (constructor16 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor16, Object.class, ICurveI.class, Double.TYPE, Double.TYPE, IVec.class);
        }
        if (constructor15 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor15, Object.class, ICurveI.class, Double.TYPE, IVec.class);
        }
        if (constructor11 != null) {
            return new ConstructorAndParameters<IParticleOnCurveI>(constructor11, Object.class, ICurveI.class, Double.TYPE);
        }
        IOut.err("no matching particle on curve constructor found. it should be like constructor(ICurve,double) or constructor(ICurve,double,double)");
        return null;
    }

    public static IParticleI getParticleInstance(IVec iVec, Constructor<? extends IParticleI> constructor, Class<?>[] classArray) {
        IParticleI iParticleI = null;
        try {
            if (classArray.length == 0) {
                iParticleI = constructor.newInstance(new Object[0]);
                iParticleI.pos().set(iVec);
            } else if (classArray.length == 1 && classArray[0] == IVecI.class) {
                iParticleI = constructor.newInstance(iVec);
            } else if (classArray.length == 2 && classArray[0] == IVecI.class) {
                iParticleI = constructor.newInstance(iVec, new IVec());
            } else if (classArray.length == 1 && classArray[0] == Object.class) {
                iParticleI = constructor.newInstance(new Object[]{null});
                iParticleI.pos().set(iVec);
            } else if (classArray.length == 2 && classArray[0] == Object.class) {
                iParticleI = constructor.newInstance(null, iVec);
            } else if (classArray.length == 3 && classArray[0] == Object.class) {
                iParticleI = constructor.newInstance(null, iVec, new IVec());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iParticleI;
    }

    public static ITensionI getTensionInstance(IParticleI iParticleI, IParticleI iParticleI2, Constructor<? extends ITensionI> constructor, Class<?>[] classArray) {
        ITensionI iTensionI = null;
        try {
            if (classArray.length == 2 && classArray[0] == IParticleI.class && classArray[1] == IParticleI.class) {
                iTensionI = constructor.newInstance(iParticleI, iParticleI2);
            } else if (classArray.length == 3 && classArray[0] == IParticleI.class && classArray[1] == IParticleI.class && classArray[2] == Double.TYPE) {
                iTensionI = constructor.newInstance(iParticleI, iParticleI2, tension);
            } else if (classArray.length == 3 && classArray[0] == Object.class && classArray[1] == IParticleI.class && classArray[2] == IParticleI.class) {
                iTensionI = constructor.newInstance(null, iParticleI, iParticleI2);
            } else if (classArray.length == 4 && classArray[0] == Object.class && classArray[1] == IParticleI.class && classArray[2] == IParticleI.class && classArray[3] == Double.TYPE) {
                iTensionI = constructor.newInstance(null, iParticleI, iParticleI2, tension);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iTensionI;
    }

    public static IParticleOnCurveI getParticleOnCurveInstance(ICurveI iCurveI, double d, IVec iVec, Constructor<? extends IParticleOnCurveI> constructor, Class<?>[] classArray) {
        IParticleOnCurveI iParticleOnCurveI = null;
        try {
            if (classArray.length == 2 && classArray[0] == ICurveI.class && classArray[1] == Double.TYPE) {
                iParticleOnCurveI = constructor.newInstance(iCurveI, d);
            } else if (classArray.length == 3 && classArray[0] == ICurveI.class && classArray[1] == Double.TYPE && classArray[2] == Double.TYPE) {
                iParticleOnCurveI = constructor.newInstance(iCurveI, d, 0);
            } else if (classArray.length == 3 && classArray[0] == Object.class && classArray[1] == ICurveI.class && classArray[2] == Double.TYPE) {
                iParticleOnCurveI = constructor.newInstance(null, iCurveI, d);
            } else if (classArray.length == 4 && classArray[0] == Object.class && classArray[1] == ICurveI.class && classArray[2] == Double.TYPE && classArray[3] == Double.TYPE) {
                iParticleOnCurveI = constructor.newInstance(null, iCurveI, d, 0);
            } else if (classArray.length == 3 && classArray[0] == ICurveI.class && classArray[1] == Double.TYPE && classArray[2] == IVec.class) {
                iParticleOnCurveI = constructor.newInstance(iCurveI, d, iVec);
            } else if (classArray.length == 4 && classArray[0] == ICurveI.class && classArray[1] == Double.TYPE && classArray[2] == Double.TYPE && classArray[3] == IVec.class) {
                iParticleOnCurveI = constructor.newInstance(iCurveI, d, 0, iVec);
            } else if (classArray.length == 4 && classArray[0] == Object.class && classArray[1] == ICurveI.class && classArray[2] == Double.TYPE && classArray[3] == IVec.class) {
                iParticleOnCurveI = constructor.newInstance(null, iCurveI, d, iVec);
            } else if (classArray.length == 5 && classArray[0] == Object.class && classArray[1] == ICurveI.class && classArray[2] == Double.TYPE && classArray[3] == Double.TYPE && classArray[4] == IVec.class) {
                iParticleOnCurveI = constructor.newInstance(null, iCurveI, d, 0, iVec);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iParticleOnCurveI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray) {
        int n;
        Object object;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            return ITensileNet.create(iCurveIArray2, iVecIArray);
        }
        if (iCurveIArray2 == null || iCurveIArray2.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray = new IVec[iCurveIArray2.length][2];
        for (int i = 0; i < iCurveIArray2.length; ++i) {
            iVecArray[i][0] = iCurveIArray2[i].start().get();
            iVecArray[i][1] = iCurveIArray2[i].end().get();
        }
        IColor[] iColorArray = new IColor[iCurveIArray2.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray2.length];
        IServer iServer = null;
        if (deleteInputLine) {
            for (n3 = 0; n3 < iCurveIArray2.length; ++n3) {
                if (!(iCurveIArray2[n3] instanceof IObject)) continue;
                iColorArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).clr();
                iLayerArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).layer();
                ((IObject)((Object)iCurveIArray2[n3])).del();
                if (iServer != null) continue;
                iServer = ((IObject)((Object)iCurveIArray2[n3])).server();
            }
        }
        if (deleteInputPoint) {
            for (n3 = 0; n3 < iVecIArray.length; ++n3) {
                if (!(iVecIArray[n3] instanceof IObject)) continue;
                ((IObject)((Object)iVecIArray[n3])).del();
            }
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray.length; ++n3) {
            IVec[] iVecArray2 = iVecArray[n3];
            if (iVecArray2[1].eq(iVecArray2[0], tolerance)) {
                iVecArray[n3] = null;
                continue;
            }
            for (n2 = n3 + 1; n2 < iVecArray.length; ++n2) {
                object = iVecArray[n2];
                for (n = 0; n < 2; ++n) {
                    if (object[n].eq(iVecArray2[0], tolerance)) {
                        object[n] = iVecArray2[0];
                        continue;
                    }
                    if (!object[n].eq(iVecArray2[1], tolerance)) continue;
                    object[n] = iVecArray2[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray.length; ++i) {
            if (iVecArray[i] == null) continue;
            for (n2 = 0; n2 < 2; ++n2) {
                object = iVecArray[i][n2];
                if (arrayList.contains(object)) continue;
                arrayList.add((IVec[])object);
            }
        }
        ArrayList arrayList2 = null;
        if (fixOpenEnd) {
            arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray.length; ++n) {
                    if (iVecArray[n] == null) continue;
                    if (iVecArray[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            blArray[i] = false;
            if (iVecIArray == null) continue;
            for (n = 0; n < iVecIArray.length && !blArray[i]; ++n) {
                if (!iVecIArray[n].eq((IVecI)arrayList.get(i), tolerance)) continue;
                blArray[i] = true;
            }
        }
        ArrayList[] arrayListArray = null;
        if (tensionOnRail || spacingEqualizer) {
            ArrayList[] arrayListArray2;
            arrayListArray = arrayListArray2 = new ArrayList[iCurveIArray.length];
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
        }
        ConstructorAndParameters<IParticleI> constructorAndParameters = null;
        ConstructorAndParameters<ITensionI> constructorAndParameters2 = null;
        ConstructorAndParameters<IParticleOnCurveI> constructorAndParameters3 = null;
        if (particleClass != null) {
            constructorAndParameters = ITensileNet.searchParticleConstructor(particleClass);
        }
        if (tensionClass != null) {
            constructorAndParameters2 = ITensileNet.searchTensionConstructor(tensionClass);
        }
        if (particleOnCurveClass != null) {
            constructorAndParameters3 = ITensileNet.searchParticleOnCurveConstructor(particleOnCurveClass);
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            IParameter iParameter;
            Object object2;
            IParticleI iParticleI;
            int n5;
            int n6;
            Object object3;
            ArrayList<IParticleI> arrayList3 = new ArrayList<IParticleI>();
            for (int i = 0; i < arrayList.size(); ++i) {
                IParticleOnCurveI iParticleOnCurveI;
                if (arrayList.size() > 100 && i % 100 == 0) {
                    IOut.debug(0, "finding curve for point to be on (" + i + "/" + arrayList.size() + ")");
                }
                if ((object3 = (iParticleOnCurveI = ITensileNet.createParticleOnClosestCurve(iCurveIArray, (IVec)arrayList.get(i), railTolerance, 0.001, constructorAndParameters3))) == null) {
                    if (constructorAndParameters != null && (object3 = ITensileNet.getParticleInstance((IVec)arrayList.get(i), constructorAndParameters.constructor, constructorAndParameters.parameters)) != null) {
                        object3.fric(friction);
                        if (fixPointOffRail || fixOpenEnd && arrayList2 != null && arrayList2.contains(arrayList.get(i))) {
                            object3.fix();
                            if (object3 instanceof IObject) {
                                if (fixedPointLayer != null) {
                                    ((IObject)object3).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                                }
                                ((IObject)object3).clr(fixedPointColor);
                            }
                        } else if (object3 instanceof IObject) {
                            if (pointLayer != null) {
                                ((IObject)object3).layer(IG.layer(pointLayer).clr(pointColor));
                            }
                            ((IObject)object3).clr(pointColor);
                        }
                    }
                    if (object3 == null) {
                        IParticle iParticle = new IParticle((IVec)arrayList.get(i));
                        iParticle.fric(friction);
                        if (fixPointOffRail || fixOpenEnd && arrayList2 != null && arrayList2.contains(arrayList.get(i))) {
                            iParticle.fix();
                            iParticle.clr(fixedPointColor);
                            if (fixedPointLayer != null) {
                                iParticle.layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                            }
                        } else {
                            iParticle.clr(pointColor);
                            if (pointLayer != null) {
                                iParticle.layer(IG.layer(pointLayer).clr(pointColor));
                            }
                        }
                        object3 = iParticle;
                    }
                }
                arrayList3.add((IParticleI)object3);
                if (blArray[i]) {
                    object3.fix();
                    if (object3 instanceof IObject) {
                        ((IObject)object3).clr(fixedPointColor);
                        if (fixedPointLayer != null) {
                            ((IObject)object3).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                        }
                    }
                }
                if (iParticleOnCurveI == null) continue;
                if (tensionOnRail || spacingEqualizer) {
                    int n7 = -1;
                    for (n6 = 0; n6 < iCurveIArray.length && n7 < 0; ++n6) {
                        if (iCurveIArray[n6] != iParticleOnCurveI.curve()) continue;
                        n7 = n6;
                    }
                    if (n7 >= 0) {
                        arrayListArray[n7].add(iParticleOnCurveI);
                    }
                }
                if (!fixAtRailEnd || !(iParticleOnCurveI.upos() < IConfig.parameterTolerance) && !(iParticleOnCurveI.upos() > 1.0 - IConfig.parameterTolerance)) continue;
                iParticleOnCurveI.fix();
                if (!(iParticleOnCurveI instanceof IObject)) continue;
                ((IObject)((Object)iParticleOnCurveI)).clr(fixedPointColor);
                if (fixedPointLayer == null) continue;
                ((IObject)((Object)iParticleOnCurveI)).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
            }
            ArrayList<ITensionI> arrayList4 = new ArrayList<ITensionI>();
            for (n5 = 0; n5 < iVecArray.length; ++n5) {
                object3 = iVecArray[n5];
                if (object3 == null) continue;
                int n8 = arrayList.indexOf(object3[0]);
                n6 = arrayList.indexOf(object3[1]);
                if (n8 >= 0 && n6 >= 0) {
                    IParticleI iParticleI2 = arrayList3.get(n8);
                    iParticleI = arrayList3.get(n6);
                    object2 = null;
                    if (constructorAndParameters2 != null && (object2 = ITensileNet.getTensionInstance(iParticleI2, iParticleI, constructorAndParameters2.constructor, constructorAndParameters2.parameters)) != null) {
                        if (object2 instanceof IObject) {
                            if (tensionColor != null) {
                                ((IObject)object2).clr(tensionColor);
                            } else if (iColorArray[n5] != null) {
                                ((IObject)object2).clr(iColorArray[n5]);
                            }
                            if (tensionLayer != null) {
                                ((IObject)object2).layer(tensionLayer);
                            } else if (iLayerArray[n5] != null) {
                                ((IObject)object2).layer(iLayerArray[n5]);
                            }
                        }
                        object2.tension(tension);
                        object2.constant(constantTension);
                        arrayList4.add((ITensionI)object2);
                    }
                    if (object2 != null) continue;
                    iParameter = new ITensionLine(iParticleI2, iParticleI, tension);
                    if (tensionColor != null) {
                        ((ITensionLine)iParameter).clr(tensionColor);
                    } else if (iColorArray[n5] != null) {
                        ((ITensionLine)iParameter).clr(iColorArray[n5]);
                    }
                    if (tensionLayer != null) {
                        ((ITensionLine)iParameter).layer(tensionLayer);
                    } else if (iLayerArray[n5] != null) {
                        ((ITensionLine)iParameter).layer(iLayerArray[n5]);
                    }
                    ((ITensionLine)iParameter).tension(tension);
                    ((ITensionLine)iParameter).constant(constantTension);
                    arrayList4.add((ITensionI)((Object)iParameter));
                    continue;
                }
                IOut.err("end point is not found");
            }
            if (tensionOnRail || spacingEqualizer) {
                for (n5 = 0; n5 < iCurveIArray.length; ++n5) {
                    IDynamicsBase iDynamicsBase;
                    int n9;
                    if (arrayListArray[n5].size() <= 1) continue;
                    ISort.sort(arrayListArray[n5], new IParticleOnCurveComparator());
                    boolean bl = iCurveIArray[n5].isClosed();
                    if (tensionOnRail) {
                        for (n9 = 0; !bl && n9 < arrayListArray[n5].size() - 1 || bl && n9 < arrayListArray[n5].size(); ++n9) {
                            iDynamicsBase = new ITensionOnCurve((IParticleOnCurveI)arrayListArray[n5].get(n9), (IParticleOnCurveI)arrayListArray[n5].get((n9 + 1) % arrayListArray[n5].size()), onRailTension);
                        }
                    }
                    if (!spacingEqualizer) continue;
                    for (n9 = 0; !bl && n9 < arrayListArray[n5].size() - 2 || bl && n9 < arrayListArray[n5].size(); ++n9) {
                        iDynamicsBase = new ISpacingEqualizer((IParticleI)arrayListArray[n5].get(n9), (IParticleI)arrayListArray[n5].get((n9 + 1) % arrayListArray[n5].size()), (IParticleI)arrayListArray[n5].get((n9 + 2) % arrayListArray[n5].size())).tension(equalizerTension);
                    }
                }
            }
            if (straightener) {
                Object object4;
                IParticleI iParticleI3;
                int n10;
                ArrayList<IStraightenerCurve> arrayList5 = new ArrayList<IStraightenerCurve>();
                for (n10 = 0; n10 < arrayList4.size(); ++n10) {
                    IParticleI iParticleI4 = arrayList4.get(n10).pt(0);
                    IParticleI iParticleI5 = arrayList4.get(n10).pt(1);
                    for (int i = n10 + 1; i < arrayList4.size(); ++i) {
                        iParticleI = arrayList4.get(i).pt(0);
                        object2 = arrayList4.get(i).pt(1);
                        iParameter = null;
                        iParticleI3 = null;
                        object4 = null;
                        if (iParticleI4 == iParticleI) {
                            iParameter = iParticleI5;
                            iParticleI3 = iParticleI4;
                            object4 = object2;
                        } else if (iParticleI4 == object2) {
                            iParameter = iParticleI5;
                            iParticleI3 = iParticleI4;
                            object4 = iParticleI;
                        } else if (iParticleI5 == iParticleI) {
                            iParameter = iParticleI4;
                            iParticleI3 = iParticleI5;
                            object4 = object2;
                        } else if (iParticleI5 == object2) {
                            iParameter = iParticleI4;
                            iParticleI3 = iParticleI5;
                            object4 = iParticleI;
                        }
                        if (iParameter == null || iParticleI3 == null || object4 == null || !(Math.abs(iParticleI3.pos().diff(iParameter.pos()).angle(object4.pos().diff(iParticleI3.pos()))) < straightenerThresholdAngle)) continue;
                        IStraightenerCurve iStraightenerCurve = new IStraightenerCurve((IParticleI)iParameter, iParticleI3, (IParticleI)object4);
                        iStraightenerCurve.tension(straightenerTension);
                        iStraightenerCurve.clr(straightenerColor);
                        iStraightenerCurve.layer(IG.layer(straightenerLayer).clr(straightenerColor));
                        arrayList5.add(iStraightenerCurve);
                    }
                }
                if (removeBranchStraightener) {
                    for (n10 = 0; n10 < arrayList5.size(); ++n10) {
                        IParticleI iParticleI6 = ((IStraightenerCurve)arrayList5.get(n10)).pt(0);
                        IParticleI iParticleI7 = ((IStraightenerCurve)arrayList5.get(n10)).pt(1);
                        IParticleI iParticleI8 = ((IStraightenerCurve)arrayList5.get(n10)).pt(2);
                        boolean bl = false;
                        for (int i = n10 + 1; i < arrayList5.size() && !bl; ++i) {
                            iParameter = ((IStraightenerCurve)arrayList5.get(i)).pt(0);
                            iParticleI3 = ((IStraightenerCurve)arrayList5.get(i)).pt(1);
                            object4 = ((IStraightenerCurve)arrayList5.get(i)).pt(2);
                            if (iParticleI7 != iParticleI3 || iParticleI6 != iParameter && iParticleI6 != object4 && iParticleI8 != iParameter && iParticleI8 != object4) continue;
                            double d = iParticleI7.pos().diff(iParticleI6.pos()).angle(iParticleI8.pos().diff(iParticleI7.pos()));
                            double d2 = iParticleI3.pos().diff(iParameter.pos()).angle(object4.pos().diff(iParticleI3.pos()));
                            if (Math.abs(d) < Math.abs(d2)) {
                                ((IStraightenerCurve)arrayList5.get(i)).del();
                                arrayList5.remove(i);
                                --i;
                                continue;
                            }
                            ((IStraightenerCurve)arrayList5.get(n10)).del();
                            arrayList5.remove(n10);
                            --n10;
                            --i;
                            bl = true;
                        }
                    }
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray) {
        int n;
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        for (n = 0; n < iCurveIArray3.length; ++n) {
            int n2;
            IVec iVec;
            IVec iVec2 = iCurveIArray3[n].start().get();
            if (iVec2.eq(iVec = iCurveIArray3[n].end().get(), tolerance)) {
                iVec = null;
            }
            for (n2 = 0; n2 < arrayList.size() && iVec2 != null; ++n2) {
                if (!iVec2.eq((IVecI)arrayList.get(n2), tolerance)) continue;
                iVec2 = null;
            }
            if (iVec2 != null) {
                arrayList.add(iVec2);
            }
            for (n2 = 0; n2 < arrayList.size() && iVec != null; ++n2) {
                if (!iVec.eq((IVecI)arrayList.get(n2), tolerance)) continue;
                iVec = null;
            }
            if (iVec == null) continue;
            arrayList.add(iVec);
        }
        for (n = 0; iVecIArray != null && n < iVecIArray.length; ++n) {
            arrayList.add(iVecIArray[n]);
        }
        return ITensileNet.create(iCurveIArray, iCurveIArray2, arrayList.toArray(new IVecI[arrayList.size()]));
    }

    public static ICurveI findClosestCurve(ICurveI[] iCurveIArray, IVec iVec, int n) {
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j <= n; ++j) {
                double d2 = iCurveIArray[i].pt((double)j / (double)n).dist(iVec);
                if (n2 >= 0 && !(d2 < d)) continue;
                n2 = i;
                d = d2;
            }
        }
        if (n2 < 0) {
            return null;
        }
        return iCurveIArray[n2];
    }

    public static IParticleOnCurveI createParticleOnClosestCurve(ICurveI[] iCurveIArray, IVec iVec, double d, double d2, ConstructorAndParameters<IParticleOnCurveI> constructorAndParameters) {
        IParticleOnCurveI iParticleOnCurveI = null;
        do {
            ICurveI iCurveI = null;
            iCurveI = iCurveIArray.length == 1 ? iCurveIArray[0] : ITensileNet.findClosestCurve(iCurveIArray, iVec, 20);
            iParticleOnCurveI = ITensileNet.createParticleOnCurve(iCurveI, iVec, d, d2, constructorAndParameters);
            if (iParticleOnCurveI != null) continue;
            if (iCurveIArray.length > 1) {
                ICurveI[] iCurveIArray2 = new ICurveI[iCurveIArray.length - 1];
                int n = 0;
                int n2 = 0;
                while (n < iCurveIArray.length) {
                    if (iCurveIArray[n] != iCurveI) {
                        iCurveIArray2[n2] = iCurveIArray[n];
                    } else {
                        --n2;
                    }
                    ++n;
                    ++n2;
                }
                iCurveIArray = iCurveIArray2;
                continue;
            }
            return null;
        } while (iParticleOnCurveI == null && iCurveIArray.length > 1);
        return iParticleOnCurveI;
    }

    public static IParticleOnCurveI createParticleOnCurve(ICurveI iCurveI, IVec iVec, double d, double d2, ConstructorAndParameters<IParticleOnCurveI> constructorAndParameters) {
        IParticleOnCurveI iParticleOnCurveI;
        int n = 0;
        if (iCurveI == null) {
            return null;
        }
        n = d2 == 0.0 ? 10000 : (int)(1.0 / d2 + 0.5);
        double d3 = -1.0;
        double d4 = -1.0;
        for (int i = 0; i <= n; ++i) {
            double d5 = (double)i / (double)n;
            double d6 = iCurveI.pt(d5).dist(iVec);
            if (!(d4 < 0.0) && !(d6 < d3)) continue;
            d3 = d6;
            d4 = d5;
        }
        if (d4 >= 0.0) {
            IVec iVec2 = iCurveI.pt(d4).get();
            IVec iVec3 = iCurveI.tan(d4).get();
            double d7 = iVec3.len2();
            double d8 = iVec.diff(iVec2).dot(iVec3) / d7;
            if ((d4 += d8) < 0.0) {
                d4 = 0.0;
            }
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d3 = iCurveI.pt(d4).dist(iVec);
        }
        if (d >= 0.0 && d3 > d) {
            return null;
        }
        if (constructorAndParameters != null && (iParticleOnCurveI = ITensileNet.getParticleOnCurveInstance(iCurveI, d4, iVec, constructorAndParameters.constructor, constructorAndParameters.parameters)) != null) {
            iParticleOnCurveI.friction(friction);
            if (iParticleOnCurveI instanceof IObject) {
                if (pointLayer != null) {
                    ((IObject)((Object)iParticleOnCurveI)).layer(IG.layer(pointLayer).clr(pointColor));
                }
                ((IObject)((Object)iParticleOnCurveI)).clr(railPointColor);
            }
            return iParticleOnCurveI;
        }
        IParticleOnCurve iParticleOnCurve = new IParticleOnCurve(iCurveI, d4, iVec);
        iParticleOnCurve.fric(friction);
        if (pointLayer != null) {
            iParticleOnCurve.layer(IG.layer(pointLayer).clr(pointColor));
        }
        iParticleOnCurve.clr(railPointColor);
        return iParticleOnCurve;
    }

    public ITensileNet join(ITensileNet iTensileNet) {
        return this.join(iTensileNet, tolerance);
    }

    public ITensileNet join(ITensileNet iTensileNet, double d) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            IParticleI iParticleI = this.nodes.get(i);
            for (int j = 0; j < iTensileNet.nodes.size(); ++j) {
                IParticleI iParticleI2 = iTensileNet.nodes.get(j);
                if (!iParticleI.eq(iParticleI2, d)) continue;
                new IParticleCoupler(iParticleI, iParticleI2);
            }
        }
        return this;
    }

    public static class IParticleCoupler
    extends IDynamicsBase {
        public IParticleI particle1;
        public IParticleI particle2;

        public IParticleCoupler(IParticleI iParticleI, IParticleI iParticleI2) {
            this.particle1 = iParticleI;
            this.particle2 = iParticleI2;
            IConfig.enablePreupdate = true;
            IConfig.loopPreupdate = true;
        }

        @Override
        public void preupdate() {
            if (this.particle1.fixed()) {
                this.particle2.fix();
            } else if (this.particle2.fixed()) {
                this.particle1.fix();
            } else {
                this.particle2.pos(this.particle1.pos());
                this.particle2.vel(this.particle1.vel());
            }
        }
    }

    public static class IParticleOnCurveComparator
    implements IComparator<IParticleOnCurveI> {
        @Override
        public int compare(IParticleOnCurveI iParticleOnCurveI, IParticleOnCurveI iParticleOnCurveI2) {
            if (iParticleOnCurveI.upos() < iParticleOnCurveI2.upos()) {
                return -1;
            }
            if (iParticleOnCurveI.upos() > iParticleOnCurveI2.upos()) {
                return 1;
            }
            return 0;
        }
    }

    public static class ConstructorAndParameters<T> {
        public Constructor<? extends T> constructor;
        public Class<?>[] parameters;

        ConstructorAndParameters(Constructor<? extends T> constructor, Class<?> ... classArray) {
            this.constructor = constructor;
            this.parameters = classArray;
            this.constructor.setAccessible(true);
        }
    }
}

