/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDoubleI;
import igeo.IMatrix;
import igeo.IMatrix2I;
import igeo.IVec2;
import igeo.IVec2I;

public class IMatrix2
extends IMatrix
implements IMatrix2I {
    public IMatrix2() {
        super(2, 2);
        this.setZero();
    }

    public IMatrix2(double d, double d2, double d3, double d4) {
        super(2, 2);
        this.set(d, d2, d3, d4);
    }

    public IMatrix2(IMatrix2 iMatrix2) {
        super(2, 2);
        this.set(iMatrix2.val);
    }

    @Override
    public IMatrix2 get() {
        return this;
    }

    @Override
    public IMatrix2 set(double d, double d2, double d3, double d4) {
        this.val[0][0] = d;
        this.val[0][1] = d2;
        this.val[1][0] = d3;
        this.val[1][1] = d4;
        return this;
    }

    @Override
    public IMatrix2 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return this.set(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x(), iDoubleI4.x());
    }

    @Override
    public IMatrix2 dup() {
        return new IMatrix2(this);
    }

    @Override
    public IMatrix2 cp() {
        return this.dup();
    }

    @Override
    public double determinant() {
        return IMatrix2.det(this.val[0][0], this.val[0][1], this.val[1][0], this.val[1][1]);
    }

    @Override
    public IMatrix2 invert() {
        double d = this.determinant();
        this.set(this.val[1][1], -this.val[0][1], -this.val[1][0], this.val[0][0]);
        this.div(d);
        return this;
    }

    public IMatrix2 mul(IMatrix2 iMatrix2) {
        for (int i = 0; i < 2; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < 2; ++j) {
                d += this.val[i][j] * iMatrix2.val[j][0];
                d2 += this.val[i][j] * iMatrix2.val[j][1];
            }
            this.val[i][0] = d;
            this.val[i][1] = d2;
        }
        return this;
    }

    @Override
    public IMatrix2 mul(IMatrix2I iMatrix2I) {
        return this.mul(iMatrix2I.get());
    }

    @Override
    public IVec2 mul(IVec2I iVec2I) {
        return this.mul(iVec2I.get());
    }

    public IVec2 mul(IVec2 iVec2) {
        IVec2 iVec22 = new IVec2();
        iVec22.x = this.val[0][0] * iVec2.x + this.val[0][1] * iVec2.y;
        iVec22.y = this.val[1][0] * iVec2.x + this.val[1][1] * iVec2.y;
        return iVec22;
    }

    public static IMatrix2 getRotation(double d) {
        return new IMatrix2(Math.cos(d), -Math.sin(d), Math.sin(d), Math.cos(d));
    }
}

