/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IAttribute;
import igeo.IColor;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.ISurface;
import igeo.ISurfaceGeo;
import igeo.ISurfaceR;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicFillGL;
import igeo.gui.ISurfaceGraphicWireframeGL;

public class ISurfaceGraphicGL
extends IGraphicObject {
    public ISurfaceGraphicFillGL fill;
    public ISurfaceGraphicWireframeGL wireframe;

    public ISurfaceGraphicGL(ISurface iSurface) {
        super(iSurface);
        this.wireframe = new ISurfaceGraphicWireframeGL(iSurface);
        this.fill = new ISurfaceGraphicFillGL(iSurface);
    }

    public ISurfaceGraphicGL(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
        this.wireframe = new ISurfaceGraphicWireframeGL(iSurfaceR);
        this.fill = new ISurfaceGraphicFillGL(iSurfaceR);
    }

    public ISurfaceGraphicGL(IObject iObject, ISurfaceGeo iSurfaceGeo) {
        super(iObject);
        this.wireframe = new ISurfaceGraphicWireframeGL(iObject, iSurfaceGeo);
        this.fill = new ISurfaceGraphicFillGL(iObject, iSurfaceGeo);
    }

    @Override
    public void setAttribute(IAttribute iAttribute) {
        super.setAttribute(iAttribute);
        if (this.fill != null) {
            this.fill.setAttribute(iAttribute);
        }
        if (this.wireframe != null) {
            this.wireframe.setAttribute(iAttribute);
        }
    }

    @Override
    public void setColor(IColor iColor) {
        super.setColor(iColor);
        if (this.fill != null) {
            this.fill.setColor(iColor);
        }
        if (this.wireframe != null) {
            this.wireframe.setColor(iColor);
        }
    }

    @Override
    public void setWeight(float f) {
        if (this.wireframe != null) {
            this.wireframe.setWeight(f);
        }
    }

    @Override
    public float getWeight() {
        if (this.wireframe != null) {
            return this.wireframe.getWeight();
        }
        return -1.0f;
    }

    @Override
    public void update() {
        if (this.fill != null) {
            this.fill.update();
        }
        if (this.wireframe != null) {
            this.wireframe.update();
        }
    }

    @Override
    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (iGraphics.view().mode().isFill()) {
            this.fill.draw(iGraphics);
        }
        if (iGraphics.view().mode().isWireframe()) {
            this.wireframe.draw(iGraphics);
        }
    }
}

