/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IDynamics;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IParticleOnCurveI;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IVec;
import igeo.IVec2I;
import igeo.IVecI;
import java.util.ArrayList;

public class IParticleOnCurveGeo
extends IParticleGeo
implements IParticleOnCurveI {
    public ICurveI curve;
    public double upos;
    public double uvel;
    public double ufrc;
    public IVec utan;

    public IParticleOnCurveGeo(ICurveI iCurveI) {
        this(iCurveI, 0.0);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d) {
        super(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, double d2) {
        this(iCurveI, d);
        this.uvel = d2;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, IVec iVec) {
        this(iCurveI, 0.0, iVec);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, IVec iVec) {
        super(iVec);
        iVec.set(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, double d2, IVec iVec) {
        this(iCurveI, d, iVec);
        this.uvel = d2;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, IObject iObject) {
        this(iCurveI, 0.0, iObject);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, IObject iObject) {
        super(iCurveI.pt(d).get(), iObject);
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, double d2, IObject iObject) {
        this(iCurveI, d, iObject);
        this.uvel = d2;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, IVec iVec, IObject iObject) {
        this(iCurveI, 0.0, iVec, iObject);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, IVec iVec, IObject iObject) {
        super(iVec, iObject);
        iVec.set(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, double d2, IVec iVec, IObject iObject) {
        this(iCurveI, d, iVec, iObject);
        this.uvel = d2;
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, IPoint iPoint) {
        this(iCurveI, d, iPoint.pos, (IObject)iPoint);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, double d2, IPoint iPoint) {
        this(iCurveI, d, d2, iPoint.pos, iPoint);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, IPoint iPoint) {
        this(iCurveI, 0.0, iPoint.pos, (IObject)iPoint);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, IPointR iPointR) {
        this(iCurveI, 0.0, iPointR.pos.get(), (IObject)iPointR);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, IPointR iPointR) {
        this(iCurveI, d, iPointR.pos.get(), (IObject)iPointR);
    }

    public IParticleOnCurveGeo(ICurveI iCurveI, double d, double d2, IPointR iPointR) {
        this(iCurveI, d, d2, iPointR.pos.get(), iPointR);
    }

    public IParticleOnCurveGeo(ICurve iCurve) {
        this((ICurveI)iCurve, 0.0, (IObject)iCurve);
    }

    public IParticleOnCurveGeo(ICurve iCurve, double d) {
        this((ICurveI)iCurve, d, (IObject)iCurve);
    }

    public IParticleOnCurveGeo(ICurve iCurve, double d, double d2) {
        this((ICurveI)iCurve, d, d2, (IObject)iCurve);
    }

    public IParticleOnCurveGeo(ICurve iCurve, IVec iVec) {
        this((ICurveI)iCurve, 0.0, iVec, (IObject)iCurve);
    }

    public IParticleOnCurveGeo(ICurve iCurve, double d, IVec iVec) {
        this((ICurveI)iCurve, d, iVec, (IObject)iCurve);
    }

    public IParticleOnCurveGeo(ICurve iCurve, double d, double d2, IVec iVec) {
        this(iCurve, d, d2, iVec, iCurve);
    }

    public IParticleOnCurveGeo(IParticleOnCurveGeo iParticleOnCurveGeo) {
        this(iParticleOnCurveGeo.curve, iParticleOnCurveGeo.upos, iParticleOnCurveGeo.pos.dup(), iParticleOnCurveGeo.parent());
    }

    public IParticleOnCurveGeo(IParticleOnCurveGeo iParticleOnCurveGeo, IVec iVec) {
        this(iParticleOnCurveGeo.curve, iParticleOnCurveGeo.upos, iVec, iParticleOnCurveGeo.parent());
    }

    public IParticleOnCurveGeo(IParticleOnCurveGeo iParticleOnCurveGeo, IObject iObject) {
        this(iParticleOnCurveGeo.curve, iParticleOnCurveGeo.upos, iParticleOnCurveGeo.pos.dup(), iObject);
    }

    public IParticleOnCurveGeo(IParticleOnCurveGeo iParticleOnCurveGeo, IVec iVec, IObject iObject) {
        this(iParticleOnCurveGeo.curve, iParticleOnCurveGeo.upos, iVec, iObject);
    }

    @Override
    public IParticleOnCurveGeo dup() {
        return new IParticleOnCurveGeo(this);
    }

    @Override
    public ICurveI curve() {
        return this.curve;
    }

    @Override
    public synchronized IParticleOnCurveGeo fix() {
        super.fix();
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo unfix() {
        super.unfix();
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo skipUpdateOnce(boolean bl) {
        super.skipUpdateOnce(bl);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo mass(double d) {
        super.mass(d);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo position(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo pos(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo velocity(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo vel(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo force(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo frc(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo friction(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo fric(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo decay(double d) {
        return this.fric(d);
    }

    @Override
    public synchronized IParticleOnCurveGeo push(IVecI iVecI) {
        super.push(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo pull(IVecI iVecI) {
        super.pull(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo addForce(IVecI iVecI) {
        super.addForce(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo reset() {
        super.reset();
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo resetForce() {
        super.resetForce();
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo uposition(double d) {
        return this.upos(d);
    }

    @Override
    public synchronized IParticleOnCurveGeo upos(double d) {
        this.upos = d;
        return this;
    }

    @Override
    public synchronized double uposition() {
        return this.upos();
    }

    @Override
    public synchronized double upos() {
        return this.upos;
    }

    @Override
    public synchronized IParticleOnCurveGeo uvelocity(double d) {
        return this.uvel(d);
    }

    @Override
    public synchronized IParticleOnCurveGeo uvel(double d) {
        this.uvel = d;
        return this;
    }

    @Override
    public synchronized double uvelocity() {
        return this.uvel();
    }

    @Override
    public synchronized double uvel() {
        return this.uvel;
    }

    @Override
    public synchronized IParticleOnCurveGeo uforce(double d) {
        return this.ufrc(d);
    }

    @Override
    public synchronized IParticleOnCurveGeo ufrc(double d) {
        this.ufrc = d;
        return this;
    }

    @Override
    public synchronized double uforce() {
        return this.ufrc();
    }

    @Override
    public synchronized double ufrc() {
        return this.ufrc;
    }

    @Override
    public synchronized IParticleOnCurveGeo addUForce(double d) {
        return this.upush(d);
    }

    @Override
    public synchronized IParticleOnCurveGeo resetUForce() {
        return this.ureset();
    }

    @Override
    public synchronized IParticleOnCurveGeo upush(double d) {
        this.ufrc += d;
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo upull(double d) {
        this.ufrc -= d;
        return this;
    }

    @Override
    public synchronized IParticleOnCurveGeo ureset() {
        this.ufrc = 0.0;
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public synchronized void preupdate() {
        if (this.fixed || this.curve == null) {
            return;
        }
        this.utan = this.curve.tan(this.upos).get();
        this.ufrc = this.frc.projectToVec(this.utan) > 0.0 ? (this.ufrc += this.frc.len() / this.utan.len()) : (this.ufrc += -this.frc.len() / this.utan.len());
        this.uvel += this.ufrc / this.mass * IConfig.updateRate;
        this.uvel *= 1.0 - this.friction;
        if (!IConfig.enablePostupdate || !IConfig.clearParticleForceInPostupdate) {
            this.frc.zero();
            this.ufrc = 0.0;
        }
    }

    @Override
    public synchronized void update() {
        if (this.skipUpdateOnce) {
            this.skipUpdateOnce = false;
            return;
        }
        if (this.fixed || this.curve == null) {
            return;
        }
        if (this.upos + this.uvel * IConfig.updateRate < 0.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * IConfig.updateRate;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 0.0;
                this.uvel = 0.0;
            }
        } else if (this.upos + this.uvel * IConfig.updateRate > 1.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * IConfig.updateRate;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 1.0;
                this.uvel = 0.0;
            }
        } else {
            this.upos += this.uvel * IConfig.updateRate;
        }
        this.pos.set(this.curve.pt(this.upos));
    }

    @Override
    public synchronized void postupdate() {
        if (IConfig.enablePostupdate && IConfig.clearParticleForceInPostupdate) {
            this.frc.zero();
            this.ufrc = 0.0;
        }
    }

    @Override
    public IParticleOnCurveGeo x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo x(IVecI iVecI) {
        this.pos.x(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo y(IVecI iVecI) {
        this.pos.y(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo z(IVecI iVecI) {
        this.pos.z(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo x(IVec2I iVec2I) {
        this.pos.x(iVec2I);
        return this;
    }

    @Override
    public IParticleOnCurveGeo y(IVec2I iVec2I) {
        this.pos.y(iVec2I);
        return this;
    }

    @Override
    public IParticleOnCurveGeo set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IParticleOnCurveGeo rev() {
        return this.neg();
    }

    @Override
    public IParticleOnCurveGeo flip() {
        return this.neg();
    }

    @Override
    public IParticleOnCurveGeo zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(double d, IVecI iVecI) {
        this.pos.add(d, iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        this.pos.add(iDoubleI, iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(double d) {
        this.pos.rot2(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(IDoubleI iDoubleI) {
        this.pos.rot2(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticleOnCurveGeo ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurveGeo translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurveGeo transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IParticleOnCurveGeo transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IParticleOnCurveGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticleOnCurveGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IParticleOnCurveGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IParticleOnCurveGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticleOnCurveGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IParticleOnCurveGeo cp() {
        return this.dup();
    }

    @Override
    public IParticleOnCurveGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IParticleOnCurveGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticleOnCurveGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

