/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBSplineBasisFunction;
import igeo.IBool;
import igeo.IConfig;
import igeo.ICurveCache;
import igeo.ICurveI;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IEdge;
import igeo.IEntityParameter;
import igeo.IG;
import igeo.IInteger;
import igeo.IIntegerI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.INurbsGeo;
import igeo.IOut;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;

public class ICurveGeo
extends INurbsGeo
implements ICurveI,
IEntityParameter {
    public IVecI[] controlPoints;
    public int degree;
    public double[] knots;
    public double ustart;
    public double uend;
    public boolean[] defaultWeights;
    public IBSplineBasisFunction basisFunction;
    public IBSplineBasisFunction derivativeFunction;
    public ICurveCache uSearchCache;

    public ICurveGeo() {
    }

    public ICurveGeo(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        this.ustart = d;
        this.uend = d2;
        if (d != 0.0 || d2 != 1.0) {
            ICurveGeo.normalizeKnots(dArray, d, d2);
        }
        this.init(iVecIArray, n, dArray);
    }

    public ICurveGeo(IVecI[] iVecIArray, int n, double[] dArray) {
        this.ustart = dArray[0];
        this.uend = dArray[dArray.length - 1];
        if (dArray[0] != 0.0 || dArray[dArray.length - 1] != 1.0) {
            ICurveGeo.normalizeKnots(dArray, dArray[0], dArray[dArray.length - 1]);
        }
        this.init(iVecIArray, n, dArray);
    }

    public ICurveGeo(IVecI[] iVecIArray, int n) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, n, ICurveGeo.createKnots(n, iVecIArray.length));
    }

    public ICurveGeo(IVecI[] iVecIArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, 1, ICurveGeo.createKnots(1, iVecIArray.length));
    }

    public ICurveGeo(IVecI[] iVecIArray, int n, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, n, bl);
    }

    public ICurveGeo(IVecI[] iVecIArray, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, 1, bl);
    }

    public ICurveGeo(IVecI iVecI, IVecI iVecI2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(new IVecI[]{iVecI, iVecI2}, 1, ICurveGeo.createKnots(1, 2));
    }

    public ICurveGeo(IVecI iVecI) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(new IVecI[]{iVecI, iVecI.dup()}, 1, ICurveGeo.createKnots(1, 2));
    }

    public ICurveGeo(double d, double d2, double d3, double d4, double d5, double d6) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6));
    }

    public ICurveGeo(double[][] dArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), 1);
    }

    public ICurveGeo(double[][] dArray, int n) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), n);
    }

    public ICurveGeo(double[][] dArray, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), 1, bl);
    }

    public ICurveGeo(double[][] dArray, int n, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), n, bl);
    }

    public ICurveGeo(IEdge iEdge) {
        this(iEdge.vertex(0), iEdge.vertex(1));
    }

    public ICurveGeo(ICurveGeo iCurveGeo) {
        this.controlPoints = new IVecI[iCurveGeo.controlPoints.length];
        for (int i = 0; i < this.controlPoints.length; ++i) {
            this.controlPoints[i] = iCurveGeo.controlPoints[i].dup();
        }
        this.knots = new double[iCurveGeo.knots.length];
        System.arraycopy(iCurveGeo.knots, 0, this.knots, 0, this.knots.length);
        this.degree = iCurveGeo.degree;
        this.ustart = iCurveGeo.ustart;
        this.uend = iCurveGeo.uend;
        this.init(this.controlPoints, this.degree, this.knots);
    }

    public void init(IVecI[] iVecIArray) {
        this.init(iVecIArray, 1, ICurveGeo.createKnots(1, iVecIArray.length));
    }

    public void init(IVecI[] iVecIArray, int n) {
        this.init(iVecIArray, n, ICurveGeo.createKnots(n, iVecIArray.length));
    }

    public void init(IVecI[] iVecIArray, boolean bl) {
        this.init(iVecIArray, 1, bl);
    }

    public void init(IVecI[] iVecIArray, int n, boolean bl) {
        if (bl) {
            IVecI[] iVecIArray2 = ICurveGeo.createClosedCP(iVecIArray, n);
            this.init(iVecIArray2, n, ICurveGeo.createClosedKnots(n, iVecIArray2.length));
        } else {
            this.init(iVecIArray, n, ICurveGeo.createKnots(n, iVecIArray.length));
        }
    }

    public void init(IVecI[] iVecIArray, int n, double[] dArray) {
        if (IConfig.checkValidControlPoint) {
            ICurveGeo.isValidCP(iVecIArray, n, dArray);
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ICurveGeo.checkDuplicatedCP(iVecIArray);
        } else if (IConfig.checkDuplicatedControlPointOnEdge) {
            ICurveGeo.checkDuplicatedCPOnEdge(iVecIArray);
        }
        this.controlPoints = iVecIArray;
        this.degree = n;
        this.knots = dArray;
        this.basisFunction = new IBSplineBasisFunction(n, dArray);
        this.defaultWeights = new boolean[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            this.defaultWeights[i] = !(iVecIArray[i] instanceof IVec4I);
        }
    }

    @Override
    public boolean isValid() {
        return ICurveGeo.isValidCP(this.controlPoints, this.degree, this.knots);
    }

    public static boolean isValidCP(IVecI[] iVecIArray, int n, double[] dArray) {
        if (iVecIArray == null) {
            IOut.err("control points are null");
            return false;
        }
        if (dArray == null) {
            IOut.err("knots are null");
            return false;
        }
        if (n <= 0) {
            IOut.err("invalid degree (" + n + ")");
            return false;
        }
        int n2 = iVecIArray.length;
        if (n2 <= n) {
            IOut.err("too less control points (" + n2 + ") for degree " + n + ". it needs minimum " + (n + 1));
            return false;
        }
        if (dArray.length != n + n2 + 1) {
            IOut.err("knot array length is invalid. it needs to be " + (n + n2 + 1));
            return false;
        }
        if (!ICurveGeo.isValidCP(iVecIArray)) {
            return false;
        }
        if (!ICurveGeo.isValidKnots(dArray)) {
            IOut.err("knot has invalid value");
            return false;
        }
        return true;
    }

    public static boolean isValidCP(IVecI[] iVecIArray) {
        for (int i = 0; i < iVecIArray.length; ++i) {
            if (iVecIArray[i].isValid()) continue;
            IOut.err("controlPoint at " + i + " is invalid");
            return false;
        }
        return true;
    }

    public static void checkDuplicatedCP(IVecI[] iVecIArray) {
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = i + 1; j < iVecIArray.length; ++j) {
                if (iVecIArray[j] != iVecIArray[i]) continue;
                iVecIArray[j] = iVecIArray[i].dup();
            }
        }
    }

    public static void checkDuplicatedCP(IVecI[] iVecIArray, IVecI iVecI) {
        for (int i = 0; i < iVecIArray.length; ++i) {
            if (iVecIArray[i] != iVecI) continue;
            iVecIArray[i] = iVecI.dup();
        }
    }

    public static void checkDuplicatedCP(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray2.length; ++j) {
                if (iVecIArray[i] != iVecIArray2[j]) continue;
                iVecIArray[i] = iVecIArray2[j].dup();
            }
        }
    }

    public static void checkDuplicatedCPOnEdge(IVecI[] iVecIArray) {
        if (iVecIArray[0] == iVecIArray[iVecIArray.length - 1]) {
            iVecIArray[iVecIArray.length - 1] = iVecIArray[0].dup();
        }
    }

    public static IVec[] getPointsFromArray(double[][] dArray) {
        IVec[] iVecArray = new IVec[dArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            if (dArray[i].length == 4) {
                iVecArray[i] = new IVec4(dArray[i][0], dArray[i][1], dArray[i][2], dArray[i][3]);
                continue;
            }
            iVecArray[i] = new IVec();
            if (dArray[i].length >= 1) {
                iVecArray[i].x = dArray[i][0];
            }
            if (dArray[i].length >= 2) {
                iVecArray[i].y = dArray[i][1];
            }
            if (dArray[i].length < 3) continue;
            iVecArray[i].z = dArray[i][2];
        }
        return iVecArray;
    }

    @Override
    public ICurveGeo get() {
        return this;
    }

    @Override
    public ICurveGeo dup() {
        return new ICurveGeo(this);
    }

    @Override
    public IVec pt(IDoubleI iDoubleI) {
        return this.pt(iDoubleI.x());
    }

    @Override
    public IVec pt(double d) {
        IVec iVec = new IVec();
        this.pt(d, iVec);
        return iVec;
    }

    public void pt(double d, IVec iVec) {
        int n = this.basisFunction.index(d);
        double[] dArray = this.basisFunction.eval(n, d);
        double d2 = 0.0;
        for (int i = 0; i <= this.degree; ++i) {
            IVec iVec2 = this.controlPoints[n - this.degree + i].get();
            double d3 = 1.0;
            if (!this.defaultWeights[n - this.degree + i]) {
                d3 = ((IVec4)iVec2).w;
            }
            iVec.x += iVec2.x * d3 * dArray[i];
            iVec.y += iVec2.y * d3 * dArray[i];
            iVec.z += iVec2.z * d3 * dArray[i];
            d2 += d3 * dArray[i];
        }
        iVec.x /= d2;
        iVec.y /= d2;
        iVec.z /= d2;
    }

    @Override
    public IVec tan(IDoubleI iDoubleI) {
        return this.tan(iDoubleI.x());
    }

    @Override
    public IVec tan(double d) {
        IVec iVec = new IVec();
        this.tan(d, iVec);
        return iVec;
    }

    public void tan(double d, IVec iVec) {
        if (this.derivativeFunction == null) {
            this.derivativeFunction = new IBSplineBasisFunction(this.basisFunction);
            this.derivativeFunction.differentiate();
        }
        int n = this.derivativeFunction.index(d);
        double[] dArray = this.derivativeFunction.eval(n, d);
        double[] dArray2 = this.basisFunction.eval(n, d);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.degree; ++i) {
            IVec iVec2 = this.controlPoints[n - this.degree + i].get();
            double d2 = 1.0;
            if (!this.defaultWeights[n - this.degree + i]) {
                d2 = ((IVec4)iVec2).w;
            }
            iVec4.x += iVec2.x * d2 * dArray2[i];
            iVec4.y += iVec2.y * d2 * dArray2[i];
            iVec4.z += iVec2.z * d2 * dArray2[i];
            iVec4.w += d2 * dArray2[i];
            iVec42.x += iVec2.x * d2 * dArray[i];
            iVec42.y += iVec2.y * d2 * dArray[i];
            iVec42.z += iVec2.z * d2 * dArray[i];
            iVec42.w += d2 * dArray[i];
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    @Override
    public IVecI cp(int n) {
        return this.controlPoints[n];
    }

    @Override
    public IVecI cp(IIntegerI iIntegerI) {
        return this.controlPoints[iIntegerI.x()];
    }

    @Override
    public IVecI[] cps() {
        return this.controlPoints;
    }

    public ICurveGeo addCP(IVecI iVecI, int n) {
        if (this.degree == n || this.controlPoints.length == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            return this.addCP(iVecI);
        }
        if (this.controlPoints.length + 1 > n) {
            this.degree = n;
        }
        return this.addCP(iVecI);
    }

    public ICurveGeo addCP(IVecI iVecI) {
        int n;
        if (!iVecI.isValid()) {
            IOut.err("input pt is invalid. not added");
            return this;
        }
        if (this.controlPoints.length == 2 && this.controlPoints[0].x() == this.controlPoints[1].x() && this.controlPoints[0].y() == this.controlPoints[1].y() && this.controlPoints[0].z() == this.controlPoints[1].z()) {
            if (IConfig.checkDuplicatedControlPoint) {
                ICurveGeo.checkDuplicatedCP(this.controlPoints, iVecI);
            }
            this.controlPoints[1] = iVecI;
            this.defaultWeights[1] = !(iVecI instanceof IVec4I);
            return this;
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ICurveGeo.checkDuplicatedCP(this.controlPoints, iVecI);
        }
        if ((n = this.controlPoints.length) == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            n = 1;
        }
        IVecI[] iVecIArray = new IVecI[n + 1];
        for (int i = 0; i < n; ++i) {
            iVecIArray[i] = this.controlPoints[i];
        }
        iVecIArray[n] = iVecI;
        double[] dArray = ICurveGeo.createKnots(this.degree, n + 1);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n + 1];
        for (int i = 0; i < n; ++i) {
            blArray[i] = this.defaultWeights[i];
        }
        blArray[n] = !(iVecI instanceof IVec4I);
        this.controlPoints = iVecIArray;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    public ICurveGeo addCP(int n, IVecI iVecI, int n2) {
        if (this.degree == n2 || this.controlPoints.length == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            return this.addCP(n, iVecI);
        }
        if (this.controlPoints.length + 1 > n2) {
            this.degree = n2;
        }
        return this.addCP(n, iVecI);
    }

    public ICurveGeo addCP(int n, IVecI iVecI) {
        int n2;
        int n3 = this.controlPoints.length;
        if (n < 0 || n >= n3) {
            IOut.err("index " + n + " is out of range. not added");
            return this;
        }
        if (!iVecI.isValid()) {
            IOut.err("input pt is invalid. not added");
            return this;
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ICurveGeo.checkDuplicatedCP(this.controlPoints, iVecI);
        }
        if (n3 == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            n3 = 1;
        }
        IVecI[] iVecIArray = new IVecI[n3 + 1];
        for (n2 = 0; n2 < n; ++n2) {
            iVecIArray[n2] = this.controlPoints[n2];
        }
        iVecIArray[n2++] = iVecI;
        while (n2 < n3 + 1) {
            iVecIArray[n2] = this.controlPoints[n2 - 1];
            ++n2;
        }
        double[] dArray = ICurveGeo.createKnots(this.degree, n3 + 1);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n3 + 1];
        for (n2 = 0; n2 < n; ++n2) {
            blArray[n2] = this.defaultWeights[n2];
        }
        boolean bl = blArray[n2++] = !(iVecI instanceof IVec4I);
        while (n2 < n3 + 1) {
            blArray[n2] = this.defaultWeights[n2 - 1];
            ++n2;
        }
        this.controlPoints = iVecIArray;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    public ICurveGeo addCP(IVecI[] iVecIArray, int n) {
        if (this.degree == n || this.controlPoints.length == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            return this.addCP(iVecIArray);
        }
        if (this.controlPoints.length + 1 > n) {
            this.degree = n;
        }
        return this.addCP(iVecIArray);
    }

    public ICurveGeo addCP(IVecI[] iVecIArray) {
        int n;
        int n2;
        int n3 = iVecIArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (iVecIArray[n2].isValid()) continue;
            IOut.err("input pts[" + n2 + "] is invalid. not added");
            return this;
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ICurveGeo.checkDuplicatedCP(this.controlPoints, iVecIArray);
        }
        if ((n2 = this.controlPoints.length) == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            n2 = 1;
        }
        IVecI[] iVecIArray2 = new IVecI[n2 + n3];
        for (n = 0; n < n2; ++n) {
            iVecIArray2[n] = this.controlPoints[n];
        }
        while (n < n2 + n3) {
            iVecIArray2[n] = iVecIArray[n - n2];
            ++n;
        }
        double[] dArray = ICurveGeo.createKnots(this.degree, n2 + n3);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n2 + n3];
        for (n = 0; n < n2; ++n) {
            blArray[n] = this.defaultWeights[n];
        }
        while (n < n2 + n3) {
            blArray[n] = !(iVecIArray[n - n2] instanceof IVec4I);
            ++n;
        }
        this.controlPoints = iVecIArray2;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    public ICurveGeo addCP(int n, IVecI[] iVecIArray, int n2) {
        if (this.degree == n2 || this.controlPoints.length == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            return this.addCP(n, iVecIArray);
        }
        if (this.controlPoints.length + 1 > n2) {
            this.degree = n2;
        }
        return this.addCP(n, iVecIArray);
    }

    public ICurveGeo addCP(int n, IVecI[] iVecIArray) {
        int n2;
        int n3 = this.controlPoints.length;
        if (n < 0 || n >= n3) {
            IOut.err("index " + n + " is out of range. not added");
            return this;
        }
        int n4 = iVecIArray.length;
        for (int i = 0; i < n4; ++i) {
            if (iVecIArray[i].isValid()) continue;
            IOut.err("input pts[" + i + "] is invalid. not added");
            return this;
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ICurveGeo.checkDuplicatedCP(this.controlPoints, iVecIArray);
        }
        if (n3 == 2 && this.controlPoints[0].eq(this.controlPoints[1])) {
            n3 = 1;
        }
        IVecI[] iVecIArray2 = new IVecI[n3 + n4];
        for (n2 = 0; n2 < n; ++n2) {
            iVecIArray2[n2] = this.controlPoints[n2];
        }
        while (n2 < n + n4) {
            iVecIArray2[n2] = iVecIArray[n2 - n];
            ++n2;
        }
        while (n2 < n3 + n4) {
            iVecIArray2[n2] = this.controlPoints[n2 - n4];
            ++n2;
        }
        double[] dArray = ICurveGeo.createKnots(this.degree, n3 + n4);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n3 + n4];
        for (n2 = 0; n2 < n; ++n2) {
            blArray[n2] = this.defaultWeights[n2];
        }
        while (n2 < n + n4) {
            blArray[n2] = !(iVecIArray[n2 - n] instanceof IVec4I);
            ++n2;
        }
        while (n2 < n3 + n4) {
            blArray[n2] = this.defaultWeights[n2 - n4];
            ++n2;
        }
        this.controlPoints = iVecIArray2;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    public ICurveGeo insertCP(int n, IVecI iVecI) {
        return this.addCP(n, iVecI);
    }

    public ICurveGeo insertCP(int n, IVecI[] iVecIArray) {
        return this.addCP(n, iVecIArray);
    }

    public ICurveGeo removeCP() {
        int n = this.controlPoints.length;
        IVecI[] iVecIArray = new IVecI[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            iVecIArray[i] = this.controlPoints[i];
        }
        double[] dArray = ICurveGeo.createKnots(this.degree, n - 1);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            blArray[i] = this.defaultWeights[i];
        }
        this.controlPoints = iVecIArray;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    public ICurveGeo removeCP(int n) {
        int n2;
        int n3 = this.controlPoints.length;
        if (n < 0 || n >= n3) {
            IOut.err("index " + n + " is out of range. not removed");
            return this;
        }
        IVecI[] iVecIArray = new IVecI[n3 - 1];
        for (n2 = 0; n2 < n; ++n2) {
            iVecIArray[n2] = this.controlPoints[n2];
        }
        while (n2 < n3 - 1) {
            iVecIArray[n2] = this.controlPoints[n2 + 1];
            ++n2;
        }
        double[] dArray = ICurveGeo.createKnots(this.degree, n3 - 1);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n3 - 1];
        for (n2 = 0; n2 < n; ++n2) {
            blArray[n2] = this.defaultWeights[n2];
        }
        while (n2 < n3 - 1) {
            blArray[n2] = this.defaultWeights[n2 + 1];
            ++n2;
        }
        this.controlPoints = iVecIArray;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    public ICurveGeo removeCP(int n, int n2) {
        int n3;
        int n4 = this.controlPoints.length;
        if (n < 0 || n >= n4 || n2 < 0 || n >= n4 || n >= n2) {
            IOut.err("index range [" + n + "-" + n2 + " is invalid. not removed");
            return this;
        }
        int n5 = n2 - n;
        IVecI[] iVecIArray = new IVecI[n4 - n5];
        for (n3 = 0; n3 < n; ++n3) {
            iVecIArray[n3] = this.controlPoints[n3];
        }
        while (n3 < n4 - n5) {
            iVecIArray[n3] = this.controlPoints[n3 + n5];
            ++n3;
        }
        double[] dArray = ICurveGeo.createKnots(this.degree, n4 - n5);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.degree, dArray);
        boolean[] blArray = new boolean[n4 - n5];
        for (n3 = 0; n3 < n; ++n3) {
            blArray[n3] = this.defaultWeights[n3];
        }
        while (n3 < n4 - n5) {
            blArray[n3] = this.defaultWeights[n3 + n5];
            ++n3;
        }
        this.controlPoints = iVecIArray;
        this.knots = dArray;
        this.basisFunction = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        this.uSearchCache = null;
        return this;
    }

    @Override
    public IVec ep(int n) {
        return this.pt(this.knots[n + this.degree]);
    }

    @Override
    public IVec ep(IIntegerI iIntegerI) {
        return this.pt(this.knots[iIntegerI.x() + this.degree]);
    }

    @Override
    public IVec start() {
        return this.pt(0.0);
    }

    @Override
    public IVec end() {
        return this.pt(1.0);
    }

    @Override
    public IVec startCP() {
        return this.controlPoints[0].get();
    }

    @Override
    public IVec endCP() {
        return this.controlPoints[this.controlPoints.length - 1].get();
    }

    @Override
    public IVec mid() {
        return this.pt(0.5);
    }

    @Override
    public IVec center() {
        int n = this.cpNum();
        if (this.isClosed()) {
            n -= this.overlapCPNum();
        }
        IVec iVec = new IVec();
        for (int i = 0; i < n; ++i) {
            iVec.add(this.cp(i));
        }
        iVec.div(n);
        return iVec;
    }

    @Override
    public synchronized double u(IVecI iVecI) {
        if (this.uSearchCache == null) {
            this.uSearchCache = new ICurveCache(this);
        }
        return this.uSearchCache.u(iVecI.get());
    }

    @Override
    public double u(ISwitchE iSwitchE, IVecI iVecI) {
        return this.u(iVecI);
    }

    @Override
    public IDouble u(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.u(iVecI));
    }

    @Override
    public double u(IVec2I iVec2I) {
        if (this.uSearchCache == null) {
            this.uSearchCache = new ICurveCache(this);
        }
        return this.uSearchCache.u(iVec2I.get());
    }

    @Override
    public double u(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.u(iVec2I);
    }

    @Override
    public IDouble u(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.u(iVec2I));
    }

    @Override
    public IVec closePt(IVecI iVecI) {
        return this.pt(this.u(iVecI));
    }

    @Override
    public IVec closePt(IVec2I iVec2I) {
        return this.pt(this.u(iVec2I));
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.closePt(iVecI).dist(iVecI);
    }

    @Override
    public double dist(IVec2I iVec2I) {
        return this.closePt(iVec2I).to2d().dist(iVec2I);
    }

    @Override
    public double knot(int n) {
        return this.knots[n];
    }

    @Override
    public IDouble knot(IIntegerI iIntegerI) {
        return new IDouble(this.knots[iIntegerI.x()]);
    }

    @Override
    public double[] knots() {
        return this.knots;
    }

    @Override
    public double[] knots(ISwitchE iSwitchE) {
        return this.knots();
    }

    public IDouble[] knots(ISwitchR iSwitchR) {
        IDouble[] iDoubleArray = new IDouble[this.knots.length];
        for (int i = 0; i < this.knots.length; ++i) {
            iDoubleArray[i] = new IDouble(this.knots[i]);
        }
        return iDoubleArray;
    }

    @Override
    public int knotNum() {
        return this.knots.length;
    }

    @Override
    public int knotNum(ISwitchE iSwitchE) {
        return this.knotNum();
    }

    @Override
    public IInteger knotNum(ISwitchR iSwitchR) {
        return new IInteger(this.knotNum());
    }

    @Override
    public int deg() {
        return this.degree;
    }

    @Override
    public int deg(ISwitchE iSwitchE) {
        return this.deg();
    }

    @Override
    public IInteger deg(ISwitchR iSwitchR) {
        return new IInteger(this.deg());
    }

    @Override
    public int num() {
        return this.controlPoints.length;
    }

    @Override
    public int num(ISwitchE iSwitchE) {
        return this.num();
    }

    @Override
    public IInteger num(ISwitchR iSwitchR) {
        return new IInteger(this.num());
    }

    @Override
    public int cpNum() {
        return this.num();
    }

    @Override
    public int cpNum(ISwitchE iSwitchE) {
        return this.cpNum();
    }

    @Override
    public IInteger cpNum(ISwitchR iSwitchR) {
        return new IInteger(this.cpNum());
    }

    @Override
    public int epNum() {
        return this.knots.length - 2 * this.degree;
    }

    @Override
    public int epNum(ISwitchE iSwitchE) {
        return this.epNum();
    }

    @Override
    public IInteger epNum(ISwitchR iSwitchR) {
        return new IInteger(this.epNum());
    }

    @Override
    public boolean isRational() {
        if (this.defaultWeights == null) {
            IOut.err("defaultWeights is null");
            return false;
        }
        for (int i = 0; i < this.defaultWeights.length; ++i) {
            if (this.defaultWeights[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRational(ISwitchE iSwitchE) {
        return this.isRational();
    }

    @Override
    public IBool isRational(ISwitchR iSwitchR) {
        return new IBool(this.isRational());
    }

    public double len(double d) {
        double d2 = 0.0;
        if (this.degree == 1) {
            for (int i = 0; i < this.num() - 1; ++i) {
                d2 += this.cp(i + 1).dist(this.cp(i));
            }
            return d2;
        }
        int n = this.epNum();
        int n2 = (int)(1.0 / d);
        if (n2 < 1) {
            n2 = 1;
        }
        IVec iVec = null;
        IVec iVec2 = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2 && i < n - 1 || j <= 0; ++j) {
                iVec2 = this.pt(this.u(i, (double)j / (double)n2));
                if (iVec != null) {
                    d2 += iVec2.dist(iVec);
                }
                iVec = iVec2;
            }
        }
        return d2;
    }

    @Override
    public double len() {
        return this.len(0.01);
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    @Override
    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    @Override
    public double u(int n, double d) {
        if (d >= 0.0) {
            return this.knots[n + this.degree] + (this.knots[n + this.degree + 1] - this.knots[n + this.degree]) * d;
        }
        return this.knots[n + this.degree] + (this.knots[n + this.degree] - this.knots[n + this.degree - 1]) * d;
    }

    @Override
    public IDouble u(IInteger iInteger, IDouble iDouble) {
        return new IDouble(this.u(iInteger.x(), iDouble.x()));
    }

    @Override
    public double ustart() {
        return this.ustart;
    }

    @Override
    public double uend() {
        return this.uend;
    }

    @Override
    public double ustart(ISwitchE iSwitchE) {
        return this.ustart();
    }

    @Override
    public double uend(ISwitchE iSwitchE) {
        return this.uend();
    }

    @Override
    public IDouble ustart(ISwitchR iSwitchR) {
        return new IDouble(this.ustart());
    }

    @Override
    public IDouble uend(ISwitchR iSwitchR) {
        return new IDouble(this.uend());
    }

    @Override
    public boolean isClosed() {
        return this.pt(0.0).eq(this.pt(1.0));
    }

    @Override
    public boolean isClosed(ISwitchE iSwitchE) {
        return this.isClosed();
    }

    @Override
    public IBool isClosed(ISwitchR iSwitchR) {
        return new IBool(this.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICurveGeo rev() {
        Object object = IG.lock;
        synchronized (object) {
            IVecI[] iVecIArray = new IVecI[this.controlPoints.length];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                iVecIArray[i] = this.controlPoints[this.controlPoints.length - 1 - i];
            }
            double[] dArray = new double[this.knots.length];
            for (int i = 0; i < this.knots.length; ++i) {
                dArray[i] = 1.0 - this.knots[this.knots.length - 1 - i];
            }
            boolean[] blArray = new boolean[this.defaultWeights.length];
            for (int i = 0; i < this.defaultWeights.length; ++i) {
                blArray[i] = this.defaultWeights[this.defaultWeights.length - 1 - i];
            }
            this.controlPoints = iVecIArray;
            this.knots = dArray;
            this.defaultWeights = blArray;
            if (this.ustart != 0.0 || this.uend != 1.0) {
                double d = -this.uend;
                double d2 = -this.ustart;
                this.ustart = d;
                this.uend = d2;
            }
            this.basisFunction = new IBSplineBasisFunction(this.degree, this.knots);
            this.derivativeFunction = null;
        }
        return this;
    }

    @Override
    public ICurveGeo revU() {
        return this.rev();
    }

    @Override
    public ICurveGeo flipU() {
        return this.rev();
    }

    public int overlapCPNum() {
        int n;
        for (n = 0; n < this.num() - 1 && !this.cp(n).eq(this.cp(this.num() - 1)); ++n) {
        }
        if (n >= this.num() - 1) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            if (this.cp(i).eq(this.cp(this.num() - 1 - n + i))) continue;
            return 0;
        }
        return n + 1;
    }

    public boolean isInside2d(IVecI iVecI, IVecI iVecI2) {
        IVec2[] iVec2Array = null;
        if (this.deg() == 1) {
            if (this.isClosed()) {
                iVec2Array = new IVec2[this.cpNum() - 1];
                for (int i = 0; i < this.cpNum() - 1; ++i) {
                    iVec2Array[i] = this.cp(i).get().to2d(iVecI2);
                }
            } else {
                iVec2Array = new IVec2[this.cpNum()];
                for (int i = 0; i < this.cpNum(); ++i) {
                    iVec2Array[i] = this.cp(i).get().to2d(iVecI2);
                }
            }
        } else {
            int n = IConfig.segmentResolution;
            int n2 = this.epNum();
            iVec2Array = new IVec2[(n2 - 1) * n + 1];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (i >= n2 - 1 && j != 0) continue;
                    iVec2Array[i * n + j] = this.pt(this.u(i, (double)j / (double)n)).to2d(iVecI2);
                }
            }
        }
        return iVecI.get().to2d(iVecI2).isInside(iVec2Array);
    }

    public boolean isInside2d(IVecI iVecI) {
        IVec2[] iVec2Array = null;
        if (this.deg() == 1) {
            if (this.isClosed()) {
                iVec2Array = new IVec2[this.cpNum() - 1];
                for (int i = 0; i < this.cpNum() - 1; ++i) {
                    iVec2Array[i] = this.cp(i).get().to2d();
                }
            } else {
                iVec2Array = new IVec2[this.cpNum()];
                for (int i = 0; i < this.cpNum(); ++i) {
                    iVec2Array[i] = this.cp(i).get().to2d();
                }
            }
        } else {
            int n = IConfig.segmentResolution;
            int n2 = this.epNum();
            iVec2Array = new IVec2[(n2 - 1) * n + 1];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (i >= n2 - 1 && j != 0) continue;
                    iVec2Array[i * n + j] = this.pt(this.u(i, (double)j / (double)n)).to2d();
                }
            }
        }
        return iVecI.get().to2d().isInside(iVec2Array);
    }

    public synchronized ICurveGeo updateCache() {
        this.uSearchCache = new ICurveCache(this);
        return this;
    }

    @Override
    public ICurveGeo add(double d, double d2, double d3) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.add(d, d2, d3);
        }
        return this;
    }

    @Override
    public ICurveGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.add(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public ICurveGeo add(IVecI iVecI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.add(iVecI);
        }
        return this;
    }

    @Override
    public ICurveGeo sub(double d, double d2, double d3) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.sub(d, d2, d3);
        }
        return this;
    }

    @Override
    public ICurveGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.sub(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public ICurveGeo sub(IVecI iVecI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.sub(iVecI);
        }
        return this;
    }

    @Override
    public ICurveGeo mul(IDoubleI iDoubleI) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.mul(iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo mul(double d) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.mul(d);
        }
        return this;
    }

    @Override
    public ICurveGeo div(IDoubleI iDoubleI) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.div(iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo div(double d) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.div(d);
        }
        return this;
    }

    @Override
    public ICurveGeo neg() {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.neg();
        }
        return this;
    }

    @Override
    public ICurveGeo flip() {
        return this.neg();
    }

    @Override
    public ICurveGeo add(IVecI iVecI, double d) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.add(iVecI, d);
        }
        return this;
    }

    @Override
    public ICurveGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.add(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public ICurveGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public ICurveGeo rot(IDoubleI iDoubleI) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.rot(iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(double d) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.rot(d);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.rot(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(IVecI iVecI, double d) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.rot(iVecI, d);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.rot(iVecI, iVecI2, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.rot(iVecI, iVecI2, d);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(IVecI iVecI, IVecI iVecI2) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.rot(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public ICurveGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (IVecI iVecI4 : this.controlPoints) {
            iVecI4.rot(iVecI, iVecI2, iVecI3);
        }
        return this;
    }

    @Override
    public ICurveGeo rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public ICurveGeo rot2(double d) {
        return this.rot(d);
    }

    @Override
    public ICurveGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.rot2(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo rot2(IVecI iVecI, double d) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.rot2(iVecI, d);
        }
        return this;
    }

    @Override
    public ICurveGeo rot2(IVecI iVecI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.rot2(iVecI);
        }
        return this;
    }

    @Override
    public ICurveGeo rot2(IVecI iVecI, IVecI iVecI2) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.rot2(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public ICurveGeo scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public ICurveGeo scale(double d) {
        return this.mul(d);
    }

    @Override
    public ICurveGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.scale(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo scale(IVecI iVecI, double d) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.scale(iVecI, d);
        }
        return this;
    }

    @Override
    public ICurveGeo scale1d(IVecI iVecI, double d) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.scale1d(iVecI, d);
        }
        return this;
    }

    @Override
    public ICurveGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.scale1d(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.scale1d(iVecI, iVecI2, d);
        }
        return this;
    }

    @Override
    public ICurveGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.scale1d(iVecI, iVecI2, iDoubleI);
        }
        return this;
    }

    @Override
    public ICurveGeo ref(IVecI iVecI) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.ref(iVecI);
        }
        return this;
    }

    @Override
    public ICurveGeo ref(IVecI iVecI, IVecI iVecI2) {
        for (IVecI iVecI3 : this.controlPoints) {
            iVecI3.ref(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public ICurveGeo mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public ICurveGeo mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public ICurveGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shear(d, d2, d3, d4, d5, d6);
        }
        return this;
    }

    @Override
    public ICurveGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        }
        return this;
    }

    @Override
    public ICurveGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shear(iVecI, d, d2, d3, d4, d5, d6);
        }
        return this;
    }

    @Override
    public ICurveGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        }
        return this;
    }

    @Override
    public ICurveGeo shearXY(double d, double d2) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shearXY(d, d2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shearXY(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearXY(IVecI iVecI, double d, double d2) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shearXY(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shearXY(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearYZ(double d, double d2) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shearYZ(d, d2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shearYZ(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearYZ(IVecI iVecI, double d, double d2) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shearYZ(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shearYZ(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearZX(double d, double d2) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shearZX(d, d2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.shearZX(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearZX(IVecI iVecI, double d, double d2) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shearZX(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public ICurveGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (IVecI iVecI2 : this.controlPoints) {
            iVecI2.shearZX(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public ICurveGeo translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ICurveGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ICurveGeo translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ICurveGeo transform(IMatrix3I iMatrix3I) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.transform(iMatrix3I);
        }
        return this;
    }

    @Override
    public ICurveGeo transform(IMatrix4I iMatrix4I) {
        for (IVecI iVecI : this.controlPoints) {
            iVecI.transform(iMatrix4I);
        }
        return this;
    }

    @Override
    public ICurveGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (IVecI iVecI4 : this.controlPoints) {
            iVecI4.transform(iVecI, iVecI2, iVecI3);
        }
        return this;
    }

    @Override
    public ICurveGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        for (IVecI iVecI5 : this.controlPoints) {
            iVecI5.transform(iVecI, iVecI2, iVecI3, iVecI4);
        }
        return this;
    }

    @Override
    public ICurveGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ICurveGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ICurveGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ICurveGeo cp() {
        return this.dup();
    }

    @Override
    public ICurveGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public ICurveGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ICurveGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

