/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IConfig;
import igeo.IDoubleI;
import igeo.IEntityParameter;
import igeo.IIntegerI;
import igeo.IOut;
import igeo.IParameterObject;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;

public class IDouble
extends IParameterObject
implements IDoubleI,
IEntityParameter {
    public double x;

    public IDouble() {
    }

    public IDouble(double d) {
        this.x = d;
    }

    public IDouble(IDouble iDouble) {
        this.x = iDouble.x;
    }

    public IDouble(IDoubleI iDoubleI) {
        this.x = iDoubleI.x();
    }

    public IDouble(IIntegerI iIntegerI) {
        this.x = iIntegerI.x();
    }

    public IDouble(IServerI iServerI) {
        super(iServerI);
    }

    public IDouble(IServerI iServerI, double d) {
        super(iServerI);
        this.x = d;
    }

    public IDouble(IServerI iServerI, IDouble iDouble) {
        super(iServerI);
        this.x = iDouble.x;
    }

    public IDouble(IServerI iServerI, IDoubleI iDoubleI) {
        super(iServerI);
        this.x = iDoubleI.x();
    }

    public IDouble(IServerI iServerI, IIntegerI iIntegerI) {
        super(iServerI);
        this.x = iIntegerI.x();
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public IDouble get() {
        return new IDouble(this.x);
    }

    @Override
    public IDouble getX() {
        return this;
    }

    @Override
    public IDouble dup() {
        return new IDouble(this.x);
    }

    @Override
    public IDouble cp() {
        return this.dup();
    }

    @Override
    public IDouble cp(double d) {
        return this.dup().add(d);
    }

    @Override
    public IDouble cp(IDoubleI iDoubleI) {
        return this.dup().add(iDoubleI);
    }

    @Override
    public IDouble set(double d) {
        this.x = d;
        return this;
    }

    @Override
    public IDouble set(IDoubleI iDoubleI) {
        this.x = iDoubleI.x();
        return this;
    }

    @Override
    public IDouble set(IIntegerI iIntegerI) {
        this.x = iIntegerI.x();
        return this;
    }

    @Override
    public IDouble add(double d) {
        this.x += d;
        return this;
    }

    @Override
    public IDouble add(IDoubleI iDoubleI) {
        this.x += iDoubleI.x();
        return this;
    }

    @Override
    public IDouble sub(double d) {
        this.x -= d;
        return this;
    }

    @Override
    public IDouble sub(IDoubleI iDoubleI) {
        this.x -= iDoubleI.x();
        return this;
    }

    @Override
    public IDouble mul(double d) {
        this.x *= d;
        return this;
    }

    @Override
    public IDouble mul(IDoubleI iDoubleI) {
        this.x *= iDoubleI.x();
        return this;
    }

    @Override
    public IDouble div(double d) {
        this.x /= d;
        return this;
    }

    @Override
    public IDouble div(IDoubleI iDoubleI) {
        this.x /= iDoubleI.x();
        return this;
    }

    @Override
    public IDouble neg() {
        this.x = -this.x;
        return this;
    }

    @Override
    public IDouble inv() {
        this.x = 1.0 / this.x;
        return this;
    }

    @Override
    public IDouble abs() {
        this.x = Math.abs(this.x);
        return this;
    }

    @Override
    public IDouble pow(double d) {
        this.x = Math.pow(this.x, d);
        return this;
    }

    @Override
    public IDouble pow(IDoubleI iDoubleI) {
        this.x = Math.pow(this.x, iDoubleI.x());
        return this;
    }

    @Override
    public IDouble sq() {
        this.x *= this.x;
        return this;
    }

    @Override
    public IDouble sqrt() {
        this.x = Math.sqrt(this.x);
        return this;
    }

    @Override
    public IDouble exp() {
        this.x = Math.exp(this.x);
        return this;
    }

    @Override
    public IDouble log() {
        this.x = Math.log(this.x);
        return this;
    }

    @Override
    public IDouble sin() {
        this.x = Math.sin(this.x);
        return this;
    }

    @Override
    public IDouble cos() {
        this.x = Math.cos(this.x);
        return this;
    }

    @Override
    public IDouble tan() {
        this.x = Math.tan(this.x);
        return this;
    }

    @Override
    public IDouble asin() {
        this.x = Math.asin(this.x);
        return this;
    }

    @Override
    public IDouble acos() {
        this.x = Math.acos(this.x);
        return this;
    }

    @Override
    public IDouble atan() {
        this.x = Math.atan(this.x);
        return this;
    }

    @Override
    public IDouble atan2(double d) {
        this.x = Math.atan2(this.x, d);
        return this;
    }

    @Override
    public IDouble atan2(IDoubleI iDoubleI) {
        this.x = Math.atan2(this.x, iDoubleI.x());
        return this;
    }

    @Override
    public IDouble deg() {
        this.x = Math.toDegrees(this.x);
        return this;
    }

    @Override
    public IDouble rad() {
        this.x = Math.toRadians(this.x);
        return this;
    }

    @Override
    public boolean eq(double d) {
        return this.eq(d, IConfig.tolerance);
    }

    public boolean eq(IDouble iDouble) {
        return this.eq(iDouble, IConfig.tolerance);
    }

    @Override
    public boolean eq(IDoubleI iDoubleI) {
        return this.eq(iDoubleI.get(), IConfig.tolerance);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IDoubleI iDoubleI) {
        return this.eq(iDoubleI);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IDoubleI iDoubleI) {
        return new IBool(this.eq(iDoubleI));
    }

    @Override
    public boolean eq(double d, double d2) {
        return Math.abs(this.x - d) <= d2;
    }

    public boolean eq(IDouble iDouble, double d) {
        return Math.abs(this.x - iDouble.x) <= d;
    }

    @Override
    public boolean eq(IDoubleI iDoubleI, double d) {
        return Math.abs(this.x - iDoubleI.x()) <= d;
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IDoubleI iDoubleI, double d) {
        return this.eq(iDoubleI, d);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IBool(this.eq(iDoubleI, iDoubleI2.x()));
    }

    public boolean isValid() {
        if (!IDouble.isValid(this.x)) {
            IOut.err("invalid value " + this.x);
            return false;
        }
        return true;
    }

    public static boolean isValid(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        return !Double.isInfinite(d);
    }

    public static boolean isValid(float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        return !Float.isInfinite(f);
    }
}

