/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IOut;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class IRandomAccessOutputStream
extends OutputStream {
    public RandomAccessFile file;

    public IRandomAccessOutputStream(String string) throws IOException {
        this.file = new RandomAccessFile(new File(string), "rw");
    }

    public IRandomAccessOutputStream(File file) throws IOException {
        this.file = new RandomAccessFile(file, "rw");
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            if (byArray.length > 5000000) {
                int n = 0;
                while (n * 5000000 < byArray.length) {
                    this.file.write(byArray, n * 5000000, byArray.length - n * 5000000 > 5000000 ? 5000000 : byArray.length - n * 5000000);
                    ++n;
                }
            } else {
                this.file.write(byArray);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IOut.err("write buffer size = " + byArray.length);
            outOfMemoryError.printStackTrace();
            throw outOfMemoryError;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.file.write(n);
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    public long pointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

