/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAgent;
import igeo.IConfig;
import igeo.IDynamics;
import igeo.ILayer;
import igeo.IParticleI;
import igeo.ITrajectoryI;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

public class IWall
extends IAgent {
    public ArrayList<Class<? extends IParticleI>> targetClasses;
    public IVecI planeDir;
    public IVecI planePt;
    public IVec planeDirCache;
    public double elasticity = 1.0;
    public double friction = 0.0;

    public IWall targetClass(Class<? extends IParticleI> clazz) {
        this.targetClasses = new ArrayList();
        this.targetClasses.add(clazz);
        return this;
    }

    public IWall targetClass(Class<? extends IParticleI> ... classArray) {
        this.targetClasses = new ArrayList();
        for (Class<? extends IParticleI> clazz : classArray) {
            this.targetClasses.add(clazz);
        }
        return this;
    }

    public boolean isTargetClass(Object object) {
        for (int i = 0; i < this.targetClasses.size(); ++i) {
            if (!this.targetClasses.get(i).isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public IWall(IVecI iVecI, IVecI iVecI2) {
        this.planeDir = iVecI;
        this.planePt = iVecI2;
    }

    public IWall(IWall iWall) {
        this.planeDir = iWall.planeDir;
        this.planePt = iWall.planePt;
        this.elasticity = iWall.elasticity;
        this.friction = iWall.friction;
        if (iWall.targetClasses != null) {
            this.targetClasses = new ArrayList();
            for (int i = 0; i < iWall.targetClasses.size(); ++i) {
                this.targetClasses.add(iWall.targetClasses.get(i));
            }
        }
    }

    public IWall fric(double d) {
        this.friction = d;
        return this;
    }

    public double fric() {
        return this.friction;
    }

    public IWall friction(double d) {
        return this.fric(d);
    }

    public double friction() {
        return this.fric();
    }

    public IWall elast(double d) {
        this.elasticity = d;
        return this;
    }

    public double elast() {
        return this.elasticity;
    }

    public IWall elasticity(double d) {
        return this.elast(d);
    }

    public double elasticity() {
        return this.elast();
    }

    public double distToCrossing(IParticleI iParticleI) {
        IVec iVec = IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iParticleI.vel(), iParticleI.pos());
        return iVec.dist(iParticleI.pos());
    }

    public IVec intersect(IVec iVec, IVec iVec2) {
        return IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iVec2.dif(iVec), iVec);
    }

    public boolean isCrossing(IParticleI iParticleI) {
        double d = iParticleI.vel().len2();
        if (d == 0.0) {
            return false;
        }
        IVec iVec = iParticleI.pos().dup();
        IVec iVec2 = iVec.dup().add(iParticleI.vel(), IConfig.updateRate);
        return this.isCrossing(iVec, iVec2);
    }

    public boolean isCrossing(IVec iVec, IVec iVec2) {
        IVec iVec3 = iVec.dif(this.planePt);
        IVec iVec4 = iVec2.dif(this.planePt);
        double d = iVec3.dot(this.planeDir);
        double d2 = iVec4.dot(this.planeDir);
        return d == 0.0 || d * d2 < 0.0;
    }

    @Override
    public void postinteract(ArrayList<IDynamics> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((this.targetClasses != null || !(arrayList.get(i) instanceof IParticleI)) && (this.targetClasses == null || !this.isTargetClass(arrayList.get(i)))) continue;
            this.bounce((IParticleI)((Object)arrayList.get(i)), arrayList);
        }
        if (this.planeDirCache != null) {
            this.planeDirCache = null;
        }
    }

    public IVec closerIntersection(IVec iVec, IVec iVec2, ArrayList<IDynamics> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IWall iWall;
            if (!(arrayList.get(i) instanceof IWall) || arrayList.get(i) == this || !(iWall = (IWall)arrayList.get(i)).isCrossing(iVec, iVec2)) continue;
            iVec2 = iWall.intersect(iVec, iVec2);
        }
        return iVec2;
    }

    public void bounce(IParticleI iParticleI, ArrayList<IDynamics> arrayList) {
        double d = iParticleI.vel().len2();
        if (d > 0.0) {
            IVec iVec = iParticleI.pos().dup();
            IVec iVec2 = iVec.dup().add(iParticleI.vel(), IConfig.updateRate);
            iVec.sub(this.planePt);
            iVec2.sub(this.planePt);
            double d2 = iVec.dot(this.planeDir);
            double d3 = iVec2.dot(this.planeDir);
            if (d2 == 0.0 || d2 * d3 < 0.0) {
                if (IConfig.checkAdjacentWalls) {
                    double d4 = this.distToCrossing(iParticleI);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!(arrayList.get(i) instanceof IWall) || arrayList.get(i) == this || !(((IWall)arrayList.get(i)).distToCrossing(iParticleI) < d4)) continue;
                        return;
                    }
                }
                if (this.elasticity == 1.0 && this.friction == 0.0) {
                    iParticleI.vel().ref(this.planeDir);
                    if (IConfig.checkAdjacentWalls) {
                        IVec iVec3 = IVec.intersectPlaneAndLine(this.planeDir.get(), iVec2.dif(iVec), iVec).add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec3);
                        }
                        IVec iVec4 = iVec2.ref(this.planeDir).add(this.planePt);
                        iVec4 = this.closerIntersection(iVec3, iVec4, arrayList);
                        iParticleI.pos(iVec4);
                        iParticleI.skipUpdateOnce(true);
                    } else {
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            IVec iVec5 = IVec.intersectPlaneAndLine(this.planeDir.get(), iVec2.dif(iVec), iVec).add(this.planePt);
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec5);
                        }
                        iParticleI.pos(iVec2.ref(this.planeDir).add(this.planePt));
                        iParticleI.skipUpdateOnce(true);
                    }
                } else {
                    if (this.planeDirCache == null) {
                        this.planeDirCache = this.planeDir.get().dup().unit();
                    }
                    IVec iVec6 = IVec.intersectPlaneAndLine(this.planeDirCache, iVec2.dif(iVec), iVec);
                    double d5 = Math.sqrt(iVec2.dist2(iVec6) / iVec2.dist2(iVec));
                    IVec iVec7 = this.planeDirCache.dup().mul(-this.planeDirCache.dot(iParticleI.vel()));
                    IVec iVec8 = iParticleI.vel().dup().add(iVec7);
                    iVec7.mul(this.elasticity);
                    if (iVec7.len2() == 0.0) {
                        iVec7.set(this.planeDirCache).mul(IConfig.tolerance / IConfig.updateRate);
                        if (this.planeDirCache.dot(iParticleI.vel()) > 0.0) {
                            iVec7.neg();
                        }
                    }
                    iVec8.mul(1.0 - this.friction);
                    if (IConfig.checkAdjacentWalls) {
                        iVec7.add(iVec8);
                        iParticleI.vel(iVec7);
                        iVec6.add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec6);
                        }
                        IVec iVec9 = iVec6.dup().add(iVec7, IConfig.updateRate * d5);
                        iVec9 = this.closerIntersection(iVec6, iVec9, arrayList);
                        iParticleI.pos(iVec9);
                        iParticleI.skipUpdateOnce(true);
                    } else {
                        iVec6.add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec6.dup());
                        }
                        iVec7.add(iVec8);
                        iParticleI.vel(iVec7);
                        iParticleI.pos(iVec6.add(iVec7, IConfig.updateRate * d5));
                        iParticleI.skipUpdateOnce(true);
                    }
                }
            }
        }
    }

    @Override
    public IWall name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IWall layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IWall hide() {
        super.hide();
        return this;
    }

    @Override
    public IWall show() {
        super.show();
        return this;
    }
}

