/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IG;
import igeo.gui.IGraphics;
import igeo.gui.IMouseEvent;
import igeo.gui.IPane;
import igeo.gui.IPanel;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IScreenTogglePanel
extends IPanel {
    public IPane fullScreenPane = null;
    public int fullPaneOrigX;
    public int fullPaneOrigY;
    public int fullPaneOrigWidth;
    public int fullPaneOrigHeight;

    public IScreenTogglePanel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void enableFullScreen(int n) {
        IPane iPane = (IPane)this.panes.get(n);
        this.fullPaneOrigX = (int)iPane.getX();
        this.fullPaneOrigY = (int)iPane.getY();
        this.fullPaneOrigWidth = iPane.getWidth();
        this.fullPaneOrigHeight = iPane.getHeight();
        this.fullScreenPane = iPane;
        for (int i = 0; i < this.panes.size(); ++i) {
            if (i == n) continue;
            ((IPane)this.panes.get(i)).setVisible(false);
        }
        this.fullScreenPane.setBounds(this.x, this.y, this.width, this.height);
        this.currentMousePane = iPane;
    }

    public void enableFullScreen(IPane iPane) {
        int n = this.panes.indexOf(iPane);
        if (n >= 0) {
            this.enableFullScreen(n);
        }
        this.sizeChanged = true;
    }

    public void disableFullScreen() {
        if (this.fullScreenPane != null) {
            this.fullScreenPane.setBounds(this.fullPaneOrigX, this.fullPaneOrigY, this.fullPaneOrigWidth, this.fullPaneOrigHeight);
            for (int i = 0; i < this.panes.size(); ++i) {
                if (this.panes.get(i) == this.fullScreenPane) continue;
                ((IPane)this.panes.get(i)).setVisible(true);
            }
            this.fullScreenPane = null;
            this.sizeChanged = true;
        }
    }

    public boolean isFull() {
        return this.fullScreenPane != null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            if (this.fullScreenPane != null) {
                this.fullScreenPane.setVisible(true);
            } else {
                for (int i = 0; i < this.panes.size(); ++i) {
                    ((IPane)this.panes.get(i)).setVisible(true);
                }
            }
        } else if (this.fullScreenPane != null) {
            this.fullScreenPane.setVisible(false);
        } else {
            for (int i = 0; i < this.panes.size(); ++i) {
                ((IPane)this.panes.get(i)).setVisible(false);
            }
        }
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        for (int i = 0; i < this.panes.size(); ++i) {
            int n5 = (int)(((IPane)this.panes.get(i)).getX() * (float)n / (float)n3);
            int n6 = (int)(((IPane)this.panes.get(i)).getY() * (float)n2 / (float)n4);
            int n7 = ((IPane)this.panes.get(i)).getWidth() * n / n3;
            int n8 = ((IPane)this.panes.get(i)).getHeight() * n2 / n4;
            ((IPane)this.panes.get(i)).setBounds(n5, n6, n7, n8);
        }
        if (this.fullScreenPane != null) {
            this.fullPaneOrigX = this.fullPaneOrigX * n / n3;
            this.fullPaneOrigY = this.fullPaneOrigY * n2 / n4;
            this.fullPaneOrigWidth = this.fullPaneOrigWidth * n / n3;
            this.fullPaneOrigHeight = this.fullPaneOrigHeight * n2 / n4;
        }
        this.width = n;
        this.height = n2;
        this.sizeChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(IGraphics iGraphics) {
        if (this.fullScreenPane == null) {
            super.draw(iGraphics);
        } else {
            this.predraw(iGraphics);
            Object object = IG.lock;
            synchronized (object) {
                this.fullScreenPane.draw(iGraphics);
            }
            this.postdraw(iGraphics);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        IMouseEvent iMouseEvent = new IMouseEvent(mouseEvent);
        if (mouseEvent.getClickCount() >= 2 && mouseEvent.getClickCount() % 2 == 0) {
            IPane iPane = this.getPaneAt(iMouseEvent);
            if (this.fullScreenPane == null) {
                if (iPane != null) {
                    this.enableFullScreen(iPane);
                }
            } else {
                this.disableFullScreen();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && keyEvent.isShiftDown()) {
            if (this.fullScreenPane != null) {
                this.disableFullScreen();
            } else if (this.currentMousePane != null) {
                this.enableFullScreen(this.currentMousePane);
            }
        }
        super.keyPressed(keyEvent);
    }
}

