/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IConfig;
import igeo.IOut;
import igeo.IServerI;
import igeo.io.I3DXMLImporter;
import igeo.io.IAIExporter;
import igeo.io.IInputWrapper;
import igeo.io.IObjFileExporter;
import igeo.io.IObjFileImporter;
import igeo.io.IRhino3dmExporter;
import igeo.io.IRhino3dmImporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class IIO {
    public static final String extensionObj = "obj";
    public static final String extensionRhino = "3dm";
    public static final String extension3DXML = "3dxml";
    public static final String extensionAI = "ai";

    public static boolean isExtension(String string, String string2) {
        String string3 = IIO.getExtension(string);
        if (string3 == null) {
            return false;
        }
        return string3.toLowerCase().equals(string2.toLowerCase());
    }

    public static String getExtension(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[stringArray.length - 1];
    }

    public static FileType getFileType(String string) {
        if (IIO.isExtension(string, extensionRhino)) {
            return FileType.RHINO;
        }
        if (IIO.isExtension(string, extensionObj)) {
            return FileType.OBJ;
        }
        if (IIO.isExtension(string, extension3DXML)) {
            return FileType._3DXML;
        }
        if (IIO.isExtension(string, extensionAI)) {
            return FileType.AI;
        }
        return FileType.OTHER;
    }

    public static boolean open(String string, IServerI iServerI) {
        IOut.debug(0, "opening " + string);
        FileType fileType = IIO.getFileType(string);
        if (fileType == FileType.OBJ) {
            return IIO.openOBJ(new File(string), iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.openRhino(new File(string), iServerI);
        }
        if (fileType == FileType._3DXML) {
            return IIO.open3DXML(new File(string), iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(string) + " is not supported");
        return false;
    }

    public static boolean open(File file, IServerI iServerI) {
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            return IIO.openOBJ(file, iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.openRhino(file, iServerI);
        }
        if (fileType == FileType._3DXML) {
            return IIO.open3DXML(file, iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return false;
    }

    public static boolean open(String string, IServerI iServerI, IInputWrapper iInputWrapper) {
        if (iInputWrapper == null) {
            return IIO.open(string, iServerI);
        }
        IOut.debug(0, "opening " + string);
        FileType fileType = IIO.getFileType(string);
        if (fileType == FileType.OBJ) {
            InputStream inputStream = iInputWrapper.getStream(string);
            boolean bl = IIO.openOBJ(inputStream, iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
        }
        if (fileType == FileType.RHINO) {
            InputStream inputStream = iInputWrapper.getStream(string);
            boolean bl = IIO.openRhino(inputStream, iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
        }
        if (fileType == FileType._3DXML) {
            InputStream inputStream = iInputWrapper.getStream(string);
            boolean bl = IIO.open3DXML(inputStream, string, iServerI);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
        }
        IOut.err("file extension ." + IIO.getExtension(string) + " is not supported");
        return false;
    }

    public static boolean openOBJ(File file, IServerI iServerI) {
        IOut.debug(0, "opening obj file " + file);
        if (IObjFileImporter.read(file, iServerI) != null) {
            IOut.debug(0, "opening complete");
            return true;
        }
        IOut.err("error occured in opening file " + file.toString());
        return false;
    }

    public static boolean openOBJ(InputStream inputStream, IServerI iServerI) {
        if (IObjFileImporter.read(inputStream, iServerI) != null) {
            IOut.debug(0, "opening complete");
            return true;
        }
        IOut.err("error occured in opening OBJ file");
        return false;
    }

    public static boolean openRhino(File file, IServerI iServerI) {
        IOut.debug(0, "opening 3dm file " + file);
        if (IRhino3dmImporter.read(file, iServerI)) {
            IOut.debug(0, "opening complete");
            return true;
        }
        IOut.err("error occured in opening file " + file.toString());
        return false;
    }

    public static boolean openRhino(InputStream inputStream, IServerI iServerI) {
        if (IRhino3dmImporter.read(inputStream, iServerI)) {
            IOut.debug(0, "opening complete");
            return true;
        }
        IOut.err("error occured in opening Rhino file");
        return false;
    }

    public static boolean open3DXML(File file, IServerI iServerI) {
        IOut.debug(0, "opening 3dxmm file " + file);
        try {
            I3DXMLImporter.read(file);
            IOut.debug(0, "opening complete");
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean open3DXML(InputStream inputStream, String string, IServerI iServerI) {
        try {
            I3DXMLImporter.read(inputStream, string);
            IOut.debug(0, "opening complete");
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean save(String string, IServerI iServerI) {
        FileType fileType = IIO.getFileType(string);
        if (fileType == FileType.OBJ) {
            return IIO.saveOBJ(new File(string), iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.saveRhino(new File(string), iServerI);
        }
        if (fileType == FileType.AI) {
            return IIO.saveAI(new File(string), iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(string) + " is not supported");
        return false;
    }

    public static boolean save(File file, IServerI iServerI) {
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            return IIO.saveOBJ(file, iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.saveRhino(file, iServerI);
        }
        if (fileType == FileType.AI) {
            return IIO.saveAI(file, iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return false;
    }

    public static boolean saveOBJ(File file, IServerI iServerI) {
        IOut.debug(0, "saving obj file: " + file);
        if (IObjFileExporter.write(file, iServerI)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static boolean saveRhino(File file, IServerI iServerI) {
        IOut.debug(0, "saving 3dm file: " + file);
        if (IRhino3dmExporter.write(file, iServerI)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static boolean saveAI(File file, IServerI iServerI) {
        return IIO.saveAI(file, iServerI, IConfig.defaultAIExportScale);
    }

    public static boolean saveAI(File file, IServerI iServerI, double d) {
        IOut.debug(0, "saving ai file: " + file);
        if (IAIExporter.write(file, iServerI, d)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static enum FileType {
        RHINO,
        OBJ,
        _3DXML,
        AI,
        OTHER;

    }
}

