/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IColor;
import igeo.IConfig;
import igeo.IGraphicI;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics3D;
import igeo.gui.IView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

public class IGraphicsGL
implements IGraphics3D {
    public static float[] defaultGLLightPosition = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static float[] defaultGLAmbientLight = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    public static float[] defaultGLDiffuseLight = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
    public static float[] defaultGLSpecularLight = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static boolean defaultGLTwoSidedLighting = false;
    public GL gl;
    public GL2 gl2;
    public Graphics2D g;
    public IView view;
    public double[][][] bgColor = new double[2][2][3];
    public boolean firstDraw = true;

    @Override
    public IView view() {
        return this.view;
    }

    public void setGL(GL gL) {
        this.gl = gL;
        this.gl2 = gL.getGL2();
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public GL getGL() {
        return this.gl;
    }

    public GL2 getGL2() {
        return this.gl2;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    @Override
    public IGraphicMode.GraphicType type() {
        return IGraphicMode.GraphicType.GL;
    }

    public void drawBG(GL gL, IView iView) {
        GL2 gL2 = gL.getGL2();
        if (this.view.bgColor != null) {
            for (int i = 0; i < this.bgColor.length; ++i) {
                for (int j = 0; j < this.bgColor[i].length; ++j) {
                    this.bgColor[i][j][0] = (double)this.view.bgColor[i][j].getRed() / 255.0;
                    this.bgColor[i][j][1] = (double)this.view.bgColor[i][j].getGreen() / 255.0;
                    this.bgColor[i][j][2] = (double)this.view.bgColor[i][j].getBlue() / 255.0;
                }
            }
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5889);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glBegin(7);
            gL2.glColor3dv(this.bgColor[0][1], 0);
            gL2.glVertex3d(-1.0, -1.0, 0.0);
            gL2.glColor3dv(this.bgColor[1][1], 0);
            gL2.glVertex3d(1.0, -1.0, 0.0);
            gL2.glColor3dv(this.bgColor[1][0], 0);
            gL2.glVertex3d(1.0, 1.0, 0.0);
            gL2.glColor3dv(this.bgColor[0][0], 0);
            gL2.glVertex3d(-1.0, 1.0, 0.0);
            gL2.glEnd();
            gL2.glMatrixMode(5888);
            gL2.glPopMatrix();
            gL2.glMatrixMode(5889);
            gL2.glPopMatrix();
        }
    }

    public void drawView(IView iView) {
        this.gl2.glViewport(iView.screenX, iView.screenY, iView.screenWidth, iView.screenHeight);
        if (IConfig.clearBG || this.firstDraw) {
            this.gl2.glDisable(2929);
            this.drawBG(this.gl, iView);
        }
        if (IConfig.depthSort) {
            this.gl2.glEnable(2929);
        }
        if (iView.mode.isLight()) {
            this.gl2.glMatrixMode(5888);
            this.gl2.glPushMatrix();
            this.gl2.glLoadIdentity();
            this.gl2.glLightfv(16385, 4611, defaultGLLightPosition, 0);
            this.gl2.glLightfv(16385, 4608, defaultGLAmbientLight, 0);
            this.gl2.glLightfv(16385, 4609, defaultGLDiffuseLight, 0);
            this.gl2.glLightfv(16385, 4610, defaultGLSpecularLight, 0);
            if (defaultGLTwoSidedLighting) {
                this.gl2.glLightModeli(2898, 1);
            }
            this.gl2.glEnable(16385);
            this.gl2.glEnable(2896);
            this.gl2.glPopMatrix();
        }
        this.gl2.glMatrixMode(5889);
        this.gl2.glLoadIdentity();
        if (iView.axonometric) {
            double d = (double)iView.screenWidth * iView.axonRatio;
            double d2 = (double)iView.screenHeight * iView.axonRatio;
            this.gl2.glOrtho(-d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, iView.near, iView.far);
        } else {
            double d = iView.near * iView.persRatio * 2.0;
            double d3 = d * (double)iView.screenWidth / (double)iView.screenHeight;
            this.gl2.glFrustum(-d3 / 2.0, d3 / 2.0, -d / 2.0, d / 2.0, iView.near, iView.far);
        }
        this.gl2.glMatrixMode(5888);
        this.gl2.glLoadMatrixd(iView.transformArray, 0);
    }

    @Override
    public void draw(ArrayList<IGraphicI> arrayList, IView iView) {
        this.view = iView;
        if (this.view.hide) {
            return;
        }
        this.drawView(this.view);
        if (arrayList != null) {
            if (IConfig.drawOrderForward) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).isVisible()) continue;
                    arrayList.get(i).draw(this);
                }
            } else {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    if (!arrayList.get(i).isVisible()) continue;
                    arrayList.get(i).draw(this);
                }
            }
        }
        if (this.view.mode().isLight()) {
            this.gl2.glDisable(2896);
            this.gl2.glDisable(16385);
        }
        if (this.g != null && this.view.pane != null && this.view.pane.getBorderWidth() > 0.0f && (this.view.pane.getPanel().getWidth() != this.view.pane.getWidth() || this.view.pane.getPanel().getHeight() != this.view.pane.getHeight())) {
            this.g.setColor(new Color(this.view.pane.getBorderColor(), true));
            this.g.setStroke(new BasicStroke(this.view.pane.getBorderWidth()));
            this.g.drawRect((int)this.view.pane.getX(), (int)this.view.pane.getY(), this.view.pane.getWidth(), this.view.pane.getHeight());
        }
    }

    @Override
    public boolean firstDraw() {
        return this.firstDraw;
    }

    @Override
    public void firstDraw(boolean bl) {
        this.firstDraw = bl;
    }

    @Override
    public void clr(IColor iColor) {
        this.gl2.glColor4fv(iColor.rgba(), 0);
    }

    @Override
    public void clr(float[] fArray) {
        this.gl2.glColor4fv(fArray, 0);
    }

    @Override
    public void clr(float f, float f2, float f3, float f4) {
        this.gl2.glColor4f(f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f);
    }

    @Override
    public void clr(float f, float f2, float f3) {
        this.clr(f, f2, f3, 255.0f);
    }

    @Override
    public void stroke(IColor iColor) {
        this.clr(iColor);
    }

    @Override
    public void stroke(float[] fArray) {
        this.clr(fArray);
    }

    @Override
    public void stroke(float f, float f2, float f3, float f4) {
        this.clr(f, f2, f3, f4);
    }

    @Override
    public void stroke(float f, float f2, float f3) {
        this.clr(f, f2, f3);
    }

    public void weight(double d) {
        this.gl2.glLineWidth((float)d);
    }

    @Override
    public void weight(float f) {
        this.gl2.glLineWidth(f);
    }

    @Override
    public void diffuse(float[] fArray) {
        this.gl2.glMaterialfv(1032, 4609, fArray, 0);
    }

    @Override
    public void diffuse(float f, float f2, float f3, float f4) {
        this.diffuse(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void diffuse(float f, float f2, float f3) {
        this.diffuse(f, f2, f3, 255.0f);
    }

    @Override
    public void diffuse(IColor iColor) {
        this.diffuse(iColor.rgba());
    }

    @Override
    public void ambient(float[] fArray) {
        this.gl2.glMaterialfv(1032, 4608, fArray, 0);
    }

    @Override
    public void ambient(float f, float f2, float f3, float f4) {
        this.ambient(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void ambient(float f, float f2, float f3) {
        this.ambient(f, f2, f3, 255.0f);
    }

    @Override
    public void ambient(IColor iColor) {
        this.ambient(iColor.rgba());
    }

    @Override
    public void specular(float[] fArray) {
        this.gl2.glMaterialfv(1032, 4610, fArray, 0);
    }

    @Override
    public void specular(float f, float f2, float f3, float f4) {
        this.specular(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void specular(float f, float f2, float f3) {
        this.specular(f, f2, f3, 255.0f);
    }

    @Override
    public void specular(IColor iColor) {
        this.specular(iColor.rgba());
    }

    @Override
    public void emissive(float[] fArray) {
        this.gl2.glMaterialfv(1032, 5632, fArray, 0);
    }

    @Override
    public void emissive(float f, float f2, float f3, float f4) {
        this.emissive(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void emissive(float f, float f2, float f3) {
        this.emissive(f, f2, f3, 255.0f);
    }

    @Override
    public void emissive(IColor iColor) {
        this.emissive(iColor.rgba());
    }

    @Override
    public void shininess(float f) {
        this.gl2.glMaterialf(1032, 5633, f);
    }

    @Override
    public void enableLight() {
        this.gl2.glEnable(16385);
        this.gl2.glEnable(2896);
    }

    @Override
    public void disableLight() {
        this.gl2.glDisable(2896);
        this.gl2.glDisable(16385);
    }

    @Override
    public void pointSize(float f) {
        this.gl2.glPointSize(f);
    }

    @Override
    public void drawPoint(IVec iVec) {
        this.gl2.glBegin(0);
        this.gl2.glVertex3d(iVec.x, iVec.y, iVec.z);
        this.gl2.glEnd();
    }

    @Override
    public void drawPoints(IVec[] iVecArray) {
        this.gl2.glBegin(0);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawLines(IVec[] iVecArray) {
        this.gl2.glBegin(1);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawLineStrip(IVec[] iVecArray) {
        this.gl2.glBegin(3);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawLineLoop(IVec[] iVecArray) {
        this.gl2.glBegin(2);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray) {
        this.gl2.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray) {
        this.gl2.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray) {
        this.gl2.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl2.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl2.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl2.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl2.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                this.gl2.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl2.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                this.gl2.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl2.glEnd();
        }
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray) {
        this.gl2.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray) {
        this.gl2.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl2.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray) {
        this.gl2.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl2.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl2.glEnd();
    }
}

