/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBoolI;
import igeo.IColor;
import igeo.IDoubleI;
import igeo.IGraphicObject;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IOut;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVec4R;
import igeo.IVecI;
import igeo.IVecR;
import igeo.gui.IGraphicMode;
import igeo.gui.IVectorGraphic;
import java.awt.Color;

public class IVectorObject
extends IObject
implements IVecI {
    public IVecI vec;
    public IVecI root;

    public IVectorObject(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.vec = iVecI;
        this.root = new IVec(0.0, 0.0, 0.0);
        this.initVector(iServerI);
    }

    public IVectorObject(IVecI iVecI) {
        this((IServerI)null, iVecI);
    }

    public IVectorObject(IServerI iServerI, IVecI iVecI, IVecI iVecI2) {
        super(iServerI);
        this.vec = iVecI;
        this.root = iVecI2;
        this.initVector(iServerI);
    }

    public IVectorObject(IVecI iVecI, IVecI iVecI2) {
        this(null, iVecI, iVecI2);
    }

    public IVectorObject(IServerI iServerI, IVectorObject iVectorObject) {
        super(iServerI, iVectorObject);
        this.vec = iVectorObject.vec;
        this.root = iVectorObject.root;
        this.initVector(iServerI);
        this.setColor(iVectorObject.getColor());
    }

    public IVectorObject(IVectorObject iVectorObject) {
        super(iVectorObject);
        this.vec = iVectorObject.vec;
        this.root = iVectorObject.root;
        this.initVector(iVectorObject.server);
        this.setColor(iVectorObject.getColor());
    }

    public IVecI vector() {
        return this.vec;
    }

    public IVectorObject vector(IVecI iVecI) {
        this.vec = iVecI;
        return this;
    }

    public IVecI root() {
        return this.root;
    }

    public IVectorObject root(IVecI iVecI) {
        this.root = iVecI;
        return this;
    }

    protected void initVector(IServerI iServerI) {
        if (this.vec instanceof IVec) {
            this.parameter = (IVec)this.vec;
        } else if (this.vec instanceof IVecR) {
            this.parameter = (IVecR)this.vec;
        } else if (this.vec instanceof IVec4) {
            this.parameter = (IVec4)this.vec;
        } else if (this.vec instanceof IVec4R) {
            this.parameter = (IVec4R)this.vec;
        }
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    @Override
    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return new IVectorGraphic(this);
    }

    @Override
    public double x() {
        return this.vec.x();
    }

    @Override
    public double y() {
        return this.vec.y();
    }

    @Override
    public double z() {
        return this.vec.z();
    }

    @Override
    public IVectorObject x(double d) {
        this.vec.x(d);
        return this;
    }

    @Override
    public IVectorObject y(double d) {
        this.vec.y(d);
        return this;
    }

    @Override
    public IVectorObject z(double d) {
        this.vec.z(d);
        return this;
    }

    @Override
    public IVectorObject x(IDoubleI iDoubleI) {
        this.vec.x(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject y(IDoubleI iDoubleI) {
        this.vec.y(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject z(IDoubleI iDoubleI) {
        this.vec.z(iDoubleI);
        return this;
    }

    @Override
    public double x(ISwitchE iSwitchE) {
        return this.vec.x(iSwitchE);
    }

    @Override
    public double y(ISwitchE iSwitchE) {
        return this.vec.y(iSwitchE);
    }

    @Override
    public double z(ISwitchE iSwitchE) {
        return this.vec.z(iSwitchE);
    }

    @Override
    public IDoubleI x(ISwitchR iSwitchR) {
        return this.vec.x(iSwitchR);
    }

    @Override
    public IDoubleI y(ISwitchR iSwitchR) {
        return this.vec.y(iSwitchR);
    }

    @Override
    public IDoubleI z(ISwitchR iSwitchR) {
        return this.vec.z(iSwitchR);
    }

    @Override
    public IVec get() {
        return this.vec.get();
    }

    public IVecI pos() {
        return this.vec;
    }

    @Override
    public IVectorObject dup() {
        return new IVectorObject(this);
    }

    @Override
    public IVec2I to2d() {
        return this.vec.to2d();
    }

    @Override
    public IVec2I to2d(IVecI iVecI) {
        return this.vec.to2d(iVecI);
    }

    @Override
    public IVec2I to2d(IVecI iVecI, IVecI iVecI2) {
        return this.vec.to2d(iVecI, iVecI2);
    }

    @Override
    public IVec2I to2d(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.vec.to2d(iVecI, iVecI2, iVecI3);
    }

    @Override
    public IVec4I to4d() {
        return this.vec.to4d();
    }

    @Override
    public IVec4I to4d(double d) {
        return this.vec.to4d(d);
    }

    @Override
    public IVec4I to4d(IDoubleI iDoubleI) {
        return this.vec.to4d(iDoubleI);
    }

    @Override
    public IDoubleI getX() {
        return this.vec.getX();
    }

    @Override
    public IDoubleI getY() {
        return this.vec.getY();
    }

    @Override
    public IDoubleI getZ() {
        return this.vec.getZ();
    }

    @Override
    public IVectorObject set(IVecI iVecI) {
        this.vec.set(iVecI);
        return this;
    }

    @Override
    public IVectorObject set(double d, double d2, double d3) {
        this.vec.set(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVectorObject add(double d, double d2, double d3) {
        this.vec.add(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVectorObject add(IVecI iVecI) {
        this.vec.add(iVecI);
        return this;
    }

    @Override
    public IVectorObject sub(double d, double d2, double d3) {
        this.vec.sub(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVectorObject sub(IVecI iVecI) {
        this.vec.sub(iVecI);
        return this;
    }

    @Override
    public IVectorObject mul(IDoubleI iDoubleI) {
        this.vec.mul(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject mul(double d) {
        this.vec.mul(d);
        return this;
    }

    @Override
    public IVectorObject div(IDoubleI iDoubleI) {
        this.vec.div(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject div(double d) {
        this.vec.div(d);
        return this;
    }

    @Override
    public IVectorObject neg() {
        this.vec.neg();
        return this;
    }

    @Override
    public IVectorObject rev() {
        return this.neg();
    }

    @Override
    public IVectorObject flip() {
        return this.neg();
    }

    @Override
    public IVectorObject zero() {
        this.vec.zero();
        return this;
    }

    @Override
    public IVectorObject add(IVecI iVecI, double d) {
        this.vec.add(iVecI, d);
        return this;
    }

    @Override
    public IVectorObject add(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IVectorObject add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public double dot(IVecI iVecI) {
        return this.vec.dot(iVecI);
    }

    @Override
    public double dot(double d, double d2, double d3) {
        return this.vec.dot(d, d2, d3);
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.dot(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.dot(iSwitchR, iVecI);
    }

    @Override
    public IVecI cross(IVecI iVecI) {
        return this.vec.cross(iVecI);
    }

    @Override
    public IVecI cross(double d, double d2, double d3) {
        return this.vec.cross(d, d2, d3);
    }

    @Override
    public double len() {
        return this.vec.len();
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.vec.len(iSwitchE);
    }

    @Override
    public IDoubleI len(ISwitchR iSwitchR) {
        return this.vec.len(iSwitchR);
    }

    @Override
    public double len2() {
        return this.vec.len2();
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.vec.len2(iSwitchE);
    }

    @Override
    public IDoubleI len2(ISwitchR iSwitchR) {
        return this.vec.len2(iSwitchR);
    }

    @Override
    public IVectorObject len(IDoubleI iDoubleI) {
        this.vec.len(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject len(double d) {
        this.vec.len(d);
        return this;
    }

    @Override
    public IVectorObject unit() {
        this.vec.unit();
        return this;
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.vec.dist(iVecI);
    }

    @Override
    public double dist(double d, double d2, double d3) {
        return this.vec.dist(d, d2, d3);
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.dist(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.dist(iSwitchR, iVecI);
    }

    @Override
    public double dist2(IVecI iVecI) {
        return this.vec.dist2(iVecI);
    }

    @Override
    public double dist2(double d, double d2, double d3) {
        return this.vec.dist2(d, d2, d3);
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.dist2(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.dist2(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI) {
        return this.vec.eq(iVecI);
    }

    @Override
    public boolean eq(double d, double d2, double d3) {
        return this.vec.eq(d, d2, d3);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eq(iSwitchE, iVecI);
    }

    @Override
    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eq(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI, double d) {
        return this.vec.eq(iVecI, d);
    }

    @Override
    public boolean eq(double d, double d2, double d3, double d4) {
        return this.vec.eq(d, d2, d3, d4);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eq(iSwitchE, iVecI, d);
    }

    @Override
    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eq(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public boolean eqX(IVecI iVecI) {
        return this.vec.eqX(iVecI);
    }

    @Override
    public boolean eqY(IVecI iVecI) {
        return this.vec.eqY(iVecI);
    }

    @Override
    public boolean eqZ(IVecI iVecI) {
        return this.vec.eqZ(iVecI);
    }

    @Override
    public boolean eqX(double d) {
        return this.vec.eqX(d);
    }

    @Override
    public boolean eqY(double d) {
        return this.vec.eqY(d);
    }

    @Override
    public boolean eqZ(double d) {
        return this.vec.eqZ(d);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eqX(iSwitchE, iVecI);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eqY(iSwitchE, iVecI);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eqZ(iSwitchE, iVecI);
    }

    @Override
    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eqX(iSwitchR, iVecI);
    }

    @Override
    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eqY(iSwitchR, iVecI);
    }

    @Override
    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eqZ(iSwitchR, iVecI);
    }

    @Override
    public boolean eqX(IVecI iVecI, double d) {
        return this.vec.eqX(iVecI, d);
    }

    @Override
    public boolean eqY(IVecI iVecI, double d) {
        return this.vec.eqY(iVecI, d);
    }

    @Override
    public boolean eqZ(IVecI iVecI, double d) {
        return this.vec.eqZ(iVecI, d);
    }

    @Override
    public boolean eqX(double d, double d2) {
        return this.vec.eqX(d, d2);
    }

    @Override
    public boolean eqY(double d, double d2) {
        return this.vec.eqY(d, d2);
    }

    @Override
    public boolean eqZ(double d, double d2) {
        return this.vec.eqZ(d, d2);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eqX(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eqY(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eqZ(iSwitchE, iVecI, d);
    }

    @Override
    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eqX(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eqY(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public double angle(IVecI iVecI) {
        return this.vec.angle(iVecI);
    }

    @Override
    public double angle(double d, double d2, double d3) {
        return this.vec.angle(d, d2, d3);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.angle(iSwitchE, iVecI);
    }

    @Override
    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.angle(iSwitchR, iVecI);
    }

    @Override
    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.vec.angle(iVecI, iVecI2);
    }

    @Override
    public double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.vec.angle(d, d2, d3, d4, d5, d6);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.vec.angle(iSwitchE, iVecI, iVecI2);
    }

    @Override
    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.vec.angle(iSwitchR, iVecI, iVecI2);
    }

    @Override
    public IVectorObject rot(IDoubleI iDoubleI) {
        this.vec.rot(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject rot(double d) {
        this.vec.rot(d);
        return this;
    }

    @Override
    public IVectorObject rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject rot(IVecI iVecI, double d) {
        this.vec.rot(iVecI, d);
        return this;
    }

    @Override
    public IVectorObject rot(double d, double d2, double d3, double d4) {
        this.vec.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.vec.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IVectorObject rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.vec.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.vec.rot(d, d2, d2, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IVectorObject rot(IVecI iVecI, IVecI iVecI2) {
        this.vec.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVectorObject rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.vec.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVectorObject rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IVectorObject rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IVectorObject rot2(IVecI iVecI, double d) {
        this.vec.rot2(iVecI, d);
        return this;
    }

    @Override
    public IVectorObject rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject rot2(double d, double d2, double d3) {
        this.vec.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject rot2(IVecI iVecI) {
        this.vec.rot2(iVecI);
        return this;
    }

    @Override
    public IVectorObject rot2(IVecI iVecI, IVecI iVecI2) {
        this.vec.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVectorObject scale(IDoubleI iDoubleI) {
        this.vec.scale(iDoubleI);
        return this;
    }

    @Override
    public IVectorObject scale(double d) {
        this.vec.scale(d);
        return this;
    }

    @Override
    public IVectorObject scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject scale(IVecI iVecI, double d) {
        this.vec.scale(iVecI, d);
        return this;
    }

    @Override
    public IVectorObject scale(double d, double d2, double d3, double d4) {
        this.vec.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject scale1d(IVecI iVecI, double d) {
        this.vec.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IVectorObject scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject scale1d(double d, double d2, double d3, double d4) {
        this.vec.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.vec.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IVectorObject scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.vec.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IVectorObject scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.vec.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IVectorObject ref(IVecI iVecI) {
        this.vec.ref(iVecI);
        return this;
    }

    @Override
    public IVectorObject ref(double d, double d2, double d3) {
        this.vec.ref(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject ref(IVecI iVecI, IVecI iVecI2) {
        this.vec.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVectorObject ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.vec.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVectorObject mirror(IVecI iVecI) {
        this.vec.ref(iVecI);
        return this;
    }

    @Override
    public IVectorObject mirror(double d, double d2, double d3) {
        this.vec.ref(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject mirror(IVecI iVecI, IVecI iVecI2) {
        this.vec.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVectorObject mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.vec.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVectorObject shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.vec.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVectorObject shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.vec.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVectorObject shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.vec.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVectorObject shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.vec.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVectorObject shearXY(double d, double d2) {
        this.vec.shearXY(d, d2);
        return this;
    }

    @Override
    public IVectorObject shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVectorObject shearXY(IVecI iVecI, double d, double d2) {
        this.vec.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IVectorObject shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVectorObject shearYZ(double d, double d2) {
        this.vec.shearYZ(d, d2);
        return this;
    }

    @Override
    public IVectorObject shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVectorObject shearYZ(IVecI iVecI, double d, double d2) {
        this.vec.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IVectorObject shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVectorObject shearZX(double d, double d2) {
        this.vec.shearZX(d, d2);
        return this;
    }

    @Override
    public IVectorObject shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVectorObject shearZX(IVecI iVecI, double d, double d2) {
        this.vec.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IVectorObject shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVectorObject translate(double d, double d2, double d3) {
        this.vec.translate(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVectorObject translate(IVecI iVecI) {
        this.vec.translate(iVecI);
        return this;
    }

    @Override
    public IVectorObject mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVectorObject mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVectorObject mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVectorObject cp() {
        return this.dup();
    }

    @Override
    public IVectorObject cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IVectorObject cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVectorObject cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVectorObject transform(IMatrix3I iMatrix3I) {
        this.vec.transform(iMatrix3I);
        return this;
    }

    @Override
    public IVectorObject transform(IMatrix4I iMatrix4I) {
        this.vec.transform(iMatrix4I);
        return this;
    }

    @Override
    public IVectorObject transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.vec.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVectorObject transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.vec.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IVecI dif(IVecI iVecI) {
        return this.vec.dif(iVecI);
    }

    @Override
    public IVecI dif(double d, double d2, double d3) {
        return this.vec.dif(d, d2, d3);
    }

    @Override
    public IVecI diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    @Override
    public IVecI diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    @Override
    public IVecI mid(IVecI iVecI) {
        return this.vec.mid(iVecI);
    }

    @Override
    public IVecI mid(double d, double d2, double d3) {
        return this.vec.mid(d, d2, d3);
    }

    @Override
    public IVecI sum(IVecI iVecI) {
        return this.vec.sum(iVecI);
    }

    @Override
    public IVecI sum(double d, double d2, double d3) {
        return this.vec.sum(d, d2, d3);
    }

    @Override
    public IVecI sum(IVecI ... iVecIArray) {
        return this.vec.sum(iVecIArray);
    }

    @Override
    public IVecI bisect(IVecI iVecI) {
        return this.vec.bisect(iVecI);
    }

    @Override
    public IVecI bisect(double d, double d2, double d3) {
        return this.vec.bisect(d, d2, d3);
    }

    @Override
    public IVecI sum(IVecI iVecI, double d, double d2) {
        return this.vec.sum(iVecI, d, d2);
    }

    @Override
    public IVecI sum(IVecI iVecI, double d) {
        return this.vec.sum(iVecI, d);
    }

    @Override
    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.vec.sum(iVecI, iDoubleI, iDoubleI2);
    }

    @Override
    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.sum(iVecI, iDoubleI);
    }

    @Override
    public IVecI nml(IVecI iVecI) {
        return this.vec.nml(iVecI);
    }

    @Override
    public IVecI nml(double d, double d2, double d3) {
        return this.vec.nml(d, d2, d3);
    }

    @Override
    public IVecI nml(IVecI iVecI, IVecI iVecI2) {
        return this.vec.nml(iVecI, iVecI2);
    }

    @Override
    public IVecI nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.vec.nml(d, d2, d3, d4, d5, d6);
    }

    @Override
    public boolean isValid() {
        if (this.vec == null) {
            return false;
        }
        return this.vec.isValid();
    }

    public String toString() {
        if (this.vec == null) {
            return super.toString();
        }
        return this.vec.toString();
    }

    public IVectorObject setSize(double d) {
        return this.size(d);
    }

    public IVectorObject size(double d) {
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IVectorGraphic)) continue;
            ((IVectorGraphic)this.graphics.get(i)).size(d);
        }
        return this;
    }

    public double getSize() {
        return this.size();
    }

    public double size() {
        if (this.graphics == null) {
            IOut.err("no graphics is set");
            return -1.0;
        }
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IVectorGraphic)) continue;
            return ((IVectorGraphic)this.graphics.get(i)).size();
        }
        return -1.0;
    }

    @Override
    public IVectorObject weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public IVectorObject weight(float f) {
        super.weight(f);
        return this;
    }

    @Override
    public IVectorObject name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IVectorObject layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IVectorObject hide() {
        super.hide();
        return this;
    }

    @Override
    public IVectorObject show() {
        super.show();
        return this;
    }

    @Override
    public IVectorObject clr(IColor iColor) {
        super.clr(iColor);
        return this;
    }

    @Override
    public IVectorObject clr(IColor iColor, int n) {
        super.clr(iColor, n);
        return this;
    }

    @Override
    public IVectorObject clr(IColor iColor, float f) {
        super.clr(iColor, f);
        return this;
    }

    @Override
    public IVectorObject clr(IColor iColor, double d) {
        super.clr(iColor, d);
        return this;
    }

    @Override
    public IVectorObject clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public IVectorObject clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public IVectorObject clr(Color color, float f) {
        super.clr(color, f);
        return this;
    }

    @Override
    public IVectorObject clr(Color color, double d) {
        super.clr(color, d);
        return this;
    }

    @Override
    public IVectorObject clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public IVectorObject clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public IVectorObject clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public IVectorObject clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public IVectorObject clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public IVectorObject clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public IVectorObject clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public IVectorObject clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public IVectorObject clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public IVectorObject clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public IVectorObject clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public IVectorObject hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public IVectorObject hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject setColor(IColor iColor) {
        super.setColor(iColor);
        return this;
    }

    @Override
    public IVectorObject setColor(IColor iColor, int n) {
        super.setColor(iColor, n);
        return this;
    }

    @Override
    public IVectorObject setColor(IColor iColor, float f) {
        super.setColor(iColor, f);
        return this;
    }

    @Override
    public IVectorObject setColor(IColor iColor, double d) {
        super.setColor(iColor, d);
        return this;
    }

    @Override
    public IVectorObject setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public IVectorObject setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public IVectorObject setColor(Color color, float f) {
        super.setColor(color, f);
        return this;
    }

    @Override
    public IVectorObject setColor(Color color, double d) {
        super.setColor(color, d);
        return this;
    }

    @Override
    public IVectorObject setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public IVectorObject setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public IVectorObject setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public IVectorObject setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public IVectorObject setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public IVectorObject setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public IVectorObject setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public IVectorObject setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public IVectorObject setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public IVectorObject setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public IVectorObject setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IVectorObject setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IVectorObject setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVectorObject setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public IVectorObject setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

