/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDynamics;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticleI;
import igeo.IParticleOnCurveI;
import igeo.ITensionI;
import igeo.IVec;
import java.util.ArrayList;

public class ITensionOnCurve
extends IDynamicsBase
implements ITensionI {
    public IParticleOnCurveI pt1;
    public IParticleOnCurveI pt2;
    public double tension = 1.0;
    public boolean constantTension = false;
    public boolean isCurveClosed;

    public ITensionOnCurve(IParticleOnCurveI iParticleOnCurveI, IParticleOnCurveI iParticleOnCurveI2, double d, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleOnCurveI;
        this.pt2 = iParticleOnCurveI2;
        this.tension = d;
        this.isCurveClosed = this.pt1.curve().isClosed();
    }

    public ITensionOnCurve(IParticleOnCurveI iParticleOnCurveI, IParticleOnCurveI iParticleOnCurveI2, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleOnCurveI;
        this.pt2 = iParticleOnCurveI2;
        this.isCurveClosed = this.pt1.curve().isClosed();
    }

    public ITensionOnCurve(IParticleOnCurveI iParticleOnCurveI, IParticleOnCurveI iParticleOnCurveI2, double d) {
        this.pt1 = iParticleOnCurveI;
        this.pt2 = iParticleOnCurveI2;
        this.tension = d;
        this.isCurveClosed = this.pt1.curve().isClosed();
    }

    public ITensionOnCurve(IParticleOnCurveI iParticleOnCurveI, IParticleOnCurveI iParticleOnCurveI2) {
        this.pt1 = iParticleOnCurveI;
        this.pt2 = iParticleOnCurveI2;
        this.isCurveClosed = this.pt1.curve().isClosed();
    }

    @Override
    public double tension() {
        return this.tension;
    }

    @Override
    public ITensionOnCurve tension(double d) {
        this.tension = d;
        return this;
    }

    @Override
    public boolean constant() {
        return this.constantTension;
    }

    @Override
    public ITensionOnCurve constant(boolean bl) {
        this.constantTension = bl;
        return this;
    }

    @Override
    public IParticleI pt(int n) {
        if (n == 1) {
            return this.pt2;
        }
        return this.pt1;
    }

    @Override
    public IParticleI particle(int n) {
        return this.pt(n);
    }

    @Override
    public IVec pos(int n) {
        return this.pt(n).pos();
    }

    @Override
    public IParticleI pt1() {
        return this.pt1;
    }

    @Override
    public IParticleI particle1() {
        return this.pt1();
    }

    @Override
    public IVec pos1() {
        return this.pt1().pos();
    }

    @Override
    public IParticleI pt2() {
        return this.pt2;
    }

    @Override
    public IParticleI particle2() {
        return this.pt2();
    }

    @Override
    public IVec pos2() {
        return this.pt2().pos();
    }

    @Override
    public ITensionOnCurve parent(IObject iObject) {
        super.parent(iObject);
        return this;
    }

    @Override
    public ITensionOnCurve target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    @Override
    public ITensionOnCurve removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    @Override
    public ITensionOnCurve removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        double d = this.pt2.upos() - this.pt1.upos();
        if (this.isCurveClosed) {
            if (d > 0.5) {
                d -= 1.0;
            } else if (d < -0.5) {
                d += 1.0;
            }
        }
        if (this.constantTension) {
            if (d > 0.0) {
                d = this.tension;
            } else if (d < 0.0) {
                d = -this.tension;
            }
        } else {
            d *= this.tension;
        }
        this.pt1.addUForce(d);
        this.pt2.addUForce(-d);
    }

    @Override
    public synchronized void update() {
    }
}

