/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.IVec;
import igeo.IVecI;

public class IPointFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public IVecI pos;
    public IVecI dir;

    public IPointFieldGeo(IVecI iVecI, IVecI iVecI2) {
        this.pos = iVecI;
        this.dir = iVecI2;
    }

    public IVecI get(IVecI iVecI, IVecI iVecI2) {
        return this.dir.dup();
    }

    @Override
    public IVecI get(IVecI iVecI) {
        double d = this.intensity;
        if (this.pos != null) {
            double d2;
            if (this.decay == IFieldGeo.Decay.Linear) {
                d2 = this.pos.dist(iVecI);
                if (d2 >= this.threshold) {
                    return new IVec();
                }
                if (this.threshold > 0.0) {
                    d *= (this.threshold - d2) / this.threshold;
                }
            } else if (this.decay == IFieldGeo.Decay.Gaussian) {
                d2 = this.pos.dist(iVecI);
                if (this.threshold > 0.0) {
                    d *= Math.exp(-2.0 * d2 * d2 / (this.threshold * this.threshold));
                }
            }
        }
        IVecI iVecI2 = this.get(iVecI, this.pos);
        if (this.constantIntensity) {
            double d3 = iVecI2.len();
            if (d3 < IConfig.tolerance) {
                return iVecI2.zero();
            }
            return iVecI2.len(d);
        }
        return iVecI2.mul(d);
    }

    public IVec pos() {
        return this.pos.get();
    }

    public IVec dir() {
        return this.dir.get();
    }

    @Override
    public IPointFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    @Override
    public IPointFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    @Override
    public IPointFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    @Override
    public IPointFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    @Override
    public IPointFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    @Override
    public IPointFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    @Override
    public IPointFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    @Override
    public void del() {
        if (this.pos != null && this.pos instanceof IObject) {
            ((IObject)((Object)this.pos)).del();
        }
        if (this.dir != null && this.dir instanceof IObject) {
            ((IObject)((Object)this.dir)).del();
        }
    }
}

