/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAttribute;
import igeo.IColor;
import igeo.IConfig;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IGeometry;
import igeo.IGraphicObject;
import igeo.IIntegerI;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IMeshGeo;
import igeo.IMeshI;
import igeo.IMeshType;
import igeo.IObject;
import igeo.IServerI;
import igeo.ISurfaceI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import igeo.gui.IGraphicMode;
import igeo.gui.IMeshGraphicGL;
import java.awt.Color;
import java.util.ArrayList;

public class IMesh
extends IGeometry
implements IMeshI {
    public IMeshGeo mesh;

    public IMesh() {
        this.mesh = new IMeshGeo();
        this.initMesh(null);
    }

    public IMesh(IServerI iServerI) {
        super(iServerI);
        this.mesh = new IMeshGeo();
        this.initMesh(iServerI);
    }

    public IMesh(IMeshGeo iMeshGeo) {
        this.mesh = iMeshGeo;
        this.initMesh(null);
    }

    public IMesh(IServerI iServerI, IMeshGeo iMeshGeo) {
        super(iServerI);
        this.mesh = iMeshGeo;
        this.initMesh(iServerI);
    }

    public IMesh(IMesh iMesh) {
        super(iMesh);
        this.mesh = iMesh.mesh.dup();
        this.initMesh(iMesh.server);
        if (iMesh.attr() != null) {
            this.attr(iMesh.attr().dup());
        }
    }

    public IMesh(IServerI iServerI, IMesh iMesh) {
        super(iServerI, iMesh);
        this.mesh = iMesh.mesh.dup();
        this.initMesh(iServerI);
    }

    public IMesh(IServerI iServerI, ICurveI[] iCurveIArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iCurveIArray);
        if (iCurveIArray != null && iCurveIArray.length > 0 && iCurveIArray[0] instanceof IObject && ((IObject)((Object)iCurveIArray[0])).attr() != null) {
            this.attr(((IObject)((Object)iCurveIArray[0])).attr().dup());
        }
        this.initMesh(iServerI);
    }

    public IMesh(ICurveI[] iCurveIArray) {
        this((IServerI)null, iCurveIArray);
    }

    public IMesh(IServerI iServerI, ISurfaceI[] iSurfaceIArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iSurfaceIArray);
        if (iSurfaceIArray != null && iSurfaceIArray.length > 0 && iSurfaceIArray[0] instanceof IObject && ((IObject)((Object)iSurfaceIArray[0])).attr() != null) {
            this.attr(((IObject)((Object)iSurfaceIArray[0])).attr().dup());
        }
        this.initMesh(iServerI);
    }

    public IMesh(ISurfaceI[] iSurfaceIArray) {
        this((IServerI)null, iSurfaceIArray);
    }

    public IMesh(IServerI iServerI, IVec[][] iVecArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecArray);
        this.initMesh(iServerI);
    }

    public IMesh(IVec[][] iVecArray) {
        this((IServerI)null, iVecArray);
    }

    public IMesh(IServerI iServerI, IVec[][] iVecArray, boolean bl) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecArray, bl);
        this.initMesh(iServerI);
    }

    public IMesh(IVec[][] iVecArray, boolean bl) {
        this((IServerI)null, iVecArray, bl);
    }

    public IMesh(IServerI iServerI, IVec[][] iVecArray, boolean bl, IMeshType iMeshType) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecArray, bl, iMeshType);
        this.initMesh(iServerI);
    }

    public IMesh(IVec[][] iVecArray, boolean bl, IMeshType iMeshType) {
        this((IServerI)null, iVecArray, bl, iMeshType);
    }

    public IMesh(IServerI iServerI, IVec[][] iVecArray, int n, int n2, boolean bl) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecArray, n, n2, bl);
        this.initMesh(iServerI);
    }

    public IMesh(IVec[][] iVecArray, int n, int n2, boolean bl) {
        this((IServerI)null, iVecArray, n, n2, bl);
    }

    public IMesh(IServerI iServerI, IVec[][] iVecArray, int n, int n2, boolean bl, IMeshType iMeshType) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecArray, n, n2, bl, iMeshType);
        this.initMesh(iServerI);
    }

    public IMesh(IVec[][] iVecArray, int n, int n2, boolean bl, IMeshType iMeshType) {
        this(null, iVecArray, n, n2, bl, iMeshType);
    }

    public IMesh(IServerI iServerI, ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        super(iServerI);
        this.mesh = new IMeshGeo(arrayList, arrayList2, arrayList3);
        this.initMesh(iServerI);
    }

    public IMesh(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        this((IServerI)null, arrayList, arrayList2, arrayList3);
    }

    public IMesh(IServerI iServerI, IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVertexArray, iEdgeArray, iFaceArray);
        this.initMesh(iServerI);
    }

    public IMesh(IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        this((IServerI)null, iVertexArray, iEdgeArray, iFaceArray);
    }

    public IMesh(IServerI iServerI, IVec[] iVecArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecArray);
        this.initMesh(iServerI);
    }

    public IMesh(IVec[] iVecArray) {
        this((IServerI)null, iVecArray);
    }

    public IMesh(IServerI iServerI, IVertex[] iVertexArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVertexArray);
        this.initMesh(iServerI);
    }

    public IMesh(IVertex[] iVertexArray) {
        this((IServerI)null, iVertexArray);
    }

    public IMesh(IServerI iServerI, IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVertex, iVertex2, iVertex3);
        this.initMesh(iServerI);
    }

    public IMesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        this((IServerI)null, iVertex, iVertex2, iVertex3);
    }

    public IMesh(IServerI iServerI, IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVertex, iVertex2, iVertex3, iVertex4);
        this.initMesh(iServerI);
    }

    public IMesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        this((IServerI)null, iVertex, iVertex2, iVertex3, iVertex4);
    }

    public IMesh(IServerI iServerI, IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecI, iVecI2, iVecI3);
        this.initMesh(iServerI);
    }

    public IMesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this((IServerI)null, iVecI, iVecI2, iVecI3);
    }

    public IMesh(IServerI iServerI, IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super(iServerI);
        this.mesh = new IMeshGeo(iVecI, iVecI2, iVecI3, iVecI4);
        this.initMesh(iServerI);
    }

    public IMesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this((IServerI)null, iVecI, iVecI2, iVecI3, iVecI4);
    }

    public IMesh(IServerI iServerI, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super(iServerI);
        this.mesh = new IMeshGeo(d, d2, d3, d4, d5, d6, d7, d8, d9);
        this.initMesh(iServerI);
    }

    public IMesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this(null, d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public IMesh(IServerI iServerI, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        super(iServerI);
        this.mesh = new IMeshGeo(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        this.initMesh(iServerI);
    }

    public IMesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this(null, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public IMesh(IServerI iServerI, IFace[] iFaceArray) {
        super(iServerI);
        this.mesh = new IMeshGeo(iFaceArray);
        this.initMesh(iServerI);
    }

    public IMesh(IFace[] iFaceArray) {
        this((IServerI)null, iFaceArray);
    }

    @Override
    public synchronized IMeshGeo get() {
        return this.mesh;
    }

    @Override
    public synchronized IMesh dup() {
        return new IMesh(this);
    }

    @Override
    public synchronized boolean isValid() {
        if (this.mesh == null) {
            return false;
        }
        return this.mesh.isValid();
    }

    public synchronized void initMesh(IServerI iServerI) {
        this.parameter = this.mesh;
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    @Override
    public synchronized IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        if (iGraphicMode.isNone()) {
            return null;
        }
        if (iGraphicMode.isGraphic3D()) {
            return new IMeshGraphicGL(this);
        }
        return null;
    }

    @Override
    public synchronized int vertexNum() {
        return this.mesh.vertexNum();
    }

    @Override
    public synchronized int edgeNum() {
        return this.mesh.edgeNum();
    }

    @Override
    public synchronized int faceNum() {
        return this.mesh.faceNum();
    }

    @Override
    public synchronized int vertexNum(ISwitchE iSwitchE) {
        return this.mesh.vertexNum(iSwitchE);
    }

    @Override
    public synchronized int edgeNum(ISwitchE iSwitchE) {
        return this.mesh.edgeNum(iSwitchE);
    }

    @Override
    public synchronized int faceNum(ISwitchE iSwitchE) {
        return this.mesh.faceNum(iSwitchE);
    }

    @Override
    public synchronized IIntegerI vertexNum(ISwitchR iSwitchR) {
        return this.mesh.vertexNum(iSwitchR);
    }

    @Override
    public synchronized IIntegerI edgeNum(ISwitchR iSwitchR) {
        return this.mesh.edgeNum(iSwitchR);
    }

    @Override
    public synchronized IIntegerI faceNum(ISwitchR iSwitchR) {
        return this.mesh.faceNum(iSwitchR);
    }

    @Override
    public synchronized IVertex vertex(int n) {
        return this.mesh.vertex(n);
    }

    @Override
    public synchronized IEdge edge(int n) {
        return this.mesh.edge(n);
    }

    @Override
    public synchronized IFace face(int n) {
        return this.mesh.face(n);
    }

    @Override
    public synchronized IVertex vertex(IIntegerI iIntegerI) {
        return this.mesh.vertex(iIntegerI);
    }

    @Override
    public synchronized IEdge edge(IIntegerI iIntegerI) {
        return this.mesh.edge(iIntegerI);
    }

    @Override
    public synchronized IFace face(IIntegerI iIntegerI) {
        return this.mesh.face(iIntegerI);
    }

    @Override
    public synchronized ArrayList<IVertex> vertices() {
        return this.mesh.vertices();
    }

    @Override
    public synchronized ArrayList<IEdge> edges() {
        return this.mesh.edges();
    }

    @Override
    public synchronized ArrayList<IFace> faces() {
        return this.mesh.faces();
    }

    @Override
    public synchronized IVec center() {
        return this.mesh.center();
    }

    public synchronized IMesh addFace(IFace iFace) {
        this.mesh.addFace(iFace);
        return this;
    }

    public synchronized IMesh addFace(IFace iFace, boolean bl, boolean bl2, boolean bl3) {
        this.mesh.addFace(iFace, bl, bl2, bl3);
        return this;
    }

    public synchronized IMesh addTriangles(IVertex[] iVertexArray) {
        this.mesh.addTriangles(iVertexArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addTriangles(IVec[] iVecArray) {
        this.mesh.addTriangles(iVecArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addQuads(IVertex[] iVertexArray) {
        this.mesh.addQuads(iVertexArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addQuads(IVec[] iVecArray) {
        this.mesh.addQuads(iVecArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addPolygon(IVertex[] iVertexArray) {
        this.mesh.addPolygon(iVertexArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addPolygon(IVec[] iVecArray) {
        this.mesh.addPolygon(iVecArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addTriangleStrip(IVertex[] iVertexArray) {
        this.mesh.addTriangleStrip(iVertexArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addTriangleStrip(IVec[] iVecArray) {
        this.mesh.addTriangleStrip(iVecArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addQuadStrip(IVertex[] iVertexArray) {
        this.mesh.addQuadStrip(iVertexArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addQuadStrip(IVec[] iVecArray) {
        this.mesh.addQuadStrip(iVecArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addTriangleFan(IVertex[] iVertexArray) {
        this.mesh.addTriangleFan(iVertexArray);
        this.resetGraphic();
        return this;
    }

    public synchronized IMesh addTriangleFan(IVec[] iVecArray) {
        this.mesh.addTriangleFan(iVecArray);
        this.resetGraphic();
        return this;
    }

    public IMesh triangulate() {
        this.mesh.triangulate();
        this.resetGraphic();
        return this;
    }

    public IMesh triangulate(boolean bl) {
        this.mesh.triangulate(bl);
        this.resetGraphic();
        return this;
    }

    public IEdge[] nakedEdges() {
        return this.mesh.nakedEdges();
    }

    @Override
    public synchronized IMesh name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public synchronized IMesh layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public synchronized IMesh layer(String string) {
        super.layer(string);
        return this;
    }

    @Override
    public synchronized IMesh attr(IAttribute iAttribute) {
        super.attr(iAttribute);
        return this;
    }

    @Override
    public synchronized IMesh hide() {
        super.hide();
        return this;
    }

    @Override
    public synchronized IMesh show() {
        super.show();
        return this;
    }

    @Override
    public synchronized IMesh clr(IColor iColor) {
        super.clr(iColor);
        return this;
    }

    @Override
    public synchronized IMesh clr(IColor iColor, int n) {
        super.clr(iColor, n);
        return this;
    }

    @Override
    public synchronized IMesh clr(IColor iColor, float f) {
        super.clr(iColor, f);
        return this;
    }

    @Override
    public synchronized IMesh clr(IColor iColor, double d) {
        super.clr(iColor, d);
        return this;
    }

    @Override
    public synchronized IMesh clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public synchronized IMesh clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public synchronized IMesh clr(Color color, float f) {
        super.clr(color, f);
        return this;
    }

    @Override
    public synchronized IMesh clr(Color color, double d) {
        super.clr(color, d);
        return this;
    }

    @Override
    public synchronized IMesh clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public synchronized IMesh clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public synchronized IMesh clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public synchronized IMesh clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public synchronized IMesh clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public synchronized IMesh clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public synchronized IMesh clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public synchronized IMesh clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public synchronized IMesh clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public synchronized IMesh clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized IMesh clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized IMesh hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized IMesh hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized IMesh hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public synchronized IMesh hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh setColor(IColor iColor) {
        super.setColor(iColor);
        return this;
    }

    @Override
    public synchronized IMesh setColor(IColor iColor, int n) {
        super.setColor(iColor, n);
        return this;
    }

    @Override
    public synchronized IMesh setColor(IColor iColor, float f) {
        super.setColor(iColor, f);
        return this;
    }

    @Override
    public synchronized IMesh setColor(IColor iColor, double d) {
        super.setColor(iColor, d);
        return this;
    }

    @Override
    public synchronized IMesh setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public synchronized IMesh setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public synchronized IMesh setColor(Color color, float f) {
        super.setColor(color, f);
        return this;
    }

    @Override
    public synchronized IMesh setColor(Color color, double d) {
        super.setColor(color, d);
        return this;
    }

    @Override
    public synchronized IMesh setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public synchronized IMesh setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public synchronized IMesh setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public synchronized IMesh setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public synchronized IMesh setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public synchronized IMesh setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public synchronized IMesh setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public synchronized IMesh setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public synchronized IMesh setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public synchronized IMesh setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized IMesh setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized IMesh setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized IMesh setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized IMesh setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public synchronized IMesh setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public synchronized IMesh weight(float f) {
        super.weight(f);
        return this;
    }

    public static synchronized IMesh joinMesh(IMesh[] iMeshArray) {
        IMeshGeo[] iMeshGeoArray = new IMeshGeo[iMeshArray.length];
        for (int i = 0; i < iMeshArray.length; ++i) {
            iMeshGeoArray[i] = iMeshArray[i].mesh;
        }
        IMesh iMesh = new IMesh(IMeshGeo.joinMesh(iMeshGeoArray));
        iMesh.attr(iMeshArray[0].attr());
        return iMesh;
    }

    @Override
    public synchronized IMesh close() {
        this.mesh.close();
        return this;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mesh.isClosed();
    }

    @Override
    public synchronized IMesh deleteVertex(int n) {
        return this.deleteVertex(this.mesh.vertex(n));
    }

    @Override
    public synchronized IMesh deleteEdge(int n) {
        return this.deleteEdge(this.mesh.edge(n));
    }

    @Override
    public synchronized IMesh deleteFace(int n) {
        return this.deleteFace(this.mesh.face(n));
    }

    @Override
    public synchronized IMesh deleteVertex(IIntegerI iIntegerI) {
        return this.deleteVertex(iIntegerI.x());
    }

    @Override
    public synchronized IMesh deleteEdge(IIntegerI iIntegerI) {
        return this.deleteEdge(iIntegerI.x());
    }

    @Override
    public synchronized IMesh deleteFace(IIntegerI iIntegerI) {
        return this.deleteFace(iIntegerI.x());
    }

    @Override
    public synchronized IMesh deleteVertex(IVertex iVertex) {
        this.mesh.deleteVertex(iVertex);
        if (this.mesh.vertexNum() == 0 || this.mesh.edgeNum() == 0 || this.mesh.faceNum() == 0) {
            this.del();
        } else {
            this.updateGraphic();
        }
        return this;
    }

    @Override
    public synchronized IMesh deleteEdge(IEdge iEdge) {
        this.mesh.deleteEdge(iEdge);
        if (this.mesh.vertexNum() == 0 || this.mesh.edgeNum() == 0 || this.mesh.faceNum() == 0) {
            this.del();
        } else {
            this.updateGraphic();
        }
        return this;
    }

    @Override
    public synchronized IMesh deleteFace(IFace iFace) {
        this.mesh.deleteFace(iFace);
        if (this.mesh.vertexNum() == 0 || this.mesh.edgeNum() == 0 || this.mesh.faceNum() == 0) {
            this.del();
        } else {
            this.updateGraphic();
        }
        return this;
    }

    public IMesh removeDuplicates() {
        this.mesh.removeDuplicates();
        return this;
    }

    public IMesh removeDuplicates(double d) {
        this.mesh.removeDuplicates(d);
        return this;
    }

    public IMesh join(IMesh[] iMeshArray) {
        return this.join(iMeshArray, IConfig.tolerance);
    }

    public IMesh join(IMesh[] iMeshArray, double d) {
        IMeshGeo[] iMeshGeoArray = new IMeshGeo[iMeshArray.length];
        for (int i = 0; i < iMeshArray.length; ++i) {
            iMeshGeoArray[i] = iMeshArray[i].mesh;
        }
        this.mesh.join(iMeshGeoArray, d);
        return this;
    }

    @Override
    public synchronized void updateGraphic() {
        super.updateGraphic();
        if (IConfig.updateMeshNormal) {
            int n;
            for (n = 0; n < this.mesh.faceNum(); ++n) {
                this.mesh.face(n).calcNormal();
            }
            for (n = 0; n < this.mesh.vertexNum(); ++n) {
                this.mesh.vertex(n).calcNormal();
            }
        }
    }

    @Override
    public synchronized IMesh add(double d, double d2, double d3) {
        this.mesh.add(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.mesh.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public synchronized IMesh add(IVecI iVecI) {
        this.mesh.add(iVecI);
        return this;
    }

    @Override
    public synchronized IMesh sub(double d, double d2, double d3) {
        this.mesh.sub(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.mesh.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public synchronized IMesh sub(IVecI iVecI) {
        this.mesh.sub(iVecI);
        return this;
    }

    @Override
    public synchronized IMesh mul(IDoubleI iDoubleI) {
        this.mesh.mul(iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh mul(double d) {
        this.mesh.mul(d);
        return this;
    }

    @Override
    public synchronized IMesh div(IDoubleI iDoubleI) {
        this.mesh.div(iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh div(double d) {
        this.mesh.div(d);
        return this;
    }

    @Override
    public synchronized IMesh neg() {
        this.mesh.neg();
        return this;
    }

    public synchronized IMesh rev() {
        return this.neg();
    }

    @Override
    public synchronized IMesh flip() {
        return this.neg();
    }

    @Override
    public synchronized IMesh add(IVecI iVecI, double d) {
        this.mesh.add(iVecI, d);
        return this;
    }

    @Override
    public synchronized IMesh add(IVecI iVecI, IDoubleI iDoubleI) {
        this.mesh.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public synchronized IMesh add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public synchronized IMesh rot(IDoubleI iDoubleI) {
        this.mesh.rot(iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh rot(double d) {
        this.mesh.rot(d);
        return this;
    }

    @Override
    public synchronized IMesh rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.mesh.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh rot(IVecI iVecI, double d) {
        this.mesh.rot(iVecI, d);
        return this;
    }

    @Override
    public synchronized IMesh rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.mesh.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.mesh.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public synchronized IMesh rot(IVecI iVecI, IVecI iVecI2) {
        this.mesh.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public synchronized IMesh rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.mesh.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public synchronized IMesh rot2(IDoubleI iDoubleI) {
        this.mesh.rot2(iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh rot2(double d) {
        this.mesh.rot2(d);
        return this;
    }

    @Override
    public synchronized IMesh rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.mesh.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh rot2(IVecI iVecI, double d) {
        this.mesh.rot2(iVecI, d);
        return this;
    }

    @Override
    public synchronized IMesh rot2(IVecI iVecI) {
        this.mesh.rot2(iVecI);
        return this;
    }

    @Override
    public synchronized IMesh rot2(IVecI iVecI, IVecI iVecI2) {
        this.mesh.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public synchronized IMesh scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public synchronized IMesh scale(double d) {
        return this.mul(d);
    }

    @Override
    public synchronized IMesh scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.mesh.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh scale(IVecI iVecI, double d) {
        this.mesh.scale(iVecI, d);
        return this;
    }

    @Override
    public synchronized IMesh scale1d(IVecI iVecI, double d) {
        this.mesh.scale1d(iVecI, d);
        return this;
    }

    @Override
    public synchronized IMesh scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.mesh.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.mesh.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public synchronized IMesh scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.mesh.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public synchronized IMesh ref(IVecI iVecI) {
        this.mesh.ref(iVecI);
        return this;
    }

    @Override
    public synchronized IMesh ref(IVecI iVecI, IVecI iVecI2) {
        this.mesh.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public synchronized IMesh mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public synchronized IMesh mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public synchronized IMesh shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.mesh.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public synchronized IMesh shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.mesh.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public synchronized IMesh shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.mesh.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public synchronized IMesh shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.mesh.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public synchronized IMesh shearXY(double d, double d2) {
        this.mesh.shearXY(d, d2);
        return this;
    }

    @Override
    public synchronized IMesh shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.mesh.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized IMesh shearXY(IVecI iVecI, double d, double d2) {
        this.mesh.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public synchronized IMesh shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.mesh.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized IMesh shearYZ(double d, double d2) {
        this.mesh.shearYZ(d, d2);
        return this;
    }

    @Override
    public synchronized IMesh shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.mesh.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized IMesh shearYZ(IVecI iVecI, double d, double d2) {
        this.mesh.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public synchronized IMesh shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.mesh.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized IMesh shearZX(double d, double d2) {
        this.mesh.shearZX(d, d2);
        return this;
    }

    @Override
    public synchronized IMesh shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.mesh.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized IMesh shearZX(IVecI iVecI, double d, double d2) {
        this.mesh.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public synchronized IMesh shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.mesh.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized IMesh mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public synchronized IMesh mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public synchronized IMesh mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public synchronized IMesh cp() {
        return this.dup();
    }

    @Override
    public synchronized IMesh cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public synchronized IMesh cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public synchronized IMesh cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public synchronized IMesh translate(double d, double d2, double d3) {
        this.mesh.translate(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IMesh translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.mesh.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public synchronized IMesh translate(IVecI iVecI) {
        this.mesh.translate(iVecI);
        return this;
    }

    @Override
    public synchronized IMesh transform(IMatrix3I iMatrix3I) {
        this.mesh.transform(iMatrix3I);
        return this;
    }

    @Override
    public synchronized IMesh transform(IMatrix4I iMatrix4I) {
        this.mesh.transform(iMatrix4I);
        return this;
    }

    @Override
    public synchronized IMesh transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.mesh.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public synchronized IMesh transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.mesh.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }
}

