/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolOp;
import igeo.IBoolR;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDoubleOp;
import igeo.IIntegerI;
import igeo.IIntegerOp;
import igeo.IParameterObject;
import igeo.IReferenceParameter;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;

public class IDoubleR
extends IParameterObject
implements IDoubleI,
IReferenceParameter {
    protected IDoubleOp op;

    public IDoubleR(double d) {
        this.op = new IDouble(d);
    }

    public IDoubleR(IDoubleOp iDoubleOp) {
        this.op = iDoubleOp;
    }

    public IDoubleR(IIntegerI iIntegerI) {
        this.op = new FromInt(iIntegerI);
    }

    public IDoubleR(IServerI iServerI, double d) {
        super(iServerI);
        this.op = new IDouble(d);
    }

    public IDoubleR(IServerI iServerI, IDoubleOp iDoubleOp) {
        super(iServerI);
        this.op = iDoubleOp;
    }

    public IDoubleR(IServerI iServerI, IIntegerI iIntegerI) {
        super(iServerI);
        this.op = new FromInt(iIntegerI);
    }

    public double x() {
        return this.op.x();
    }

    public IDouble get() {
        return this.op.get();
    }

    public IDoubleR getX() {
        return this;
    }

    public IDoubleOp operator() {
        return this.op;
    }

    public IDoubleR dup() {
        return new IDoubleR(this.op);
    }

    public IDoubleR cp() {
        return this.dup();
    }

    public IDoubleR cp(double d) {
        return this.dup().add(d);
    }

    public IDoubleR cp(IDoubleI iDoubleI) {
        return this.dup().add(iDoubleI);
    }

    public IDoubleR set(double d) {
        this.op = new IDouble(d);
        return this;
    }

    public IDoubleR set(IDoubleI iDoubleI) {
        this.op = iDoubleI;
        return this;
    }

    public IDoubleR set(IIntegerI iIntegerI) {
        this.op = new FromInt(iIntegerI);
        return this;
    }

    public IDoubleR add(IDoubleI iDoubleI) {
        this.op = new Add(this.op, iDoubleI);
        return this;
    }

    public IDoubleR add(double d) {
        this.op = new Add(this.op, new IDouble(d));
        return this;
    }

    public IDoubleR sub(IDoubleI iDoubleI) {
        this.op = new Sub(this.op, iDoubleI);
        return this;
    }

    public IDoubleR sub(double d) {
        this.op = new Sub(this.op, new IDouble(d));
        return this;
    }

    public IDoubleR mul(IDoubleI iDoubleI) {
        this.op = new Mul(this.op, iDoubleI);
        return this;
    }

    public IDoubleR mul(double d) {
        this.op = new Mul(this.op, new IDouble(d));
        return this;
    }

    public IDoubleR div(IDoubleI iDoubleI) {
        this.op = new Div(this.op, iDoubleI);
        return this;
    }

    public IDoubleR div(double d) {
        this.op = new Div(this.op, new IDouble(d));
        return this;
    }

    public IDoubleR neg() {
        this.op = new Neg(this.op);
        return this;
    }

    public IDoubleR inv() {
        this.op = new Inv(this.op);
        return this;
    }

    public IDoubleI abs() {
        this.op = new Abs(this.op);
        return this;
    }

    public IDoubleI pow(double d) {
        this.op = new Pow(this.op, new IDouble(d));
        return this;
    }

    public IDoubleI pow(IDoubleI iDoubleI) {
        this.op = new Pow(this.op, iDoubleI);
        return this;
    }

    public IDoubleI sq() {
        this.op = new Sq(this.op);
        return this;
    }

    public IDoubleI sqrt() {
        this.op = new Sqrt(this.op);
        return this;
    }

    public IDoubleI exp() {
        this.op = new Exp(this.op);
        return this;
    }

    public IDoubleI log() {
        this.op = new Log(this.op);
        return this;
    }

    public IDoubleI sin() {
        this.op = new Sin(this.op);
        return this;
    }

    public IDoubleI cos() {
        this.op = new Cos(this.op);
        return this;
    }

    public IDoubleI tan() {
        this.op = new Tan(this.op);
        return this;
    }

    public IDoubleI asin() {
        this.op = new ASin(this.op);
        return this;
    }

    public IDoubleI acos() {
        this.op = new ACos(this.op);
        return this;
    }

    public IDoubleI atan() {
        this.op = new ATan(this.op);
        return this;
    }

    public IDoubleI atan2(double d) {
        this.op = new ATan2(this.op, new IDouble(d));
        return this;
    }

    public IDoubleI atan2(IDoubleI iDoubleI) {
        this.op = new ATan2(this.op, iDoubleI);
        return this;
    }

    public IDoubleI deg() {
        this.op = new Deg(this.op);
        return this;
    }

    public IDoubleI rad() {
        this.op = new Rad(this.op);
        return this;
    }

    public boolean eq(double d) {
        return this.get().eq(d);
    }

    public boolean eq(IDoubleI iDoubleI) {
        return this.get().eq(iDoubleI);
    }

    public boolean eq(ISwitchE iSwitchE, IDoubleI iDoubleI) {
        return this.eq(iDoubleI);
    }

    public IBoolR eq(ISwitchR iSwitchR, IDoubleI iDoubleI) {
        return new IBoolR(new Eq(this.op, iDoubleI));
    }

    public boolean eq(double d, double d2) {
        return this.get().eq(d, d2);
    }

    public boolean eq(IDoubleI iDoubleI, double d) {
        return this.get().eq(iDoubleI, d);
    }

    public boolean eq(ISwitchE iSwitchE, IDoubleI iDoubleI, double d) {
        return this.eq(iDoubleI, d);
    }

    public IBoolR eq(ISwitchR iSwitchR, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IBoolR(new Eq(this.op, iDoubleI, iDoubleI2));
    }

    public static class Eq
    extends IParameterObject
    implements IBoolOp {
        public IDoubleOp v1;
        public IDoubleOp v2;
        public IDoubleOp resolution = null;

        public Eq(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
        }

        public Eq(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2, IDoubleOp iDoubleOp3) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
            this.resolution = iDoubleOp3;
        }

        public boolean x() {
            if (this.resolution == null) {
                return this.v1.get().eq(this.v2.get());
            }
            return this.v1.get().eq(this.v2.get(), this.resolution.x());
        }

        public IBool get() {
            if (this.resolution == null) {
                return this.v1.get().eq((ISwitchR)null, (IDoubleI)this.v2.get());
            }
            return this.v1.get().eq((ISwitchR)null, (IDoubleI)this.v2.get(), this.resolution.get());
        }
    }

    public static class Rad
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Rad(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.toRadians(this.v.x());
        }

        public IDouble get() {
            return this.v.get().rad();
        }
    }

    public static class Deg
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Deg(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.toDegrees(this.v.x());
        }

        public IDouble get() {
            return this.v.get().deg();
        }
    }

    public static class ATan2
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp y;
        public IDoubleOp x;

        public ATan2(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.y = iDoubleOp;
            this.x = iDoubleOp2;
        }

        public double x() {
            return Math.atan2(this.y.x(), this.x.x());
        }

        public IDouble get() {
            return this.y.get().atan2(this.x.get());
        }
    }

    public static class ATan
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public ATan(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.atan(this.v.x());
        }

        public IDouble get() {
            return this.v.get().atan();
        }
    }

    public static class ACos
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public ACos(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.acos(this.v.x());
        }

        public IDouble get() {
            return this.v.get().acos();
        }
    }

    public static class ASin
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public ASin(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.asin(this.v.x());
        }

        public IDouble get() {
            return this.v.get().asin();
        }
    }

    public static class Tan
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Tan(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.tan(this.v.x());
        }

        public IDouble get() {
            return this.v.get().tan();
        }
    }

    public static class Cos
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Cos(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.cos(this.v.x());
        }

        public IDouble get() {
            return this.v.get().cos();
        }
    }

    public static class Sin
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Sin(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.sin(this.v.x());
        }

        public IDouble get() {
            return this.v.get().sin();
        }
    }

    public static class Log
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Log(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.log(this.v.x());
        }

        public IDouble get() {
            return this.v.get().log();
        }
    }

    public static class Exp
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Exp(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.exp(this.v.x());
        }

        public IDouble get() {
            return this.v.get().exp();
        }
    }

    public static class Sqrt
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Sqrt(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.sqrt(this.v.x());
        }

        public IDouble get() {
            return this.v.get().sqrt();
        }
    }

    public static class Sq
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Sq(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            double d = this.v.x();
            return d * d;
        }

        public IDouble get() {
            return this.v.get().sq();
        }
    }

    public static class Pow
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v1;
        public IDoubleOp v2;

        public Pow(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
        }

        public double x() {
            return Math.pow(this.v1.x(), this.v2.x());
        }

        public IDouble get() {
            return this.v1.get().pow(this.v2.get());
        }
    }

    public static class FromInt
    extends IParameterObject
    implements IDoubleOp {
        public IIntegerOp v;

        public FromInt(IIntegerOp iIntegerOp) {
            this.v = iIntegerOp;
        }

        public double x() {
            return this.v.x();
        }

        public IDouble get() {
            return new IDouble(this.v.x());
        }
    }

    public static class Abs
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Abs(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return Math.abs(this.v.x());
        }

        public IDouble get() {
            return this.v.get().abs();
        }
    }

    public static class Inv
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Inv(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return 1.0 / this.v.x();
        }

        public IDouble get() {
            return this.v.get().inv();
        }
    }

    public static class Neg
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v;

        public Neg(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        public double x() {
            return -this.v.x();
        }

        public IDouble get() {
            return this.v.get().neg();
        }
    }

    public static class Div
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v1;
        public IDoubleOp v2;

        public Div(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
        }

        public double x() {
            return this.v1.x() / this.v2.x();
        }

        public IDouble get() {
            return this.v1.get().div(this.v2.get());
        }
    }

    public static class Mul
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v1;
        public IDoubleOp v2;

        public Mul(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
        }

        public double x() {
            return this.v1.x() * this.v2.x();
        }

        public IDouble get() {
            return this.v1.get().mul(this.v2.get());
        }
    }

    public static class Sub
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v1;
        public IDoubleOp v2;

        public Sub(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
        }

        public double x() {
            return this.v1.x() - this.v2.x();
        }

        public IDouble get() {
            return this.v1.get().sub(this.v2.get());
        }
    }

    public static class Add
    extends IParameterObject
    implements IDoubleOp {
        public IDoubleOp v1;
        public IDoubleOp v2;

        public Add(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v1 = iDoubleOp;
            this.v2 = iDoubleOp2;
        }

        public double x() {
            return this.v1.x() + this.v2.x();
        }

        public IDouble get() {
            return this.v1.get().add(this.v2.get());
        }
    }
}

