/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBoolI;
import igeo.IComparator;
import igeo.IConfig;
import igeo.IDoubleI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IOut;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import java.util.ArrayList;

public class IVertex
implements IVecI {
    public ArrayList<IEdge> edges;
    public ArrayList<IFace> faces;
    public ArrayList<IVertex> linkedVertices;
    public IVecI pos;
    public IVecI normal;
    public IVec2I texture;

    public IVertex() {
        this.pos = new IVec();
        this.init();
    }

    public IVertex(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.init();
    }

    public IVertex(IVec iVec) {
        this.pos = iVec.cp();
        this.init();
    }

    public IVertex(IVec4 iVec4) {
        this.pos = iVec4.cp();
        this.init();
    }

    public IVertex(IVecI iVecI) {
        this.pos = iVecI.cp();
        this.init();
    }

    public IVertex(IVertex iVertex) {
        int n;
        this.edges = new ArrayList();
        for (n = 0; n < iVertex.edges.size(); ++n) {
            this.edges.add(iVertex.edges.get(n));
        }
        this.faces = new ArrayList();
        for (n = 0; n < iVertex.faces.size(); ++n) {
            this.faces.add(iVertex.faces.get(n));
        }
        this.linkedVertices = new ArrayList();
        for (n = 0; n < iVertex.linkedVertices.size(); ++n) {
            this.linkedVertices.add(iVertex.linkedVertices.get(n));
        }
        this.pos = iVertex.pos.dup();
        if (iVertex.normal != null) {
            this.normal = iVertex.normal.dup();
        }
        if (iVertex.texture != null) {
            this.texture = iVertex.texture.dup();
        }
    }

    public void init() {
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        this.linkedVertices = new ArrayList();
    }

    public void del() {
        int n;
        for (n = 0; n < this.faces.size(); ++n) {
            this.faces.get(n).del();
            --n;
        }
        for (n = 0; n < this.edges.size(); ++n) {
            this.edges.get(n).del();
            --n;
        }
    }

    public void del(IEdge iEdge) {
        this.edges.remove(iEdge);
        IVertex iVertex = iEdge.vertices[0];
        if (iVertex == this) {
            iVertex = iEdge.vertices[1];
        }
        this.linkedVertices.remove(iVertex);
    }

    public double x() {
        return this.pos.x();
    }

    public double y() {
        return this.pos.y();
    }

    public double z() {
        return this.pos.z();
    }

    public IVertex x(double d) {
        this.pos.x(d);
        return this;
    }

    public IVertex y(double d) {
        this.pos.y(d);
        return this;
    }

    public IVertex z(double d) {
        this.pos.z(d);
        return this;
    }

    public IVertex x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    public IVertex y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    public IVertex z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    public double x(ISwitchE iSwitchE) {
        return this.pos.x(iSwitchE);
    }

    public double y(ISwitchE iSwitchE) {
        return this.pos.y(iSwitchE);
    }

    public double z(ISwitchE iSwitchE) {
        return this.pos.z(iSwitchE);
    }

    public IDoubleI x(ISwitchR iSwitchR) {
        return this.pos.x(iSwitchR);
    }

    public IDoubleI y(ISwitchR iSwitchR) {
        return this.pos.y(iSwitchR);
    }

    public IDoubleI z(ISwitchR iSwitchR) {
        return this.pos.z(iSwitchR);
    }

    public IVec get() {
        return this.pos.get();
    }

    public IVecI pos() {
        return this.pos;
    }

    public IVertex dup() {
        return new IVertex(this);
    }

    public IVec2I to2d() {
        return this.pos.to2d();
    }

    public IVec2I to2d(IVecI iVecI) {
        return this.pos.to2d(iVecI);
    }

    public IVec2I to2d(IVecI iVecI, IVecI iVecI2) {
        return this.pos.to2d(iVecI, iVecI2);
    }

    public IVec2I to2d(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.pos.to2d(iVecI, iVecI2, iVecI3);
    }

    public IVec4I to4d() {
        return this.pos.to4d();
    }

    public IVec4I to4d(double d) {
        return this.pos.to4d(d);
    }

    public IVec4I to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    public IDoubleI getX() {
        return this.pos.getX();
    }

    public IDoubleI getY() {
        return this.pos.getY();
    }

    public IDoubleI getZ() {
        return this.pos.getZ();
    }

    public IVertex set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public IVertex set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    public IVertex set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    public IVertex add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    public IVertex sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    public IVertex sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    public IVertex mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    public IVertex mul(double d) {
        this.pos.mul(d);
        return this;
    }

    public IVertex div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    public IVertex div(double d) {
        this.pos.div(d);
        return this;
    }

    public IVertex neg() {
        this.pos.neg();
        return this;
    }

    public IVertex rev() {
        return this.neg();
    }

    public IVertex flip() {
        return this.neg();
    }

    public IVertex zero() {
        this.pos.zero();
        return this;
    }

    public IVertex add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    public IVertex add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    public IVertex add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    public IVertex add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    public double dot(double d, double d2, double d3) {
        return this.pos.dot(d, d2, d3);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    public IDoubleI dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    public IVecI cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    public IVecI cross(double d, double d2, double d3) {
        return this.pos.cross(d, d2, d3);
    }

    public double len() {
        return this.pos.len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    public IDoubleI len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    public double len2() {
        return this.pos.len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    public IDoubleI len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    public IVertex len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    public IVertex len(double d) {
        this.pos.len(d);
        return this;
    }

    public IVertex unit() {
        this.pos.unit();
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    public double dist(double d, double d2, double d3) {
        return this.pos.dist(d, d2, d3);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    public IDoubleI dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    public double dist2(double d, double d2, double d3) {
        return this.pos.dist2(d, d2, d3);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    public IDoubleI dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    public boolean eq(double d, double d2, double d3) {
        return this.pos.eq(d, d2, d3);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    public boolean eq(double d, double d2, double d3, double d4) {
        return this.pos.eq(d, d2, d3, d4);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    public boolean eqX(double d) {
        return this.pos.eqX(d);
    }

    public boolean eqY(double d) {
        return this.pos.eqY(d);
    }

    public boolean eqZ(double d) {
        return this.pos.eqZ(d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    public boolean eqX(double d, double d2) {
        return this.pos.eqX(d, d2);
    }

    public boolean eqY(double d, double d2) {
        return this.pos.eqY(d, d2);
    }

    public boolean eqZ(double d, double d2) {
        return this.pos.eqZ(d, d2);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    public double angle(double d, double d2, double d3) {
        return this.pos.angle(d, d2, d3);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    public double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.angle(d, d2, d3, d4, d5, d6);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    public IVertex rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    public IVertex rot(double d) {
        this.pos.rot(d);
        return this;
    }

    public IVertex rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    public IVertex rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    public IVertex rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    public IVertex rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVertex rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    public IVertex rot2(double d) {
        return this.rot(d);
    }

    public IVertex rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    public IVertex rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    public IVertex rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    public IVertex rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    public IVertex rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    public IVertex scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    public IVertex scale(double d) {
        this.pos.scale(d);
        return this;
    }

    public IVertex scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    public IVertex scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    public IVertex scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    public IVertex scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    public IVertex scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    public IVertex scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    public IVertex scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    public IVertex scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IVertex scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    public IVertex ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IVertex ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    public IVertex ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IVertex ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IVertex mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IVertex mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    public IVertex mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IVertex mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IVertex shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IVertex shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IVertex shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    public IVertex shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IVertex shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    public IVertex shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    public IVertex shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    public IVertex shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IVertex shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    public IVertex shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    public IVertex shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    public IVertex shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IVertex shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    public IVertex shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    public IVertex shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    public IVertex shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IVertex translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    public IVertex translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    public IVertex transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    public IVertex transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    public IVertex transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVertex transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IVertex mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVertex mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVertex mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVertex cp() {
        return this.dup();
    }

    public IVertex cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IVertex cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVertex cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVecI dif(IVecI iVecI) {
        return this.pos.dif(iVecI);
    }

    public IVecI dif(double d, double d2, double d3) {
        return this.pos.dif(d, d2, d3);
    }

    public IVecI diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    public IVecI diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    public IVecI mid(IVecI iVecI) {
        return this.pos.mid(iVecI);
    }

    public IVecI mid(double d, double d2, double d3) {
        return this.pos.mid(d, d2, d3);
    }

    public IVecI sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVecI sum(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IVecI sum(IVecI ... iVecIArray) {
        return this.pos.sum(iVecIArray);
    }

    public IVecI bisect(IVecI iVecI) {
        return this.pos.bisect(iVecI);
    }

    public IVecI bisect(double d, double d2, double d3) {
        return this.pos.bisect(d, d2, d3);
    }

    public IVecI sum(IVecI iVecI, double d, double d2) {
        return this.pos.sum(iVecI, d, d2);
    }

    public IVecI sum(IVecI iVecI, double d) {
        return this.pos.sum(iVecI, d);
    }

    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.pos.sum(iVecI, iDoubleI, iDoubleI2);
    }

    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.sum(iVecI, iDoubleI);
    }

    public IVecI nml(IVecI iVecI) {
        return this.pos.nml(iVecI);
    }

    public IVecI nml(double d, double d2, double d3) {
        return this.pos.nml(d, d2, d3);
    }

    public IVecI nml(IVecI iVecI, IVecI iVecI2) {
        return this.pos.nml(iVecI, iVecI2);
    }

    public IVecI nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.nml(d, d2, d3, d4, d5, d6);
    }

    public IVec getAverageNormal() {
        if (this.faces == null || this.faces.size() == 0) {
            return new IVec(0.0, 0.0, 1.0);
        }
        IVec iVec = new IVec(0.0, 0.0, 0.0);
        for (int i = 0; i < this.faces.size(); ++i) {
            iVec.add(this.faces.get(i).getAverageNormal());
        }
        iVec.unit();
        return iVec;
    }

    public void calcNormal() {
        this.normal = this.getAverageNormal();
    }

    public IVecI normal() {
        return this.nml();
    }

    public IVecI nml() {
        if (this.normal == null) {
            this.calcNormal();
        }
        return this.normal;
    }

    public IVecI getNormal() {
        return this.nml();
    }

    public IVecI getNml() {
        return this.nml();
    }

    public IVertex setNormal(IVecI iVecI) {
        return this.setNml(iVecI);
    }

    public IVertex setNormal(double d, double d2, double d3) {
        return this.setNml(d, d2, d3);
    }

    public IVertex setNml(IVecI iVecI) {
        this.normal = iVecI;
        return this;
    }

    public IVertex setNml(double d, double d2, double d3) {
        return this.setNml(new IVec(d, d2, d3));
    }

    public boolean isValid() {
        if (this.pos == null) {
            return false;
        }
        return this.pos.isValid();
    }

    public IVec2I texture() {
        return this.texture;
    }

    public IVertex texture(IVec2I iVec2I) {
        this.texture = iVec2I;
        return this;
    }

    public IVertex texture(double d, double d2) {
        this.texture(new IVec2(d, d2));
        return this;
    }

    public void addEdge(IEdge iEdge) {
        this.edges.add(iEdge);
        if (iEdge.getVertex(0) == this) {
            this.linkedVertices.add(iEdge.getVertex(1));
        } else {
            this.linkedVertices.add(iEdge.getVertex(0));
        }
    }

    public IEdge getEdge(int n) {
        return this.edge(n);
    }

    public IEdge edge(int n) {
        return this.edges.get(n);
    }

    public int edgeNum() {
        return this.edges.size();
    }

    public IEdge getEdgeTo(IVertex iVertex) {
        for (int i = 0; i < this.edges.size(); ++i) {
            IEdge iEdge = this.edges.get(i);
            if (iEdge.getOtherVertex(this) != iVertex) continue;
            return iEdge;
        }
        return null;
    }

    public IEdge createEdgeTo(IVertex iVertex) {
        IEdge iEdge = this.getEdgeTo(iVertex);
        if (iEdge == null) {
            iEdge = new IEdge(this, iVertex);
        }
        return iEdge;
    }

    public void addFace(IFace iFace) {
        this.faces.add(iFace);
    }

    public IFace getFace(int n) {
        return this.face(n);
    }

    public IFace face(int n) {
        return this.faces.get(n);
    }

    public int faceNum() {
        return this.faces.size();
    }

    public IVertex linkedVertex(int n) {
        return this.linkedVertices.get(n);
    }

    public int linkedVertexNum() {
        return this.linkedVertices.size();
    }

    public void replaceLinkedVertex(IVertex iVertex, IVertex iVertex2) {
        int n = this.linkedVertices.indexOf(iVertex);
        if (n < 0) {
            IOut.err("no such linked vertex in this vertex");
            return;
        }
        this.linkedVertices.set(n, iVertex2);
    }

    public void replaceVertex(IVertex iVertex) {
        int n;
        int n2;
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        for (int i = 0; i < this.edges.size(); ++i) {
            IVertex iVertex2 = this.edges.get(i).getOtherVertex(this);
            for (int j = 0; j < iVertex.edges.size(); ++j) {
                IVertex iVertex3 = iVertex.edges.get(j).getOtherVertex(iVertex);
                if (iVertex2 != iVertex3 || arrayList.contains(iVertex2)) continue;
                arrayList.add(iVertex2);
            }
        }
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        for (n2 = 0; n2 < this.edges.size(); ++n2) {
            IEdge iEdge = this.edges.get(n2);
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                if (!iEdge.contains((IVertex)arrayList.get(n))) continue;
                bl = true;
            }
            if (iEdge.contains(iVertex)) {
                bl = true;
            }
            if (bl) {
                arrayList2.add(iEdge);
                continue;
            }
            iEdge.replaceVertex(this, iVertex);
            iVertex.addEdge(iEdge);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            ((IEdge)arrayList2.get(n2)).del();
        }
        for (n2 = 0; n2 < this.linkedVertices.size(); ++n2) {
            IVertex iVertex4 = this.linkedVertices.get(n2);
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                if (iVertex4 != arrayList.get(n)) continue;
                bl = true;
            }
            if (iVertex4 == iVertex) {
                bl = true;
            }
            if (bl) continue;
            iVertex4.replaceLinkedVertex(this, iVertex);
        }
        for (n2 = 0; n2 < this.faces.size(); ++n2) {
            IFace iFace = this.faces.get(n2);
            iFace.replaceVertex(this, iVertex);
            iVertex.addFace(iFace);
        }
    }

    public IEdge[] getOtherEdges(IEdge iEdge) {
        IEdge[] iEdgeArray = new IEdge[this.edges.size() - 1];
        if (!this.edges.contains(iEdge)) {
            IOut.err("no such edge in this vertex");
            return null;
        }
        int n = 0;
        for (int i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i) == iEdge) continue;
            iEdgeArray[n] = this.edges.get(i);
            ++n;
        }
        return iEdgeArray;
    }

    public String toString() {
        return "IVertex: " + this.pos + " (normal=" + this.normal + ", texture=" + this.texture + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZYXComparator
    implements IComparator<IVertex> {
        @Override
        public int compare(IVertex iVertex, IVertex iVertex2) {
            IVec iVec = iVertex.pos.get();
            IVec iVec2 = iVertex2.pos.get();
            if (iVec.z < iVec2.z - IConfig.tolerance) {
                return 1;
            }
            if (iVec.z > iVec2.z + IConfig.tolerance) {
                return -1;
            }
            if (iVec.y < iVec2.y - IConfig.tolerance) {
                return 1;
            }
            if (iVec.y > iVec2.y + IConfig.tolerance) {
                return -1;
            }
            if (iVec.x < iVec2.x - IConfig.tolerance) {
                return 1;
            }
            if (iVec.x > iVec2.x + IConfig.tolerance) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZComparator
    implements IComparator<IVertex> {
        @Override
        public int compare(IVertex iVertex, IVertex iVertex2) {
            double d;
            double d2 = iVertex.pos.z();
            if (d2 < (d = iVertex2.pos.z())) {
                return 1;
            }
            if (d2 > d) {
                return -1;
            }
            return 0;
        }
    }
}

