/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IDynamics;
import igeo.IParticleI;
import igeo.ITrajectoryI;
import igeo.IVec;
import igeo.IVecI;
import igeo.IWall;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITriangleWall
extends IWall {
    public IVecI[] pts = new IVecI[3];
    public IVec dir1;
    public IVec dir2;

    public ITriangleWall(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super(iVecI.nml(iVecI2, iVecI3), iVecI);
        this.pts[0] = iVecI;
        this.pts[1] = iVecI2;
        this.pts[2] = iVecI3;
    }

    public ITriangleWall(IVecI[] iVecIArray) {
        super(iVecIArray[0].nml(iVecIArray[1], iVecIArray[2]), iVecIArray[0]);
        this.pts[0] = iVecIArray[0];
        this.pts[1] = iVecIArray[1];
        this.pts[2] = iVecIArray[2];
    }

    public ITriangleWall(ITriangleWall iTriangleWall) {
        super(iTriangleWall);
        this.pts[0] = iTriangleWall.pts[0].dup();
        this.pts[1] = iTriangleWall.pts[1].dup();
        this.pts[2] = iTriangleWall.pts[2].dup();
    }

    @Override
    public ITriangleWall fric(double d) {
        this.friction = d;
        return this;
    }

    @Override
    public ITriangleWall friction(double d) {
        return this.fric(d);
    }

    @Override
    public ITriangleWall elast(double d) {
        this.elasticity = d;
        return this;
    }

    @Override
    public ITriangleWall elasticity(double d) {
        return this.elast(d);
    }

    @Override
    public double distToCrossing(IParticleI iParticleI) {
        IVec iVec = IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iParticleI.vel(), iParticleI.pos());
        if (this.isInside(iVec)) {
            return iVec.dist(iParticleI.pos());
        }
        return -1.0;
    }

    public IVec intersect(IParticleI iParticleI) {
        IVec iVec = IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iParticleI.vel(), iParticleI.pos());
        if (this.isInside(iVec)) {
            return iVec;
        }
        return null;
    }

    @Override
    public IVec intersect(IVec iVec, IVec iVec2) {
        IVec iVec3 = IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iVec2.dif(iVec), iVec);
        if (this.isInside(iVec3)) {
            return iVec3;
        }
        return null;
    }

    public boolean isInside(IVec iVec) {
        return this.isInsideLocal(iVec.dif(this.pts[0]));
    }

    public boolean isInsideLocal(IVec iVec) {
        double[] dArray;
        if (this.dir1 == null) {
            this.dir1 = this.pts[1].get().dif(this.pts[0]);
        }
        if (this.dir2 == null) {
            this.dir2 = this.pts[2].get().dif(this.pts[0]);
        }
        return (dArray = iVec.projectTo2Vec(this.dir1, this.dir2))[0] >= 0.0 && dArray[0] <= 1.0 && dArray[1] >= 0.0 && dArray[1] <= 1.0 && dArray[0] + dArray[1] <= 1.0;
    }

    @Override
    public boolean isCrossing(IParticleI iParticleI) {
        double d = iParticleI.vel().len2();
        if (d == 0.0) {
            return false;
        }
        IVec iVec = iParticleI.pos().dup();
        IVec iVec2 = iVec.dup().add(iParticleI.vel(), IConfig.updateRate);
        return this.isCrossing(iVec, iVec2);
    }

    @Override
    public boolean isCrossing(IVec iVec, IVec iVec2) {
        IVec iVec3 = iVec.dif(this.planePt);
        IVec iVec4 = iVec2.dif(this.planePt);
        double d = iVec3.dot(this.planeDir);
        double d2 = iVec4.dot(this.planeDir);
        if (d == 0.0 || d * d2 < 0.0) {
            IVec iVec5 = IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iVec2.dif(iVec), iVec);
            return this.isInside(iVec5);
        }
        return false;
    }

    @Override
    public IVec closerIntersection(IVec iVec, IVec iVec2, ArrayList<IDynamics> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IWall iWall;
            if (!(arrayList.get(i) instanceof IWall) || arrayList.get(i) == this || !(iWall = (IWall)arrayList.get(i)).isCrossing(iVec, iVec2)) continue;
            iVec2 = iWall.intersect(iVec, iVec2);
        }
        return iVec2;
    }

    @Override
    public void postinteract(ArrayList<IDynamics> arrayList) {
        this.planeDir = this.pts[0].get().nml(this.pts[1], this.pts[2]);
        super.postinteract(arrayList);
        this.dir1 = null;
        this.dir2 = null;
    }

    @Override
    public void bounce(IParticleI iParticleI, ArrayList<IDynamics> arrayList) {
        double d = iParticleI.vel().len2();
        if (d > 0.0) {
            IVec iVec;
            IVec iVec2 = iParticleI.pos().dup();
            IVec iVec3 = iVec2.dup().add(iParticleI.vel(), IConfig.updateRate);
            iVec2.sub(this.planePt);
            iVec3.sub(this.planePt);
            double d2 = iVec2.dot(this.planeDir);
            double d3 = iVec3.dot(this.planeDir);
            if ((d2 == 0.0 || d2 * d3 < 0.0) && this.isInsideLocal(iVec = IVec.intersectPlaneAndLine(this.planeDir.get(), iVec3.dif(iVec2), iVec2))) {
                double d4;
                if (IConfig.checkAdjacentWalls) {
                    d4 = this.distToCrossing(iParticleI);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        double d5;
                        if (!(arrayList.get(i) instanceof IWall) || arrayList.get(i) == this || !((d5 = ((IWall)arrayList.get(i)).distToCrossing(iParticleI)) >= 0.0) || !(d5 < d4)) continue;
                        return;
                    }
                }
                if (this.elasticity == 1.0 && this.friction == 0.0) {
                    iParticleI.vel().ref(this.planeDir);
                    iVec.add(this.planePt);
                    if (IConfig.checkAdjacentWalls) {
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec);
                        }
                        IVec iVec4 = iVec3.ref(this.planeDir).add(this.planePt);
                        iVec4 = this.closerIntersection(iVec, iVec4, arrayList);
                        iParticleI.pos(iVec4);
                        iParticleI.skipUpdateOnce(true);
                    } else {
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec);
                        }
                        iParticleI.pos(iVec3.ref(this.planeDir).add(this.planePt));
                        iParticleI.skipUpdateOnce(true);
                    }
                } else {
                    if (this.planeDirCache == null) {
                        this.planeDirCache = this.planeDir.get().dup().unit();
                    }
                    d4 = Math.sqrt(iVec3.dist2(iVec) / iVec3.dist2(iVec2));
                    IVec iVec5 = this.planeDirCache.dup().mul(-this.planeDirCache.dot(iParticleI.vel()));
                    IVec iVec6 = iParticleI.vel().dup().add(iVec5);
                    iVec5.mul(this.elasticity);
                    if (iVec5.len2() == 0.0) {
                        iVec5.set(this.planeDirCache).mul(IConfig.tolerance / IConfig.updateRate);
                        if (this.planeDirCache.dot(iParticleI.vel()) > 0.0) {
                            iVec5.neg();
                        }
                    }
                    iVec6.mul(1.0 - this.friction);
                    if (IConfig.checkAdjacentWalls) {
                        iVec5.add(iVec6);
                        iParticleI.vel(iVec5);
                        iVec.add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec);
                        }
                        IVec iVec7 = iVec.dup().add(iVec5, IConfig.updateRate * d4);
                        iVec7 = this.closerIntersection(iVec, iVec7, arrayList);
                        iParticleI.pos(iVec7);
                        iParticleI.skipUpdateOnce(true);
                    } else {
                        iVec.add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec.dup());
                        }
                        iVec5.add(iVec6);
                        iParticleI.vel(iVec5);
                        iParticleI.pos(iVec.add(iVec5, IConfig.updateRate * d4));
                        iParticleI.skipUpdateOnce(true);
                    }
                }
            }
        }
    }
}

