/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IAttribute;
import igeo.IBasicMaterial;
import igeo.IBrep;
import igeo.IColor;
import igeo.ICurve;
import igeo.ICurveGeo;
import igeo.ICurveR;
import igeo.IG;
import igeo.IMesh;
import igeo.IMeshI;
import igeo.IMeshR;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IServerI;
import igeo.ISurface;
import igeo.ISurfaceGeo;
import igeo.ISurfaceR;
import igeo.IText;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVecI;
import igeo.io.IRandomAccessOutputStream;
import igeo.io.IRhino3dm;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRhino3dmExporter
extends IRhino3dm {
    public static final int version = 4;
    public static final int openNurbsVersion = 201004095;
    public OutputStream ostream;
    public IRhino3dm.Rhino3dmFile file;
    public IServerI server;
    public int currentPos;

    public IRhino3dmExporter(OutputStream outputStream, IServerI iServerI) {
        this.ostream = outputStream;
        this.server = iServerI;
    }

    public static boolean write(File file, IServerI iServerI) {
        try {
            IRandomAccessOutputStream iRandomAccessOutputStream = new IRandomAccessOutputStream(file);
            if (iRandomAccessOutputStream == null) {
                return false;
            }
            boolean bl = IRhino3dmExporter.write(iRandomAccessOutputStream, iServerI);
            iRandomAccessOutputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean write(OutputStream outputStream, IServerI iServerI) throws IOException {
        IRhino3dmExporter iRhino3dmExporter = new IRhino3dmExporter(outputStream, iServerI);
        iRhino3dmExporter.write();
        return true;
    }

    public void write() throws IOException {
        this.file = new IRhino3dm.Rhino3dmFile(4, 201004095, this.server);
        this.currentPos = 0;
        this.writeStartSection();
        this.writeProperties();
        this.writeSettings();
        this.writeBitmapTable();
        this.writeTextureMappingTable();
        this.writeMaterialTable();
        this.writeLinetypeTable();
        this.writeLayerTable();
        this.writeGroupTable();
        this.writeFontTable();
        this.writeDimStyleTable();
        this.writeLightTable();
        this.writeHatchPatternTable();
        this.writeInstanceDefinitionTable();
        this.writeObjectTable();
        this.writeHistoryRecordTable();
        this.writeUserDataTable();
        this.writeEndMark();
    }

    public void writeStartSection() throws IOException {
        String string = String.valueOf(4);
        for (int i = 0; i < 8 && string.length() < 8; ++i) {
            string = " " + string;
        }
        String string2 = "3D Geometry File Format " + string;
        this.write(string2.getBytes(), 32, null);
        String string3 = " IGeo 3D geometry library : version " + IG.version();
        byte[] byArray = string3.getBytes();
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 2] = 26;
        byArray2[byArray2.length - 1] = 0;
        this.writeChunk(new IRhino3dm.Chunk(1, byArray2));
    }

    public void writeProperties() throws IOException {
        IRhino3dm.Chunk[] chunkArray = new IRhino3dm.Chunk[]{new IRhino3dm.Chunk(-1610612698, 201004095)};
        this.writeChunkTable(0x10000014, chunkArray);
    }

    public void writeSettings() throws IOException {
        if (this.file != null && this.file.settings != null && this.file.settings.unitsAndTolerances != null && this.file.settings.unitsAndTolerances.unitSystem != null) {
            IRhino3dm.Chunk[] chunkArray = new IRhino3dm.Chunk[1];
            ChunkOutputStream chunkOutputStream = new ChunkOutputStream(536903729);
            this.file.settings.unitsAndTolerances.write(this.file, chunkOutputStream, chunkOutputStream.getCRC());
            chunkArray[0] = chunkOutputStream.getChunk();
            this.writeChunkTable(0x10000015, chunkArray);
        } else {
            this.writeChunkTable(0x10000015);
        }
    }

    public void writeBitmapTable() throws IOException {
        this.writeChunkTable(0x10000016);
    }

    public void writeTextureMappingTable() throws IOException {
        this.writeChunkTable(268435493);
    }

    public IRhino3dm.Chunk getMaterialChunk(IRhino3dm.Material material) throws IOException {
        ChunkOutputStream chunkOutputStream = new ChunkOutputStream(536903744);
        material.write(this.file, chunkOutputStream, chunkOutputStream.getCRC());
        return chunkOutputStream.getChunk();
    }

    public void writeMaterialTable() throws IOException {
        this.file.materials = new ArrayList();
        this.file.imaterials = new ArrayList();
        for (int i = 0; i < this.server.server().objectNum(); ++i) {
            IRhino3dm.Material material;
            IBasicMaterial iBasicMaterial;
            IAttribute iAttribute = this.server.server().object(i).attr();
            if (iAttribute == null) continue;
            if (iAttribute.material != null) {
                if (this.file.imaterials.contains(iAttribute.material) || !(iAttribute.material instanceof IBasicMaterial)) continue;
                iBasicMaterial = (IBasicMaterial)iAttribute.material;
                material = new IRhino3dm.Material(iBasicMaterial);
                material.materialIndex = this.file.materials.size();
                this.file.imaterials.add(iBasicMaterial);
                this.file.materials.add(material);
                continue;
            }
            if (iAttribute.color == null) continue;
            iBasicMaterial = new IBasicMaterial();
            iBasicMaterial.diffuse = iAttribute.color;
            iBasicMaterial.transparency = (double)(255 - iAttribute.color.getAlpha()) / 255.0;
            material = new IRhino3dm.Material(iBasicMaterial);
            material.materialIndex = this.file.materials.size();
            this.file.imaterials.add(iBasicMaterial);
            this.file.materials.add(material);
            iAttribute.material = iBasicMaterial;
        }
        IRhino3dm.ChunkTable chunkTable = new IRhino3dm.ChunkTable(0x10000010);
        for (int i = 0; i < this.file.materials.size(); ++i) {
            chunkTable.add(this.nestChunk(536903744, this.getObjectChunk(this.file.materials.get(i))));
        }
        this.writeChunkTable(chunkTable);
    }

    public void writeLinetypeTable() throws IOException {
        this.writeChunkTable(268435491);
    }

    public void writeLayerTable() throws IOException {
        IRhino3dm.ChunkTable chunkTable = new IRhino3dm.ChunkTable(0x10000011);
        for (int i = 0; i < this.server.server().layerNum(); ++i) {
            IRhino3dm.Layer layer = new IRhino3dm.Layer(this.server.server().getLayer(i), i);
            chunkTable.add(this.nestChunk(536903760, this.getObjectChunk(layer)));
        }
        this.writeChunkTable(chunkTable);
    }

    public void writeGroupTable() throws IOException {
        this.writeChunkTable(0x10000018);
    }

    public void writeFontTable() throws IOException {
        this.writeChunkTable(0x10000019);
    }

    public void writeDimStyleTable() throws IOException {
        this.writeChunkTable(0x10000020);
    }

    public void writeLightTable() throws IOException {
        this.writeChunkTable(0x10000012);
    }

    public void writeHatchPatternTable() throws IOException {
        this.writeChunkTable(0x10000022);
    }

    public void writeInstanceDefinitionTable() throws IOException {
        this.writeChunkTable(0x10000021);
    }

    public void writeObjectTable() throws IOException {
        IRhino3dm.ChunkTable chunkTable = new IRhino3dm.ChunkTable(0x10000013);
        IRandomAccessOutputStream iRandomAccessOutputStream = null;
        if (this.ostream instanceof IRandomAccessOutputStream) {
            iRandomAccessOutputStream = (IRandomAccessOutputStream)this.ostream;
            chunkTable.writeTableHeader(iRandomAccessOutputStream);
        }
        int n = this.server.server().objectNum();
        IOut.debug(0, "writing " + n + "objects");
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            IObject iObject;
            if (i % 100 == 0 && i > 0) {
                IOut.debug(0, "object #" + i + "/" + n);
            }
            if ((iObject = this.server.server().getObject(i)).isValid()) {
                IRhino3dm.Chunk chunk = this.getObjectChunk(iObject);
                if (iObject instanceof IMesh) {
                    IOut.debug(100, i + ": chunk =" + chunk);
                    if (chunk != null) {
                        IOut.debug(100, i + ": chunk size=" + chunk.contentLength());
                    }
                }
                if (chunk == null) continue;
                if (iRandomAccessOutputStream != null) {
                    chunkTable.writeTableEntry(iRandomAccessOutputStream, chunk);
                    chunk.clear();
                    chunk = null;
                } else {
                    chunkTable.add(chunk);
                }
                ++n2;
                continue;
            }
            IOut.err("invalid object " + iObject + " is skipped.");
        }
        if (iRandomAccessOutputStream != null) {
            chunkTable.writeTableEnd(iRandomAccessOutputStream);
        } else {
            chunkTable.serialize();
            this.writeChunkTable(chunkTable);
        }
        IOut.debug(1, n2 + " objects are wrote");
    }

    public static IRhino3dm.RhinoObject getRhinoObject(IObject iObject, IRhino3dm.Rhino3dmFile rhino3dmFile) {
        IRhino3dm.RhinoObject rhinoObject = null;
        if (iObject instanceof IPoint) {
            rhinoObject = IRhino3dmExporter.getRhinoPoint(((IPoint)iObject).get());
        } else if (iObject instanceof IPointR) {
            rhinoObject = IRhino3dmExporter.getRhinoPoint(((IPointR)iObject).get());
        } else if (iObject instanceof ICurve) {
            rhinoObject = IRhino3dmExporter.getRhinoCurve(((ICurve)iObject).get());
        } else if (iObject instanceof ICurveR) {
            rhinoObject = IRhino3dmExporter.getRhinoCurve(((ICurveR)iObject).get());
        } else if (iObject instanceof ISurface) {
            rhinoObject = IRhino3dmExporter.getRhinoSurface(((ISurface)iObject).get());
        } else if (iObject instanceof ISurfaceR) {
            rhinoObject = IRhino3dmExporter.getRhinoSurface(((ISurfaceR)iObject).get());
        } else if (iObject instanceof IMesh) {
            rhinoObject = IRhino3dmExporter.getRhinoMesh(((IMesh)iObject).mesh);
        } else if (iObject instanceof IMeshR) {
            rhinoObject = IRhino3dmExporter.getRhinoMesh(((IMeshR)iObject).mesh);
        } else if (iObject instanceof IBrep) {
            rhinoObject = IRhino3dmExporter.getRhinoBrep((IBrep)iObject);
        } else if (iObject instanceof IText) {
            rhinoObject = IRhino3dmExporter.getRhinoText((IText)iObject);
        }
        if (rhinoObject != null) {
            rhinoObject.setAttributes(new IRhino3dm.ObjectAttributes(iObject, rhino3dmFile));
        }
        return rhinoObject;
    }

    public static IRhino3dm.Point getRhinoPoint(IVec iVec) {
        return new IRhino3dm.Point(iVec);
    }

    public static IRhino3dm.NurbsCurve getRhinoCurve(ICurveGeo iCurveGeo) {
        return new IRhino3dm.NurbsCurve(iCurveGeo);
    }

    public static IRhino3dm.RhinoObject getRhinoSurface(ISurfaceGeo iSurfaceGeo) {
        if (!iSurfaceGeo.hasTrim() || iSurfaceGeo.hasDefaultTrim() && !iSurfaceGeo.hasInnerTrim()) {
            return new IRhino3dm.NurbsSurface(iSurfaceGeo);
        }
        return new IRhino3dm.Brep(iSurfaceGeo);
    }

    public static IRhino3dm.Brep getRhinoBrep(IBrep iBrep) {
        return new IRhino3dm.Brep(iBrep);
    }

    public static IRhino3dm.Mesh getRhinoMesh(IMeshI iMeshI) {
        return new IRhino3dm.Mesh(iMeshI);
    }

    public static IRhino3dm.TextEntity2 getRhinoText(IText iText) {
        return new IRhino3dm.TextEntity2(iText);
    }

    public IRhino3dm.Chunk getObjectChunk(IObject iObject) throws IOException {
        IRhino3dm.RhinoObject rhinoObject = IRhino3dmExporter.getRhinoObject(iObject, this.file);
        if (rhinoObject == null) {
            return null;
        }
        IRhino3dm.ChunkTable chunkTable = new IRhino3dm.ChunkTable(536903792, -2113929089);
        chunkTable.add(new IRhino3dm.Chunk(-2113929103, rhinoObject.getType()));
        IRhino3dm.Chunk chunk = this.getObjectChunk(rhinoObject);
        if (chunk == null) {
            return null;
        }
        chunkTable.add(chunk);
        if (rhinoObject.attributes != null) {
            ChunkOutputStream chunkOutputStream = new ChunkOutputStream(33587314);
            rhinoObject.attributes.write(this.file, chunkOutputStream, chunkOutputStream.getCRC());
            IRhino3dm.Chunk chunk2 = chunkOutputStream.getChunk();
            if (chunk2 != null) {
                chunkTable.add(chunk2);
            }
        }
        chunkTable.serialize();
        return chunkTable;
    }

    public void writeHistoryRecordTable() throws IOException {
        this.writeChunkTable(268435494);
    }

    public void writeUserDataTable() throws IOException {
        this.writeChunkTable(0x10000017);
    }

    public void writeEndMark() throws IOException {
        ChunkOutputStream chunkOutputStream = new ChunkOutputStream(Short.MAX_VALUE);
        if (this.file.sizeOfChunkLength() == 4) {
            int n = this.currentPos + 12;
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
        } else {
            int n = this.currentPos + 24;
            IRhino3dmExporter.writeInt64(chunkOutputStream, n, chunkOutputStream.getCRC());
        }
        this.writeChunk(chunkOutputStream.getChunk());
    }

    public IRhino3dm.Chunk getObjectChunk(IRhino3dm.RhinoObject rhinoObject) throws IOException {
        IRhino3dm.UUID uUID = rhinoObject.getClassUUID();
        IRhino3dm.ChunkTable chunkTable = new IRhino3dm.ChunkTable(163834);
        ChunkOutputStream chunkOutputStream = new ChunkOutputStream(196603);
        uUID.write(chunkOutputStream, chunkOutputStream.getCRC());
        chunkTable.add(chunkOutputStream.getChunk());
        ChunkOutputStream chunkOutputStream2 = new ChunkOutputStream(196604);
        rhinoObject.write(this.file, chunkOutputStream2, chunkOutputStream2.getCRC());
        IRhino3dm.Chunk chunk = chunkOutputStream2.getChunk();
        if (chunk.content == null || chunk.content.length == 0) {
            return null;
        }
        chunkTable.add(chunk);
        IRhino3dm.Chunk chunk2 = new IRhino3dm.Chunk(-2147319809, 0);
        chunkTable.add(chunk2);
        chunkTable.serialize();
        return chunkTable;
    }

    public static IRhino3dm.Chunk getObjectChunk(IRhino3dm.Rhino3dmFile rhino3dmFile, IRhino3dm.RhinoObject rhinoObject) throws IOException {
        IRhino3dm.UUID uUID = rhinoObject.getClassUUID();
        IRhino3dm.ChunkTable chunkTable = new IRhino3dm.ChunkTable(163834);
        ChunkOutputStream chunkOutputStream = new ChunkOutputStream(196603);
        uUID.write(chunkOutputStream, chunkOutputStream.getCRC());
        chunkTable.add(chunkOutputStream.getChunk());
        ChunkOutputStream chunkOutputStream2 = new ChunkOutputStream(196604);
        rhinoObject.write(rhino3dmFile, chunkOutputStream2, chunkOutputStream2.getCRC());
        IRhino3dm.Chunk chunk = chunkOutputStream2.getChunk();
        if (chunk.content == null || chunk.content.length == 0) {
            return null;
        }
        chunkTable.add(chunk);
        IRhino3dm.Chunk chunk2 = new IRhino3dm.Chunk(-2147319809, 0);
        chunkTable.add(chunk2);
        chunkTable.serialize();
        return chunkTable;
    }

    public IRhino3dm.Chunk nestChunk(int n, IRhino3dm.Chunk chunk) throws IOException {
        ChunkOutputStream chunkOutputStream = new ChunkOutputStream(n);
        IRhino3dmExporter.writeChunk(chunkOutputStream, chunk);
        return chunkOutputStream.getChunk();
    }

    public void write(byte[] byArray, CRC32 cRC32) throws IOException {
        this.ostream.write(byArray);
        this.currentPos += byArray.length;
        if (cRC32 != null) {
            cRC32.update(byArray);
        }
    }

    public void write(byte[] byArray, int n, CRC32 cRC32) throws IOException {
        this.ostream.write(byArray, 0, n);
        this.currentPos += n;
        if (cRC32 != null) {
            cRC32.update(byArray, 0, n);
        }
    }

    public void writeBytes(byte[] byArray, CRC32 cRC32) throws IOException {
        this.write(byArray, cRC32);
    }

    public void writeByte(byte by, CRC32 cRC32) throws IOException {
        this.ostream.write(by);
        ++this.currentPos;
        if (cRC32 != null) {
            cRC32.update(by);
        }
    }

    public void writeChar(char c, CRC32 cRC32) throws IOException {
        this.ostream.write(c);
        ++this.currentPos;
        if (cRC32 != null) {
            cRC32.update(c);
        }
    }

    public void writeInt32(int n, CRC32 cRC32) throws IOException {
        this.write(IRhino3dmExporter.itob(n), cRC32);
    }

    public void writeInt16(short s, CRC32 cRC32) throws IOException {
        this.write(IRhino3dmExporter.stob(s), cRC32);
    }

    public void writeInt64(long l, CRC32 cRC32) throws IOException {
        this.write(IRhino3dmExporter.ltob(l), cRC32);
    }

    public void writeShort(short s, CRC32 cRC32) throws IOException {
        this.writeInt16(s, cRC32);
    }

    public void writeLong(long l, CRC32 cRC32) throws IOException {
        this.writeInt64(l, cRC32);
    }

    public static void write(OutputStream outputStream, byte[] byArray, CRC32 cRC32) throws IOException {
        outputStream.write(byArray);
        if (cRC32 != null) {
            cRC32.update(byArray);
        }
    }

    public static void write(OutputStream outputStream, byte[] byArray, int n, CRC32 cRC32) throws IOException {
        outputStream.write(byArray, 0, n);
        if (cRC32 != null) {
            cRC32.update(byArray);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.write(outputStream, byArray, cRC32);
    }

    public static void writeByte(OutputStream outputStream, byte by, CRC32 cRC32) throws IOException {
        outputStream.write(by);
        if (cRC32 != null) {
            cRC32.update(by);
        }
    }

    public static void writeChar(OutputStream outputStream, char c, CRC32 cRC32) throws IOException {
        outputStream.write(c);
        if (cRC32 != null) {
            cRC32.update(c);
        }
    }

    public static void writeInt32(OutputStream outputStream, int n, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.write(outputStream, IRhino3dmExporter.itob(n), cRC32);
    }

    public static void writeInt16(OutputStream outputStream, short s, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.write(outputStream, IRhino3dmExporter.stob(s), cRC32);
    }

    public static void writeInt64(OutputStream outputStream, long l, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.write(outputStream, IRhino3dmExporter.ltob(l), cRC32);
    }

    public static void writeShort(OutputStream outputStream, short s, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeInt16(outputStream, s, cRC32);
    }

    public static void writeInt(OutputStream outputStream, int n, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.write(outputStream, IRhino3dmExporter.itob(n), cRC32);
    }

    public static void writeLong(OutputStream outputStream, long l, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeInt64(outputStream, l, cRC32);
    }

    public static void writeBool(OutputStream outputStream, boolean bl, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeByte(outputStream, (byte)(bl ? 1 : 0), cRC32);
    }

    public static void writeDouble(OutputStream outputStream, double d, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeInt64(outputStream, Double.doubleToLongBits(d), cRC32);
    }

    public static void writeFloat(OutputStream outputStream, float f, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeInt32(outputStream, Float.floatToIntBits(f), cRC32);
    }

    public static void writePoint(OutputStream outputStream, IVecI iVecI, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeDouble(outputStream, iVecI.x(), cRC32);
        IRhino3dmExporter.writeDouble(outputStream, iVecI.y(), cRC32);
        IRhino3dmExporter.writeDouble(outputStream, iVecI.z(), cRC32);
    }

    public static void writePoint3f(OutputStream outputStream, IVecI iVecI, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeFloat(outputStream, (float)iVecI.x(), cRC32);
        IRhino3dmExporter.writeFloat(outputStream, (float)iVecI.y(), cRC32);
        IRhino3dmExporter.writeFloat(outputStream, (float)iVecI.z(), cRC32);
    }

    public static void writePoint2(OutputStream outputStream, IVec2I iVec2I, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeDouble(outputStream, iVec2I.x(), cRC32);
        IRhino3dmExporter.writeDouble(outputStream, iVec2I.y(), cRC32);
    }

    public static void writePoint2f(OutputStream outputStream, IVec2I iVec2I, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeFloat(outputStream, (float)iVec2I.x(), cRC32);
        IRhino3dmExporter.writeFloat(outputStream, (float)iVec2I.y(), cRC32);
    }

    public static void writeVector(OutputStream outputStream, IVecI iVecI, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writePoint(outputStream, iVecI, cRC32);
    }

    public static void writeVector(OutputStream outputStream, IVec2I iVec2I, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writePoint2(outputStream, iVec2I, cRC32);
    }

    public static void writePlane(OutputStream outputStream, IRhino3dm.Plane plane, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writePoint(outputStream, plane.origin, cRC32);
        IRhino3dmExporter.writeVector(outputStream, plane.xaxis, cRC32);
        IRhino3dmExporter.writeVector(outputStream, plane.yaxis, cRC32);
        IRhino3dmExporter.writeVector(outputStream, plane.zaxis, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, plane.planeEquation.x, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, plane.planeEquation.y, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, plane.planeEquation.z, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, plane.planeEquation.d, cRC32);
    }

    public static void writeInterval(OutputStream outputStream, IRhino3dm.Interval interval, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeDouble(outputStream, interval.v1, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, interval.v2, cRC32);
    }

    public static void writeString(OutputStream outputStream, String string, CRC32 cRC32) throws IOException {
        if (string == null) {
            string = "";
        }
        int n = string.length() + 1;
        byte[] byArray = string.getBytes("UTF-16LE");
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        IRhino3dmExporter.writeBytes(outputStream, byArray, cRC32);
        IRhino3dmExporter.writeByte(outputStream, (byte)0, cRC32);
        IRhino3dmExporter.writeByte(outputStream, (byte)0, cRC32);
    }

    public static void writeColor(OutputStream outputStream, IColor iColor, CRC32 cRC32) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (iColor != null) {
            n = iColor.getRed();
            n2 = iColor.getGreen();
            n3 = iColor.getBlue();
            n4 = 255 - iColor.getAlpha();
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
        }
        IRhino3dmExporter.writeByte(outputStream, (byte)(n & 0xFF), cRC32);
        IRhino3dmExporter.writeByte(outputStream, (byte)(n2 & 0xFF), cRC32);
        IRhino3dmExporter.writeByte(outputStream, (byte)(n3 & 0xFF), cRC32);
        IRhino3dmExporter.writeByte(outputStream, (byte)(n4 & 0xFF), cRC32);
    }

    public static void writeBoundingBox(OutputStream outputStream, IRhino3dm.BoundingBox boundingBox, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeDouble(outputStream, boundingBox.min.x, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, boundingBox.min.y, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, boundingBox.min.z, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, boundingBox.max.x, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, boundingBox.max.y, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, boundingBox.max.z, cRC32);
    }

    public static void writeSurfaceCurvature(OutputStream outputStream, IRhino3dm.SurfaceCurvature surfaceCurvature, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeDouble(outputStream, surfaceCurvature.k1, cRC32);
        IRhino3dmExporter.writeDouble(outputStream, surfaceCurvature.k2, cRC32);
    }

    public static void writeArray(OutputStream outputStream, ArrayList<? extends IRhino3dm.RhinoObject> arrayList, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeArray(null, outputStream, arrayList, cRC32);
    }

    public static void writeArray(IRhino3dm.Rhino3dmFile rhino3dmFile, OutputStream outputStream, ArrayList<? extends IRhino3dm.RhinoObject> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            arrayList.get(i).write(rhino3dmFile, outputStream, cRC32);
        }
    }

    public static void writeArrayInt(OutputStream outputStream, ArrayList<Integer> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writeInt32(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static void writeArrayPoint(OutputStream outputStream, ArrayList<IVec> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writePoint(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static void writeArrayPoint3f(OutputStream outputStream, ArrayList<IVec> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writePoint3f(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static byte[] writeArrayPoint3f(ArrayList<IVec> arrayList, CRC32 cRC32) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            IRhino3dmExporter.writePoint3f(byteArrayOutputStream, arrayList.get(i), cRC32);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeArrayPoint2(OutputStream outputStream, ArrayList<IVec2> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writePoint2(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static void writeArrayPoint2f(OutputStream outputStream, ArrayList<IVec2> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writePoint2f(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static byte[] writeArrayPoint2f(ArrayList<IVec2> arrayList, CRC32 cRC32) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            IRhino3dmExporter.writePoint2f(byteArrayOutputStream, arrayList.get(i), cRC32);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeArrayColor(OutputStream outputStream, ArrayList<IColor> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writeColor(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static byte[] writeArrayColor(ArrayList<IColor> arrayList, CRC32 cRC32) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            IRhino3dmExporter.writeColor(byteArrayOutputStream, arrayList.get(i), cRC32);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeArraySurfaceCurvature(OutputStream outputStream, ArrayList<IRhino3dm.SurfaceCurvature> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writeSurfaceCurvature(outputStream, arrayList.get(i), cRC32);
        }
    }

    public static byte[] writeArraySurfaceCurvature(ArrayList<IRhino3dm.SurfaceCurvature> arrayList, CRC32 cRC32) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            IRhino3dmExporter.writeSurfaceCurvature(byteArrayOutputStream, arrayList.get(i), cRC32);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeArrayDisplayMaterialRef(IRhino3dm.Rhino3dmFile rhino3dmFile, OutputStream outputStream, ArrayList<IRhino3dm.DisplayMaterialRef> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            arrayList.get(i).write(rhino3dmFile, outputStream, cRC32);
        }
    }

    public static void writeArrayUUIDIndex(IRhino3dm.Rhino3dmFile rhino3dmFile, OutputStream outputStream, ArrayList<IRhino3dm.UUIDIndex> arrayList, CRC32 cRC32) throws IOException {
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
        for (int i = 0; arrayList != null && i < n; ++i) {
            IRhino3dmExporter.writeUUID(outputStream, arrayList.get((int)i).id, cRC32);
            IRhino3dmExporter.writeInt(outputStream, arrayList.get((int)i).i, cRC32);
        }
    }

    public static void writeUUID(OutputStream outputStream, IRhino3dm.UUID uUID, CRC32 cRC32) throws IOException {
        if (uUID != null) {
            uUID.write(outputStream, cRC32);
        } else {
            IRhino3dm.UUID.nilValue.write(outputStream, cRC32);
        }
    }

    public static void writeChunkVersion(OutputStream outputStream, int n, int n2, CRC32 cRC32) throws IOException {
        byte by = (byte)(n << 4 & 0xF0 | n2 & 0xF);
        IRhino3dmExporter.writeByte(outputStream, by, cRC32);
    }

    public void writeChunk(IRhino3dm.Chunk chunk) throws IOException {
        if (chunk == null) {
            throw new IOException("chunk is null");
        }
        if (!chunk.isShort()) {
            if (chunk.getContent() == null) {
                throw new IOException("chunk is big chunk and chunk content is null : chunk = " + chunk.toString());
            }
            if (chunk.contentLength() != chunk.getBody()) {
                throw new IOException("chunk content length doesn't match : chunk = " + chunk.toString());
            }
        }
        this.writeInt32(chunk.header, null);
        if (!chunk.isShort() && chunk.doCRC()) {
            this.writeInt32(chunk.body + 4, null);
        } else {
            this.writeInt32(chunk.body, null);
        }
        if (!chunk.isShort()) {
            this.writeBytes(chunk.content, null);
            if (chunk.doCRC()) {
                this.writeInt32(chunk.getCRC(), null);
            }
        }
    }

    public static void writeChunk(OutputStream outputStream, IRhino3dm.Chunk chunk) throws IOException {
        if (chunk == null) {
            throw new IOException("chunk is null");
        }
        if (!chunk.isShort()) {
            if (chunk.getContent() == null) {
                throw new IOException("chunk is big chunk and chunk content is null : chunk = " + chunk.toString());
            }
            if (chunk.contentLength() != chunk.getBody()) {
                throw new IOException("chunk content length doesn't match : chunk = " + chunk.toString());
            }
        }
        IRhino3dmExporter.writeInt32(outputStream, chunk.header, null);
        if (!chunk.isShort() && chunk.doCRC()) {
            IRhino3dmExporter.writeInt32(outputStream, chunk.body + 4, null);
        } else {
            IRhino3dmExporter.writeInt32(outputStream, chunk.body, null);
        }
        if (!chunk.isShort()) {
            IRhino3dmExporter.writeBytes(outputStream, chunk.content, null);
            if (chunk.doCRC()) {
                IRhino3dmExporter.writeInt32(outputStream, chunk.getCRC(), null);
            }
        }
    }

    public void writeChunkTable(int n) throws IOException {
        this.writeChunkTable(n, null);
    }

    public void writeChunkTable(int n, IRhino3dm.Chunk[] chunkArray) throws IOException {
        this.writeChunkTable(n, chunkArray, -1);
    }

    public void writeChunkTable(int n, IRhino3dm.Chunk[] chunkArray, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; chunkArray != null && i < chunkArray.length; ++i) {
            IRhino3dmExporter.writeChunk(byteArrayOutputStream, chunkArray[i]);
        }
        IRhino3dmExporter.writeChunk(byteArrayOutputStream, new IRhino3dm.Chunk(n2, 0));
        this.writeChunk(new IRhino3dm.Chunk(n, byteArrayOutputStream.toByteArray()));
    }

    public void writeChunkTable(IRhino3dm.ChunkTable chunkTable) throws IOException {
        chunkTable.serialize();
        this.writeChunk(chunkTable);
    }

    public static void writeChunkTable(OutputStream outputStream, IRhino3dm.ChunkTable chunkTable) throws IOException {
        chunkTable.serialize();
        IRhino3dmExporter.writeChunk(outputStream, chunkTable);
    }

    public static void writeCompressedBuffer(OutputStream outputStream, byte[] byArray, int n, CRC32 cRC32) throws IOException {
        IRhino3dmExporter.writeInt(outputStream, n, cRC32);
        CRC32 cRC322 = new CRC32();
        cRC322.update(byArray);
        IRhino3dmExporter.writeInt(outputStream, (int)cRC322.getValue(), cRC32);
        byte by = n > 128 ? (byte)1 : 0;
        IRhino3dmExporter.writeByte(outputStream, by, cRC32);
        if (by == 0) {
            IRhino3dmExporter.write(outputStream, byArray, n, cRC32);
        } else {
            IRhino3dmExporter.writeDeflate(outputStream, byArray, n, cRC32);
        }
    }

    public static void writeDeflate(OutputStream outputStream, byte[] byArray, int n, CRC32 cRC32) throws IOException {
        Deflater deflater = new Deflater(9);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(byArray, 0, n);
        deflaterOutputStream.close();
        byteArrayOutputStream.close();
        ChunkOutputStream chunkOutputStream = new ChunkOutputStream(0x40008000);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        IRhino3dmExporter.write(chunkOutputStream, byArray2, byArray2.length, chunkOutputStream.getCRC());
        IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
    }

    public static class ChunkOutputStream
    extends ByteArrayOutputStream {
        public int header;
        public CRC32 crc;

        public ChunkOutputStream(int n) {
            this.header = n;
            this.crc = new CRC32();
        }

        public ChunkOutputStream(int n, int n2, int n3) throws IOException {
            this.header = n;
            this.crc = new CRC32();
            IRhino3dmExporter.writeInt32(this, n2, this.crc);
            IRhino3dmExporter.writeInt32(this, n3, this.crc);
        }

        public CRC32 getCRC() {
            return this.crc;
        }

        public IRhino3dm.Chunk getChunk() {
            byte[] byArray = super.toByteArray();
            return new IRhino3dm.Chunk(this.header, byArray, this.crc);
        }
    }
}

