/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticleDirectionLink
extends IDynamicsBase {
    public ArrayList<IParticleGeo> particles;
    public IVecI center;
    public IVec vel;

    public IParticleDirectionLink(ArrayList<IParticleGeo> arrayList, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particles = arrayList;
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IParticleGeo[] iParticleGeoArray, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particles = new ArrayList();
        for (int i = 0; i < iParticleGeoArray.length; ++i) {
            this.particles.add(iParticleGeoArray[i]);
        }
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particles = new ArrayList();
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(ArrayList<IParticleGeo> arrayList, IVecI iVecI) {
        this.particles = arrayList;
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IParticleGeo[] iParticleGeoArray, IVecI iVecI) {
        this.particles = new ArrayList();
        for (int i = 0; i < iParticleGeoArray.length; ++i) {
            this.particles.add(iParticleGeoArray[i]);
        }
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IVecI iVecI) {
        this.particles = new ArrayList();
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public void initParticleDirectionLink() {
        for (int i = 0; i < this.particles.size(); ++i) {
            this.particles.get(i).fix();
        }
    }

    public void add(IParticleGeo iParticleGeo) {
        iParticleGeo.fix();
        this.particles.add(iParticleGeo);
    }

    @Override
    public synchronized void update() {
        IParticleGeo iParticleGeo;
        int n;
        IVec iVec = new IVec();
        double d = 0.0;
        double[] dArray = new double[this.particles.size()];
        IVec[] iVecArray = new IVec[this.particles.size()];
        IVec iVec2 = new IVec();
        for (int i = 0; i < this.particles.size(); ++i) {
            IParticleGeo iParticleGeo2 = this.particles.get(i);
            iVecArray[i] = iParticleGeo2.pos.diff(this.center);
            iVec.add(iVecArray[i].cross(iParticleGeo2.frc));
            dArray[i] = iVecArray[i].len2();
            d += iParticleGeo2.mass * dArray[i];
            if (!(dArray[i] > IConfig.tolerance)) continue;
            iVec2.add(iVecArray[i].cross(iParticleGeo2.vel).div(dArray[i]));
        }
        iVec2.div(this.particles.size());
        iVec2.add(iVec.mul(IConfig.updateRate / d));
        IVec iVec3 = new IVec();
        for (n = 0; n < this.particles.size(); ++n) {
            iParticleGeo = this.particles.get(n);
            iParticleGeo.frc.projectToVec(iVecArray[n]);
            iParticleGeo.frc.mul(IConfig.updateRate / iParticleGeo.mass);
            iParticleGeo.vel.projectToVec(iVecArray[n]);
            iParticleGeo.vel.add(iParticleGeo.frc);
            iParticleGeo.vel.add(iVec2.cross(iVecArray[n]));
            iParticleGeo.vel.mul(1.0 - iParticleGeo.friction);
            iParticleGeo.pos.add(iParticleGeo.vel.dup().mul(IConfig.updateRate));
            iVecArray[n] = iParticleGeo.pos.diff(this.center);
            if (iVec3.len() < IConfig.tolerance) {
                if (!(iVecArray[n].len() > IConfig.tolerance)) continue;
                iVec3.add(iVecArray[n]);
                continue;
            }
            if (iVec3.dot(iVecArray[n]) < 0.0) {
                iVec3.add(iVecArray[n], -1.0);
                continue;
            }
            iVec3.add(iVecArray[n]);
        }
        if (iVec3.len() < IConfig.tolerance) {
            iVec3.set(0.0, 0.0, 1.0);
        }
        for (n = 0; n < this.particles.size(); ++n) {
            iParticleGeo = this.particles.get(n);
            iParticleGeo.pos.projectToLine(this.center, iVec3);
            iParticleGeo.updateTarget();
            iParticleGeo.frc.zero();
        }
    }
}

