/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IField;
import igeo.IParticleI;
import igeo.IVecI;

public abstract class I3DField
extends IField
implements I3DFieldI {
    public I3DFieldI field;

    public I3DField(I3DFieldI i3DFieldI) {
        this.field = i3DFieldI;
    }

    public IVecI get(IVecI iVecI) {
        if (this.field == null) {
            return null;
        }
        return this.field.get(iVecI);
    }

    public void applyField(IParticleI iParticleI) {
        iParticleI.push(this.get(iParticleI.pos()));
    }

    public I3DFieldI field() {
        return this.field;
    }

    public I3DField noDecay() {
        if (this.field != null) {
            this.field.noDecay();
        }
        return this;
    }

    public I3DField linearDecay(double d) {
        if (this.field != null) {
            this.field.linearDecay(d);
        }
        return this;
    }

    public I3DField linear(double d) {
        return this.linearDecay(d);
    }

    public I3DField gaussianDecay(double d) {
        if (this.field != null) {
            this.field.gaussianDecay(d);
        }
        return this;
    }

    public I3DField gaussian(double d) {
        return this.gaussianDecay(d);
    }

    public I3DField constantIntensity(boolean bl) {
        if (this.field != null) {
            this.field.constantIntensity(bl);
        }
        return this;
    }

    public I3DField threshold(double d) {
        if (this.field != null) {
            this.field.threshold(d);
        }
        return this;
    }

    public double threshold() {
        if (this.field == null) {
            return 0.0;
        }
        return this.field.threshold();
    }

    public I3DField intensity(double d) {
        if (this.field != null) {
            this.field.intensity(d);
        }
        return this;
    }

    public double intensity() {
        if (this.field == null) {
            return 0.0;
        }
        return this.field.intensity();
    }

    public void del() {
        if (this.field != null) {
            this.field.del();
        }
        super.del();
    }

    public void del(boolean bl) {
        if (bl && this.field != null) {
            this.field.del();
        }
        super.del(bl);
    }
}

