/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBrep;
import igeo.IColor;
import igeo.ICurve;
import igeo.IDynamicsBase;
import igeo.IGeometry;
import igeo.IMesh;
import igeo.IOut;
import igeo.IParticleI;
import igeo.IPoint;
import igeo.IPointAgent;
import igeo.ISurface;
import igeo.IVec;
import igeo.IVecI;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IAgentTracker
extends IDynamicsBase {
    public static boolean setAgentAttributes = true;
    public static IVec defaultOrientation = new IVec(0.0, 1.0, 0.0);
    public IGeometry[] geometries;
    public IPointAgent agent;
    public IParticleI particle;
    public IVec prevPos;
    public IVec prevVel;
    public IVec rotAxis;
    public double rotAngle = 0.0;
    public boolean orient = true;

    public IAgentTracker(IPointAgent iPointAgent, IGeometry ... iGeometryArray) {
        this.geometries = iGeometryArray;
        this.initTracker(iPointAgent);
    }

    public IAgentTracker(IPointAgent iPointAgent, IVecI iVecI, IGeometry[] iGeometryArray) {
        this.geometries = iGeometryArray;
        this.initTracker(iVecI, iPointAgent);
    }

    public IAgentTracker(IPointAgent iPointAgent, IVecI iVecI, IVecI iVecI2, IGeometry[] iGeometryArray) {
        this.geometries = iGeometryArray;
        this.initTracker(iVecI, iVecI2, iPointAgent);
    }

    public int geometryNum() {
        return this.geometries.length;
    }

    public IGeometry geometry() {
        if (this.geometries.length == 0) {
            return null;
        }
        return this.geometries[0];
    }

    public IGeometry geometry(int n) {
        return this.geometries[n];
    }

    public IGeometry[] geometries() {
        return this.geometries;
    }

    public <T extends IGeometry> T[] subgeometries(Class<T> clazz) {
        IGeometry[] iGeometryArray = (IGeometry[])Array.newInstance(clazz, this.subgeometryNum(clazz));
        int n = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!clazz.isInstance(this.geometries[i])) continue;
            iGeometryArray[n++] = this.geometries[i];
        }
        return iGeometryArray;
    }

    public <T extends IGeometry> T subgeometry(Class<T> clazz) {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!clazz.isInstance(this.geometries[i])) continue;
            return (T)this.geometries[i];
        }
        return null;
    }

    public <T extends IGeometry> T subgeometry(Class<T> clazz, int n) {
        int n2 = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!clazz.isInstance(this.geometries[i])) continue;
            if (n2 == n) {
                return (T)this.geometries[i];
            }
            ++n2;
        }
        return null;
    }

    public int subgeometryNum(Class<? extends IGeometry> clazz) {
        int n = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!clazz.isInstance(this.geometries[i])) continue;
            ++n;
        }
        return n;
    }

    public IPoint[] points() {
        return (IPoint[])this.subgeometries(IPoint.class);
    }

    public IPoint point() {
        return this.subgeometry(IPoint.class);
    }

    public IPoint point(int n) {
        return this.subgeometry(IPoint.class, n);
    }

    public int pointNum() {
        return this.subgeometryNum(IPoint.class);
    }

    public ICurve[] curves() {
        return (ICurve[])this.subgeometries(ICurve.class);
    }

    public ICurve curve() {
        return this.subgeometry(ICurve.class);
    }

    public ICurve curve(int n) {
        return this.subgeometry(ICurve.class, n);
    }

    public int curveNum() {
        return this.subgeometryNum(ICurve.class);
    }

    public ISurface[] surfaces() {
        return (ISurface[])this.subgeometries(ISurface.class);
    }

    public ISurface surface() {
        return this.subgeometry(ISurface.class);
    }

    public ISurface surface(int n) {
        return this.subgeometry(ISurface.class, n);
    }

    public int surfaceNum() {
        return this.subgeometryNum(ISurface.class);
    }

    public IBrep[] breps() {
        return (IBrep[])this.subgeometries(IBrep.class);
    }

    public IBrep brep() {
        return this.subgeometry(IBrep.class);
    }

    public IBrep brep(int n) {
        return this.subgeometry(IBrep.class, n);
    }

    public int brepNum() {
        return this.subgeometryNum(IBrep.class);
    }

    public IMesh[] meshes() {
        return (IMesh[])this.subgeometries(IMesh.class);
    }

    public IMesh mesh() {
        return this.subgeometry(IMesh.class);
    }

    public IMesh mesh(int n) {
        return this.subgeometry(IMesh.class, n);
    }

    public int meshNum() {
        return this.subgeometryNum(IMesh.class);
    }

    public IAgentTracker show() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].show();
        }
        return this;
    }

    public IAgentTracker hide() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].hide();
        }
        return this;
    }

    public void del() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].del();
        }
        this.geometries = new IGeometry[0];
        this.parent.deleteDynamics(this);
    }

    public IAgentTracker orient(boolean bl) {
        if (this.particle != null) {
            this.orient = bl;
        } else {
            IOut.err("parent is not particle. orient is changed.");
        }
        return this;
    }

    public IAgentTracker clr(IColor iColor) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(iColor);
        }
        return this;
    }

    public IAgentTracker clr(IColor iColor, int n) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(iColor, n);
        }
        return this;
    }

    public IAgentTracker clr(IColor iColor, float f) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(iColor, f);
        }
        return this;
    }

    public IAgentTracker clr(IColor iColor, double d) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(iColor, d);
        }
        return this;
    }

    public IAgentTracker clr(int n) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(n);
        }
        return this;
    }

    public IAgentTracker clr(float f) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(f);
        }
        return this;
    }

    public IAgentTracker clr(double d) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(d);
        }
        return this;
    }

    public IAgentTracker clr(int n, int n2) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(n, n2);
        }
        return this;
    }

    public IAgentTracker clr(float f, float f2) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(f, f2);
        }
        return this;
    }

    public IAgentTracker clr(double d, double d2) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(d, d2);
        }
        return this;
    }

    public IAgentTracker clr(int n, int n2, int n3) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(n, n2, n3);
        }
        return this;
    }

    public IAgentTracker clr(float f, float f2, float f3) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(f, f2, f3);
        }
        return this;
    }

    public IAgentTracker clr(double d, double d2, double d3) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(d, d2, d3);
        }
        return this;
    }

    public IAgentTracker clr(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(n, n2, n3, n4);
        }
        return this;
    }

    public IAgentTracker clr(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(f, f2, f3, f4);
        }
        return this;
    }

    public IAgentTracker clr(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].clr(d, d2, d3, d4);
        }
        return this;
    }

    public IAgentTracker hsb(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].hsb(f, f2, f3, f4);
        }
        return this;
    }

    public IAgentTracker hsb(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].hsb(d, d2, d3, d4);
        }
        return this;
    }

    public IAgentTracker hsb(float f, float f2, float f3) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].hsb(f, f2, f3);
        }
        return this;
    }

    public IAgentTracker hsb(double d, double d2, double d3) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].hsb(d, d2, d3);
        }
        return this;
    }

    public void initTracker(IPointAgent iPointAgent) {
        IVec iVec = new IVec();
        for (int i = 0; i < this.geometries.length; ++i) {
            iVec.add(this.geometries[i].center());
        }
        iVec.div(this.geometries.length);
        this.initTracker(iVec, iPointAgent);
    }

    public void initTracker(IVecI iVecI, IPointAgent iPointAgent) {
        this.initTracker(iVecI, defaultOrientation, iPointAgent);
    }

    public void initTracker(IVecI iVecI, IVecI iVecI2, IPointAgent iPointAgent) {
        int n;
        this.agent = iPointAgent;
        this.agent.addDynamics(this);
        if (this.agent instanceof IParticleI) {
            this.particle = (IParticleI)((Object)this.agent);
        } else {
            this.orient = false;
        }
        if (iVecI2 == null) {
            this.orient = false;
        }
        if (setAgentAttributes) {
            int n2;
            if (this.agent.attr() != null) {
                for (n2 = 0; n2 < this.geometries.length; ++n2) {
                    if (this.geometries[n2].attr() != null) {
                        this.geometries[n2].attr().merge(this.agent.attr());
                        continue;
                    }
                    this.geometries[n2].attr(this.agent.attr());
                }
            } else if (this.agent.clr() != null && this.agent.clr() != null) {
                for (n2 = 0; n2 < this.geometries.length; ++n2) {
                    this.geometries[n2].clr(this.agent.clr());
                }
            }
        }
        IVec iVec = this.agent.pos().dif(iVecI);
        boolean bl = false;
        if (iVec.len() > 0.0) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].add(iVec);
            }
            bl = true;
        }
        this.prevPos = this.agent.pos().dup();
        if (this.particle != null && iVecI2 != null) {
            this.prevVel = this.particle.vel().dup();
            if (this.prevVel.len() == 0.0) {
                this.prevVel = iVecI2.get();
            } else if (iVecI2.len() > 0.0) {
                this.rotAngle = iVecI2.angle(this.prevVel);
                this.rotAxis = iVecI2.get().cross(this.prevVel);
                if (this.rotAngle != 0.0) {
                    for (n = 0; n < this.geometries.length; ++n) {
                        this.geometries[n].rot((IVecI)this.agent.pos(), (IVecI)this.rotAxis, this.rotAngle);
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].updateGraphic();
            }
        }
    }

    @Override
    public void update() {
        int n;
        this.prevPos.sub(this.agent.pos()).neg();
        if (this.orient && this.particle != null) {
            if (this.particle.vel().len() == 0.0) {
                this.rotAngle = 0.0;
            } else {
                this.rotAngle = this.prevVel.angle(this.particle.vel());
                this.rotAxis = this.prevVel.cross(this.particle.vel());
                this.prevVel = this.particle.vel().dup();
                if (this.rotAxis.len() == 0.0) {
                    this.rotAngle = 0.0;
                }
            }
        }
        boolean bl = false;
        if (this.prevPos.len() > 0.0) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].add(this.prevPos);
            }
            bl = true;
        }
        if (this.orient && this.rotAngle != 0.0) {
            for (n = 0; n < this.geometries.length; ++n) {
                if (!this.orient || this.rotAngle == 0.0) continue;
                this.geometries[n].rot((IVecI)this.agent.pos(), (IVecI)this.rotAxis, this.rotAngle);
            }
            bl = true;
        }
        if (bl) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].updateGraphic();
            }
        }
        this.prevPos.set(this.agent.pos());
    }
}

