/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IDelaunay2D;
import igeo.IOut;
import igeo.IVec2;
import igeo.gui.ISubsurfaceMesh;
import java.util.ArrayList;

public class ISurfaceMesh {
    public static IVec2[][] getTriangles(IVec2[][] iVec2Array, IVec2[][] iVec2Array2, IVec2[][] iVec2Array3) {
        int n;
        int n2;
        double[] dArray = new double[iVec2Array.length];
        double[] dArray2 = new double[iVec2Array[0].length];
        for (n2 = 0; n2 < iVec2Array.length; ++n2) {
            dArray[n2] = iVec2Array[n2][0].x;
            IOut.debug(20, "upos[" + n2 + "]=" + dArray[n2]);
        }
        for (n2 = 0; n2 < iVec2Array[0].length; ++n2) {
            dArray2[n2] = iVec2Array[0][n2].y;
            IOut.debug(20, "vpos[" + n2 + "]=" + dArray2[n2]);
        }
        ISubsurfaceMesh.SubsurfaceMatrix subsurfaceMatrix = new ISubsurfaceMesh.SubsurfaceMatrix(dArray, dArray2);
        for (n = 0; iVec2Array2 != null && n < iVec2Array2.length; ++n) {
            subsurfaceMatrix.setLoop(iVec2Array2[n], true);
        }
        for (n = 0; iVec2Array3 != null && n < iVec2Array3.length; ++n) {
            subsurfaceMatrix.setLoop(iVec2Array3[n], false);
        }
        return subsurfaceMatrix.getTriangles();
    }

    public static IVec2[][] getTriangles(IVec2[] iVec2Array, IVec2[][] iVec2Array2, IVec2[][] iVec2Array3) {
        int n;
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
        ArrayList<IVec2[]> arrayList2 = new ArrayList<IVec2[]>();
        for (n = 0; iVec2Array2 != null && n < iVec2Array2.length; ++n) {
            arrayList2.add(iVec2Array2[n]);
        }
        for (n = 0; iVec2Array3 != null && n < iVec2Array3.length; ++n) {
            arrayList2.add(iVec2Array3[n]);
        }
        if (iVec2Array != null) {
            for (n = 0; n < iVec2Array.length; ++n) {
                arrayList.add(iVec2Array[n]);
            }
        }
        IVec2[][] iVec2Array4 = IDelaunay2D.getTriangles(arrayList.toArray(new IVec2[arrayList.size()]), (IVec2[][])arrayList2.toArray((T[])new IVec2[arrayList2.size()][]));
        return iVec2Array4;
    }

    public static IVec2[] insertPoint(IVec2[] iVec2Array, int n, IVec2 iVec2) {
        IVec2[] iVec2Array2 = new IVec2[iVec2Array.length + 1];
        if (n > 0) {
            System.arraycopy(iVec2Array, 0, iVec2Array2, 0, n);
        }
        iVec2Array2[n] = iVec2;
        if (n < iVec2Array.length) {
            System.arraycopy(iVec2Array, n, iVec2Array2, n + 1, iVec2Array.length - n);
        }
        return iVec2Array2;
    }

    public static IVec2 getCenter(IVec2[] iVec2Array) {
        IVec2 iVec2 = new IVec2();
        for (int i = 0; i < iVec2Array.length; ++i) {
            iVec2.add(iVec2Array[i]);
        }
        iVec2.div(iVec2Array.length);
        return iVec2;
    }

    public static class SubsurfaceIndex {
        public int uindex;
        public int vindex;

        public SubsurfaceIndex(int n, int n2) {
            this.uindex = n;
            this.vindex = n2;
        }

        public boolean equals(int n, int n2) {
            return this.uindex == n && this.vindex == n2;
        }

        public boolean equals(SubsurfaceIndex subsurfaceIndex) {
            return this.uindex == subsurfaceIndex.uindex && this.vindex == subsurfaceIndex.vindex;
        }
    }

    public static class SubsurfaceIndexGroup {
        public ArrayList<SubsurfaceIndex> indices;
        public int unum;
        public int vnum;
        public double[] uvalues;
        public double[] vvalues;

        public SubsurfaceIndexGroup(double[] dArray, double[] dArray2) {
            this.unum = dArray.length - 1;
            this.vnum = dArray2.length - 1;
            this.uvalues = dArray;
            this.vvalues = dArray2;
            this.indices = new ArrayList();
        }

        public void add(int n, int n2) {
            this.indices.add(new SubsurfaceIndex(n, n2));
        }

        public int num() {
            return this.indices.size();
        }

        public boolean contains(int n, int n2) {
            for (int i = 0; i < this.indices.size(); ++i) {
                if (!this.indices.get(i).equals(n, n2)) continue;
                return true;
            }
            return false;
        }

        public SubsurfaceIndex getIndex(int n) {
            return this.indices.get(n);
        }

        public IVec2[][] getSubsurfaceCorners(int n) {
            SubsurfaceIndex subsurfaceIndex = this.indices.get(n);
            IVec2[][] iVec2Array = new IVec2[2][2];
            if (subsurfaceIndex.uindex < this.unum && subsurfaceIndex.vindex < this.vnum) {
                iVec2Array[0][0] = this.getPoint(subsurfaceIndex);
                iVec2Array[1][0] = this.getPoint(subsurfaceIndex.uindex + 1, subsurfaceIndex.vindex);
                iVec2Array[0][1] = this.getPoint(subsurfaceIndex.uindex, subsurfaceIndex.vindex + 1);
                iVec2Array[1][1] = this.getPoint(subsurfaceIndex.uindex + 1, subsurfaceIndex.vindex + 1);
                return iVec2Array;
            }
            return null;
        }

        public void setPolyline(IVec2[] iVec2Array, boolean bl) {
            for (int i = 0; i < iVec2Array.length; ++i) {
                IOut.debug(30, "polyline[" + i + "]=" + iVec2Array[i]);
            }
            SubsurfaceIndex subsurfaceIndex = this.getIndexOnPoint(iVec2Array[0]);
            this.indices.add(subsurfaceIndex);
            for (int i = 1; i <= iVec2Array.length; ++i) {
                SubsurfaceIndex subsurfaceIndex2 = this.getIndexOnPoint(iVec2Array[i % iVec2Array.length]);
                IOut.debug(30, "i=" + i + ", prevIndex=<" + subsurfaceIndex.uindex + "," + subsurfaceIndex.vindex + ">, index=<" + subsurfaceIndex2.uindex + "," + subsurfaceIndex2.vindex + ">");
                if (subsurfaceIndex2.equals(subsurfaceIndex)) continue;
                if (i < iVec2Array.length || bl) {
                    int n;
                    int n2;
                    IOut.debug(30, "polyline[" + (i - 1) + "] to polyline[" + i % iVec2Array.length + "]");
                    SubsurfaceIndex[] subsurfaceIndexArray = this.getIndexOnLine(iVec2Array[i - 1], iVec2Array[i % iVec2Array.length]);
                    if (subsurfaceIndexArray == null) {
                        IOut.debug(30, "array == null");
                    } else {
                        IOut.debug(30, "array.length = " + subsurfaceIndexArray.length);
                        for (n2 = 0; n2 < subsurfaceIndexArray.length; ++n2) {
                            IOut.debug(30, "array[" + n2 + "]=<" + subsurfaceIndexArray[n2].uindex + "," + subsurfaceIndexArray[n2].vindex + ">");
                        }
                    }
                    if (subsurfaceIndexArray != null) {
                        for (n2 = 0; n2 < subsurfaceIndexArray.length; ++n2) {
                            n = 0;
                            for (int j = 0; j < this.indices.size() && n == 0; ++j) {
                                if (!this.indices.get(j).equals(subsurfaceIndexArray[n2])) continue;
                                n = 1;
                            }
                            if (n != 0) continue;
                            this.indices.add(subsurfaceIndexArray[n2]);
                        }
                    }
                    if (i < iVec2Array.length) {
                        n2 = 0;
                        for (n = 0; n < this.indices.size() && n2 == 0; ++n) {
                            if (!this.indices.get(n).equals(subsurfaceIndex2)) continue;
                            n2 = 1;
                        }
                        if (n2 == 0) {
                            this.indices.add(subsurfaceIndex2);
                        }
                    }
                    IOut.debug(30, "index=<" + subsurfaceIndex2.uindex + "," + subsurfaceIndex2.vindex + ">");
                }
                subsurfaceIndex = subsurfaceIndex2;
            }
        }

        protected int getUIndex(IVec2 iVec2) {
            for (int i = 0; i < this.unum; ++i) {
                if (!(iVec2.x < this.uvalues[i + 1])) continue;
                return i;
            }
            return this.unum - 1;
        }

        protected int getVIndex(IVec2 iVec2) {
            for (int i = 0; i < this.vnum; ++i) {
                if (!(iVec2.y < this.vvalues[i + 1])) continue;
                return i;
            }
            return this.vnum - 1;
        }

        protected double getU(int n) {
            return this.uvalues[n];
        }

        protected double getV(int n) {
            return this.vvalues[n];
        }

        protected IVec2 getPoint(int n, int n2) {
            return new IVec2(this.getU(n), this.getV(n2));
        }

        protected IVec2 getPoint(SubsurfaceIndex subsurfaceIndex) {
            return new IVec2(this.getU(subsurfaceIndex.uindex), this.getV(subsurfaceIndex.vindex));
        }

        protected boolean isOnCorner(IVec2 iVec2) {
            return this.isOnUEdge(iVec2) && this.isOnVEdge(iVec2);
        }

        protected boolean isOnEdge(IVec2 iVec2) {
            return this.isOnUEdge(iVec2) || this.isOnVEdge(iVec2);
        }

        protected boolean isOnUEdge(IVec2 iVec2) {
            return iVec2.y == this.getV(this.getVIndex(iVec2));
        }

        protected boolean isOnVEdge(IVec2 iVec2) {
            return iVec2.x == this.getU(this.getUIndex(iVec2));
        }

        protected SubsurfaceIndex getIndexOnPoint(IVec2 iVec2) {
            return new SubsurfaceIndex(this.getUIndex(iVec2), this.getVIndex(iVec2));
        }

        protected SubsurfaceIndex[] getIndexOnLine(IVec2 iVec2, IVec2 iVec22) {
            int n = this.getUIndex(iVec2);
            int n2 = this.getVIndex(iVec2);
            int n3 = this.getUIndex(iVec22);
            int n4 = this.getVIndex(iVec22);
            if (n == n3 && n2 == n4) {
                return null;
            }
            if (n == n3) {
                if (Math.abs(n2 - n4) == 1) {
                    return null;
                }
                int n5 = 1;
                if (n2 > n4) {
                    n5 = -1;
                }
                int n6 = Math.abs(n2 - n4) - 1;
                SubsurfaceIndex[] subsurfaceIndexArray = new SubsurfaceIndex[n6];
                for (int i = 0; i < n6; ++i) {
                    subsurfaceIndexArray[i] = new SubsurfaceIndex(n, n2 + (i + 1) * n5);
                }
                return subsurfaceIndexArray;
            }
            if (n2 == n4) {
                if (Math.abs(n - n3) == 1) {
                    return null;
                }
                int n7 = 1;
                if (n > n3) {
                    n7 = -1;
                }
                int n8 = Math.abs(n - n3) - 1;
                SubsurfaceIndex[] subsurfaceIndexArray = new SubsurfaceIndex[n8];
                for (int i = 0; i < n8; ++i) {
                    subsurfaceIndexArray[i] = new SubsurfaceIndex(n + (i + 1) * n7, n2);
                }
                return subsurfaceIndexArray;
            }
            SubsurfaceIndex subsurfaceIndex = this.getNextIndexOnLine(iVec2, iVec22, n, n2);
            ArrayList<SubsurfaceIndex> arrayList = new ArrayList<SubsurfaceIndex>();
            while (subsurfaceIndex != null && !subsurfaceIndex.equals(n3, n4) && iVec2.diff(iVec22).dot(this.getPoint(subsurfaceIndex).mid(this.getPoint(subsurfaceIndex.uindex + 1, subsurfaceIndex.vindex + 1)).diff(iVec22)) > 0.0) {
                arrayList.add(subsurfaceIndex);
                subsurfaceIndex = this.getNextIndexOnLine(iVec2, iVec22, subsurfaceIndex.uindex, subsurfaceIndex.vindex);
            }
            return arrayList.toArray(new SubsurfaceIndex[arrayList.size()]);
        }

        protected SubsurfaceIndex getNextIndexOnLine(IVec2 iVec2, IVec2 iVec22, int n, int n2) {
            if (iVec2.x < iVec22.x) {
                if (n < this.unum) {
                    if (n2 < this.vnum && this.isLineOnVEdge(iVec2, iVec22, n + 1, n2, n2 + 1)) {
                        return new SubsurfaceIndex(n + 1, n2);
                    }
                    if (this.isLineOnPoint(iVec2, iVec22, n + 1, n2)) {
                        if (n2 > 0 && iVec2.y > iVec22.y) {
                            return new SubsurfaceIndex(n + 1, n2 - 1);
                        }
                        return new SubsurfaceIndex(n + 1, n2);
                    }
                    if (n2 < this.vnum && this.isLineOnPoint(iVec2, iVec22, n + 1, n2 + 1)) {
                        if (iVec2.y < iVec22.y) {
                            return new SubsurfaceIndex(n + 1, n2 + 1);
                        }
                        return new SubsurfaceIndex(n + 1, n2);
                    }
                }
            } else if (n > 0) {
                if (n2 < this.vnum && this.isLineOnVEdge(iVec2, iVec22, n, n2, n2 + 1)) {
                    return new SubsurfaceIndex(n - 1, n2);
                }
                if (n2 > 0 && this.isLineOnPoint(iVec2, iVec22, n, n2)) {
                    if (iVec2.y > iVec22.y) {
                        return new SubsurfaceIndex(n - 1, n2 - 1);
                    }
                    return new SubsurfaceIndex(n - 1, n2);
                }
                if (n2 < this.vnum && this.isLineOnPoint(iVec2, iVec22, n, n2 + 1)) {
                    if (iVec2.y < iVec22.y) {
                        return new SubsurfaceIndex(n - 1, n2 + 1);
                    }
                    return new SubsurfaceIndex(n - 1, n2);
                }
            }
            if (iVec2.y < iVec22.y) {
                if (n2 < this.vnum) {
                    if (n < this.unum && this.isLineOnUEdge(iVec2, iVec22, n, n + 1, n2 + 1)) {
                        return new SubsurfaceIndex(n, n2 + 1);
                    }
                    if (this.isLineOnPoint(iVec2, iVec22, n, n2 + 1)) {
                        if (iVec2.x > iVec22.x) {
                            return new SubsurfaceIndex(n - 1, n2 + 1);
                        }
                        return new SubsurfaceIndex(n, n2 + 1);
                    }
                    if (n < this.unum && this.isLineOnPoint(iVec2, iVec22, n + 1, n2 + 1)) {
                        if (iVec2.x < iVec22.x) {
                            return new SubsurfaceIndex(n + 1, n2 + 1);
                        }
                        return new SubsurfaceIndex(n, n2 + 1);
                    }
                }
            } else if (n2 > 0) {
                if (n < this.unum && this.isLineOnUEdge(iVec2, iVec22, n, n + 1, n2)) {
                    return new SubsurfaceIndex(n, n2 - 1);
                }
                if (this.isLineOnPoint(iVec2, iVec22, n, n2)) {
                    if (iVec2.x > iVec22.x) {
                        return new SubsurfaceIndex(n - 1, n2 - 1);
                    }
                    return new SubsurfaceIndex(n, n2 - 1);
                }
                if (n < this.unum && this.isLineOnPoint(iVec2, iVec22, n + 1, n2)) {
                    if (iVec2.x < iVec22.x) {
                        return new SubsurfaceIndex(n + 1, n2 - 1);
                    }
                    return new SubsurfaceIndex(n, n2 - 1);
                }
            }
            return null;
        }

        protected boolean isLineOnPoint(IVec2 iVec2, IVec2 iVec22, int n, int n2) {
            return iVec22.diff((IVec2)iVec2).cross((IVec2)this.getPoint((int)n, (int)n2).diff((IVec2)iVec2)).z == 0.0;
        }

        protected boolean isLineOnEdge(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
            IVec2 iVec25 = iVec22.diff(iVec2);
            double d = iVec25.cross((IVec2)iVec23.diff((IVec2)iVec2)).z;
            double d2 = iVec25.cross((IVec2)iVec24.diff((IVec2)iVec2)).z;
            return d * d2 < 0.0;
        }

        protected boolean isLineOnUEdge(IVec2 iVec2, IVec2 iVec22, int n, int n2, int n3) {
            return this.isLineOnEdge(iVec2, iVec22, this.getPoint(n, n3), this.getPoint(n2, n3));
        }

        protected boolean isLineOnVEdge(IVec2 iVec2, IVec2 iVec22, int n, int n2, int n3) {
            return this.isLineOnEdge(iVec2, iVec22, this.getPoint(n, n2), this.getPoint(n, n3));
        }

        protected boolean isPointOnLeft(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
            return iVec23.diff((IVec2)iVec22).cross((IVec2)iVec2.diff((IVec2)iVec22)).z > 0.0;
        }
    }
}

