/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IComparator;
import igeo.IConfig;
import igeo.IVec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRadialComparator
implements IComparator<IVec> {
    public IVec center = new IVec(0.0, 0.0, 0.0);
    public IVec normal = new IVec(0.0, 0.0, 1.0);
    public IVec startDir = new IVec(1.0, 0.0, 0.0);

    public IRadialComparator() {
    }

    public IRadialComparator(IVec iVec) {
        this.center = iVec;
    }

    public IRadialComparator(IVec iVec, IVec iVec2) {
        this.center = iVec;
        this.normal = iVec2;
        double d = this.startDir.angle(iVec2);
        this.startDir = d < IConfig.angleTolerance || Math.abs(Math.abs(d) - Math.PI) < IConfig.angleTolerance ? iVec2.cross(new IVec(0.0, 0.0, 1.0)).cross(iVec2) : iVec2.cross(this.startDir).cross(iVec2);
    }

    public IRadialComparator(IVec iVec, IVec iVec2, IVec iVec3) {
        this.center = iVec;
        this.normal = iVec2;
        this.startDir = iVec3;
        if (Math.abs(Math.abs(iVec3.angle(iVec2)) - 1.5707963267948966) >= IConfig.angleTolerance) {
            iVec3 = iVec2.cross(iVec3.dup()).cross(iVec2);
        }
    }

    public double angle(IVec iVec) {
        double d = this.startDir.angle(this.normal.cross(iVec.diff(this.center)).cross(this.normal), this.normal);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    @Override
    public int compare(IVec iVec, IVec iVec2) {
        double d;
        double d2 = this.angle(iVec);
        if (d2 < (d = this.angle(iVec2))) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }
}

